library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity one_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end one_rom;
architecture rom of one_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"F",X"F",X"F",X"E",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"E",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"E",X"F",X"E",X"F",X"F",X"E",X"E",X"F",X"E",X"B",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"E",X"E",X"F",X"F",X"B",X"A",X"9",X"B",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E"),
(X"F",X"F",X"E",X"F",X"F",X"E",X"A",X"A",X"9",X"9",X"B",X"E",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"E",X"F",X"F"),
(X"F",X"E",X"F",X"F",X"B",X"A",X"9",X"9",X"9",X"B",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"E",X"F",X"E",X"9",X"9",X"7",X"7",X"9",X"A",X"B",X"E",X"B",X"C",X"D",X"C",X"D",X"E",X"F",X"E",X"F",X"F",X"F"),
(X"E",X"F",X"B",X"9",X"A",X"7",X"8",X"9",X"9",X"9",X"9",X"2",X"3",X"4",X"3",X"7",X"0",X"1",X"1",X"1",X"1",X"F"),
(X"F",X"F",X"C",X"5",X"6",X"6",X"6",X"6",X"6",X"6",X"6",X"2",X"3",X"4",X"3",X"7",X"0",X"B",X"1",X"1",X"1",X"F"),
(X"F",X"F",X"C",X"8",X"8",X"8",X"8",X"8",X"8",X"8",X"8",X"2",X"3",X"4",X"3",X"7",X"0",X"1",X"0",X"0",X"1",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"E",X"C",X"C",X"C",X"D",X"B",X"A",X"A",X"A",X"B",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F"),
(X"E",X"F",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"E",X"F",X"F"),
(X"F",X"F",X"E",X"E",X"E",X"F",X"E",X"E",X"E",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"F",X"F"),
(X"F",X"F",X"E",X"E",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"F",X"F",X"F")

);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
