--
-- DE2 top-level module that includes the simple audio component
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity lab3_audio2 is

  port (
    -- Clocks
    
    CLOCK_50: in std_logic ;                                    -- 50 MHz
 

    -- LED displays

--hEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7 -- 7-segment displays
   hEX0, HEX2: out std_logic_vector(6 downto 0);

    
    -- General-purpose I/O
    
                                       -- GPIO Connection 0
    GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1   
    fsm_out2 : out std_logic_vector (1 downto 0)
    );
  
end lab3_audio2 ;

architecture datapath of lab3_audio2  is

signal outfromfsm2 : std_logic_vector (1 downto 0);
signal inputtofsm2 : std_logic_vector (1 downto 0);
signal states2  : std_logic_vector (7 downto 0);
signal counter2 : unsigned (3 downto 0);
component  fsm is

	port(
		clk      : in	std_logic;
		input	 : in	std_logic_vector (1 downto 0);
		reset_n	 : in	std_logic;
		output	 : out	std_logic_vector(1 downto 0);
		output1  : out std_logic_vector (7 downto 0)
	);

end component; 

component hex7seg is
port ( input : in unsigned(3 downto 0); 
output : out std_logic_vector(6 downto 0)); 
end component;



begin
fsm_out2 <= outfromfsm2;
inputtofsm2 <= (not GPIO_1(0)) & (not gpio_1 (2));
vv: fsm port map (
clock_50,
inputtofsm2,
'1',
outfromfsm2,
states2
);

vvv: hex7seg port map(
input => counter2,
output=> hex2

);
 
process (clock_50)
begin
	if (rising_edge (clock_50)) then
		if inputtofsm2 = "00" then
			HEX0 <= "1000000";
		elsif inputtofsm2 = "01" then
			HEX0 <= "1111001";
		elsif inputtofsm2 = "11" then
			HEX0 <= "0100100";
		else 
			HEX0 <= "0110000";
		end if;
	end if;
	end process;
--		
process (outfromfsm2)
begin
	 if (rising_edge (outfromfsm2(1))) then
		if outfromfsm2 = "10" then
			counter2 <= counter2 +1 ;
		else 
			counter2 <= counter2 -1 ;
		end if;

	end if;
end process;



end datapath;
