--
-- DE2 top-level module that includes the simple audio component
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity lab3_audio is

  port (
    -- Clocks
    
    CLOCK_50: in std_logic ;                                    -- 50 MHz
 

    -- LED displays

--hEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7 -- 7-segment displays
   hEX1, HEX3: out std_logic_vector(6 downto 0);

    
    -- General-purpose I/O
    
                                       -- GPIO Connection 0
    GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1   
	move_right : out std_logic;
	move_left: out std_logic;
	fsm_out : out std_logic_vector (1 downto 0)
    );
  
end lab3_audio ;

architecture datapath of lab3_audio  is
signal g1 : std_logic_vector (6 downto 0); 
signal g2 : std_logic_vector (6 downto 0); 
signal outfromfsm : std_logic_vector (1 downto 0);
signal inputtofsm : std_logic_vector (1 downto 0);
signal states  : std_logic_vector (7 downto 0);
signal counter : unsigned (3 downto 0);
component  fsm is

	port(
		clk		 : in	std_logic;
		input	 : in	std_logic_vector (1 downto 0);
		reset_n	 : in	std_logic;
		output	 : out	std_logic_vector(1 downto 0);
		output1 : out std_logic_vector (7 downto 0)
	);

end component; 

component hex7seg is
port ( input : in unsigned(3 downto 0); 
output : out std_logic_vector(6 downto 0)); 
end component;



begin
fsm_out <= outfromfsm;
inputtofsm <= (not GPIO_1(1)) & (not gpio_1 (3));
vv: fsm port map (
clock_50,
inputtofsm,
'1',
outfromfsm,
states
);

vvv: hex7seg port map(
input => counter,
output=> hex3

);
  --g1 <=   "00000" & outfromfsm;
  g1 <=   "00000" & inputtofsm;
  g2 <= "00000" & outfromfsm;
--
process (clock_50)
begin
	if (rising_edge (clock_50)) then
		if inputtofsm = "00" then
			HEX1 <= "1000000";
		elsif inputtofsm = "01" then
			HEX1 <= "1111001";
		elsif inputtofsm = "11" then
			HEX1 <= "0100100";
		else 
			HEX1 <= "0110000";
		end if;
	end if;
	end process;
--		
process (outfromfsm)
begin
	 if (rising_edge (outfromfsm(1))) then
		if outfromfsm(0) = '0' then
			--move_right <= '1';
			counter <= counter +1 ;
		else --if outfromfsm = "11" then
			counter <= counter -1 ;
			--move_left <= '1';
		end if;
--	else
--	   move_right <= '0';
--	   move_left <= '0';
	end if;
end process;

--process (outfromfsm)
--begin
--     if outfromfsm = "00" then
--			move_right <= '0';
--			move_left <= '0';
--	end if;
--end process;
--		
		
--  HEX7     <= states (6 downto 0);
-- -- HEX6     <= (others => '1');
--  HEX5     <= (others => '1');
--  --HEX4     <= (others => '1');
--  --HEX3     <= (others => '1');
--  HEX2     <= (others => '1');
--  HEX1     <= g2;
--  HEX0     <= ( g1);          -- Rightmost
--  

end datapath;
