-- Shangru Li
-- 
-- This component is basically a 26-bit counter
--
-- When the counter is 1, irq will be '1'
-- The irq is reset to '0' by the cpu, when the cpu wants to write to this
-- component, the irq will become '0'
--
-- The address, readdata, and writedata are effectively ignored

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity irComp2 is port (
  clk, reset_n, chipselect, read, write, address : in std_logic;
  readdata  : out std_logic_vector(15 downto 0);
  writedata : in  std_logic_vector(15 downto 0);
  irq       : out std_logic;
  GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1
  hex0, HEX2: out std_logic_vector(6 downto 0)
  );
end entity irComp2;

architecture rtl of irComp2 is 
  signal data    : std_logic_vector(15 downto 0);
  signal counter : unsigned(27 downto 0);
  signal fsm_o2 : std_logic_vector (1 downto 0);
  signal irq_inter : std_logic;
  signal clk_irq : std_logic;
  signal clk_counter:unsigned(15 downto 0) := "0000000000000000";
  signal irq1, irq2,irq3,irq4,irq5:std_logic;

component lab3_audio2 is
  port (   
     CLOCK_50: in std_logic;                                      -- 50 MHz
     GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1   
     hex0,HEX2: out std_logic_vector(6 downto 0);
	 fsm_out2 : out std_logic_vector (1 downto 0)
    ); 
end component lab3_audio2 ;


begin



vvvv: lab3_audio2 port map(
	CLOCK_50 => clk,                                      -- 50 MHz
    	GPIO_1 => GPIO_1,   
	hex2 => hex2,
	hex0 => hex0,
    	fsm_out2=> fsm_o2
	);
	


process (clk)
  begin
    --if rising_edge(clk_irq) then
	if rising_edge(clk) then
      if reset_n = '0' then
        irq1 <= '0';
      else			
	        if write = '1' and chipselect = '1' then 
	          irq1 <= '0';  -- important to reset the irq
			  --readdata(15 downto 2) <= "00000000000000";
			  --readdata(1 downto 0) <= "00";
			else
				irq1<= fsm_o2(1);
				readdata(15 downto 2) <= "00000000000000";
				readdata(1 downto 0) <= fsm_o2;
				
			end if;
      end if;
    end if;
  end process;

irq <= irq1;

end rtl;


