-- Shangru Li
-- 
-- This component is basically a 26-bit counter
--
-- When the counter is 1, irq will be '1'
-- The irq is reset to '0' by the cpu, when the cpu wants to write to this
-- component, the irq will become '0'
--
-- The address, readdata, and writedata are effectively ignored

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity irComp is port (
  clk, reset_n, chipselect, read, write, address : in std_logic;
  readdata  : out std_logic_vector(15 downto 0);
  writedata : in  std_logic_vector(15 downto 0);
  irq       : out std_logic;
  GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1
  hex1, HEX3: out std_logic_vector(6 downto 0)
  );
end entity irComp;

architecture rtl of irComp is 
  signal data    : std_logic_vector(15 downto 0);
  signal counter : unsigned(27 downto 0);
  signal move_r, move_l : std_logic ;
  signal fsm_o : std_logic_vector (1 downto 0);
  signal irq_inter : std_logic;
  signal clk_irq : std_logic;
  signal clk_counter:unsigned(15 downto 0) := "0000000000000000";
  signal irq1,irq2,irq3 : std_logic;

component lab3_audio is
  port (   
     CLOCK_50: in std_logic;                                      -- 50 MHz
     GPIO_1 : inout std_logic_vector(35 downto 0); -- GPIO Connection 1   
	 move_right,move_left: out std_logic;
     hex1,HEX3: out std_logic_vector(6 downto 0);
	 fsm_out : out std_logic_vector (1 downto 0)
    ); 
end component lab3_audio ;


begin



process(clk)
  begin
    if rising_edge(clk) then
		if clk_counter = "1000010001000000" then
			clk_counter <= "0000000000000000";
			clk_irq <= not clk_irq;
        else 
			clk_counter <= clk_counter + 1;
		end if;
	end if;
end process;

vvvv: lab3_audio port map(
	CLOCK_50 => clk,                                      -- 50 MHz
    GPIO_1 => GPIO_1,   
	move_right => move_r,
	move_left => move_l,
	hex3 => hex3,
	hex1 => hex1,
    fsm_out=> fsm_o
	);
	

  
--  process (clk)
--  begin
--    if rising_edge(clk) then
--      if reset_n = '0' then
--        data <= (others => '0');
--      else
--        if chipselect = '1' then
--          if address = '1' then
--            if write = '1' then
--              data <= writedata;
--            elsif read = '1' then
--              readdata <= data;
--            end if;
--          end if;
--        end if;
--      end if;
--    end if;
--  end process;
  
--  process (clk)
--  begin
--    if rising_edge(clk) then
--      if reset_n = '0' then
--        counter <= (others => '0');
--      else
--        counter <= counter +1 ;
--      end if;
--    end if;
--  end process;
--    
  --process (clk_irq)
process (clk)
  begin
    --if rising_edge(clk_irq) then
	if rising_edge(clk) then
      if reset_n = '0' then
        irq <= '0';
      else
--			if counter = "0000000000000000000000000001" then
--				irq <= '1';
--			elsif write = '1' and chipselect = '1' then
--				irq <= '0'; --important: reset the irq
--if move_r = '1' or move_l = '1' then
--	          irq <= '1';
--	else 
--			irq <= '0';
--		end if;
			
	        if write = '1' and chipselect = '1' then 
	          irq <= '0';  -- important to reset the irq
			  --readdata(15 downto 2) <= "00000000000000";
			  --readdata(1 downto 0) <= "00";
			else
				irq<= fsm_o(1);
				readdata(15 downto 2) <= "00000000000000";
--				if fsm_o(0)= '0' then
--				readdata(1 downto 0) <= fsm_o;
--				elsif fsm_o(0)= '1' then
				readdata(1 downto 0) <= fsm_o;
				--end if;
--			elsif move_r = '1' then
--	          irq <= '1';
--			elsif move_l = '1' then
--	          irq <= '1';
--	        else
--				irq <= '0';
			end if;
      end if;
    end if;
  end process;

--IRQcop : process(clk)
--	begin 
--	if rising_edge(clk) then
--		irq1 <= irq2;
--	end if;
--end process;
--IRQcop1 : process(clk)
--	begin 
--	if rising_edge(clk) then
--		irq2 <= irq3;
--	end if;
--end process;
--irq <= irq1 and (not irq3);

--readdata (1 downto 0) <= fsm_o;
  

end rtl;


