library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity heart_rom is
port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (2 downto 0)
  );
  end heart_rom;
architecture rom of heart_rom is
	type ball_row is array(0 to 19) of unsigned(2 downto 0);
	type ball_column is array(0 to 19) of ball_row; 
constant ball : ball_column:=(

("111","111","111","111","111","111","111","110","101","101","101","101","110","111","111","111","111","111","111","111"),
("111","111","111","111","111","110","101","100","100","100","100","100","100","101","101","111","111","111","111","111"),
("111","111","111","110","101","100","100","100","100","100","100","100","100","100","100","101","110","111","111","111"),
("111","111","110","100","100","100","100","010","001","001","010","100","100","100","100","100","100","111","111","111"),
("111","111","100","100","100","100","001","011","011","011","011","000","101","100","100","100","100","101","111","111"),
("111","110","100","100","100","001","011","011","011","011","011","011","000","101","100","100","100","100","110","111"),
("111","101","100","100","100","000","011","011","011","011","011","011","011","000","100","100","100","100","100","111"),
("110","100","100","100","100","000","011","011","011","011","011","011","011","000","001","100","100","100","100","110"),
("110","100","100","100","100","010","011","011","011","011","011","011","011","011","000","101","100","100","100","101"),
("101","100","100","100","100","100","010","000","011","011","011","011","011","011","011","010","100","100","100","100"),
("101","100","100","100","100","100","100","000","011","011","011","011","011","011","011","000","100","100","100","100"),
("101","100","100","100","100","100","001","011","011","011","011","011","011","011","011","000","100","100","100","101"),
("110","100","100","100","100","101","011","011","011","011","011","011","011","011","000","010","100","100","100","101"),
("111","101","100","100","100","010","011","011","011","011","011","011","011","011","001","100","100","100","100","110"),
("111","110","100","100","100","010","011","011","011","011","011","011","000","001","100","100","100","100","101","111"),
("111","111","101","100","100","100","010","000","000","000","000","001","101","100","100","100","100","100","110","111"),
("111","111","111","101","100","100","100","100","100","100","100","100","100","100","100","100","100","110","111","111"),
("111","111","111","111","101","100","100","100","100","100","100","100","100","100","100","100","101","111","111","111"),
("111","111","111","111","111","110","100","100","100","100","100","100","100","100","101","110","111","111","111","111"),
("111","111","111","111","111","111","111","110","101","101","100","101","101","110","111","111","111","111","111","111")

);

begin 
 process (clk)
	begin
		if rising_edge(clk) then
				dataout<= ball(h_addr)(v_addr);
		end if;
	end process;
end rom; 
