-- Quartus II VHDL Template
-- Four-State Moore State Machine

-- A Moore machine's outputs are dependent only on the current state.
-- The output is written only when the state changes.  (State
-- transitions are synchronous.)

library ieee;
use ieee.std_logic_1164.all;

entity fsm is

	port(
		clk		 : in	std_logic;
		input	 : in	std_logic_vector (1 downto 0);
		reset_n	 : in	std_logic;
		output	 : out	std_logic_vector(1 downto 0);
		output1 : out std_logic_vector (7 downto 0)	
	);

end entity;

architecture rtl of fsm is

	-- Build an enumerated type for the state machine
	type state_type is (s0, s1, s2, s3, s4 , s5, s6);

	-- Register to hold the current state
	signal state   : state_type;
	signal interoutput: std_logic_vector(1 downto 0);

begin

	-- Logic to advance to the next state
	process (clk)
	begin
		if reset_n = '0' then
			state <= s0;
		elsif (rising_edge(clk)) then
			case state is
				when s0=>
					if input = "01" then
						state <= s1;
					elsif input = "10" then
						state <= s4;
					else
						state <= s0;
					end if;
				when s1=>
					if input = "11" then
						state <= s2;
					elsif input = "00" then
						state <= s0;
					else
						state <= s1;
					end if;
				when s2=>
					if input = "10" then
						state <= s3;
					elsif input = "00" then
						state <= s0;
					else
						state <= s2;
					end if;
				when s3 =>
					if input = "00" then
						state <= s0;
					else
						state <= s3;
					end if;
				when s4 =>
					if input = "11" then
						state <= s5;
					elsif input = "00" then
						state <= s0;
					else
						state <= s4;
					end if;
				when s5 =>
					if input = "01" then
						state <= s6;
					elsif input = "00" then
						state <= s0;
					else
						state <= s5;
					end if;


				when s6 =>
					if input = "00" then
						state <= s0;
					else
						state <= s6;
					end if;
			end case;
		end if;
	end process;

	-- Output depends solely on the current state
	process (state)
	begin
		case state is
			when s0 =>
				output <= "00";
				output1 <= "01000000";
			when s1 =>
				output <= "00";
				output1 <= "01111001";
			when s2 =>
				output <= "00";
				output1 <= "00100100";
			when s3 =>
				output <= "10";
				output1 <= "00110000";
			when s4 =>
				output <= "00";
				output1 <= "00011001";
			when s5 =>
				output <= "00";
				output1 <= "00010010";
			when s6 =>
				output <= "11";
				output1 <= "00000010";
	
		end case;
	end process;
	
--	process(interoutput(1))
--	begin
--           if (rising_edge(interoutput(1))) then
--				if interoutput(0) = '0' then 
--					output <=  "10";
--				else  
--					output <=  "11";
--				end if;
--			
--			else
--				output <= "00";
--			end if;
--			
--	end process;


end rtl;
