library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity eight_rom is
  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end eight_rom;
architecture rom of eight_rom is
type ball_row is array(0 to 21) of unsigned(3 downto 0);
type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F",X"E",X"E",X"E",X"F",X"F",X"F",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"F",X"D",X"5",X"6",X"A",X"A",X"B",X"E",X"E",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"D",X"B",X"8",X"8",X"B",X"D",X"1",X"0",X"3",X"7",X"A",X"6",X"3",X"D",X"F",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"D",X"7",X"A",X"6",X"9",X"A",X"8",X"3",X"4",X"7",X"7",X"6",X"1",X"1",X"3",X"D",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"2",X"3",X"A",X"C",X"A",X"C",X"B",X"A",X"7",X"A",X"D",X"C",X"3",X"1",X"4",X"C",X"F",X"F",X"E"),
(X"F",X"F",X"D",X"1",X"4",X"B",X"F",X"E",X"7",X"6",X"A",X"7",X"D",X"F",X"F",X"C",X"4",X"7",X"A",X"E",X"F",X"F"),
(X"F",X"F",X"D",X"1",X"4",X"C",X"F",X"E",X"A",X"7",X"7",X"B",X"E",X"E",X"F",X"D",X"7",X"8",X"A",X"E",X"F",X"F"),
(X"F",X"F",X"E",X"6",X"6",X"7",X"D",X"B",X"4",X"4",X"7",X"A",X"E",X"F",X"F",X"D",X"7",X"B",X"C",X"E",X"F",X"F"),
(X"F",X"E",X"F",X"D",X"7",X"7",X"3",X"2",X"1",X"1",X"6",X"A",X"C",X"F",X"E",X"B",X"8",X"4",X"8",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"C",X"A",X"3",X"0",X"2",X"1",X"3",X"A",X"7",X"8",X"A",X"7",X"8",X"6",X"D",X"F",X"F",X"F"),
(X"F",X"F",X"F",X"F",X"F",X"D",X"C",X"9",X"D",X"5",X"4",X"7",X"7",X"7",X"6",X"2",X"3",X"C",X"E",X"F",X"F",X"F"),
(X"E",X"F",X"F",X"F",X"F",X"F",X"E",X"F",X"F",X"E",X"C",X"A",X"A",X"A",X"3",X"1",X"5",X"E",X"F",X"F",X"F",X"F"),
(X"E",X"F",X"F",X"F",X"E",X"F",X"F",X"E",X"F",X"F",X"F",X"E",X"D",X"D",X"D",X"E",X"E",X"F",X"E",X"F",X"F",X"F"),
(X"F",X"E",X"F",X"F",X"F",X"E",X"F",X"F",X"F",X"E",X"E",X"F",X"F",X"F",X"F",X"E",X"E",X"E",X"E",X"F",X"F",X"F")


);
begin 
 process (clk)
begin
if rising_edge(clk) then
dataout<= ball(h_addr)(v_addr);
end if;
end process;	
end rom; 
