
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster is
  
  port (

    clk_50 : in std_logic;                    -- Should be 25.125 MHz
	writedata : in unsigned (15 downto 0);
	readdata : out unsigned(15 downto 0);
    address : in std_logic_vector(17 downto 0);
	irq : out std_logic;
    chipselect,
	reset : in std_logic;
    read,
    write : in std_logic;
    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0) -- Blue[9:0]
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;
  signal bugdie_sta : unsigned(1 downto 0);
  signal HPOS : integer ;
  signal VPOS : integer ; 
  signal irq1 : std_logic;
  signal irq2 : std_logic;
  signal RECTANGLE_HSTART : integer := 100;
  signal RECTANGLE_VSTART : integer := 100;
  signal BALL_POS_H : integer := 10;
  signal BALL_POS_V : integer := 10;
  signal BUG_H : integer := 0;
  signal BUG_V : integer := 0;
  signal BUG_STA : integer := 0;
  signal YUN_POS : integer := 10;
  signal YUN_POS1 : integer := 10;

  signal SPEEDUP_POS_H : integer ;
  signal SPEEDUP_POS_V : integer ;
  signal LOSELIFE_POS_H : integer ;
  signal LOSELIFE_POS_V : integer ;
  signal blackhole_POS_H : integer ;
  signal blackhole_POS_V : integer ;
  signal heart_POS_H : integer := 0;
  signal heart_POS_V : integer := 0;

  signal RECTANGLE_HSTART_yun : integer := 100;
  signal RECTANGLE_VSTART_yun : integer := 100;
  signal YUN_STA : integer := 0;
  signal YUN_STA11 : integer := 0;
  signal YUN_STA21 : integer := 0;
  signal YUN_STA31 : integer := 0;
  signal YUN_STA41 : integer := 0;
  signal BUG_STA1 : integer := 0;
  signal BUG_STA2 : integer := 0;
  signal BUG_STA3 : integer := 0;
  signal BUG_STA4 : integer := 0;
  signal YUN_FLAG : integer := 30000000;
  signal BUG_FLAG1 : integer := 50000000;
  signal BUG_FLAG2 : integer := 50000000;
  signal BUG_FLAG3 : integer := 50000000;
  signal BUG_FLAG4 : integer := 50000000;
  signal bugdie2_RGB : unsigned(1 downto 0);
  signal bugdie3_RGB : unsigned(1 downto 0);

  -- Signals for the video controller
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;
  signal numv_bug : integer := 0;
  signal numh_bug : integer := 0;
  signal numv_bug_flag : integer := 0;
  signal numh_bug_flag : integer := 0;
  signal numh_back : integer := 0;
  signal numv_back : integer := 0;
  signal numh_back_1 : integer := 0;
  signal numv_back_1 : integer := 0;
  signal numh_back_2 : integer := 0;
  signal numv_back_2 : integer := 0;
  signal numh_back_3 : integer := 0;
  signal numv_back_3 : integer := 0;
  signal numv_yun : integer := 0;
  signal numh_yun : integer := 0;
  signal numv_yun1 : integer := 0;
  signal numh_yun1 : integer := 0;
  signal numv_yun2 : integer := 0;
  signal numh_yun2 : integer := 0;
  signal numv_yun3 : integer := 0;
  signal numh_yun3 : integer := 0;
  signal numv_ball : integer := 0;
  signal numh_ball : integer := 0;


  signal numv_numb : integer := 0;
  signal numh_numb : integer := 0;
  signal numv_numb1 : integer := 0;
  signal numh_numb1 : integer := 0;
  signal numv_numb2 : integer := 0;
  signal numh_numb2 : integer := 0;
  signal numv_heart : integer := 0;
  signal numh_heart : integer := 0;
  signal numv_heart1 : integer := 0;
  signal numh_heart1 : integer := 0;
  signal numv_heart2 : integer := 0;
  signal numh_heart2 : integer := 0;
  signal numv_blackhole1 : integer := 0;
  signal numh_blackhole1 : integer := 0;
  signal numv_blackhole2 : integer := 0;
  signal numh_blackhole2 : integer := 0;
  signal numv_blackhole3 : integer := 0;
  signal numh_blackhole3 : integer := 0;
  signal numh_3 : integer := 0;
  signal numv_loselife : integer := 0;
  signal numh_loselife : integer := 0;
  signal numv_speedup : integer := 0;
  signal numh_speedup : integer := 0;

  signal OUT_R : std_logic_vector(7 downto 0);
  signal OUT_G : std_logic_vector(7 downto 0);
  signal OUT_B : std_logic_vector(7 downto 0);

  signal bug_pink1_RGB : unsigned(3 downto 0);
  signal bug_pink2_RGB : unsigned(3 downto 0);
  signal bug_purple1_RGB : unsigned(3 downto 0);
  signal bug_purple2_RGB : unsigned(3 downto 0);
  signal bug_green1_RGB : unsigned(3 downto 0);
  signal bug_green2_RGB : unsigned(3 downto 0);
  signal bug_yellow1_RGB : unsigned(3 downto 0);
  signal bug_yellow2_RGB : unsigned(3 downto 0);
  signal yun1_RGB : unsigned(3 downto 0);
  signal yun2_RGB : unsigned(3 downto 0);
  signal yun3_RGB : unsigned(3 downto 0);
  signal yun11_RGB : unsigned(3 downto 0);
  signal yun12_RGB : unsigned(3 downto 0);
  signal yun13_RGB : unsigned(3 downto 0);
  signal yun21_RGB : unsigned(3 downto 0);
  signal yun22_RGB : unsigned(3 downto 0);
  signal yun23_RGB : unsigned(3 downto 0);
  signal yun31_RGB : unsigned(3 downto 0);
  signal yun32_RGB : unsigned(3 downto 0);
  signal yun33_RGB : unsigned(3 downto 0);
  signal blackhole1_RGB : unsigned(3 downto 0);
  signal blackhole2_RGB : unsigned(3 downto 0);
  signal blackhole3_RGB : unsigned(3 downto 0);
  signal loselife_RGB : unsigned(3 downto 0);
  signal speedup_RGB : unsigned(1 downto 0);
  signal heart_RGB : unsigned(2 downto 0);
  signal numberofheart : integer;



  signal ball_RGB : unsigned(3 downto 0);
  signal back_RGB : std_logic;
  signal ball_sta : unsigned(2 downto 0);
  signal one_RGB : unsigned(3 downto 0);
  signal two_RGB : unsigned(3 downto 0);
  signal three_RGB : unsigned(3 downto 0);
  signal four_RGB : unsigned(3 downto 0);
  signal five_RGB : unsigned(3 downto 0);
  signal six_RGB : unsigned(3 downto 0);
  signal seven_RGB : unsigned(3 downto 0);
  signal eight_RGB : unsigned(3 downto 0);
  signal nine_RGB : unsigned(3 downto 0);
  signal zero_RGB : unsigned(3 downto 0);
  signal numbsco: unsigned(15 downto 0);





	  signal VGA_R_BUFFER : std_logic_vector(9 downto 0);
	  signal VGA_G_BUFFER : std_logic_vector(9 downto 0);
	  signal VGA_B_BUFFER : std_logic_vector(9 downto 0);
	  signal VGA_R_yun1 : std_logic_vector(9 downto 0);
	  signal VGA_G_yun1 : std_logic_vector(9 downto 0);
	  signal VGA_B_yun1 : std_logic_vector(9 downto 0);
	  signal VGA_R_yun2 : std_logic_vector(9 downto 0);
	  signal VGA_G_yun2 : std_logic_vector(9 downto 0);
	  signal VGA_B_yun2 : std_logic_vector(9 downto 0);
	  signal VGA_R_yun3 : std_logic_vector(9 downto 0);
	  signal VGA_G_yun3 : std_logic_vector(9 downto 0);
	  signal VGA_B_yun3 : std_logic_vector(9 downto 0);
	  signal VGA_R_yun4 : std_logic_vector(9 downto 0);
	  signal VGA_G_yun4 : std_logic_vector(9 downto 0);
	  signal VGA_B_yun4 : std_logic_vector(9 downto 0);
	  signal VGA_R_ball : std_logic_vector(9 downto 0);
	  signal VGA_G_ball : std_logic_vector(9 downto 0);
	  signal VGA_B_ball : std_logic_vector(9 downto 0);
	  signal VGA_R_bug : std_logic_vector(7 downto 0);
	  signal VGA_G_bug : std_logic_vector(7 downto 0);
	  signal VGA_B_bug : std_logic_vector(7 downto 0);
	  signal VGA_R_num : std_logic_vector(7 downto 0);
	  signal VGA_G_num : std_logic_vector(7 downto 0);
	  signal VGA_B_num : std_logic_vector(7 downto 0);
	signal yun_vga1,yun_vga2,yun_vga3,yun_vga4,bug_vga,ball_vga : std_logic;
	signal reset1,reset2,reset3,reset4,reset11,reset22,reset33,reset44,virb_sta2,virb_sta3,virb_sta4 : std_logic;
	signal h_virb1,v_virb1,h_virb2,v_virb2,h_virb3,v_virb3,h_virb4,v_virb4 : integer;
	signal virb_sta1 : unsigned(0 downto 0)  :="1";

	signal vga_hblank, vga_hsync, vga_vblank, vga_vsync : std_logic;  -- Sync. signals
    signal rectangle_h, rectangle_v, rectangle : std_logic;  -- rectangle area
	signal rectangle_h_yun, rectangle_v_yun, rectangle_yun : std_logic;
	signal rectangle_h_yun1, rectangle_v_yun1, rectangle_yun1 : std_logic;
	signal rectangle_h_yun2, rectangle_v_yun2, rectangle_yun2 : std_logic;
	signal rectangle_h_yun3, rectangle_v_yun3, rectangle_yun3 : std_logic;
	signal rectangle_h_ball, rectangle_v_ball, rectangle_ball : std_logic;
	signal rectangle_h_heart, rectangle_v_heart, rectangle_heart : std_logic;

	signal rectangle_h_loselife, rectangle_v_loselife, rectangle_loselife : std_logic;
	signal rectangle_h_blackhole1, rectangle_v_blackhole1, rectangle_blackhole1 : std_logic;
	signal rectangle_h_blackhole2, rectangle_v_blackhole2, rectangle_blackhole2 : std_logic;
	signal rectangle_h_blackhole3, rectangle_v_blackhole3, rectangle_blackhole3 : std_logic;
	signal rectangle_h_speedup, rectangle_v_speedup, rectangle_speedup : std_logic;	signal rectangle_h_bug_purple, rectangle_v_bug_purple, rectangle_bug_purple : std_logic;	
	signal rectangle_h_bug_green, rectangle_v_bug_green, rectangle_bug_green : std_logic;	
	signal rectangle_h_back, rectangle_v_back, rectangle_back : std_logic;	
	signal rectangle_h_numb, rectangle_v_numb, rectangle_numb : std_logic;
	signal number : unsigned(15 downto 0);	
	signal clk : std_logic;
	type bug_row is array(0 to 29) of std_logic_vector(7 downto 0);
	type bug_column is array(0 to 29) of bug_row; 
	type yun_row is array(0 to 33) of std_logic_vector(7 downto 0);
	type yun_column is array(0 to 57) of yun_row; 	
	type ball_row is array(0 to 14) of std_logic_vector(7 downto 0);
	type ball_column is array(0 to 14) of ball_row; 	
	type  background_r is array (0 to 11) of std_logic_vector(3 downto 0);
	type  background_c is array (0 to 15) of background_r;
	type  heartnumb is array (0 to 3) of std_logic;
	type  numin is array (0 to 3) of unsigned(3 downto 0);
	type  color is array (0 to 15) of std_logic_vector(23 downto 0);
	type  color1 is array (0 to 3) of std_logic_vector(7 downto 0);
	type  color2 is array (0 to 3) of std_logic_vector(23 downto 0);
	type  color3 is array (0 to 7) of std_logic_vector(23 downto 0);
	signal numinput : numin := ("0000","0000","0000","0000");
signal background : background_c := (
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"),
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"),
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"),
("0000","0000","0000","1110","1111","1110","1111","1110","1001","0000","0000","0000"),
("0000","0000","0000","1000","1001","1010","1011","1100","1101","0000","0000","0000"),
("0000","0000","0000","1100","1101","1100","1101","1110","1011","0000","0000","0000"),
("0000","0000","0000","1011","1100","1011","1011","1001","1101","0000","0000","0000"),
("0000","0000","0000","1101","1001","1101","1111","1110","1001","0000","0000","0000"),
("0000","0000","0000","1001","1101","1110","1100","1100","1101","0000","0000","0000"),
("0000","0000","0000","1100","1111","1011","1010","1000","1010","0000","0000","0000"),
("0000","0000","0000","1011","1001","1010","1001","1101","1101","0000","0000","0000"),
("0000","0000","0000","1010","1101","1110","1001","1001","1011","0000","0000","0000"),
("0000","0000","0000","1000","1001","1011","1101","1000","1100","0000","0000","0000"),
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"),
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000"),
("0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000","0000")
);
signal heartnum : heartnumb := ('1','1','1','1');
constant zero : color :=(
X"b11d6d",X"da4850",X"9c6e73",X"897e8d",
X"d86793",X"cf8449",X"9a967e",X"dd9ab6",
X"faa459",X"f2b02c",X"c0bca7",X"d8bc6f",
X"c5c2c9",X"dedadd",X"f6e1bc",X"fcfdfb"
);

constant one : color :=(
X"77358f",X"9164a7",X"c05a8a",X"e65943",
X"ea843a",X"969a8a",X"abaab4",X"daa755",
X"b1b093",X"b7b1d9",X"c5b9d7",X"ddd6e4",
X"efded7",X"faf2e8",X"fafbff",X"fdfefb"
);

constant two : color :=(
X"a91436",X"b33357",X"b83b35",X"d26828",
X"d26788",X"cc7c96",X"f094ae",X"f5b322",
X"fcab7e",X"f2b0c4",X"f5be62",X"e5c0cc",
X"f3dca4",X"f7dce5",X"faf1d4",X"fdfdfb"
);

constant three : color :=(
X"db3168",X"d4437a",X"d46e94",X"e786a6",
X"d58cb0",X"e094a5",X"afaca7",X"c7a3c1",
X"f1a0bc",X"ebb4c9",X"cfc5dd",X"ecced8",
X"f8e0ea",X"faf0f6",X"fffbfd",X"fcfefc"
);
constant four : color :=(
X"6c3189",X"db2050",X"dc2c63",X"9f63a1",
X"e75c41",X"e05c89",X"e390b2",X"e4a63d",
X"bba7ce",X"dfba8e",X"e3b9cd",X"f1c3d5",
X"e8d9e6",X"fde9a7",X"faeff6",X"fdfefc"
);
constant five : color :=(
X"dc0c55",X"d92262",X"e44746",X"db457a",
X"de618e",X"e78244",X"db7da1",X"d1a2bf",
X"eeb3c7",X"f6c03e",X"e3cddb",X"f2dde6",
X"f3e8ef",X"f8efd4",X"fefdf4",X"fcfdfc"
);
constant six : color :=(
X"c8254f",X"83449f",X"c65a79",X"c1648e",
X"b98099",X"a189c0",X"e47f67",X"ae9576",
X"e295ae",X"e6a85c",X"ccb1ca",X"bec4db",
X"fbd875",X"d8dde9",X"fbfcfb",X"fffdee"
);
constant seven : color :=(
X"c54b56",X"8a55a2",X"cb4e7b",X"b46d5f",
X"b87391",X"da7431",X"e498b9",X"baae8f",
X"f9a482",X"ecb12d",X"eab262",X"c2b5cb",
X"eecbab",X"e3d8e5",X"f8f0ce",X"fdfdfb"
);
constant eight : color :=(
X"d80649",X"d82160",X"d63d78",X"c75d92",
X"c57eaf",X"df8cab",X"c196bd",X"b7a9cf",
X"c6afd4",X"e2adc0",X"bbb7d9",X"cdc8e2",
X"d5cfe1",X"e8e3ec",X"f8f9fd",X"fdfefb"
);
constant nine : color :=(
X"db0247",X"d84078",X"d15c86",X"986dab",
X"c77789",X"e07f67",X"e88527",X"b29ac5",
X"f9b719",X"e7b587",X"f2c760",X"e8c3d2",
X"f3d994",X"f4dee7",X"f4e8c6",X"fcfefc"
);
constant ball : color :=(
X"62a6f1",X"7ab3f2",X"97bff3",X"fec11b",
X"fec645",X"fbc56a",X"b4d0f5",X"f9ce92",
X"fedc1d",X"f4d6b7",X"d6dff6",X"ffe666",
X"f4e4da",X"fef086",X"f5f3fb",X"fcfbf9"
);

constant bug_green1 : color :=(
X"21231b",X"4e564d",X"5d663a",X"7e8b63",
X"859497",X"9bad65",X"9fb078",X"9cbd3a",
X"a7c25c",X"bcd764",X"bed38a",X"c0da71",
X"dce7c3",X"dff5aa",X"d6f0f9",X"fcfefa"
);
constant bug_green2 : color :=(
X"5e6746",X"889664",X"8cb01b",X"9bbc37",
X"abc94b",x"b1cb5d",x"b6c688",x"b7cc70",
x"c0da6e",x"c6df7a",x"d0e39e",x"d7e2b1",
x"d4ec97",x"ececcc",x"e0f5ab",x"fcfefa"
);

constant bug_pink1 :color := (
x"2b262a",x"675a65",x"885a6d",x"df61ba",
x"88909a",x"ab899f",x"c58f87",x"e384c9",
x"f4a1e4",x"fbb7ab",x"e9b9df",x"bed8e1",
x"f9d2f4",x"d3f0fa",x"faeaf5",x"fdfefd"
);

constant bug_pink2 :color := (
x"513b41",x"896d82",x"997070",x"dc56b2",
x"e36ec1",x"c79088",x"e387c9",x"c3a5c0",
x"f69ee4",x"f2a3e3",x"e2b6d8",x"fbb5aa",
x"f3b6e5",x"f9d1f3",x"fadaf3",x"fdfcfc"
);

constant bug_purple1 :color := (
x"131315",x"35343d",x"4b4a56",x"7f5cca",
x"6c6b7d",x"8e70d1",x"937fb9",x"848895",
x"9e85d7",x"b09be0",x"a7aabd",x"d1c4ea",
x"b9d2db",x"dfd3f3",x"d8edf8",x"fbfefd"
);

constant bug_purple2 :color := (
x"5f5578",x"61626d",x"815ecc",x"9072d2",
x"8e7db3",x"838593",x"a48bd9",x"af9be1",
x"c3b2e7",x"aac0c7",x"c7bcda",x"ccbfea",
x"dcd0f1",x"e5dbf8",x"d7e2f2",x"fafdfd"
);

constant bug_yellow1 :color := (
x"20211c",x"564e34",x"4e5454",x"818577",
x"9a8640",x"9b9671",x"8699a4",x"eb8315",
x"eec441",x"d4cd9d",x"f9d96f",x"f5df8c",
x"d2edf6",x"faf5bd",x"fbf6ca",x"fdfffa"
);

constant bug_yellow2 :color := (
x"6a6957",x"9e9975",x"9b9a96",x"e8b315",
x"c4bc8c",x"dcc066",x"eec23b",x"f9d86b",
x"f8dd7d",x"ebe2af",x"fae89d",x"f7ecca",
x"fcefad",x"fbf5b8",x"fbf7c0",x"fcfefa"
);

constant xiaoyun1 :color := (
x"000200",x"272927",x"4d4f4c",x"4e84ea",
x"6796ec",x"969896",x"7ca4ee",x"96b6f0",
x"acc4cf",x"c0c1be",x"b3ccf5",x"cee8fb",
x"d3eef9",x"f5f4fd",x"f4fcff",x"fdfffc"
);

constant xiaoyun2 :color := (
x"0a0d09",x"232321",x"2f302e",x"51524f",
x"4d84e9",x"848786",x"6696ec",x"7ca5ef",
x"a5a9a8",x"94b7f0",x"c6c7c4",x"b3cdf5",
x"cde8fb",x"d5eef9",x"f6fcff",x"fdfffc"
);

constant xiaoyun3 :color := (
x"151412",x"645859",x"4e85ea",x"919290",
x"6b99ed",x"cb8b9b",x"8cb1f1",x"fab6c7",
x"c9cbc8",x"bad2f7",x"cadce8",x"cee7fb",
x"f0e0ea",x"d5eef9",x"f6fcff",x"fdfffb"
);
constant bugdie1 : color1 :=(
X"2a",X"72",X"a3",X"e5"
);
constant bugdie2 : color1 :=(
X"1f",X"6d",X"a0",X"ef"
);
constant bugdie3 : color1 :=(
X"2e",X"75",X"a5",X"f0"
);
constant speedup: color2 :=(
X"7ab3f2",X"9ab9db",X"bfd9f5",X"f4f9fa"
);
constant blackhole: color :=(
X"000200",X"0c101a",X"151b2a",X"212638",
X"2c3246",X"384158",X"434e68",X"4f5e7c",
X"5d6b8c",X"6e7c9e",X"747f96",X"8d868b",
X"8491af",X"9fa8be",X"c6b39c",X"edddb9"
);
constant loselife: color :=(
X"504932",X"867557",X"87794f",X"ae8075",
X"b2a170",X"f3a3ab",X"cec07f",X"fed42b",
X"ffda49",X"fddf61",X"fce171",X"fee787",
X"fded9f",X"faedb3",X"fff4d4",X"fffefb"
);
constant heart: color3 :=(
X"c36969",X"b17a88",X"a088a6",X"f77a5c",
X"60abf6",X"8ebbee",X"d8eafa",X"fdfffc"
);
constant backgroundco: color :=(
X"cee6ea",X"ffffff",X"d5e5ec",X"ffffff",
X"e8e9cb",X"eaecc4",X"ebedde",X"e5f3ed",
X"ecf1f4",X"e6f5f5",X"ffffff",X"ffffff",
X"ffffff",X"ffffff",X"ffffff",X"ffffff"
);
begin
  -- Horizontal and vertical counters
process (clk_50)
begin
	if rising_edge(clk_50) then
		clk<= not clk;
	end if;
end process;

  HCounter : process (clk)
  begin
    if rising_edge(clk) then      
      if reset = '1' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk)
  begin
    if rising_edge(clk) then      
      if reset = '1' then
        Vcount <= (others => '0');
		irq <='0';
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
		irq <='1';
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
		irq <='0';
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk)
  begin
    if rising_edge(clk) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;

YUNSTA: process (clk)
begin
if rising_edge(clk) then

        if YUN_FLAG <= 70000000 then 
        YUN_STA <= 0;
        YUN_FLAG <= YUN_FLAG+1;
        elsif YUN_FLAG <= 73000000 then 
        YUN_STA <= 1;
        YUN_FLAG <= YUN_FLAG+1;
        else YUN_FLAG <= 0;
end if; 
end if;
end process;

BUG_PINKSTA1: process (clk)
begin
if rising_edge(clk) then

        if BUG_FLAG1 <= 50000000 then 
        BUG_STA1 <= 0;
        BUG_FLAG1 <= BUG_FLAG1+1;
        elsif BUG_FLAG1 <= 53000000 then 
        BUG_STA1 <= 1;
        BUG_FLAG1 <= BUG_FLAG1+1;
        else BUG_FLAG1 <= 0;
end if; 
end if;
end process;



BUG_PINKSTA2: process (clk)
begin
if rising_edge(clk) then

        if BUG_FLAG2 <= 100000000 then 
			BUG_STA2 <= 0;
			BUG_FLAG2 <= BUG_FLAG2+1;
        elsif BUG_FLAG2 <= 103000000 then 
			BUG_STA2 <= 1;
			BUG_FLAG2 <= BUG_FLAG2+1;
        else BUG_FLAG2 <= 0;
end if; 
end if;
end process;



BUG_PINKSTA3: process (clk)
begin
if rising_edge(clk) then

        if BUG_FLAG3 <= 130000000 then 
			BUG_STA3 <= 0;
			BUG_FLAG3 <= BUG_FLAG3+1;
        elsif BUG_FLAG3 <= 133000000 then 
			BUG_STA3 <= 1;
			BUG_FLAG3 <= BUG_FLAG3+1;
        else BUG_FLAG3 <= 0;
end if; 
end if;
end process;

BUG_PINKSTA4: process (clk)
begin
if rising_edge(clk) then

        if BUG_FLAG4 <= 80000000 then 
			BUG_STA4 <= 0;
			BUG_FLAG4 <= BUG_FLAG4+1;
        elsif BUG_FLAG4 <= 83000000 then 
			BUG_STA4 <= 1;
			BUG_FLAG4 <= BUG_FLAG4+1;
        else BUG_FLAG4 <= 0;
end if; 
end if;
end process;
YUNSTA11: process (clk_50)
begin
	if rising_edge(clk_50) then
		if chipselect = '1' then
			if address(7 downto 0)="001100" then
					YUN_STA11 <= to_integer(writedata);
			end if;
		end if;
	end if;
end process;


YUNSTA12: process (clk_50)
begin
	if rising_edge(clk_50) then
		if chipselect = '1' then
			if address(7 downto 0)="001101" then
					YUN_STA21 <= to_integer(writedata);
			end if;
		end if;
	end if;
end process;

YUNSTA13: process (clk_50)
begin
	if rising_edge(clk_50) then
		if chipselect = '1' then
			if address(7 downto 0)="001110" then
					YUN_STA31 <= to_integer(writedata);
			end if;
		end if;
	end if;
end process;

YUNSTA14: process (clk_50)
begin
	if rising_edge(clk_50) then
		if chipselect = '1' then
			if address(7 downto 0)="001111" then
					YUN_STA41 <= to_integer(writedata);
			end if;
		end if;
	end if;
end process;

BUGSTA : process (clk_50)
begin
	if rising_edge(clk_50) then
		if chipselect = '1' then
			if address(7 downto 0)="00001000" then
					h_virb1 <= to_integer(writedata(7 downto 4));
					v_virb1 <= to_integer (writedata(3 downto 0));
					background(h_virb1)(v_virb1)(3) <= std_logic(writedata(8));

			end if;
			end if;
		end if;
end process;

RES1 : process (clk)
		begin 
			if rising_edge(clk) then
				reset11<= reset1;
			end if;
		end process;

RES2 : process (clk)
		begin 
			if rising_edge(clk) then
				reset22<=reset2;
			end if;
		end process;
		
RES3 : process (clk)
		begin 
			if rising_edge(clk) then
				reset33<=reset3;
			end if;
		end process;
		
RES4 : process (clk)
		begin 
			if rising_edge(clk) then
				reset44<=reset4;
			end if;
		end process;

numinput1: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	numinput(0) <= "0000"; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00010001" then
				numinput(0) <= (writedata(3 downto 0));
			end if;
		end if;
	end if;
end if;
end process;

numinput2: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	numinput(1) <= "0000"; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00010001" then
				numinput(1) <= (writedata(7 downto 4));
			end if;
		end if;
	end if;
end if;
end process;

numinput3: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	numinput(2) <= "0000"; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00010001" then
				numinput(2) <= (writedata(11 downto 8));
			end if;
		end if;
	end if;
end if;
end process;

numinput4: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
		numinput(3) <= "0000"; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00010001" then
				numinput(3) <= (writedata(15 downto 12));
			end if;
		end if;
	end if;
end if;
end process;


BALLPOS_H: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
		BALL_POS_H <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00000101" then
				BALL_POS_H <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


BALLPOS_V: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	BALL_POS_V <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00000110" then
				BALL_POS_V <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


NOH: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
		numberofheart <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00010000" then
				numberofheart <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


NOH2 : process (clk)
begin
	if rising_edge(clk) then	
		case numberofheart is
			when 4 => 
				heartnum(3) <='1';
				heartnum(2) <='1';
				heartnum(1) <='1';
				heartnum(0) <='1';
			when 3 => 
				heartnum(3) <='0';
				heartnum(2) <='1';
				heartnum(1) <='1';
				heartnum(0) <='1';
			when 2 => 
				heartnum(3) <='0';
				heartnum(2) <='0';
				heartnum(1) <='1';
				heartnum(0) <='1';
			when 1 => 
				heartnum(3) <='0';
				heartnum(2) <='0';
				heartnum(1) <='0';
				heartnum(0) <='1';
			when 0 => 
				heartnum(3) <='0';
				heartnum(2) <='0';
				heartnum(1) <='0';
				heartnum(0) <='0';
			when others =>
			end case;
	end if;
end process;


YUNPOS: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	YUN_POS <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00000111" then
				YUN_POS <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


lifePOSh: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	loselife_POS_h <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00000010" then
				loselife_POS_h <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


lifePOSv: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	loselife_POS_v <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00000011" then
				loselife_POS_v <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


speeduph: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	speedup_POS_h <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00001010" then
				speedup_POS_h <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


speedupv: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	speedup_POS_v <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00001011" then
				speedup_POS_v <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;


YUNPOS1: process (clk_50)
begin
if rising_edge(clk_50) then
	if reset='1' then
	YUN_POS1 <= 0; 
	else 
		if chipselect = '1' then
			if address(7 downto 0)="00001001" then
				YUN_POS1 <= to_integer(writedata(15 downto 0));
			end if;
		end if;
	end if;
end if;
end process;





  begin
    if rising_edge(clk) then
     RECTANGLE_HSTART <= to_integer(Hcount) - HSYNC - HBACK_PORCH;
      if reset = '1' then
		rectangle_h <= '1';	
		elsif RECTANGLE_HSTART >= 0 and RECTANGLE_HSTART <= 639 then
        rectangle_h <= '1';
      else 
        rectangle_h <= '0';
		end if;     
    end if;
  end process RectangleHGen;

  RectangleVGen : process (clk)
  begin
    if rising_edge(clk) then
	RECTANGLE_VSTART <= to_integer(Vcount) - VSYNC - VBACK_PORCH;
      if reset = '1' then       
        rectangle_v <= '0';
		elsif EndOfLine = '1' then
        if RECTANGLE_VSTART >=0 and RECTANGLE_VSTART <=479 then
          rectangle_v <= '1';
        else
          rectangle_v <= '0';
        end if;
      end if;      
    end if;
  end process RectangleVGen;


RectangleHGen_loselife : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_loselife <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH + loselife_POS_H and Hcount <= HSYNC + HBACK_PORCH + loselife_POS_H + 14 then
				rectangle_h_loselife <= '1';
				numh_loselife <= to_integer(Hcount) - HSYNC - HBACK_PORCH - loselife_POS_H ;
			  elsif Hcount >= HSYNC + HBACK_PORCH + loselife_POS_H + 15  then
				rectangle_h_loselife <= '0';
				numh_loselife<= 0;
      end if;      
    end if;
  end process RectangleHGen_loselife;

  RectangleVGen_loselife : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
			rectangle_v_loselife <= '0';
			elsif EndOfLine = '1' then
		if Vcount >= VSYNC + VBACK_PORCH + loselife_POS_V and Vcount <= VSYNC + VBACK_PORCH + loselife_POS_V+20 then
			rectangle_v_loselife <= '1';
			numv_loselife <= to_integer(Vcount) - VSYNC - VBACK_PORCH - loselife_POS_V ;
		elsif Vcount >= VSYNC + VBACK_PORCH + loselife_POS_V+21 then
			rectangle_v_loselife <= '0';
			numv_loselife <= 0;
		end if;
      end if;  
    end if;
  end process RectangleVGen_loselife;

RectangleHGen_blackhole1 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
			rectangle_h_blackhole1 <= '1';
			elsif Hcount >= HSYNC + HBACK_PORCH + 49 and Hcount <= HSYNC + HBACK_PORCH + 49 + 30 then
				rectangle_h_blackhole1 <= '1';
				numh_blackhole1 <= to_integer(Hcount) - HSYNC - HBACK_PORCH - 49 ;
			elsif Hcount >= HSYNC + HBACK_PORCH + 50+ 30  then
				rectangle_h_blackhole1 <= '0';
				numh_blackhole1<= 0;
      end if; 
    end if;
  end process RectangleHGen_blackhole1;

  RectangleVGen_blackhole1 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
		rectangle_v_blackhole1 <= '0';
		  elsif EndOfLine = '1' then
				if Vcount >= VSYNC + VBACK_PORCH + 49 and Vcount <= VSYNC + VBACK_PORCH + 49+29 then
				  rectangle_v_blackhole1 <= '1';
				  numv_blackhole1 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 49 ;
				elsif Vcount >= VSYNC + VBACK_PORCH + 50+30 then
				  rectangle_v_blackhole1 <= '0';
				  numv_blackhole1 <= 0;
		  end if;
      end if;  
    end if;
  end process RectangleVGen_blackhole1;


RectangleHGen_blackhole2 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
				rectangle_h_blackhole2 <= '1';
						elsif Hcount >= HSYNC + HBACK_PORCH + 550 and Hcount <= HSYNC + HBACK_PORCH + 550 + 29 then
							rectangle_h_blackhole2 <= '1';
							numh_blackhole2 <= to_integer(Hcount) - HSYNC - HBACK_PORCH - 550 ;
						elsif Hcount >= HSYNC + HBACK_PORCH + 550 + 30  then
				rectangle_h_blackhole2 <= '0';
			numh_blackhole2<= 0;
      end if; 
    end if;
  end process RectangleHGen_blackhole2;


  RectangleVGen_blackhole2 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
		rectangle_v_blackhole2 <= '0';
		  elsif EndOfLine = '1' then
				if Vcount >= VSYNC + VBACK_PORCH + 49 and Vcount <= VSYNC + VBACK_PORCH + 49+29 then
				  rectangle_v_blackhole2 <= '1';
				  numv_blackhole2 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 49 ;
				elsif Vcount >= VSYNC + VBACK_PORCH + 50+30 then
				  rectangle_v_blackhole2 <= '0';
				  numv_blackhole2 <= 0;
				end if;
      end if;  
    end if;
  end process RectangleVGen_blackhole2;



RectangleHGen_blackhole3 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
			rectangle_h_blackhole3 <= '1';
				elsif Hcount >= HSYNC + HBACK_PORCH + 420 and Hcount <= HSYNC + HBACK_PORCH + 420 + 29 then
					rectangle_h_blackhole3 <= '1';
					numh_blackhole3 <= to_integer(Hcount) - HSYNC - HBACK_PORCH - 420 ;
				elsif Hcount >= HSYNC + HBACK_PORCH + 421 + 30  then
			rectangle_h_blackhole3 <= '0';
			numh_blackhole3<= 0;
      end if; 
    end if;
  end process RectangleHGen_blackhole3;


 RectangleVGen_blackhole3 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
		rectangle_v_blackhole3 <= '0';
  elsif EndOfLine = '1' then
			if Vcount >= VSYNC + VBACK_PORCH + 320 and Vcount <= VSYNC + VBACK_PORCH + 320+29 then
				rectangle_v_blackhole3 <= '1';
				numv_blackhole3 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 320 ;
			elsif Vcount >= VSYNC + VBACK_PORCH + 321+ 29 then
				rectangle_v_blackhole3 <= '0';
				numv_blackhole3 <= 0;
		  end if;
      end if;  
    end if;
  end process RectangleVGen_blackhole3;





RectangleHGen_speedup : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_speedup <= '1';
	  elsif Hcount >= HSYNC + HBACK_PORCH + speedup_POS_H and Hcount <= HSYNC + HBACK_PORCH + speedup_POS_H + 14 then
        rectangle_h_speedup <= '1';
		numh_speedup <= to_integer(Hcount) - HSYNC - HBACK_PORCH - speedup_POS_H ;
      elsif Hcount = HSYNC + HBACK_PORCH + speedup_POS_H + 15  then
        rectangle_h_speedup <= '0';
		numh_speedup<= 0;
      end if;      
    end if;
  end process RectangleHGen_speedup;


  RectangleVGen_speedup : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
		rectangle_v_speedup <= '0';
	  elsif EndOfLine = '1' then
		if Vcount >= VSYNC + VBACK_PORCH + speedup_POS_V and Vcount <= VSYNC + VBACK_PORCH + speedup_POS_V+14 then
		rectangle_v_speedup <= '1';
		numv_speedup <= to_integer(Vcount) - VSYNC - VBACK_PORCH - speedup_POS_V ;
		elsif Vcount >= VSYNC + VBACK_PORCH + speedup_POS_V+15 then
		 rectangle_v_speedup <= '0';
		numv_speedup <= 0;
		end if;
      end if;  
    end if;
  end process RectangleVGen_speedup;


RectangleHGen_heart : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_heart <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH and Hcount <= HSYNC + HBACK_PORCH  + 79 then
        rectangle_h_heart <= '1';
		numh_heart1 <= to_integer(Hcount) - HSYNC - HBACK_PORCH ;
		elsif Hcount >= HSYNC + HBACK_PORCH  + 80  then
        rectangle_h_heart <= '0';
		numh_heart1<= 0;
      end if;      
    end if;
  end process RectangleHGen_heart;


numh_heart<=numh_heart1 mod 20;
numh_heart2<=numh_heart1/20;





  RectangleVGen_heart : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
		rectangle_v_heart <= '0';
		elsif EndOfLine = '1' then
		if Vcount >= VSYNC + VBACK_PORCH + 32 and Vcount <= VSYNC + VBACK_PORCH + 32+19 then
		rectangle_v_heart <= '1';
		numv_heart <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 32;
		elsif Vcount >= VSYNC + VBACK_PORCH + 33 + 20 then
		 rectangle_v_heart <= '0';
		numv_heart <= 0;
end if;
      end if;  
    end if;
  end process RectangleVGen_heart;



RectangleHGen_yun1 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_yun1 <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH + YUN_POS and Hcount <= HSYNC + HBACK_PORCH + YUN_POS + 57 then
        rectangle_h_yun1 <= '1';
		 numh_yun1 <= to_integer(Hcount) - HSYNC - HBACK_PORCH - YUN_POS ;
      elsif Hcount >= HSYNC + HBACK_PORCH + YUN_POS +58  then
        rectangle_h_yun1 <= '0';
		numh_yun1<= 0;
      end if;      
    end if;
  end process RectangleHGen_yun1;


  RectangleVGen_yun1 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
				rectangle_v_yun1 <= '0';
		  elsif EndOfLine = '1' then
			if Vcount >= VSYNC + VBACK_PORCH + 5 and Vcount <= VSYNC + VBACK_PORCH + 5+33 then
				rectangle_v_yun1 <= '1';
				numv_yun1 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 5 ;
			elsif Vcount >= VSYNC + VBACK_PORCH + 5+34 then
				rectangle_v_yun1 <= '0';
				numv_yun1 <= 0;
			end if;
      end if;  
    end if;
  end process RectangleVGen_yun1;



RectangleHGen_back : process (clk)
  begin
       if reset = '1' then
			rectangle_h_back <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH + 0 and Hcount <= HSYNC + HBACK_PORCH + YUN_POS + 639 then
			rectangle_h_back <= '1';
			numh_back <= ((to_integer(Hcount) - HSYNC - HBACK_PORCH))mod 160 ;
		elsif Hcount >= HSYNC + HBACK_PORCH + YUN_POS + 640  then
			rectangle_h_back <= '0';
			numh_back<= 0;
      end if;   
  end process RectangleHGen_back;


RectangleVGen_back : process (clk)
  begin
       if reset = '1' then
			rectangle_v_back <= '1';
		elsif Vcount >= VSYNC + VBACK_PORCH and Vcount <= VSYNC + VBACK_PORCH + 479 then
			rectangle_v_back <= '1';
			numv_back <= ((to_integer(Vcount) - VSYNC - VBACK_PORCH))mod 160;
		elsif Vcount >= VSYNC + VBACK_PORCH + 480 then
			rectangle_v_back <= '0';
			numv_back<= 0;
      end if;   
  end process RectangleVGen_back;
numh_back_3<=numh_back_1 mod 160;

RectangleHGen_yun : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_yun <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH + YUN_POS and Hcount <= HSYNC + HBACK_PORCH + YUN_POS + 57 then
        rectangle_h_yun <= '1';
		 numh_yun <= to_integer(Hcount) - HSYNC - HBACK_PORCH - YUN_POS ;
      elsif Hcount >= HSYNC + HBACK_PORCH + YUN_POS +58  then
        rectangle_h_yun <= '0';
		numh_yun<= 0;
      end if;      
    end if;
  end process RectangleHGen_yun;


  RectangleVGen_yun : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
			rectangle_v_yun <= '0';
		  elsif EndOfLine = '1' then
			if Vcount >= VSYNC + VBACK_PORCH + 440 and Vcount <= VSYNC + VBACK_PORCH + 440+33 then
			  rectangle_v_yun <= '1';
			  numv_yun <= to_integer(Vcount) - VSYNC - VBACK_PORCH - 440 ;
			elsif Vcount >= VSYNC + VBACK_PORCH + 440+34 then
			  rectangle_v_yun <= '0';
				numv_yun <= 0;
			end if;
      end if;  
    end if;
  end process RectangleVGen_yun;



RectangleHGen_yun2 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_yun2 <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH +5 and Hcount <= HSYNC + HBACK_PORCH +5+33then
        rectangle_h_yun2 <= '1';
		 numv_yun2 <= to_integer(Hcount) - HSYNC - HBACK_PORCH-5 ;
      elsif Hcount >= HSYNC + HBACK_PORCH + 5+34 then
        rectangle_h_yun2 <= '0';
		numv_yun2<= 0;
      end if;      
    end if;
  end process RectangleHGen_yun2;


  RectangleVGen_yun2 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
			rectangle_v_yun2 <= '0';
		  elsif EndOfLine = '1' then
			if Vcount >= VSYNC + VBACK_PORCH + YUN_POS1+2 and Vcount <= VSYNC + VBACK_PORCH  + YUN_POS1 +2+55 then
			  rectangle_v_yun2 <= '1';
			  numh_yun2 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - YUN_POS1 ;
			elsif Vcount >= VSYNC + VBACK_PORCH  + YUN_POS1 +2 + 56 then
			  rectangle_v_yun2 <= '0';
				numh_yun2 <= 0;
			end if;
      end if;  
    end if;
  end process RectangleVGen_yun2;


RectangleHGen_yun3 : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_yun3 <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH +600 and Hcount <= HSYNC + HBACK_PORCH +600+33then
        rectangle_h_yun3 <= '1';
		 numv_yun3 <= to_integer(Hcount) - HSYNC - HBACK_PORCH-600;
      elsif Hcount >= HSYNC + HBACK_PORCH + 600+34 then
        rectangle_h_yun3 <= '0';
		numv_yun3<= 0;
      end if;      
    end if;
  end process RectangleHGen_yun3;


  RectangleVGen_yun3 : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
			rectangle_v_yun3 <= '0';
			elsif EndOfLine = '1' then
			if Vcount >= VSYNC + VBACK_PORCH + YUN_POS1+2 and Vcount <= VSYNC + VBACK_PORCH  + YUN_POS1+2+55 then
				  rectangle_v_yun3 <= '1';
				  numh_yun3 <= to_integer(Vcount) - VSYNC - VBACK_PORCH - YUN_POS1 ;
			elsif Vcount >= VSYNC + VBACK_PORCH  + YUN_POS1+2 + 56 then
				rectangle_v_yun3 <= '0';
				numh_yun3 <= 0;
			end if;
      end if;  
    end if;
  end process RectangleVGen_yun3;





RectangleHGen_ball : process (clk)
  begin
    if rising_edge(clk) then     
      if reset = '1' then
		rectangle_h_ball <= '1';
		elsif Hcount >= HSYNC + HBACK_PORCH + BALL_POS_H and Hcount <= HSYNC + HBACK_PORCH + BALL_POS_H + 15 then
        rectangle_h_ball <= '1';
		 numh_ball <= to_integer(Hcount) - HSYNC - HBACK_PORCH - BALL_POS_H;
      elsif Hcount >= HSYNC + HBACK_PORCH + BALL_POS_H + 16 then
        rectangle_h_ball <= '0';
		numh_ball<= 0;
      end if;      
    end if;
  end process RectangleHGen_ball;

 RectangleVGen_ball : process (clk)
  begin
    if rising_edge(clk) then
      if reset = '1' then       
        rectangle_v_ball <= '0';
      elsif EndOfLine = '1' then
        if Vcount >= VSYNC + VBACK_PORCH + BALL_POS_V and Vcount <= VSYNC + VBACK_PORCH + BALL_POS_V+14 then
          rectangle_v_ball <= '1';
		  numv_ball <= to_integer(Vcount) - VSYNC - VBACK_PORCH - BALL_POS_V ;
        elsif Vcount >= VSYNC + VBACK_PORCH + BALL_POS_V+15 then
          rectangle_v_ball <= '0';
			numv_ball <= 0;
        end if;
      end if;      
    end if;
  end process RectangleVGen_ball;

rectangle_ball <= rectangle_h_ball and rectangle_v_ball;
rectangle_yun <= rectangle_h_yun and rectangle_v_yun;
rectangle_yun1 <= rectangle_h_yun1 and rectangle_v_yun1;
rectangle_yun2 <= rectangle_h_yun2 and rectangle_v_yun2;
rectangle_yun3 <= rectangle_h_yun3 and rectangle_v_yun3;
rectangle <= rectangle_h and rectangle_v;
rectangle_back <= rectangle_v_back and rectangle_h_back;
rectangle_blackhole1 <= rectangle_v_blackhole1 and rectangle_h_blackhole1;
rectangle_blackhole2 <= rectangle_v_blackhole2 and rectangle_h_blackhole2;
rectangle_blackhole3 <= rectangle_v_blackhole3 and rectangle_h_blackhole3;
rectangle_loselife <= rectangle_v_loselife and rectangle_h_loselife;
rectangle_heart <= rectangle_v_heart and rectangle_h_heart;
rectangle_speedup <= rectangle_v_speedup and rectangle_h_speedup;
rectangle_numb <= rectangle_h_numb and rectangle_v_numb;

		HPOS <= to_integer(Hcount) - HSYNC - HBACK_PORCH;
		VPOS <= to_integer(Vcount) - VSYNC - VBACK_PORCH;
		numh_bug <= HPOS mod 40; 
		numv_bug <= VPOS mod 40;
		numh_bug_flag <= HPOS/40;
		numv_bug_flag <= VPOS/40;

RGB2 : process (clk_50)
begin 
 if rising_edge(clk_50) then
				if virb_sta1="1" and h_virb1=numh_bug_flag and v_virb1=numv_bug_flag then 

				case bugdie_sta is 
							when "00" =>
								OUT_R<=bugdie2(to_integer(bugdie2_RGB)) ;
								OUT_G<=bugdie2(to_integer(bugdie2_RGB)) ;
								OUT_B<=bugdie2(to_integer(bugdie2_RGB)) ;
							when "01" =>
								OUT_R<=bugdie3(to_integer(bugdie3_RGB)) ;
								OUT_G<=bugdie3(to_integer(bugdie3_RGB)) ;
								OUT_B<=bugdie3(to_integer(bugdie3_RGB)) ;
							when others =>
								
							end case;
				
				else
				
				
				case background(numh_bug_flag)(numv_bug_flag) is 
				when "1000" =>
							if BUG_STA1 = 0 then
								OUT_R<=bug_pink1(to_integer(bug_pink1_RGB))(23 downto 16) ;
								OUT_G<=bug_pink1(to_integer(bug_pink1_RGB))(15 downto 8) ;
								OUT_B<=bug_pink1(to_integer(bug_pink1_RGB))(7 downto 0) ;
							else
								OUT_R<=bug_pink2(to_integer(bug_pink2_RGB))(23 downto 16) ;
								OUT_G<=bug_pink2(to_integer(bug_pink2_RGB))(15 downto 8) ;
								OUT_B<=bug_pink2(to_integer(bug_pink2_RGB))(7 downto 0) ;
							end if;
				when "1001"  =>
				
							if BUG_STA2 = 0 then
								OUT_R<=bug_yellow1(to_integer(bug_yellow1_RGB))(23 downto 16) ;
								OUT_G<=bug_yellow1(to_integer(bug_yellow1_RGB))(15 downto 8) ;
								OUT_B<=bug_yellow1(to_integer(bug_yellow1_RGB))(7 downto 0) ;
							else
								OUT_R<=bug_yellow2(to_integer(bug_yellow2_RGB))(23 downto 16) ;
								OUT_G<=bug_yellow2(to_integer(bug_yellow2_RGB))(15 downto 8) ;
								OUT_B<=bug_yellow2(to_integer(bug_yellow2_RGB))(7 downto 0) ;
							end if;

				when "1010" =>
							if BUG_STA3 = 0 then
								OUT_R<=bug_green1(to_integer(bug_green1_RGB))(23 downto 16) ;
								OUT_G<=bug_green1(to_integer(bug_green1_RGB))(15 downto 8) ;
								OUT_B<=bug_green1(to_integer(bug_green1_RGB))(7 downto 0) ;
							else
								OUT_R<=bug_green2(to_integer(bug_green2_RGB))(23 downto 16) ;
								OUT_G<=bug_green2(to_integer(bug_green2_RGB))(15 downto 8) ;
								OUT_B<=bug_green2(to_integer(bug_green2_RGB))(7 downto 0) ;
							end if;
		
				
				
				
				when "1011" =>
							if BUG_STA4 = 0 then
								OUT_R<=bug_purple1(to_integer(bug_purple1_RGB))(23 downto 16) ;
								OUT_G<=bug_purple1(to_integer(bug_purple1_RGB))(15 downto 8) ;
								OUT_B<=bug_purple1(to_integer(bug_purple1_RGB))(7 downto 0) ;
							else
								OUT_R<=bug_purple2(to_integer(bug_purple2_RGB))(23 downto 16) ;
								OUT_G<=bug_purple2(to_integer(bug_purple2_RGB))(15 downto 8) ;
								OUT_B<=bug_purple2(to_integer(bug_purple2_RGB))(7 downto 0) ;
							end if;
		
	
	
	
				when "1100" =>
		
							if BUG_STA1 = 0 then
								OUT_R<=bug_pink1(to_integer(bug_pink1_RGB))(15 downto 8) ;
								OUT_G<=bug_pink1(to_integer(bug_pink1_RGB))(7 downto 0);
								OUT_B<=bug_pink1(to_integer(bug_pink1_RGB))(23 downto 16) ;
							else
								OUT_R<=bug_pink2(to_integer(bug_pink2_RGB))(15 downto 8) ;
								OUT_G<=bug_pink2(to_integer(bug_pink2_RGB))(7 downto 0);
								OUT_B<=bug_pink2(to_integer(bug_pink2_RGB))(23 downto 16) ;
							end if;
	

	
	
	
				when "1101" =>
		
							if BUG_STA3 = 0 then
								OUT_R<=bug_purple1(to_integer(bug_purple1_RGB))(15 downto 8) ;
								OUT_G<=bug_purple1(to_integer(bug_purple1_RGB))(7 downto 0);
								OUT_B<=bug_purple1(to_integer(bug_purple1_RGB))(23 downto 16) ;
							else
								OUT_R<=bug_purple2(to_integer(bug_purple2_RGB))(15 downto 8) ;
								OUT_G<=bug_purple2(to_integer(bug_purple2_RGB))(7 downto 0);
								OUT_B<=bug_purple2(to_integer(bug_purple2_RGB))(23 downto 16) ;
							end if;
		
	

	
	
				when "1110" =>
		
							if BUG_STA4 = 0 then
								OUT_R<=bug_yellow1(to_integer(bug_yellow1_RGB))(15 downto 8) ;
								OUT_G<=bug_yellow1(to_integer(bug_yellow1_RGB))(7 downto 0);
								OUT_B<=bug_yellow1(to_integer(bug_yellow1_RGB))(23 downto 16) ;
							else
								OUT_R<=bug_yellow2(to_integer(bug_yellow2_RGB))(15 downto 8) ;
								OUT_G<=bug_yellow2(to_integer(bug_yellow2_RGB))(7 downto 0);
								OUT_B<=bug_yellow2(to_integer(bug_yellow2_RGB))(23 downto 16) ;
							end if;
			
	
	
	
	
				when "1111" =>
			
							if BUG_STA2 = 0 then
								OUT_R<=bug_green1(to_integer(bug_green1_RGB))(15 downto 8) ;
								OUT_G<=bug_green1(to_integer(bug_green1_RGB))(7 downto 0);
								OUT_B<=bug_green1(to_integer(bug_green1_RGB))(23 downto 16) ;
							else
								OUT_R<=bug_green2(to_integer(bug_green2_RGB))(15 downto 8) ;
								OUT_G<=bug_green2(to_integer(bug_green2_RGB))(7 downto 0);
								OUT_B<=bug_green2(to_integer(bug_green2_RGB))(23 downto 16) ;
							end if;
				when others =>
				 end case;						
				 end if;	
			 end if;								
				
end process RGB2;

Rpink1 : work.bug_pink1_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_pink1_RGB
);

Rpink2 : work.bug_pink2_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_pink2_RGB
);


Ryellow1 : work.bug_yellow1_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_yellow1_RGB
);

Ryellow2 : work.bug_yellow2_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_yellow2_RGB
);


Rpurple1 : work.bug_purple1_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_purple1_RGB
);

Rpurple2 : work.bug_purple2_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_purple2_RGB
);

Rgreen1 : work.bug_green1_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_green1_RGB
);

Rgreen2 : work.bug_green2_rom
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bug_green2_RGB
);


pyun1 : work.xiaoyun1_rom
port map(
	clk => clk,
  h_addr => numh_yun,
  v_addr => numv_yun,
  dataout => yun1_RGB
);

pyun2 : work.xiaoyun2_rom
port map(
	clk => clk,
  h_addr => numh_yun,
  v_addr => numv_yun,
  dataout => yun2_RGB
);

pyun3 : work.xiaoyun3_rom
port map(
	clk => clk,
  h_addr => numh_yun,
  v_addr => numv_yun,
  dataout => yun3_RGB
);

pyun11 : work.xiaoyun1_rom
port map(
	clk => clk,
  h_addr => numh_yun1,
  v_addr => numv_yun1,
  dataout => yun11_RGB
);

pyun12 : work.xiaoyun2_rom
port map(
	clk => clk,
  h_addr => numh_yun1,
  v_addr => numv_yun1,
  dataout => yun12_RGB
);

pyun13 : work.xiaoyun3_rom
port map(
	clk => clk,
  h_addr => numh_yun1,
  v_addr => numv_yun1,
  dataout => yun13_RGB
);

pyun21 : work.xiaoyun1_rom
port map(
	clk => clk,
  h_addr => numh_yun2,
  v_addr => numv_yun2,
  dataout => yun21_RGB
);

pyun22 : work.xiaoyun3_rom
port map(
	clk => clk,
  h_addr => numh_yun2,
  v_addr => numv_yun2,
  dataout => yun22_RGB
);

pyun23 : work.xiaoyun3_rom
port map(
	clk => clk,
  h_addr => numh_yun2,
  v_addr => numv_yun2,
  dataout => yun23_RGB
);

pyun31 : work.xiaoyun1_rom
port map(
	clk => clk,
  h_addr => numh_yun3,
  v_addr => numv_yun3,
  dataout => yun31_RGB
);

pyun32 : work.xiaoyun2_rom
port map(
	clk => clk,
  h_addr => numh_yun3,
  v_addr => numv_yun3,
  dataout => yun32_RGB
);

pyun33 : work.xiaoyun3_rom
port map(
	clk => clk,
  h_addr => numh_yun3,
  v_addr => numv_yun3,
  dataout => yun33_RGB
);

pball : work.ball_rom
port map(
	clk => clk,
  h_addr => numh_ball,
  v_addr => numv_ball,
  dataout => ball_RGB
);

pbd2 : work.bugdie2
port map(
	clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bugdie2_RGB
);

pbd3 : work.bugdie3
port map(
  clk => clk,
  h_addr => numh_bug,
  v_addr => numv_bug,
  dataout => bugdie3_RGB
);

bdtm : work.timer_bugdie
port map(
  clk => clk,
  output => bugdie_sta
);

--tmd1 : work.timerfordie
--port map(
--clk=>clk,
--reset=>reset1 and (not reset11),
--output=>virb_sta1
--);

tmd2 : work.timerfordie
port map(
clk=>clk,
reset=>reset2 and (not reset22),
output=>virb_sta2
);
tmd3 : work.timerfordie
port map(
clk=>clk,
reset=>reset3 and (not reset33),
output=>virb_sta3
);

tmd4 : work.timerfordie
port map(
clk=>clk,
reset=>reset4 and (not reset44),
output=>virb_sta4
);

tmd5 : work.timer_ball
port map(
clk=>clk,
output=>ball_sta
);

backg : work.backround_rom
port map(
clk => clk,
  h_addr => numh_back,
  v_addr => numv_back,
  dataout => back_RGB
);

hert : work.heart_rom
port map(
clk => clk,
  h_addr => numh_heart,
  v_addr => numv_back,
  dataout => heart_RGB
);

speedu : work.speedup_rom
port map(
clk => clk,
  h_addr => numh_speedup,
  v_addr => numv_speedup,
  dataout => speedup_RGB
);

losel : work.loselife_rom
port map(
clk => clk,
  h_addr => numh_loselife,
  v_addr => numv_loselife,
  dataout => loselife_RGB
);





  VideoOut: process (clk, reset)
  begin
    if reset = '1' then
		  VGA_R <= "0000000000";
		  VGA_G <= "0000000000";
		  VGA_B <= "0000000000";
    elsif clk'event and clk = '1' then

if rectangle = '1'  and (
((numh_bug<=30 and numv_bug <=29 and numh_bug >=1)
 and background(numh_bug_flag)(numv_bug_flag)(3)='1'
and (OUT_R <=X"F5" or OUT_G <=X"F5" or OUT_B <=X"F5"))
or
(
(numh_bug<=36 and numv_bug <=34 and numh_bug >=2) 
and 
(
(virb_sta1="1" and h_virb1 = numh_bug_flag and v_virb1 = numv_bug_flag) 

)

and(OUT_G <=X"EE")
)
)
then
        VGA_R(9 downto 2) <= OUT_R ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= OUT_G ;
        VGA_G(1 downto 0) <= "11"; 
        VGA_B(9 downto 2) <= OUT_B ;
        VGA_B(1 downto 0) <= "11";
elsif rectangle_ball = '1' and (ball(to_integer(ball_RGB))(23 downto 16) <=X"F0" or ball(to_integer(ball_RGB))(15 downto 8) <=X"F0" or ball(to_integer(ball_RGB))(7 downto 0) <=X"F0") then
        
if Vcount >= VSYNC + VBACK_PORCH + BALL_POS_V and Vcount <= VSYNC + VBACK_PORCH + BALL_POS_V+14 then

		
		VGA_R(9 downto 2) <= ball(to_integer(ball_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= ball(to_integer(ball_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= ball(to_integer(ball_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
end if;
elsif rectangle_yun3 = '1' and (xiaoyun1(to_integer(yun32_RGB))(23 downto 16)<=X"F0" or xiaoyun1(to_integer(yun32_RGB))(15 downto 8)<=X"F0" or xiaoyun1(to_integer(yun32_RGB))(7 downto 0)<=X"F0") then
if YUN_STA41 =1 then
        VGA_R(9 downto 2) <= xiaoyun3(to_integer(yun33_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun3(to_integer(yun33_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun3(to_integer(yun33_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
else

        VGA_R(9 downto 2) <= xiaoyun1(to_integer(yun32_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun1(to_integer(yun32_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun1(to_integer(yun32_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
end if;
elsif rectangle_yun2 = '1'and (xiaoyun1(to_integer(yun22_RGB))(23 downto 16)<=X"F0" or xiaoyun1(to_integer(yun22_RGB))(15 downto 8)<=X"F0" or xiaoyun1(to_integer(yun22_RGB))(7 downto 0)<=X"F0" ) then
if YUN_STA31 =1 then
        VGA_R(9 downto 2) <= xiaoyun3(to_integer(yun23_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun3(to_integer(yun23_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun3(to_integer(yun23_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
else
case YUN_STA is
when 0 =>

        VGA_R(9 downto 2) <= xiaoyun1(to_integer(yun22_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun1(to_integer(yun22_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun1(to_integer(yun22_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
end if;
elsif rectangle_yun1 = '1' and (xiaoyun1(to_integer(yun11_RGB))(23 downto 16)<=X"F0" or xiaoyun1(to_integer(yun11_RGB))(15 downto 8)<=X"F0" or xiaoyun1(to_integer(yun11_RGB))(7 downto 0)<=X"F0")  then
if YUN_STA21 =1 then
        VGA_R(9 downto 2) <= xiaoyun3(to_integer(yun13_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun3(to_integer(yun13_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun3(to_integer(yun13_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
else


        VGA_R(9 downto 2) <= xiaoyun1(to_integer(yun11_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= xiaoyun1(to_integer(yun11_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= xiaoyun1(to_integer(yun11_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
end if;

elsif rectangle_yun = '1'and (xiaoyun1(to_integer(yun1_RGB))(23 downto 16)<=X"F0" or xiaoyun1(to_integer(yun1_RGB))(15 downto 8)<=X"F0" or xiaoyun1(to_integer(yun1_RGB))(7 downto 0)<=X"F0" ) then
if YUN_STA11 =1 then
VGA_R(9 downto 2) <= xiaoyun3(to_integer(yun3_RGB))(23 downto 16) ;
VGA_R(1 downto 0) <= "11";
VGA_G(9 downto 2) <= xiaoyun3(to_integer(yun3_RGB))(15 downto 8) ;
VGA_G(1 downto 0) <= "11";
VGA_B(9 downto 2) <= xiaoyun3(to_integer(yun3_RGB))(7 downto 0) ;
VGA_B(1 downto 0) <= "11";
else

VGA_R(9 downto 2) <= xiaoyun1(to_integer(yun1_RGB))(23 downto 16) ;
VGA_R(1 downto 0) <= "11";
VGA_G(9 downto 2) <= xiaoyun1(to_integer(yun1_RGB))(15 downto 8) ;
VGA_G(1 downto 0) <= "11";
VGA_B(9 downto 2) <= xiaoyun1(to_integer(yun1_RGB))(7 downto 0) ;
VGA_B(1 downto 0) <= "11";
end if;


elsif rectangle_heart = '1' and heartnum(numh_heart2)='1'and (heart(to_integer(heart_RGB))(23 downto 16)<=X"F0" or heart(to_integer(heart_RGB))(15 downto 8)<=X"F0" or heart(to_integer(heart_RGB))(7 downto 0)<=X"F0")  then

        VGA_R(9 downto 2) <= heart(to_integer(heart_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= heart(to_integer(heart_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= heart(to_integer(heart_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";

elsif rectangle_loselife = '1'and (loselife(to_integer(loselife_RGB))(23 downto 16)<=X"F0" or loselife(to_integer(loselife_RGB))(15 downto 8)<=X"F0" or loselife(to_integer(loselife_RGB))(7 downto 0)<=X"F0" ) then
        VGA_R(9 downto 2) <= loselife(to_integer(loselife_RGB))(23 downto 16) ;
        VGA_R(1 downto 0) <= "11";
        VGA_G(9 downto 2) <= loselife(to_integer(loselife_RGB))(15 downto 8) ;
        VGA_G(1 downto 0) <= "11";
        VGA_B(9 downto 2) <= loselife(to_integer(loselife_RGB))(7 downto 0) ;
        VGA_B(1 downto 0) <= "11";
elsif vga_hblank = '0' and vga_vblank ='0' then					
			VGA_R <= "1111111111";
			VGA_G <= "1111111111";
			VGA_B <= "1111111111"; 
	else
			VGA_R <= "0000000000";
			VGA_G <= "0000000000";
			VGA_B <= "0000000000"; 
end if;
end if;
end process;


  VGA_CLK <= clk;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);
end rtl;