library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity ball_rom is

  port (
  clk : in std_logic;
  h_addr: in integer; 
  v_addr: in integer;
  dataout: out unsigned (3 downto 0)
  );
  end ball_rom;
architecture rom of ball_rom is
	type ball_row is array(0 to 14) of unsigned(3 downto 0);
	type ball_column is array(0 to 14) of ball_row; 
constant ball : ball_column:=(
(X"f",X"f",X"f",X"f",X"6",X"0",X"0",X"0",X"0",X"6",X"f",X"f",X"f",X"f",X"f"),
(X"f",X"f",X"a",X"1",X"1",X"6",X"6",X"6",X"2",X"1",X"1",X"a",X"f",X"f",X"f"),
(X"f",X"6",X"0",X"6",X"e",X"e",X"f",X"e",X"e",X"e",X"6",X"0",X"6",X"f",X"f"),
(X"e",X"0",X"a",X"f",X"e",X"c",X"5",X"c",X"e",X"e",X"f",X"a",X"0",X"6",X"f"),
(X"2",X"2",X"e",X"e",X"e",X"7",X"8",X"3",X"e",X"e",X"e",X"f",X"6",X"1",X"e"),
(X"1",X"a",X"e",X"e",X"9",X"4",X"d",X"8",X"3",X"3",X"3",X"c",X"e",X"1",X"2"),
(X"2",X"e",X"c",X"5",X"4",X"d",X"b",X"8",X"8",X"8",X"3",X"c",X"e",X"2",X"0"),
(X"6",X"f",X"9",X"4",X"d",X"d",X"8",X"8",X"8",X"8",X"7",X"e",X"e",X"6",X"0"),
(X"2",X"e",X"e",X"7",X"4",X"b",X"8",X"8",X"8",X"3",X"e",X"e",X"e",X"6",X"0"),
(X"2",X"e",X"e",X"e",X"5",X"8",X"8",X"8",X"8",X"8",X"9",X"e",X"e",X"2",X"2"),
(X"1",X"a",X"e",X"e",X"5",X"b",X"b",X"4",X"3",X"3",X"7",X"f",X"a",X"1",X"f"),
(X"2",X"2",X"e",X"e",X"5",X"4",X"7",X"e",X"c",X"9",X"f",X"e",X"1",X"2",X"f"),
(X"e",X"1",X"2",X"e",X"c",X"c",X"e",X"e",X"e",X"e",X"e",X"2",X"0",X"e",X"f"),
(X"f",X"e",X"1",X"0",X"6",X"a",X"e",X"e",X"a",X"6",X"1",X"1",X"e",X"f",X"f"),
(X"f",X"f",X"f",X"6",X"2",X"1",X"1",X"1",X"1",X"1",X"6",X"f",X"f",X"f",X"f")
);
begin 
 process (clk)
	begin
		if rising_edge(clk) then
				dataout<= ball(h_addr)(v_addr);
		end if;
	end process;	
end rom; 
