library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity rotary_top is port (
  clk, reset_n, chipselect, read, write, address : in std_logic;
  readdata  : out std_logic_vector(15 downto 0);
  writedata : in  std_logic_vector(15 downto 0);

  irq       : out std_logic;
  GPIO_1     : inout std_logic_vector(35 downto 0);
  key        : in  unsigned( 3 downto 0);
  leds       : out std_logic_vector(17 downto 0)
  );
end rotary_top;

architecture rtl of rotary_top is 

component rotary_controller is 
	port(
		CLOCK_50 : in	std_logic;
		GPIO_1   : inout std_logic_vector(35 downto 0);
		ledr     : out std_logic_vector(17 downto 0);
		r_output : out unsigned (1 downto 0)
	);
end component rotary_controller;

  signal ram : unsigned (1 downto 0) := "00";
  signal temp : std_logic := '0';
  signal data    : std_logic_vector(15 downto 0);
  signal counter : unsigned(25 downto 0);

  begin

C1 : rotary_controller
    port map(
		CLOCK_50 => clk,
		GPIO_1   => GPIO_1,
		ledr     => leds,
		r_output => ram
    );

  process (clk)
  begin
	if(ram = "10") then
		readdata <= X"0002";
	elsif(ram = "01") then
		readdata <= X"0001";
	end if; 
	
    if rising_edge(clk) then
		if reset_n = '0' then
			irq <= '0';
		else
			if write = '1' and chipselect = '1' then
			irq <= '0';  -- important to reset the irq
			elsif ((ram = "10" or ram = "01") and (temp = '0')) then			
			irq  <= '1';
			temp <= '1';
			elsif ram = "00" then
			temp <= '0';
			--irq <= '0';
            end if;
		end if;
	end if;
end process; 
end rtl;


