library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity rotary_controller is

	port(
		CLOCK_50 : in	std_logic;
		GPIO_1   : inout std_logic_vector(35 downto 0);
		ledr     : out std_logic_vector(17 downto 0);
		r_output : out unsigned (1 downto 0)
	);

end entity;

architecture testing of rotary_controller is
    
	type state_type is (s0, s1, s2, s3, s4, s5, s6);
   
	signal state         : state_type := s0;
	signal temp          : std_logic_vector(7 downto 0) := "00000000";--value of clk_count determines the duration of high level voltage
	signal rc_input      : std_logic_vector(1 downto 0);
    signal clk_count     : integer range 0 to 10000:=0;
    signal output_flag   : std_logic_vector(1 downto 0):="00";
    signal output_buffer : unsigned (1 downto 0):="00";
    
begin

    rc_input <=not GPIO_1(25 downto 24);
	r_output <= output_buffer;
    ledr(7 downto 0) <= temp;   

p1: process (CLOCK_50)
	begin
		if (rising_edge(CLOCK_50)) then
			case state is
				when s0=>
					if rc_input = "01" then
						state <= s1;				
					elsif rc_input= "10" then
						state <= s4;
					else
			            state <= s0;	
					end if;
				when s1=>
					if rc_input = "11" then
						state <= s2;
					elsif rc_input = "01" then
				        state <= s1;
				    else 
					    state <= s0;
					end if;
				when s2=>
					if rc_input = "10" then
						state <= s3;
					elsif rc_input = "11" then 
				        state <= s2;
				    else 
					    state <= s0;
					end if;
				when s3 =>
					--if rc_input = "10" then
					--	state <= s3;
			       	--else
			            state <= s0;
					--end if;
				when s4 =>
					if rc_input = "11" then
						state <= s5;
					elsif rc_input = "10" then 
				        state <= s4;
					else
				        state <= s0;
					end if;
				when s5 =>
					if rc_input = "01" then
						state <= s6;
						
					elsif rc_input = "11" then 
				        state <= s5;
					else
				        state <= s0;
					end if;
				when others =>
			            state <= s0;		
			    end case;
		end if;
	end process p1;
	
p2:	process (CLOCK_50)
	begin
	if rising_edge(CLOCK_50) then  
		 case state is		    
		    when s0 => 
				temp <= "00000001";
			when s1 => 
				temp <= "00000010";
			when s2 => 
				temp <= "00000100";
			when s3 =>
				temp <= "00001000";
				output_flag <= "10";     --clockwise rotation				
			when s4 => 
				temp <= "00010000";
			when s5 => 
				temp <= "00100000";	
			when others =>
				temp <= "01000000";
				output_flag <= "01";     --counter-clockwise rotation		
		 end case;

         if output_flag ="10" then
         clk_count <= clk_count+1; 
         output_buffer <="10";        

         elsif output_flag ="01" then
         clk_count <= clk_count+1;
         output_buffer <= "01";     
         
         elsif output_flag ="00" then
         output_buffer <="00";
         clk_count <=0;
         
         end if;

         if clk_count=10000 then
           output_flag <="00";
           clk_count<=0;
         end if;
    end if;

end process p2;
end testing;
