library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
entity rom_32_4 is

port (Clk: in std_logic;
addr_x : in integer;
addrg_x : in integer;
addrb_x : in integer;
addr_y : in integer;
addrg_y : in integer;
addrb_y : in integer;
data : out std_logic_vector(9 downto 0);
datag : out std_logic_vector(9 downto 0);
datab : out std_logic_vector(9 downto 0);
addr_r_x : in integer;
addrg_r_x : in integer;
addrb_r_x : in integer;
addr_r_y : in integer;
addrg_r_y : in integer;
addrb_r_y : in integer;
data_r : out std_logic_vector(9 downto 0);
datag_r : out std_logic_vector(9 downto 0);
datab_r : out std_logic_vector(9 downto 0));
end rom_32_4;

architecture imp of rom_32_4 is
type rom_type is array (0 to 119, 0 to 20) of std_logic_vector (9 downto 0);
constant pad_r : rom_type :=

(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0100000100","0100001000","0100001000","0100000100","0100001000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0100001000","0100000100","0100000100","0100001000","0100000100","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0100100000","0011110000","0011101100","0011101100","0100001000","0100000100","0100100000","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0011110100","0100000100","0011100000","0011100000","0011100000","0100001000","0100000100","0100000100","0011110100","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0100000100","0011111100","0011111100","0100011000","0100000100","1011011100","1011011100","1011011100","0100001000","0100000100","0100001000","0100011000","0011111100","0011111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011111100","0011111100","0100010000","0011110100","0011110100","1111111100","1111111100","1111111100","0011111000","0011110100","0011111000","0011110100","0100010100","0011111100","0011111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0011111100","0011111100","0100000000","0100000100","0100000100","0100000100","1111111100","1111111100","1111111100","0100001000","0100000100","0100000100","0100000100","0100000100","0011111100","0011111100","0011111100","0000000000","0000000000"),
("0000000000","0000000000","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","1111111100","1111111100","1111111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0000000000","0000000000"),
("0000000000","0000000000","1001000100","1010000000","1001100100","1001101000","1001100100","1001100100","1000010000","1000010000","1000010000","1001100100","1001101000","1001100100","1001100100","1001100100","1001100100","1001100100","1010000100","1001000100","0000000000"),
("0000000000","1001000100","1001100000","1001000100","1001000000","1001000100","1001000100","1001000000","1001000100","1001000000","1001000100","1001000000","1001000100","1001000000","1001000100","1001000100","1001000100","1001000000","1001000100","1001100000","0000100000"),
("0000000000","1001000100","1001011000","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000000","1001000000","1001000000","1001011000","1001000100"),
("1001000100","1001000100","1001000000","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000000","1001000000","1001000100","1001111100"),
("1001110000","1001000000","1001000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001000000","1001000000","1001000000","1001000000","1001000000"),
("1001001100","1001000000","1001000100","1111101100","1111101000","1111101100","1111111100","1111111100","1111101100","1111101000","1111101100","1111101100","1111101100","1111101100","1111101100","1111101100","1001000000","1001000000","1001000100","1001000000","1001000100"),
("1001000100","1001000100","1001000100","1111100100","1111100000","1111100100","1111111100","1111111100","1111100100","1111100000","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000100"),
("1001000100","1001000100","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000100","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000100","1001000100"),
("1001000100","1001000000","1001000100","1111100100","1111100100","1111100000","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000100","1001000000","1001000100","1111100100","1111100100","1111100000","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000000","1001000100","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000000","1001000000","1001000100"),
("1001000000","1001110000","1001110000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001110000","1001110000","1001110000","1001110000","1001000100"),
("1001000000","0111111100","0111111100","1111100100","1111100100","1111100100","1110000100","1110000100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000000000","0111111100","0111111100","1000000000","1001000100"),
("1001000100","0001010100","0001010100","0010010100","0010010100","0010010100","0010011000","0010011000","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0001011000","0001010100","0001010100","0001011000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","1001000100"),
("1001000100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","1001000100"),
("1001000100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0001011000","0001010100","0010010100","0010010100","0010010100","0010011000","0010011000","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0001011000","0001010100","0001011000","0001011000","1001000100"),
("1001000000","1000000000","0111111100","1101101000","1101101000","1101101100","1110000100","1110000100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1000000000","0111111100","1000000000","1000000000","1001000000"),
("1001000000","1001000100","1001000100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001000100","1001000100","1001000100","1001000100","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1001000000","1001000000","1001000000","1001000100","1001000000"),
("1001000000","1001000100","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1001000100","1001000000","1001000000","1001000100","1001000000"),
("1001000000","1001000100","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000000","1001000100"),
("1001000000","1001000100","1001000100","1111100000","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000000","1001000100"),
("1001001000","1000111000","1000111100","1111100000","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000111100","1000111000","1000111000","1000111000","1000111100"),
("1001110000","1000100000","1000100000","1111100100","1111100000","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000100100","1000100000","1000100000","1000100000","1000100000"),
("1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111110000","1111110000","1111110000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100"),
("1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100000","1111111100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111111100","1111111100","1111111100","1111100100","1111100100"),
("1111100100","1111100100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111111100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100000","1111111100","1111100100"),
("0000000000","1111100100","1111100100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111100100","1111111100","1111100100","1111100100","0000000000"),
("0000000000","0000000000","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","1111111100","1111111100","1111111100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000"),
("0000000000","0000000000","0100000100","0011100000","0100000000","0100000000","0100000000","0011100000","1111111100","1111111100","1111111100","0100000100","0100000000","0100000000","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011100000","0011100000","0011111100","0011100000","0011100000","1111111100","1111111100","1111111100","0011100100","0011100000","0011100000","0011100100","0011100000","0011111100","0011100000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0100000100","0011100000","0100011000","0100000100","1111111100","1111111100","1111111100","0100001000","0100000100","0100000100","0100001000","0100011000","0011100000","0100000100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0100000100","0011100000","0011100000","0100001000","1111001100","1111001100","1111001100","0100000100","0100000100","0100000100","0100000100","0011100000","0100000100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0011100000","0011100000","0100100000","0110100000","0110100000","0110100000","0100000100","0100000100","0100100000","0100000100","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011100000","0011100000","0010111100","0010111000","0010111100","0100000100","0100000100","0011100000","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")
);
constant pad_g : rom_type :=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1110111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1110111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000010100","0000011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000011000","0000010100","0000000000"),
("0000000000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000000000"),
("0000000000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0001100000","0001100000","0001100000","1111111100","1111111100","0001100000","0001011100","0001100000","0001100100","0001100000","0001011100","0001100000","0001100000","0000010100","0000010100","0000010000","0000010100","0000010000"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0000010100","0000010000","0000010100","0000010000","0000010100"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011100","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011100","0000010100","0000010000","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010000","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010000","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011100","0001011100","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011000","0001011000","0001011100","0000010100","0000010000","0000010100","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0000010100","0000010000","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010000","0001011000","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001100000","0001100000","0001100000","1111111100","1111111100","0001100000","0001100000","0001100000","0001100000","0001100100","0001100000","0001100000","0001100000","0000010100","0000011000","0000010000","0000010100","0000010100"),
("0000010100","0000010000","0000010000","0001011100","0001011100","0001011100","1110000100","1110000100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0000010000","0000010000","0000010000","0000010000","0000010100"),
("0000010100","0000000100","0000000100","0000001100","0000001100","0000001100","0010011000","0010011000","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000000100","0000000100","0000000100","0000000100","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000010100"),
("0000010100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000010100"),
("0000010100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000100","0000000100","0000001100","0000001100","0000001100","0010011000","0010011000","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000000100","0000000100","0000000100","0000000100","0000010100"),
("0000010100","0000010000","0000001100","0001001100","0001001100","0001010000","1110000100","1110000100","0001010000","0001010000","0001001100","0001001100","0001001100","0001001100","0001001100","0001001100","0000010000","0000010000","0000010000","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001100000","0001100000","0001100100","1111111100","1111111100","0001100100","0001100100","0001100000","0001100000","0001100000","0001100000","0001100000","0001100000","0000010100","0000010100","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010100","0001011100","0001011100","0001011100","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010000","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011100","1111111100","1111111100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010100","0000010000","0000010000","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010000"),
("0000010000","0000010100","0000010100","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010000"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011100","0001011000","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010000","0000010000","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001001000","0001001100","0001001000","0001011000","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000001100","0000001100","0001011000","0001011000","0001011100","1111111100","1111111100","0000001100","0000001100","0000001100","0001011000","0001011000","0001011000","0001011000","0001011000","0000010000","0000010000","0000001100","0000010000","0000010000"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011100","0001011100","0001011100","1001011100","1001011100","1001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011000","0000000000","0000000000","1111111100","1111111100","1111111100","0001011000","0001011100","0001011100","0001011000","0001011100","0001100000","0001100000","0001100100","0001011100","0001011100"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","1111111100","1111111100","1111111100","0001011000","0001011100","0001011100","0001011000","0001011100","0001011000","0001011000","0001011000","0001011100","0001011100"),
("0000000000","0001011100","0001011100","0001101000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0001011100","0000000000","0001011100","0001011100","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")
);

constant pad_b : rom_type :=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1110111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1110111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1110000100","1110000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010011000","0010011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000000000"),
("0000000000","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000000000"),
("0000000000","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010011000","0010011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1110000100","1110000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1000110100","1000110100","1000110100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")

);



begin
process (Clk)
begin
if rising_edge(Clk) then
	data <= pad_r(addr_y,addr_x); 
	datag <= pad_g(addrg_y,addrg_x); 
	datab <= pad_b(addrb_y,addrb_x); 
	data_r <= pad_r(addr_r_y,addr_r_x); 
	datag_r <= pad_g(addrg_r_y,addrg_r_x); 
	datab_r <= pad_b(addrb_r_y,addrb_r_x); 	
	end if;

end process;
end imp;