-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Stephen A. Edwards
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster is
  
  port (
    reset : in std_logic;
    clk : in std_logic;              -- Should be 25.125 MHz

    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); -- Blue[9:0]
    chipselect: in std_logic;
    write : in std_logic;
    read  : in std_logic;
    address:in unsigned(4 downto 0);
    readdata: out unsigned(15 downto 0);
    writedata:in unsigned(15 downto 0);
    byteenable: in unsigned(1 downto 0);
    irq: out std_logic
);

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;

  -- Signals for the video controller
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;
  
  signal RGB,RGB_G,RGB_B,RGB_r,RGB_G_r,RGB_B_r,RGB_bg,RGB_G_bg,RGB_B_bg : std_logic_vector (9 downto 0);
  
  signal background_x, background_y: integer;--back ground;
  --signal score_x,score_y: integer;
  
  signal vga_hblank, vga_hsync,
         vga_vblank, vga_vsync : std_logic;  -- Sync. signals
  signal l1,l2,l3,r1,r2,r3:integer:=2;--l1,l2,l3:left pad lose score; r1,r2,r3: right pad lose score;
 
  signal rectangle_h_ball, rectangle_v_ball, rectangle_h_ball1, rectangle_v_ball1,rectangle_h_ball2, rectangle_v_ball2,rectangle_h_paddle, rectangle_v_paddle ,
         rectangle_ball, rectangle_ball1, rectangle_ball2, rectangle_paddle,
         rectangle_h_paddle_2, rectangle_v_paddle_2,rectangle_paddle_2: std_logic;  -- rectangle area
  signal clk25 : std_logic:='0';
  signal RECTANGLE_HSTART: unsigned(15 downto 0):=x"0100" ;
  signal RECTANGLE_VSTART : unsigned(15 downto 0):=x"0000" ;
  signal RECTANGLE_HSTART_ball1: unsigned(15 downto 0):=x"0010" ;
  signal RECTANGLE_VSTART_ball1 : unsigned(15 downto 0):=x"0000" ;
  signal RECTANGLE_HSTART_ball2: unsigned(15 downto 0):=x"000F" ;
  signal RECTANGLE_VSTART_ball2 : unsigned(15 downto 0):=x"0000" ;
  signal RECTANGLE_HSTART_paddle: unsigned(15 downto 0):=x"0000" ;
  signal RECTANGLE_VSTART_paddle: unsigned(15 downto 0):=x"0000" ;
  signal RECTANGLE_HSTART_paddle_2: unsigned(15 downto 0):=x"016B" ;
  signal RECTANGLE_VSTART_paddle_2: unsigned(15 downto 0):=x"00a0" ;
  signal num :integer; 
  signal flag :std_logic:='0' ; 
  signal bg_flag :std_logic:='0' ; 

  type ram_type is array(0 to 15, 0 to 15 ) of std_logic_vector(9 downto 0);
  signal ball_r : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0001011100","0100010000","0110000100","0110000100","0100010100","0001011100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0001010000","0111010100","1100001000","1101110000","1110110000","1110111000","1110001100","1011111100","0110011000","0000111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0010000100","1011001100","1111001000","1110100100","1110000000","1110110100","1111000000","1110100000","1101110000","1101001000","1000101000","0001101000","0000000000","0000000000"),
("0000000000","0000101100","1001000000","1110101000","1111001000","1111001100","1111001100","1111011100","1111011000","1111000000","1101111100","1100111000","1011111000","0110101100","0000110000","0000000000"),
("0000000000","0101001000","1011010100","1110100100","1111010100","1111100100","1111101000","1111101000","1111101000","1111011000","1110101000","1101001000","1011100000","1000011000","0011101000","0000000000"),
("0001010100","1010010100","1100111000","1110110000","1111100100","1111101100","1111101100","1111101100","1111110000","1111100100","1110111000","1101011100","1011001000","0111110000","0101000100","0000110100"),
("0011101000","1011111000","1110000100","1111010000","1111101000","1111101100","1111101100","1111110000","1111101100","1111100000","1110111100","1101100100","1010111000","0111100000","0101010100","0001110100"),
("0100100000","1011101100","1110000100","1111010000","1111101100","1111101100","1111101100","1111101100","1111100100","1111011000","1110101000","1101001100","1010110100","0111111000","0101011100","0010010000"),
("0100001000","1010100000","1101000100","1110111000","1111100000","1111101000","1111101000","1111100100","1111011000","1110111000","1110000000","1100011100","1010001100","0111100100","0101010000","0010001100"),
("0010110000","1000011100","1011000100","1101101100","1110111000","1111001100","1111001100","1111000100","1110110000","1110001000","1101000000","1011010000","1001001000","0110110000","0100101100","0001100100"),
("0001000000","0110111000","1001101100","1100001100","1101100100","1110001000","1110010000","1110001000","1101101000","1100110100","1011100100","1001110100","1000000000","0110000000","0100001000","0000110000"),
("0000000000","0011111100","1000000100","1010000000","1011011000","1100010000","1100100000","1100011000","1011111000","1010111100","1001101000","0111111100","0110011000","0101011000","0011000000","0000000100"),
("0000000000","0000101100","0101011000","0111101100","1001000100","1010000000","1010001000","1010000100","1001100100","1001000000","0111101000","0110000000","0100110100","0011111100","0000110000","0000000000"),
("0000000000","0000000000","0001010100","0101011000","0111010000","0111100000","0111011000","0111011000","0111010100","0111010000","0110001000","0100110100","0011100100","0001001000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000110000","0011011000","0100110000","0101001100","0101010100","0101100000","0101100000","0100110000","0011000000","0000101100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000110100","0001110100","0010010100","0010011100","0001111000","0000111100","0000000000","0000000000","0000000000","0000000000","0000000000")
  );
 
signal ball_g : ram_type:=( 
("0000000000","0000000000","0000000000","0000000000","0000000000","0000111100","0011001100","0100011100","0100010100","0010111100","0000110000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000101000","0101010000","1010000000","1011101100","1011111100","1011110000","1011010100","1001010000","0100011000","0000011100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000111000","0110111100","1011011000","1010101000","1001011100","1001000100","1000110100","1001000100","1001111100","1010010100","0101100000","0000100000","0000000000","0000000000"),
("0000000000","0000001000","0011100000","1001000100","1000011000","0111000100","0110010000","0101111000","0101100000","0101010100","0101110000","0111000000","0111101100","0010011100","0000001000","0000000000"),
("0000000000","0000100100","0011010100","0110010100","0101010100","0100110000","0100011000","0100001100","0011110000","0011001000","0010110100","0011010000","0100101000","0010010100","0000001100","0000000100"),
("0000010000","0001000000","0010001000","0011111000","0100000000","0011111100","0011111000","0011110000","0011011000","0010100100","0001110100","0001011100","0001100100","0000101100","0000000100","0000001100"),
("0000100000","0001000100","0001111000","0011000000","0011101000","0011101100","0011101100","0011100100","0011001000","0010010000","0001100100","0000111100","0000011000","0000000000","0000000100","0000010000"),
("0000011000","0000111100","0001101000","0010011100","0011001100","0011011000","0011011100","0011001100","0010101000","0001111100","0001011000","0000101100","0000001000","0000000000","0000000000","0000001100"),
("0000010100","0000101000","0001001100","0001110100","0010010100","0010100100","0010101000","0010011000","0001111100","0001100100","0001000100","0000010100","0000000000","0000000100","0000000100","0000001100"),
("0000010100","0000001100","0000100000","0001010000","0001101000","0001110100","0001110100","0001101100","0001011100","0001000100","0000100000","0000000100","0000000000","0000000000","0000000100","0000001100"),
("0000010000","0000001100","0000001000","0000101100","0001000000","0001001100","0001001100","0001000100","0000110100","0000011100","0000000100","0000000000","0000000000","0000000000","0000001000","0000001100"),
("0000000100","0000011000","0000000000","0000001000","0000010000","0000011000","0000011100","0000010100","0000001000","0000000000","0000000000","0000000100","0000000000","0000000100","0000010000","0000000100"),
("0000000000","0000001100","0000010100","0000000000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000","0000001100","0000001100","0000000000"),
("0000000000","0000000000","0000010100","0000010100","0000001100","0000000100","0000000100","0000000000","0000000000","0000000000","0000000100","0000000100","0000001100","0000010000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000010000","0000010100","0000001100","0000000100","0000000000","0000000000","0000000100","0000001100","0000010100","0000001100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000100","0000010000","0000010000","0000001100","0000001100","0000010000","0000001100","0000000100","0000000000","0000000000","0000000000","0000000000")
  ); 
 
signal ball_b : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001000100","0001111000","0001110100","0001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0001111100","0110000000","1000000100","1000100100","1000100100","1000000100","0110000000","0010000100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0010110100","0111101100","0111011000","0110001100","0101101100","0101101100","0110001100","0111010100","0111110000","0010111000","0000000000","0000000000","0000000000"),
("0000000000","0000000100","0000110000","0101010100","0100110100","0011010100","0010101000","0010010000","0010010100","0010101000","0011010100","0100110000","0101011100","0000110100","0000000100","0000000000"),
("0000000000","0000001000","0001001000","0011000000","0001100100","0000111000","0000100000","0000011000","0000011100","0000101000","0000111000","0001100100","0011000100","0001010000","0000001000","0000000100"),
("0000010000","0000001100","0000011000","0000110000","0000010000","0000001000","0000000100","0000000100","0000000100","0000000100","0000000100","0000010000","0000110000","0000011000","0000001000","0000010000"),
("0000010000","0000001000","0000000000","0000000100","0000000000","0000000100","0000000100","0000000100","0000000000","0000000100","0000000000","0000000100","0000001000","0000000100","0000000100","0000001100"),
("0000001100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000001100"),
("0000001100","0000000100","0000001000","0000000100","0000000000","0000001000","0000000100","0000000100","0000000100","0000000000","0000000100","0000000000","0000000000","0000000000","0000000100","0000001100"),
("0000010000","0000000100","0000000100","0000000000","0000000000","0000000100","0000000000","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000001100"),
("0000001100","0000001100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000001000","0000001100"),
("0000000100","0000010100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000010000","0000000100"),
("0000000000","0000001100","0000001100","0000000000","0000000000","0000000100","0000001000","0000000000","0000000000","0000000100","0000000100","0000000100","0000000000","0000001100","0000001100","0000000000"),
("0000000000","0000000000","0000010000","0000001100","0000000100","0000000000","0000000100","0000000000","0000000000","0000000100","0000000000","0000000000","0000001100","0000010000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000001100","0000010000","0000001000","0000000100","0000000100","0000000100","0000000100","0000001000","0000010100","0000001100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000100","0000010000","0000010000","0000001100","0000001100","0000001100","0000001100","0000000100","0000000000","0000000000","0000000000","0000000000")
  );

signal ball1_r : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000111000","0010100100","0011101000","0011101000","0010100100","0000111000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000110000","0100011000","0111010000","1000010000","1000111000","1000111100","1000100000","0111001100","0011110100","0000100100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0001010000","0110101100","1001000100","1000110000","1000011000","1000111000","1001000000","1000101100","1000010000","0111111000","0101001100","0001000000","0000000000","0000000000"),
("0000000000","0000011100","0101011000","1000110000","1001000100","1001001000","1001001000","1001010000","1001010000","1001000000","1000011000","0111110000","0111001000","0100000000","0000011100","0000000000"),
("0000000000","0011000100","0110110100","1000110000","1001001100","1001010100","1001011000","1001011000","1001011000","1001010000","1000110000","0111111000","0110111000","0101000000","0010001100","0000000000"),
("0000110100","0110001100","0111110000","1000111000","1001010100","1001011100","1001011100","1001011100","1001011100","1001010100","1000111100","1000000100","0110101100","0100101000","0011000100","0000100000"),
("0010001100","0111001000","1000011100","1001001000","1001011000","1001011100","1001011100","1001011100","1001011100","1001010100","1000111100","1000001000","0110100000","0100100000","0011001100","0001000100"),
("0010101100","0111000000","1000011100","1001001000","1001011100","1001011100","1001011100","1001011100","1001010100","1001010000","1000110000","0111111100","0110100000","0100110000","0011010000","0001011000"),
("0010100000","0110010100","0111110100","1000111100","1001010100","1001011000","1001011000","1001010100","1001010000","1000111100","1000011000","0111011100","0110001000","0100100100","0011001000","0001010100"),
("0001101000","0101000100","0110101000","1000001100","1000111100","1001001000","1001001000","1001000100","1000111000","1000100000","0111110100","0110110000","0101100000","0100000100","0010110100","0000111100"),
("0000101000","0100001000","0101110100","0111010100","1000001000","1000100000","1000100100","1000100000","1000001100","0111101100","0110111100","0101111000","0100110100","0011101000","0010100000","0000011100"),
("0000000000","0010011000","0100110100","0110000000","0110110100","0111011000","0111100000","0111011100","0111001000","0110100100","0101110000","0100110000","0011110100","0011010000","0001110100","0000000100"),
("0000000000","0000011100","0011010000","0100101000","0101011100","0110000000","0110000100","0110000100","0101110000","0101011000","0100100100","0011101000","0010111000","0010011000","0000011100","0000000000"),
("0000000000","0000000000","0000110100","0011010000","0100011000","0100100000","0100011100","0100011100","0100011000","0100011000","0011101100","0010111000","0010001000","0000101100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000011100","0010000000","0010111000","0011001000","0011001100","0011010100","0011010100","0010111000","0001110100","0000011100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000100000","0001000100","0001011000","0001011100","0001001000","0000100100","0000000000","0000000000","0000000000","0000000000","0000000000")
  );

signal ball1_g : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000100100","0001111100","0010101100","0010100100","0001110000","0000011100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000011000","0011001000","0110000000","0111000000","0111001100","0111000100","0110110100","0101100100","0010101000","0000010000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000100000","0100001100","0110110100","0110011000","0101101100","0101011100","0101010100","0101011100","0101111100","0110001100","0011010100","0000010100","0000000000","0000000000"),
("0000000000","0000000100","0010001000","0101011100","0101000000","0100010000","0011110000","0011100000","0011010100","0011001100","0011011100","0100001100","0100101000","0001011100","0000000100","0000000000"),
("0000000000","0000010100","0010000000","0011110100","0011001100","0010111000","0010101000","0010100000","0010010000","0001111000","0001101100","0001111100","0010110000","0001011000","0000001000","0000000100"),
("0000001000","0000101000","0001010000","0010010100","0010011000","0010011000","0010010100","0010010000","0010000000","0001100100","0001000100","0000111000","0000111100","0000011100","0000000100","0000001000"),
("0000010100","0000101000","0001001000","0001110100","0010001100","0010001100","0010001100","0010001000","0001111000","0001011000","0000111100","0000100100","0000010000","0000000000","0000000100","0000001000"),
("0000010000","0000100100","0001000000","0001011100","0001111100","0010000000","0010000100","0001111100","0001100100","0001001100","0000110100","0000011100","0000000100","0000000000","0000000000","0000001000"),
("0000001100","0000011000","0000101100","0001000100","0001011000","0001100100","0001100100","0001011100","0001001100","0000111100","0000101000","0000001100","0000000000","0000000100","0000000100","0000001000"),
("0000001100","0000001000","0000010100","0000110000","0001000000","0001000100","0001000100","0001000000","0000111000","0000101000","0000010100","0000000100","0000000000","0000000000","0000000100","0000001000"),
("0000001000","0000001000","0000000100","0000011100","0000101000","0000101100","0000101100","0000101000","0000100000","0000010000","0000000100","0000000000","0000000000","0000000000","0000000100","0000001000"),
("0000000100","0000010000","0000000000","0000000100","0000001000","0000010000","0000010000","0000001100","0000000100","0000000000","0000000000","0000000100","0000000000","0000000100","0000001000","0000000100"),
("0000000000","0000001000","0000001100","0000000000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000","0000001000","0000001000","0000000000"),
("0000000000","0000000000","0000001100","0000001100","0000001000","0000000100","0000000100","0000000000","0000000000","0000000000","0000000100","0000000100","0000001000","0000001000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000001000","0000001100","0000001000","0000000100","0000000000","0000000000","0000000100","0000001000","0000001100","0000001000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000100","0000001000","0000001000","0000001000","0000001000","0000001000","0000001000","0000000100","0000000000","0000000000","0000000000","0000000000")
  );


signal ball1_b : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000101000","0001001000","0001000100","0000101000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0001001100","0011101000","0100110100","0101001000","0101001000","0100110100","0011101000","0001010000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0001101100","0100101000","0100011100","0011101100","0011011100","0011011100","0011101100","0100011000","0100101000","0001110000","0000000000","0000000000","0000000000"),
("0000000000","0000000100","0000011100","0011001100","0010111000","0010000000","0001100100","0001011000","0001011000","0001100100","0010000000","0010111000","0011010000","0000100000","0000000100","0000000000"),
("0000000000","0000000100","0000101100","0001110100","0000111100","0000100000","0000010100","0000010000","0000010000","0000011000","0000100000","0000111100","0001110100","0000110000","0000000100","0000000100"),
("0000001000","0000001000","0000010000","0000011100","0000001000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000001000","0000011100","0000010000","0000000100","0000001000"),
("0000001000","0000000100","0000000000","0000000100","0000000000","0000000100","0000000100","0000000100","0000000000","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000001000"),
("0000001000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000001000"),
("0000001000","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000000","0000000000","0000000000","0000000100","0000001000"),
("0000001000","0000000100","0000000100","0000000000","0000000000","0000000100","0000000000","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000001000"),
("0000001000","0000001000","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000100","0000000100","0000000100","0000001000"),
("0000000100","0000001100","0000000100","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000001000","0000000100"),
("0000000000","0000001000","0000001000","0000000000","0000000000","0000000100","0000000100","0000000000","0000000000","0000000100","0000000100","0000000100","0000000000","0000001000","0000001000","0000000000"),
("0000000000","0000000000","0000001000","0000001000","0000000100","0000000000","0000000100","0000000000","0000000000","0000000100","0000000000","0000000000","0000001000","0000001000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000001000","0000001000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000001100","0000001000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000100","0000001000","0000001000","0000001000","0000001000","0000001000","0000001000","0000000100","0000000000","0000000000","0000000000","0000000000")
  );


signal ball2_r : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000100000","0001100000","0010001000","0010001000","0001100000","0000100000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000011100","0010100100","0100010000","0100111000","0101001100","0101010000","0101000000","0100001100","0010010000","0000010100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000110000","0011111100","0101010100","0101001000","0100111100","0101010000","0101010100","0101001000","0100111000","0100101000","0011000100","0000100100","0000000000","0000000000"),
("0000000000","0000010000","0011001100","0101001100","0101010100","0101011000","0101011000","0101011100","0101011100","0101010100","0100111100","0100100100","0100001100","0010011000","0000010000","0000000000"),
("0000000000","0001110100","0100000000","0101001000","0101011000","0101100000","0101100000","0101100000","0101100000","0101011100","0101001100","0100101000","0100000100","0010111100","0001010000","0000000000"),
("0000011100","0011101000","0100100100","0101001100","0101100000","0101100100","0101100100","0101100100","0101100100","0101100000","0101010000","0100110000","0011111100","0010110000","0001110100","0000010100"),
("0001010000","0100001100","0100111100","0101011000","0101100000","0101100100","0101100100","0101100100","0101100100","0101100000","0101010000","0100110100","0011110100","0010101000","0001111000","0000101000"),
("0001100100","0100001000","0100111100","0101011000","0101100100","0101100100","0101100100","0101100100","0101100000","0101011100","0101001100","0100101000","0011110100","0010110000","0001111100","0000110100"),
("0001011100","0011101100","0100101000","0101010000","0101100000","0101100000","0101100000","0101100000","0101011100","0101010000","0100111100","0100011000","0011101000","0010101100","0001111000","0000110000"),
("0001000000","0011000000","0011111000","0100110100","0101010000","0101011000","0101011000","0101010100","0101001100","0101000000","0100100100","0100000000","0011010000","0010011000","0001101000","0000100100"),
("0000011000","0010011100","0011011100","0100010100","0100110100","0101000000","0101000000","0101000000","0100110100","0100100000","0100000100","0011011100","0010110100","0010001000","0001011100","0000010000"),
("0000000000","0001011000","0010111000","0011100000","0100000000","0100010100","0100011100","0100011000","0100001100","0011111000","0011011000","0010110100","0010010000","0001111000","0001000100","0000000000"),
("0000000000","0000010000","0001111000","0010101100","0011001100","0011100000","0011100100","0011100100","0011011000","0011001100","0010101100","0010001000","0001101100","0001011000","0000010000","0000000000"),
("0000000000","0000000000","0000011100","0001111000","0010100100","0010101000","0010101000","0010101000","0010100100","0010100100","0010001100","0001101100","0001010000","0000011000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000010000","0001001100","0001101100","0001110100","0001111000","0001111100","0001111100","0001101100","0001000100","0000010000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000010100","0000101000","0000110100","0000111000","0000101100","0000010100","0000000000","0000000000","0000000000","0000000000","0000000000")
  );

signal ball2_g : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000010100","0001001000","0001100100","0001100000","0001000100","0000010000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000010000","0001111000","0011100000","0100001000","0100001100","0100001000","0100000000","0011010000","0001100100","0000001000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000010100","0010011100","0100000000","0011110000","0011010100","0011001100","0011001000","0011001100","0011100000","0011101000","0001111100","0000001100","0000000000","0000000000"),
("0000000000","0000000100","0001010000","0011001100","0010111100","0010100000","0010001100","0010000100","0001111100","0001111000","0010000000","0010100000","0010101100","0000111000","0000000100","0000000000"),
("0000000000","0000001100","0001001100","0010010000","0001111000","0001101100","0001100100","0001100000","0001010100","0001001000","0001000000","0001001000","0001101000","0000110100","0000000100","0000000000"),
("0000000100","0000011000","0000110000","0001011000","0001011100","0001011000","0001011000","0001010100","0001001100","0000111000","0000101000","0000100000","0000100100","0000010000","0000000000","0000000100"),
("0000001100","0000011000","0000101100","0001000100","0001010000","0001010100","0001010100","0001010000","0001001000","0000110100","0000100100","0000010100","0000001000","0000000000","0000000000","0000000100"),
("0000001000","0000010100","0000100100","0000111000","0001001000","0001001100","0001001100","0001001000","0000111100","0000101100","0000100000","0000010000","0000000100","0000000000","0000000000","0000000100"),
("0000001000","0000010000","0000011100","0000101000","0000110100","0000111000","0000111100","0000110100","0000101100","0000100100","0000011000","0000001000","0000000000","0000000000","0000000000","0000000100"),
("0000001000","0000000100","0000001100","0000011100","0000100100","0000101000","0000101000","0000101000","0000100000","0000011000","0000001100","0000000000","0000000000","0000000000","0000000000","0000000100"),
("0000000100","0000000100","0000000100","0000010000","0000011000","0000011100","0000011100","0000011000","0000010100","0000001000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100"),
("0000000000","0000001000","0000000000","0000000100","0000000100","0000001000","0000001000","0000001000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000000"),
("0000000000","0000000100","0000001000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000"),
("0000000000","0000000000","0000001000","0000001000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000100","0000001000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000100","0000001000","0000000100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000")
  );

signal ball2_b : ram_type:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000011000","0000101100","0000101000","0000011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000101100","0010001000","0010111000","0011000000","0011000000","0010111000","0010001000","0000110000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0001000000","0010101100","0010101000","0010001100","0010000000","0010000000","0010001100","0010100100","0010110000","0001000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000010000","0001111000","0001101100","0001001100","0000111100","0000110100","0000110100","0000111100","0001001100","0001101100","0001111100","0000010100","0000000000","0000000000"),
("0000000000","0000000100","0000011000","0001000100","0000100100","0000010100","0000001100","0000001000","0000001000","0000010000","0000010100","0000100100","0001000100","0000011100","0000000100","0000000000"),
("0000000100","0000000100","0000001000","0000010000","0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000010000","0000001000","0000000100","0000000100"),
("0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000000","0000000000","0000000100"),
("0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100"),
("0000000100","0000000000","0000000100","0000000000","0000000000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100"),
("0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100"),
("0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100"),
("0000000000","0000001000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000000"),
("0000000000","0000000100","0000000100","0000000000","0000000000","0000000000","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000"),
("0000000000","0000000000","0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000100","0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000100","0000001000","0000000100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000100","0000000100","0000000100","0000000100","0000000100","0000000100","0000000000","0000000000","0000000000","0000000000","0000000000")
  );
type rom_type is array (0 to 119, 0 to 20) of std_logic_vector (9 downto 0);
constant pad_r : rom_type :=

(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0100000100","0100001000","0100001000","0100000100","0100001000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0100001000","0100000100","0100000100","0100001000","0100000100","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0100100000","0011110000","0011101100","0011101100","0100001000","0100000100","0100100000","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0011111100","0011111100","0011110100","0100000100","0011100000","0011100000","0011100000","0100001000","0100000100","0100000100","0011110100","0011111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0100000100","0011111100","0011111100","0100011000","0100000100","1011011100","1011011100","1011011100","0100001000","0100000100","0100001000","0100011000","0011111100","0011111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011111100","0011111100","0100010000","0011110100","0011110100","1111111100","1111111100","1111111100","0011111000","0011110100","0011111000","0011110100","0100010100","0011111100","0011111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0011111100","0011111100","0100000000","0100000100","0100000100","0100000100","1111111100","1111111100","1111111100","0100001000","0100000100","0100000100","0100000100","0100000100","0011111100","0011111100","0011111100","0000000000","0000000000"),
("0000000000","0000000000","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","1111111100","1111111100","1111111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0011111100","0000000000","0000000000"),
("0000000000","0000000000","1001000100","1010000000","1001100100","1001101000","1001100100","1001100100","1000010000","1000010000","1000010000","1001100100","1001101000","1001100100","1001100100","1001100100","1001100100","1001100100","1010000100","1001000100","0000000000"),
("0000000000","1001000100","1001100000","1001000100","1001000000","1001000100","1001000100","1001000000","1001000100","1001000000","1001000100","1001000000","1001000100","1001000000","1001000100","1001000100","1001000100","1001000000","1001000100","1001100000","0000100000"),
("0000000000","1001000100","1001011000","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000000","1001000000","1001000000","1001011000","1001000100"),
("1001000100","1001000100","1001000000","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000100","1001000000","1001000000","1001000100","1001111100"),
("1001110000","1001000000","1001000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001000000","1001000000","1001000000","1001000000","1001000000"),
("1001001100","1001000000","1001000100","1111101100","1111101000","1111101100","1111111100","1111111100","1111101100","1111101000","1111101100","1111101100","1111101100","1111101100","1111101100","1111101100","1001000000","1001000000","1001000100","1001000000","1001000100"),
("1001000100","1001000100","1001000100","1111100100","1111100000","1111100100","1111111100","1111111100","1111100100","1111100000","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000100"),
("1001000100","1001000100","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000100","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000100","1001000100"),
("1001000100","1001000000","1001000100","1111100100","1111100100","1111100000","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000100","1001000000","1001000100","1111100100","1111100100","1111100000","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1001000000","1001000100","1001000100","1001000000","1001000000"),
("1001000000","1001000100","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000000","1001000000","1001000000","1001000100"),
("1001000000","1001110000","1001110000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001110000","1001110000","1001110000","1001110000","1001000100"),
("1001000000","0111111100","0111111100","1111100100","1111100100","1111100100","1110000100","1110000100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000000000","0111111100","0111111100","1000000000","1001000100"),
("1001000100","0001010100","0001010100","0010010100","0010010100","0010010100","0010011000","0010011000","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0001011000","0001010100","0001010100","0001011000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","1001000100"),
("1001000100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","1001000100"),
("1001000100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","1001000100"),
("1001000100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1001000100"),
("1001000100","0001011000","0001010100","0010010100","0010010100","0010010100","0010011000","0010011000","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0010010100","0001011000","0001010100","0001011000","0001011000","1001000100"),
("1001000000","1000000000","0111111100","1101101000","1101101000","1101101100","1110000100","1110000100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1101101100","1000000000","0111111100","1000000000","1000000000","1001000000"),
("1001000000","1001000100","1001000100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1001000100","1001000100","1001000100","1001000100","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1001000000","1001000000","1001000000","1001000100","1001000000"),
("1001000000","1001000100","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1001000000","1001000100","1001000000","1001000000","1001000000"),
("1001000100","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000100","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000100","1001000000","1001000000","1001000000"),
("1001000000","1001000000","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1001000100","1001000000","1001000000","1001000100","1001000000"),
("1001000000","1001000100","1001000000","1111100100","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000000","1001000100"),
("1001000000","1001000100","1001000100","1111100000","1111100100","1111100100","1111111100","1111111100","1111100000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1001000100","1001000000","1001000100","1001000000","1001000100"),
("1001001000","1000111000","1000111100","1111100000","1111100100","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000111100","1000111000","1000111000","1000111000","1000111100"),
("1001110000","1000100000","1000100000","1111100100","1111100000","1111100100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1000100100","1000100000","1000100000","1000100000","1000100000"),
("1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100100","1111100100","1111110000","1111110000","1111110000","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100100"),
("1111100100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100000","1111111100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111111100","1111111100","1111111100","1111100100","1111100100"),
("1111100100","1111100100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111111100","1111111100","1111111100","1111100100","1111100100","1111100100","1111100100","1111100100","1111100000","1111100100","1111100000","1111111100","1111100100"),
("0000000000","1111100100","1111100100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111100100","1111111100","1111100100","1111100100","0000000000"),
("0000000000","0000000000","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","1111111100","1111111100","1111111100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000"),
("0000000000","0000000000","0100000100","0011100000","0100000000","0100000000","0100000000","0011100000","1111111100","1111111100","1111111100","0100000100","0100000000","0100000000","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011100000","0011100000","0011111100","0011100000","0011100000","1111111100","1111111100","1111111100","0011100100","0011100000","0011100000","0011100100","0011100000","0011111100","0011100000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0100000100","0011100000","0100011000","0100000100","1111111100","1111111100","1111111100","0100001000","0100000100","0100000100","0100001000","0100011000","0011100000","0100000100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0100000100","0011100000","0011100000","0100001000","1111001100","1111001100","1111001100","0100000100","0100000100","0100000100","0100000100","0011100000","0100000100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0011100000","0011100000","0100100000","0110100000","0110100000","0110100000","0100000100","0100000100","0100100000","0100000100","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011100000","0011100000","0010111100","0010111000","0010111100","0100000100","0100000100","0011100000","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0100000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")
);
constant pad_g : rom_type :=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1110111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1110111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000010100","0000011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000011000","0000010100","0000000000"),
("0000000000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000000000"),
("0000000000","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0001100000","0001100000","0001100000","1111111100","1111111100","0001100000","0001011100","0001100000","0001100100","0001100000","0001011100","0001100000","0001100000","0000010100","0000010100","0000010000","0000010100","0000010000"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0000010100","0000010000","0000010100","0000010000","0000010100"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011100","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011100","0000010100","0000010000","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010000","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010000","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0000010100","0000010100","0000010100","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011100","0001011100","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011000","0001011000","0001011100","0000010100","0000010000","0000010100","0000010100","0000010100"),
("0000010100","0000010100","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0000010100","0000010000","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010000","0001011000","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010000","0000010100","0000010100","0001100000","0001100000","0001100000","1111111100","1111111100","0001100000","0001100000","0001100000","0001100000","0001100100","0001100000","0001100000","0001100000","0000010100","0000011000","0000010000","0000010100","0000010100"),
("0000010100","0000010000","0000010000","0001011100","0001011100","0001011100","1110000100","1110000100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100","0000010000","0000010000","0000010000","0000010000","0000010100"),
("0000010100","0000000100","0000000100","0000001100","0000001100","0000001100","0010011000","0010011000","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000000100","0000000100","0000000100","0000000100","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000010100"),
("0000010100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000010100"),
("0000010100","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000010100"),
("0000010100","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000010100"),
("0000010100","0000000100","0000000100","0000001100","0000001100","0000001100","0010011000","0010011000","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000001100","0000000100","0000000100","0000000100","0000000100","0000010100"),
("0000010100","0000010000","0000001100","0001001100","0001001100","0001010000","1110000100","1110000100","0001010000","0001010000","0001001100","0001001100","0001001100","0001001100","0001001100","0001001100","0000010000","0000010000","0000010000","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001100000","0001100000","0001100100","1111111100","1111111100","0001100100","0001100100","0001100000","0001100000","0001100000","0001100000","0001100000","0001100000","0000010100","0000010100","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010100","0001011100","0001011100","0001011100","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010000","0000010100","0000010100","0000010000"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011100","1111111100","1111111100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0000010000","0000010100","0000010100","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010100","0000010100","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0000010100","0000010100","0000010000","0000010000","0000010100"),
("0000010100","0000010000","0000010000","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011100","0001011100","0001011100","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010000"),
("0000010000","0000010100","0000010100","0001011000","0001011000","0001011000","1111111100","1111111100","0001011100","0001011000","0001011000","0001011000","0001011000","0001011100","0001011000","0001011000","0000010100","0000010100","0000010100","0000010000","0000010000"),
("0000010100","0000010000","0000010100","0001011100","0001011000","0001011000","1111111100","1111111100","0001011000","0001011000","0001011000","0001011100","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011100","0001011000","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011000","0001011000","0000010100","0000010100","0000010100","0000010100","0000010100"),
("0000010000","0000010100","0000010100","0001011100","0001011100","0001011100","1111111100","1111111100","0001011000","0001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010000","0000010000","0000010100","0001011000","0001011100","0001011000","1111111100","1111111100","0001001000","0001001100","0001001000","0001011000","0001011100","0001011000","0001011100","0001011000","0000010100","0000010100","0000010000","0000010100","0000010100"),
("0000010100","0000001100","0000001100","0001011000","0001011000","0001011100","1111111100","1111111100","0000001100","0000001100","0000001100","0001011000","0001011000","0001011000","0001011000","0001011000","0000010000","0000010000","0000001100","0000010000","0000010000"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011100","0001011100","0001011100","1001011100","1001011100","1001011100","0001011000","0001011000","0001011100","0001011000","0001011100","0001011100","0001011100","0001011100","0001011100","0001011100"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011000","0000000000","0000000000","1111111100","1111111100","1111111100","0001011000","0001011100","0001011100","0001011000","0001011100","0001100000","0001100000","0001100100","0001011100","0001011100"),
("0001011100","0001011100","0001011100","0001011100","0001011000","0001011000","0001011000","0001011000","1111111100","1111111100","1111111100","0001011000","0001011100","0001011100","0001011000","0001011100","0001011000","0001011000","0001011000","0001011100","0001011100"),
("0000000000","0001011100","0001011100","0001101000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0001011100","0000000000","0001011100","0001011100","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111000","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")
);

constant pad_b : rom_type :=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1110111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1110111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1110000100","1110000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010011000","0010011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000000000"),
("0000000000","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0101100100","0101100100","0101100100","0101100100","0101100100","1111111100","1111111100","0101100100","0101100100","0101100100","0101100100","0101100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0010100100","0000000000"),
("0000000000","0110001100","0110001100","0110001100","0110001100","0110001100","1111111100","1111111100","0110001100","0110001100","0110001100","0110001100","0110001100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0010110100","0000000000"),
("0000000000","0011011000","0011011000","0011011000","0011011000","0011011000","1001101000","1001101000","0011011000","0011011000","0011011000","0011011000","0011011000","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0001100100","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010011000","0010011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1110000100","1110000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1000110100","1000110100","1000110100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","1111111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")

);



type ram_type1 is array(0 to 31, 0 to 31 ) of std_logic_vector(9 downto 0);
signal background_r: ram_type1:=(
("0001111100","0010000000","0010000100","0010001000","0010001100","0010001100","0010000100","0001111100","0001110100","0001011100","0001100100","0001101000","0001110100","0001111100","0010000000","0001111100","0001111100","0001111100","0001110100","0001110100","0010000000","0010001100","0010010000","0010010000","0010010000","0010011000","0010011000","0010010000","0010000100","0001111000","0001110100","0001110100"),
("0010010100","0010101100","0010101000","0010011100","0010010000","0001111100","0001101100","0001100000","0001011000","0001011000","0001011100","0001011100","0001100000","0001100100","0001101000","0001101000","0001101000","0001101100","0001100000","0001100100","0010000000","0010001100","0010001000","0010000100","0010001000","0001110000","0010000000","0010000100","0001110100","0001011100","0001011100","0001111000"),
("0010001000","0010100100","0010011100","0010001100","0001111000","0001101000","0001011000","0001010000","0001001100","0001100100","0001100000","0001011000","0001011000","0001011000","0001100000","0001100000","0001100100","0001100000","0001011000","0001100000","0001111100","0010001000","0001111000","0001101100","0001110000","0001011000","0001101000","0001110000","0001100100","0001010000","0001010000","0001101100"),
("0001110100","0010001000","0010000000","0001110100","0001100100","0001011100","0001011100","0001100000","0001100000","0001101100","0001101000","0001011100","0001011100","0001100000","0001101000","0001101100","0001110100","0001100100","0001011000","0001100000","0010000100","0010001100","0001110100","0001100000","0001100000","0001100100","0001101100","0001110100","0001101100","0001011000","0001010100","0001100100"),
("0010000000","0010000100","0010010100","0010011100","0010000100","0001100000","0001010000","0001100000","0001111000","0001110100","0001110100","0001110000","0001110000","0001101100","0001101000","0001100000","0001011100","0001101100","0001101000","0001100000","0001101000","0001110100","0001110000","0001011100","0001001000","0001100000","0001100100","0001110000","0001110100","0001100100","0001010100","0001100100"),
("0001110000","0010000000","0010000000","0010000000","0001111100","0001110100","0001101100","0001101000","0001101000","0010001100","0010001000","0010000100","0010000000","0001110100","0001101100","0001011100","0001010100","0001110000","0001101100","0001101000","0001101100","0001101100","0001101000","0001011100","0001010100","0001011100","0001011100","0001101000","0001101100","0001011100","0001001100","0001011000"),
("0001101000","0001110100","0001100100","0001011000","0001100100","0001111100","0010000100","0001110100","0001011100","0010001000","0010001000","0010000000","0001111000","0001110000","0001101000","0001011100","0001011000","0001111000","0001111100","0001111000","0001110000","0001100100","0001011100","0001011100","0001100000","0001011000","0001011000","0001100100","0001101100","0001100000","0001001100","0001010100"),
("0001111000","0001101100","0001011000","0001001000","0001010100","0001110100","0010000100","0001111100","0001110000","0001110100","0001110000","0001100000","0001011000","0001011000","0001100000","0001100000","0001100100","0010001000","0010001100","0010000100","0001110100","0001011100","0001010000","0001010100","0001011100","0001011100","0001011100","0001101100","0001111100","0001111000","0001101000","0001101000"),
("0010000100","0001100100","0001011100","0001010000","0001010000","0001011100","0001110000","0010000000","0010001000","0001111100","0001101100","0001011000","0001001000","0001001000","0001011000","0001100100","0001110000","0010010000","0010010100","0010001000","0001111000","0001011100","0001001100","0001001100","0001011000","0001010100","0001011000","0001101100","0010000100","0010001000","0001111100","0001111000"),
("0010000000","0001100100","0001101000","0001100100","0001011100","0001010100","0001011100","0001110100","0010001100","0010010000","0010000100","0001101100","0001011100","0001011000","0001100000","0001100100","0001101100","0010000100","0010000100","0001111100","0001110100","0001100100","0001011000","0001010100","0001010100","0001010100","0001010100","0001101000","0010001000","0010010000","0010000100","0001111100"),
("0001111100","0001101000","0001110000","0001110100","0001101100","0001100100","0001100000","0001101000","0001110000","0010001000","0010001000","0010000000","0001111100","0001111000","0001110100","0001101000","0001101000","0001101000","0001101000","0001100100","0001101000","0001110000","0001101100","0001100100","0001011100","0001101000","0001100100","0001111000","0010010100","0010011100","0010001100","0001111100"),
("0001111100","0001110000","0001110100","0001111000","0001111100","0001111000","0001101100","0001011100","0001010000","0001101000","0001110100","0010000000","0010010000","0010010000","0010001000","0001110000","0001101000","0001010100","0001010000","0001010000","0001100100","0001111000","0001111100","0001110100","0001100100","0010000000","0001111100","0010001100","0010101000","0010101100","0010010100","0010000000"),
("0010010100","0001111100","0001111100","0010000000","0001111100","0001110100","0001110000","0001110000","0001101100","0001101000","0010000000","0010010100","0010010000","0001111000","0001100100","0001011100","0001101000","0001101000","0001100000","0001010000","0001001100","0001010100","0001101000","0001111100","0010001100","0010000100","0010000100","0010000100","0010001000","0010001000","0010001100","0010010100"),
("0010010000","0010010100","0010010000","0010010000","0010000100","0001111000","0001110000","0001101100","0001100100","0001101100","0001111000","0010001000","0010010000","0010001100","0001111100","0001101000","0001011100","0001100000","0001011000","0001001100","0001001000","0001010000","0001100000","0001110100","0010000000","0010000000","0001111100","0001110100","0001110000","0001110100","0001111100","0010001000"),
("0010000100","0010001000","0010001000","0010001100","0010001000","0010000100","0010000100","0010000100","0010000100","0010000000","0010000100","0010001000","0010011000","0010100000","0010011000","0001111000","0001100100","0001011100","0001011000","0001001100","0001001000","0001010000","0001011100","0001101100","0001111000","0010000100","0001111100","0001110000","0001101000","0001101000","0001101100","0001111100"),
("0001110000","0001011000","0001100000","0001110000","0010000000","0010001100","0010011100","0010101000","0010110000","0010011100","0010011100","0010011100","0010100000","0010100000","0010011000","0010000000","0001111000","0001100100","0001100000","0001011000","0001011000","0001011100","0001100100","0001110000","0001110100","0010001100","0010000100","0001111100","0001110100","0001110000","0001101100","0001110000"),
("0001010100","0001010000","0001010100","0001101000","0001110100","0010000100","0010010000","0010100000","0010100100","0010100000","0010101000","0010100100","0010011000","0010000000","0001110100","0001110100","0010000100","0001110000","0001110000","0001101000","0001101000","0001101100","0001110000","0001110100","0001111000","0001111100","0010000000","0010000100","0010000000","0001111000","0001101000","0001011100"),
("0001001000","0001110000","0001110000","0001110100","0001110000","0001110000","0001101100","0001101100","0001101100","0010001000","0010010100","0010011000","0010000100","0001100100","0001011000","0001100000","0001110100","0001110100","0001110100","0001110000","0001110100","0001110100","0001110100","0001110100","0001110100","0001100000","0001101000","0001111000","0001111100","0001111000","0001101000","0001011000"),
("0001100100","0010000000","0001111100","0001111000","0001110000","0001100100","0001011000","0001010100","0001010000","0001110000","0001111100","0010000000","0001111100","0001110000","0001101000","0001100000","0001100100","0001101000","0001101100","0001101100","0001101100","0001101100","0001101000","0001100100","0001100000","0001001100","0001011000","0001101000","0001110100","0001111000","0001110100","0001101100"),
("0010001100","0001101100","0001101100","0001110000","0001101000","0001100100","0001100000","0001100000","0001011100","0001101000","0001101100","0001110100","0010000100","0010010000","0010001000","0001101100","0001011100","0001011100","0001100000","0001100000","0001100100","0001100000","0001011100","0001011000","0001010000","0001001000","0001010100","0001100000","0001110000","0010000000","0010000100","0010001100"),
("0001111100","0001011100","0001011000","0001011000","0001010100","0001010000","0001010000","0001011000","0001011100","0001101000","0001101000","0001101100","0001110000","0001110000","0001110100","0001101000","0001101000","0001010100","0001001000","0001000000","0001001100","0001100000","0001101000","0001011000","0001001000","0000110000","0001010000","0001111000","0010001100","0010001100","0010000000","0001111100"),
("0001101000","0001001100","0001001000","0001010000","0001010000","0001010000","0001011000","0001100000","0001100100","0001001100","0001010000","0001010100","0001100000","0001101000","0001110100","0001110000","0001110100","0001110000","0001100100","0001010100","0001010100","0001100000","0001100100","0001100000","0001011000","0001101100","0001111000","0010000100","0010001000","0010000000","0001110100","0001110000"),
("0001011000","0001001000","0001001000","0001010000","0001010000","0001010100","0001011000","0001100000","0001100100","0001001100","0001010000","0001010100","0001011100","0001100100","0001110000","0001101100","0001110000","0001111000","0001110100","0001101000","0001100100","0001100100","0001110000","0001111000","0001111100","0010010000","0010001000","0010000000","0001111000","0001110000","0001101000","0001100000"),
("0001010100","0001100000","0001011100","0001100000","0001100000","0001011100","0001011000","0001011100","0001011100","0001110000","0001101100","0001101000","0001100100","0001100100","0001100100","0001011100","0001011100","0001101000","0001101100","0001110100","0001111000","0001111100","0010000100","0010010100","0010100000","0010000000","0001110000","0001100100","0001100000","0001101000","0001101000","0001100000"),
("0001011000","0001101000","0001101000","0001110000","0001101100","0001101000","0001101000","0001101000","0001100100","0001111100","0001111000","0001101100","0001100000","0001011100","0001011000","0001010000","0001010000","0001011000","0001101000","0001111000","0010001000","0010001100","0010010000","0010010100","0010010100","0001101000","0001100000","0001011000","0001011100","0001101000","0001101100","0001101000"),
("0001101100","0001100000","0001100100","0001110000","0001110100","0001111000","0001111000","0001111100","0001111100","0001101000","0001100100","0001011000","0001010000","0001010000","0001010000","0001001100","0001010000","0001100000","0001101100","0001111000","0010001000","0010001100","0010001000","0001111100","0001110000","0001101000","0001100000","0001100000","0001100000","0001101000","0001101100","0001101100"),
("0010001000","0001100000","0001100100","0001110000","0001111000","0001111000","0001111000","0001111100","0001111000","0001100000","0001011000","0001010000","0001001100","0001001100","0001010100","0001010100","0001011000","0001101000","0001100100","0001100000","0001110000","0001111100","0001111100","0001110000","0001100000","0001011100","0001011100","0001011000","0001010100","0001010100","0001100000","0001111000"),
("0010100100","0001101000","0001101100","0001111000","0001111000","0001110100","0001110000","0001101100","0001101000","0001101100","0001100100","0001011000","0001010100","0001010100","0001011000","0001011000","0001011100","0001100000","0001010000","0001001000","0001011000","0001110000","0001111100","0001110100","0001101000","0001001000","0001001000","0001000100","0000111100","0000111100","0001010100","0010000000"),
("0010011100","0001110100","0001110000","0001110000","0001101100","0001101000","0001100000","0001011000","0001010100","0001111000","0001110000","0001100000","0001011000","0001010100","0001011000","0001010100","0001011000","0001000000","0001010100","0001010100","0001010000","0001100000","0001111000","0001110100","0001011000","0001010100","0001011100","0001100000","0001010100","0001000100","0001010100","0001111000"),
("0010000100","0001101100","0001101100","0001110000","0001110000","0001101100","0001101000","0001100000","0001011100","0010000100","0001111100","0001101100","0001100000","0001010100","0001010000","0001000100","0001000100","0001001000","0001011000","0001010100","0001001100","0001011000","0001101100","0001101000","0001010000","0001010000","0001010000","0001010000","0001010100","0001100000","0001110000","0001111100"),
("0001100100","0001010100","0001011100","0001101000","0001110100","0001111000","0001111000","0001110100","0001110000","0010001000","0010000100","0001111000","0001110000","0001101000","0001100000","0001010000","0001001100","0001100000","0001100100","0001100000","0001011000","0001100000","0001110000","0001101100","0001011100","0001101000","0001011100","0001010100","0001100100","0010000000","0010001000","0001111000"),
("0001100000","0001011000","0001100000","0001110000","0010000000","0010001000","0010001000","0010000100","0010000000","0001110100","0001111000","0001111000","0001111100","0001111100","0001111100","0001110100","0001110100","0001111000","0001111000","0001110000","0001110000","0001111100","0010000100","0010000100","0001111100","0010010100","0010001000","0001111100","0010000000","0010001100","0010001100","0001110100")
);
signal background_g: ram_type1:=(
("0110101100","0110110000","0110110100","0110111000","0110111100","0110111100","0110110100","0110101100","0110100100","0110001000","0110010000","0110011000","0110100100","0110101100","0110110000","0110111000","0110111000","0110111000","0110110000","0110111000","0111000100","0111010000","0111010100","0111010100","0111010100","0111001000","0111001000","0111000000","0110110100","0110101000","0110100100","0110100100"),
("0111000100","0111011100","0111011000","0111001100","0111000000","0110101100","0110011100","0110010000","0110001000","0110000100","0110001000","0110001100","0110010000","0110010100","0110011000","0110100100","0110100100","0110101000","0110011100","0110101000","0111000100","0111010000","0111001100","0111001000","0111001100","0110100000","0110110000","0110110100","0110100100","0110001100","0110001100","0110101000"),
("0111000100","0111100000","0111011000","0111001000","0110110100","0110100100","0110010100","0110001100","0110001000","0110010000","0110001100","0110001000","0110001000","0110001000","0110010000","0110011100","0110100000","0110011100","0110010100","0110100100","0111000000","0111001100","0110111100","0110110000","0110110100","0110010100","0110100100","0110101100","0110100000","0110001100","0110001100","0110101000"),
("0110110000","0111000100","0110111100","0110110000","0110100000","0110011000","0110011000","0110011100","0110011100","0110011000","0110010100","0110001100","0110001100","0110010000","0110011000","0110101000","0110110000","0110100000","0110010100","0110100100","0111001000","0111010000","0110111000","0110100100","0110100100","0110100000","0110101000","0110110000","0110101000","0110010100","0110010000","0110100000"),
("0110111100","0111000000","0111010000","0111011000","0111000000","0110011100","0110001100","0110011100","0110110100","0110100000","0110100000","0110100000","0110100000","0110011100","0110011000","0110011100","0110011000","0110101000","0110100100","0110100100","0110101100","0110111000","0110110100","0110100000","0110001100","0110011100","0110100000","0110101100","0110110000","0110100000","0110010000","0110100000"),
("0110101100","0110111100","0110111100","0110111100","0110111000","0110110000","0110101000","0110100100","0110100100","0110111000","0110110100","0110110100","0110110000","0110100100","0110011100","0110011000","0110010000","0110101100","0110101000","0110101100","0110110000","0110110000","0110101100","0110100000","0110011000","0110011000","0110011000","0110100100","0110101000","0110011000","0110001000","0110010100"),
("0110101100","0110111000","0110101000","0110011100","0110101000","0111000000","0111001000","0110111000","0110100000","0110110100","0110110100","0110110000","0110101000","0110100000","0110011000","0110011000","0110010100","0110110100","0110111000","0110111100","0110110100","0110101000","0110100000","0110100000","0110100100","0110011100","0110011100","0110101000","0110110000","0110100100","0110010000","0110011000"),
("0110111100","0110110000","0110011100","0110001100","0110011000","0110111000","0111001000","0111000000","0110110100","0110100000","0110011100","0110010000","0110001000","0110001000","0110010000","0110011100","0110100000","0111000100","0111001000","0111001000","0110111000","0110100000","0110010100","0110011000","0110100000","0110100000","0110100000","0110110000","0111000000","0110111100","0110101100","0110101100"),
("0111001000","0110101000","0110100000","0110010100","0110010100","0110100000","0110110100","0111000100","0111001100","0110101000","0110011000","0110001000","0101111000","0101111000","0110001000","0110100000","0110101100","0111001100","0111010000","0111001100","0110111100","0110100000","0110010000","0110010000","0110011100","0110011000","0110011100","0110110000","0111001000","0111001100","0111000000","0110111100"),
("0111000100","0110101000","0110101100","0110101000","0110100000","0110011000","0110100000","0110111000","0111010000","0110111100","0110110000","0110011100","0110001100","0110001000","0110010000","0110100000","0110101000","0111000000","0111000000","0111000000","0110111000","0110101000","0110011100","0110011000","0110011000","0110011000","0110011000","0110101100","0111001100","0111010100","0111001000","0111000000"),
("0111000000","0110101100","0110110100","0110111000","0110110000","0110101000","0110100100","0110101100","0110110100","0110110100","0110110100","0110110000","0110101100","0110101000","0110100100","0110100100","0110100100","0110100100","0110100100","0110101000","0110101100","0110110100","0110110000","0110101000","0110100000","0110101100","0110101000","0110111100","0111011000","0111100000","0111010000","0111000000"),
("0111000000","0110110100","0110111000","0110111100","0111000000","0110111100","0110110000","0110100000","0110010100","0110010100","0110100000","0110110000","0111000000","0111000000","0110111000","0110101100","0110100100","0110010000","0110001100","0110010100","0110101000","0110111100","0111000000","0110111000","0110101000","0111000100","0111000000","0111010000","0111101100","0111110000","0111011000","0111000100"),
("0111010000","0110111000","0110111000","0110110000","0110101100","0110100100","0110100000","0110011100","0110011000","0110010100","0110101100","0111000100","0111000000","0110101000","0110010100","0110011000","0110100100","0110100100","0110011100","0110010100","0110010000","0110011000","0110101100","0111000000","0111010000","0111001000","0111001000","0111001000","0111001100","0111001100","0111010000","0111010000"),
("0111001100","0111010000","0111001100","0111000000","0110110100","0110101000","0110100000","0110011000","0110010000","0110011000","0110100100","0110111000","0111000000","0110111100","0110101100","0110100100","0110011000","0110011100","0110010100","0110010000","0110001100","0110010100","0110100100","0110111000","0111000100","0111000100","0111000000","0110111000","0110110100","0110111000","0111000000","0111000100"),
("0111000000","0111000100","0111000100","0110111100","0110111000","0110110100","0110110100","0110110000","0110110000","0110101100","0110110000","0110111000","0111001000","0111010000","0111001000","0110110100","0110100000","0110011000","0110010100","0110010000","0110001100","0110010100","0110100000","0110110000","0110111100","0111001000","0111000000","0110110100","0110101100","0110101100","0110110000","0110111000"),
("0110101100","0110010100","0110011100","0110100000","0110110000","0110111100","0111001100","0111010100","0111011100","0111001000","0111001000","0111001100","0111010000","0111010000","0111001000","0110111100","0110110100","0110100000","0110011100","0110011100","0110011100","0110100000","0110101000","0110110100","0110111000","0111010000","0111001000","0111000000","0110111000","0110110100","0110110000","0110101100"),
("0110010000","0110001100","0110010000","0110011000","0110100100","0110110100","0111000000","0111001100","0111010000","0111001100","0111010100","0111010100","0111001000","0110110000","0110100100","0110110000","0111000000","0110101100","0110101100","0110101100","0110101100","0110110000","0110110100","0110111000","0110111100","0111000000","0111000100","0111001000","0111000100","0110111100","0110101100","0110011000"),
("0110000100","0110101100","0110101100","0110100100","0110100000","0110100000","0110011100","0110011000","0110011000","0110110100","0111000000","0111001000","0110110100","0110010100","0110001000","0110011100","0110110000","0110110000","0110110000","0110110100","0110111000","0110111000","0110111000","0110111000","0110111000","0110100100","0110101100","0110111100","0111000000","0110111100","0110101100","0110010100"),
("0110100000","0110111100","0110111000","0110101000","0110100000","0110010100","0110001000","0110000000","0101111100","0110011100","0110101000","0110110000","0110101100","0110100000","0110011000","0110011100","0110100000","0110100100","0110101000","0110110000","0110110000","0110110000","0110101100","0110101000","0110100100","0110010000","0110011100","0110101100","0110111000","0110111100","0110111000","0110101000"),
("0111001000","0110101000","0110101000","0110100000","0110011000","0110010100","0110010000","0110001100","0110001000","0110010100","0110011000","0110100100","0110110100","0111000000","0110111000","0110101000","0110011000","0110011000","0110011100","0110100100","0110101000","0110100100","0110100000","0110011100","0110010100","0110001100","0110011000","0110100100","0110110100","0111000100","0111001000","0111001000"),
("0110111000","0110011000","0110010100","0110001000","0110000100","0110000000","0110000000","0110000100","0110001000","0110010100","0110010100","0110011100","0110100000","0110100000","0110100100","0110100100","0110100100","0110010000","0110000100","0110000100","0110010000","0110100100","0110101100","0110011100","0110001100","0101110100","0110010100","0110111100","0111010000","0111010000","0111000100","0110111000"),
("0110100100","0110001000","0110000100","0110000000","0110000000","0110000000","0110001000","0110001100","0110010000","0101111000","0101111100","0110000100","0110010000","0110011000","0110100100","0110101100","0110110000","0110101100","0110100000","0110011000","0110011000","0110100100","0110101000","0110100100","0110011100","0110110000","0110111100","0111001000","0111001100","0111000100","0110111000","0110101100"),
("0110010100","0110000100","0110000100","0110000000","0110000000","0110000100","0110001000","0110001100","0110010000","0101111000","0101111100","0110000100","0110001100","0110010100","0110100000","0110101000","0110101100","0110110100","0110110000","0110101100","0110101000","0110101000","0110110100","0110111100","0111000000","0111010100","0111001100","0111000100","0110111100","0110110100","0110101100","0110011100"),
("0110010000","0110011100","0110011000","0110010000","0110010000","0110001100","0110001000","0110001000","0110001000","0110011100","0110011000","0110011000","0110010100","0110010100","0110010100","0110011000","0110011000","0110100100","0110101000","0110111000","0110111100","0111000000","0111001000","0111011000","0111100100","0111000100","0110110100","0110101000","0110100100","0110101100","0110101100","0110011100"),
("0110010100","0110100100","0110100100","0110100000","0110011100","0110011000","0110011000","0110010100","0110010000","0110101000","0110100100","0110011100","0110010000","0110001100","0110001000","0110001100","0110001100","0110010100","0110100100","0110111100","0111001100","0111010000","0111010100","0111011000","0111011000","0110101100","0110100100","0110011100","0110100000","0110101100","0110110000","0110100100"),
("0110101000","0110011100","0110100000","0110100000","0110100100","0110101000","0110101000","0110101000","0110101000","0110010100","0110010000","0110001000","0110000000","0110000000","0110000000","0110001000","0110001100","0110011100","0110101000","0110111100","0111001100","0111010000","0111001100","0111000000","0110110100","0110101100","0110100100","0110100100","0110100100","0110101100","0110110000","0110101000"),
("0111000100","0110011100","0110100000","0110100000","0110101000","0110101000","0110101000","0110101000","0110100100","0110001100","0110000100","0110000000","0101111100","0101111100","0110000100","0110010000","0110010100","0110100100","0110100000","0110100100","0110110100","0111000000","0111000000","0110110100","0110100100","0110100000","0110100000","0110011100","0110011000","0110011000","0110100100","0110110100"),
("0111100000","0110100100","0110101000","0110101000","0110101000","0110100100","0110100000","0110011000","0110010100","0110011000","0110010000","0110001000","0110000100","0110000100","0110001000","0110010100","0110011000","0110011100","0110001100","0110001100","0110011100","0110110100","0111000000","0110111000","0110101100","0110001100","0110001100","0110001000","0110000000","0110000000","0110011000","0110111100"),
("0111001000","0110100000","0110011100","0110011100","0110011000","0110010100","0110001100","0110000100","0110000000","0110100100","0110011100","0110010000","0110001000","0110000100","0110001000","0110010000","0110010100","0101111100","0110010000","0110011000","0110010100","0110100100","0110111100","0110111000","0110011100","0110000000","0110001000","0110001100","0110000000","0101110000","0110000000","0110100100"),
("0110110000","0110011000","0110011000","0110011100","0110011100","0110011000","0110010100","0110001100","0110001000","0110110000","0110101000","0110011100","0110010000","0110000100","0110000000","0110000000","0110000000","0110000100","0110010100","0110011000","0110010000","0110011100","0110110000","0110101100","0110010100","0101111100","0101111100","0101111100","0110000000","0110001100","0110011100","0110101000"),
("0110010100","0110000100","0110001100","0110011000","0110100100","0110101000","0110101000","0110100100","0110100000","0110110100","0110110000","0110101000","0110100000","0110011000","0110010000","0110001100","0110001000","0110011100","0110100000","0110100100","0110011100","0110100100","0110110100","0110110000","0110100000","0110011000","0110001100","0110000100","0110010100","0110110000","0110111000","0110101000"),
("0110010000","0110001000","0110010000","0110100000","0110110000","0110111000","0110111000","0110110100","0110110000","0110100000","0110100100","0110101000","0110101100","0110101100","0110101100","0110110000","0110110000","0110110100","0110110100","0110110100","0110110100","0111000000","0111001000","0111001000","0111000000","0111000100","0110111000","0110101100","0110110000","0110111100","0110111100","0110100100")
);
signal background_b: ram_type1:=(
("1010010100","1010011000","1010011100","1010100000","1010100100","1010100100","1010011100","1010010100","1010001100","1001110000","1001111000","1010000000","1010001100","1010010100","1010011000","1010011100","1010011100","1010011100","1010010100","1010011000","1010100100","1010110000","1010110100","1010110100","1010110100","1010110000","1010110000","1010101000","1010011100","1010010000","1010001100","1010001100"),
("1010101100","1011000100","1011000000","1010110100","1010101000","1010010100","1010000100","1001111000","1001110000","1001101100","1001110000","1001110100","1001111000","1001111100","1010000000","1010001000","1010001000","1010001100","1010000000","1010001000","1010100100","1010110000","1010101100","1010101000","1010101100","1010001000","1010011000","1010011100","1010001100","1001110100","1001110100","1010010000"),
("1010101000","1011000100","1010111100","1010101100","1010011000","1010001000","1001111000","1001110000","1001101100","1001111000","1001110100","1001110000","1001110000","1001110000","1001111000","1010000000","1010000100","1010000000","1001111000","1010000100","1010100000","1010101100","1010011100","1010010000","1010010100","1001111000","1010001000","1010010000","1010000100","1001110000","1001110000","1010001100"),
("1010010100","1010101000","1010100000","1010010100","1010000100","1001111100","1001111100","1010000000","1010000000","1010000000","1001111100","1001110100","1001110100","1001111000","1010000000","1010001100","1010010100","1010000100","1001111000","1010000100","1010101000","1010110000","1010011000","1010000100","1010000100","1010000100","1010001100","1010010100","1010001100","1001111000","1001110100","1010000100"),
("1010100000","1010100100","1010110100","1010111100","1010100100","1010000000","1001110000","1010000000","1010011000","1010001000","1010001000","1010001000","1010001000","1010000100","1010000000","1010000000","1001111100","1010001100","1010001000","1010000100","1010001100","1010011000","1010010100","1010000000","1001101100","1010000000","1010000100","1010010000","1010010100","1010000100","1001110100","1010000100"),
("1010010000","1010100000","1010100000","1010100000","1010011100","1010010100","1010001100","1010001000","1010001000","1010100000","1010011100","1010011100","1010011000","1010001100","1010000100","1001111100","1001110100","1010010000","1010001100","1010001100","1010010000","1010010000","1010001100","1010000000","1001111000","1001111100","1001111100","1010001000","1010001100","1001111100","1001101100","1001111000"),
("1010001100","1010011000","1010001000","1001111100","1010001000","1010100000","1010101000","1010011000","1010000000","1010011100","1010011100","1010011000","1010010000","1010001000","1010000000","1001111100","1001111000","1010011000","1010011100","1010011100","1010010100","1010001000","1010000000","1010000000","1010000100","1001111100","1001111100","1010001000","1010010000","1010000100","1001110000","1001111000"),
("1010011100","1010010000","1001111100","1001101100","1001111000","1010011000","1010101000","1010100000","1010010100","1010001000","1010000100","1001111000","1001110000","1001110000","1001111000","1010000000","1010000100","1010101000","1010101100","1010101000","1010011000","1010000000","1001110100","1001111000","1010000000","1010000000","1010000000","1010010000","1010100000","1010011100","1010001100","1010001100"),
("1010101000","1010001000","1010000000","1001110100","1001110100","1010000000","1010010100","1010100100","1010101100","1010010000","1010000000","1001110000","1001100000","1001100000","1001110000","1010000100","1010010000","1010110000","1010110100","1010101100","1010011100","1010000000","1001110000","1001110000","1001111100","1001111000","1001111100","1010010000","1010101000","1010101100","1010100000","1010011100"),
("1010100100","1010001000","1010001100","1010001000","1010000000","1001111000","1010000000","1010011000","1010110000","1010100100","1010011000","1010000100","1001110100","1001110000","1001111000","1010000100","1010001100","1010100100","1010100100","1010100000","1010011000","1010001000","1001111100","1001111000","1001111000","1001111000","1001111000","1010001100","1010101100","1010110100","1010101000","1010100000"),
("1010100000","1010001100","1010010100","1010011000","1010010000","1010001000","1010000100","1010001100","1010010100","1010011100","1010011100","1010011000","1010010100","1010010000","1010001100","1010001000","1010001000","1010001000","1010001000","1010001000","1010001100","1010010100","1010010000","1010001000","1010000000","1010001100","1010001000","1010011100","1010111000","1011000000","1010110000","1010100000"),
("1010100000","1010010100","1010011000","1010011100","1010100000","1010011100","1010010000","1010000000","1001110100","1001111100","1010001000","1010011000","1010101000","1010101000","1010100000","1010010000","1010001000","1001110100","1001110000","1001110100","1010001000","1010011100","1010100000","1010011000","1010001000","1010100100","1010100000","1010110000","1011001100","1011010000","1010111000","1010100100"),
("1010110100","1010011100","1010011100","1010011000","1010010100","1010001100","1010001000","1010000100","1010000000","1001111100","1010010100","1010101100","1010101000","1010010000","1001111100","1001111100","1010001000","1010001000","1010000000","1001110100","1001110000","1001111000","1010001100","1010100000","1010110000","1010101000","1010101000","1010101000","1010101100","1010101100","1010110000","1010110100"),
("1010110000","1010110100","1010110000","1010101000","1010011100","1010010000","1010001000","1010000000","1001111000","1010000000","1010001100","1010100000","1010101000","1010100100","1010010100","1010001000","1001111100","1010000000","1001111000","1001110000","1001101100","1001110100","1010000100","1010011000","1010100100","1010100100","1010100000","1010011000","1010010100","1010011000","1010100000","1010101000"),
("1010100100","1010101000","1010101000","1010100100","1010100000","1010011100","1010011100","1010011000","1010011000","1010010100","1010011000","1010100000","1010110000","1010111000","1010110000","1010011000","1010000100","1001111100","1001111000","1001110000","1001101100","1001110100","1010000000","1010010000","1010011100","1010101000","1010100000","1010010100","1010001100","1010001100","1010010000","1010011100"),
("1010010000","1001111000","1010000000","1010001000","1010011000","1010100100","1010110100","1010111100","1011000100","1010110000","1010110000","1010110100","1010111000","1010111000","1010110000","1010100000","1010011000","1010000100","1010000000","1001111100","1001111100","1010000000","1010001000","1010010100","1010011000","1010110000","1010101000","1010100000","1010011000","1010010100","1010010000","1010010000"),
("1001110100","1001110000","1001110100","1010000000","1010001100","1010011100","1010101000","1010110100","1010111000","1010110100","1010111100","1010111100","1010110000","1010011000","1010001100","1010010100","1010100100","1010010000","1010010000","1010001100","1010001100","1010010000","1010010100","1010011000","1010011100","1010100000","1010100100","1010101000","1010100100","1010011100","1010001100","1001111100"),
("1001101000","1010010000","1010010000","1010001100","1010001000","1010001000","1010000100","1010000000","1010000000","1010011100","1010101000","1010110000","1010011100","1001111100","1001110000","1010000000","1010010100","1010010100","1010010100","1010010100","1010011000","1010011000","1010011000","1010011000","1010011000","1010000100","1010001100","1010011100","1010100000","1010011100","1010001100","1001111000"),
("1010000100","1010100000","1010011100","1010010000","1010001000","1001111100","1001110000","1001101000","1001100100","1010000100","1010010000","1010011000","1010010100","1010001000","1010000000","1010000000","1010000100","1010001000","1010001100","1010010000","1010010000","1010010000","1010001100","1010001000","1010000100","1001110000","1001111100","1010001100","1010011000","1010011100","1010011000","1010001100"),
("1010101100","1010001100","1010001100","1010001000","1010000000","1001111100","1001111000","1001110100","1001110000","1001111100","1010000000","1010001100","1010011100","1010101000","1010100000","1010001100","1001111100","1001111100","1010000000","1010000100","1010001000","1010000100","1010000000","1001111100","1001110100","1001101100","1001111000","1010000100","1010010100","1010100100","1010101000","1010101100"),
("1010011100","1001111100","1001111000","1001110000","1001101100","1001101000","1001101000","1001101100","1001110000","1001111100","1001111100","1010000100","1010001000","1010001000","1010001100","1010001000","1010001000","1001110100","1001101000","1001100100","1001110000","1010000100","1010001100","1001111100","1001101100","1001010100","1001110100","1010011100","1010110000","1010110000","1010100100","1010011100"),
("1010001000","1001101100","1001101000","1001101000","1001101000","1001101000","1001110000","1001110100","1001111000","1001100000","1001100100","1001101100","1001111000","1010000000","1010001100","1010010000","1010010100","1010010000","1010000100","1001111000","1001111000","1010000100","1010001000","1010000100","1001111100","1010010000","1010011100","1010101000","1010101100","1010100100","1010011000","1010010000"),
("1001111000","1001101000","1001101000","1001101000","1001101000","1001101100","1001110000","1001110100","1001111000","1001100000","1001100100","1001101100","1001110100","1001111100","1010001000","1010001100","1010010000","1010011000","1010010100","1010001100","1010001000","1010001000","1010010100","1010011100","1010100000","1010110100","1010101100","1010100100","1010011100","1010010100","1010001100","1010000000"),
("1001110100","1010000000","1001111100","1001111000","1001111000","1001110100","1001110000","1001110000","1001110000","1010000100","1010000000","1010000000","1001111100","1001111100","1001111100","1001111100","1001111100","1010001000","1010001100","1010011000","1010011100","1010100000","1010101000","1010111000","1011000100","1010100100","1010010100","1010001000","1010000100","1010001100","1010001100","1010000000"),
("1001111000","1010001000","1010001000","1010001000","1010000100","1010000000","1010000000","1001111100","1001111000","1010010000","1010001100","1010000100","1001111000","1001110100","1001110000","1001110000","1001110000","1001111000","1010001000","1010011100","1010101100","1010110000","1010110100","1010111000","1010111000","1010001100","1010000100","1001111100","1010000000","1010001100","1010010000","1010001000"),
("1010001100","1010000000","1010000100","1010001000","1010001100","1010010000","1010010000","1010010000","1010010000","1001111100","1001111000","1001110000","1001101000","1001101000","1001101000","1001101100","1001110000","1010000000","1010001100","1010011100","1010101100","1010110000","1010101100","1010100000","1010010100","1010001100","1010000100","1010000100","1010000100","1010001100","1010010000","1010001100"),
("1010101000","1010000000","1010000100","1010001000","1010010000","1010010000","1010010000","1010010000","1010001100","1001110100","1001101100","1001101000","1001100100","1001100100","1001101100","1001110100","1001111000","1010001000","1010000100","1010000100","1010010100","1010100000","1010100000","1010010100","1010000100","1010000000","1010000000","1001111100","1001111000","1001111000","1010000100","1010011000"),
("1011000100","1010001000","1010001100","1010010000","1010010000","1010001100","1010001000","1010000000","1001111100","1010000000","1001111000","1001110000","1001101100","1001101100","1001110000","1001111000","1001111100","1010000000","1001110000","1001101100","1001111100","1010010100","1010100000","1010011000","1010001100","1001101100","1001101100","1001101000","1001100000","1001100000","1001111000","1010100000"),
("1010110000","1010001000","1010000100","1010000100","1010000000","1001111100","1001110100","1001101100","1001101000","1010001100","1010000100","1001111000","1001110000","1001101100","1001110000","1001110100","1001111000","1001100000","1001110100","1001111000","1001110100","1010000100","1010011100","1010011000","1001111100","1001101000","1001110000","1001110100","1001101000","1001011000","1001101000","1010001100"),
("1010011000","1010000000","1010000000","1010000100","1010000100","1010000000","1001111100","1001110100","1001110000","1010011000","1010010000","1010000100","1001111000","1001101100","1001101000","1001100100","1001100100","1001101000","1001111000","1001111000","1001110000","1001111100","1010010000","1010001100","1001110100","1001100100","1001100100","1001100100","1001101000","1001110100","1010000100","1010010000"),
("1001111100","1001101100","1001110100","1010000000","1010001100","1010010000","1010010000","1010001100","1010001000","1010011100","1010011000","1010010000","1010001000","1010000000","1001111000","1001110000","1001101100","1010000000","1010000100","1010000100","1001111100","1010000100","1010010100","1010010000","1010000000","1010000000","1001110100","1001101100","1001111100","1010011000","1010100000","1010010000"),
("1001111000","1001110000","1001111000","1010001000","1010011000","1010100000","1010100000","1010011100","1010011000","1010001000","1010001100","1010010000","1010010100","1010010100","1010010100","1010010100","1010010100","1010011000","1010011000","1010010100","1010010100","1010100000","1010101000","1010101000","1010100000","1010101100","1010100000","1010010100","1010011000","1010100100","1010100100","1010001100")
); 

type ram_type2 is array(0 to 31, 0 to 31 ) of std_logic_vector(9 downto 0);
signal score_r: ram_type2:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011100100","1011100100","1011100100","1011100100","1011100100","1011100100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011100100","1011100100","1011100100","1011100100","1011100100","1011100100","1011100100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1011100100","1100010000","1011011000","1101001000","1110111100","1101111100","1101010100","1100001100","1010010100","1011100100","0000000000","0000000000","0000000000","0000000000","1010110100","1100001100","1011101000","1100010000","1110100100","1100101000","1011001100","1011110100","1100111000","1011100100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1011100100","1010110100","1101011100","1101011000","1111000100","1111100100","1110100000","1111000100","1111111000","1101111000","1011100100","1011100100","1011100100","1011100100","1011110100","1110100100","1111101000","1111000100","1111001100","1101001100","1100110000","1011100100","1100101000","1111110000","1101001000","1011100100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1011011000","1101110100","1111101000","1110110000","1111010100","1110111000","1110100100","1110101100","1111000000","1111001000","1110010000","1011010000","1100110100","1001101100","1101111100","1111111100","1111011100","1111001000","1111100000","1010010000","1100101000","1101100000","1011011100","1110000000","1111010000","1011000100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","1011100100","1011101000","1110110100","1110111000","1110111100","1111101000","1111001000","1110111100","1110110100","1110101100","1110110000","1110010000","1110010000","1100001100","1101010000","1110001100","1111001100","1110111100","1110001100","1101011100","1000111100","1010100000","1100111000","1011111100","1011110000","1101101100","1101011000","1011100100","0000000000","0000000000"),
("0000000000","0000000000","1011100100","1101010100","1111111100","1110100100","1110100000","1110111000","1110011000","1110011100","1110111000","1110100100","1110011100","1110111000","1110011100","1111111100","1111001000","1110111100","1110100000","1110110100","1111001100","1100110000","1010111000","1010001000","1010011000","1100001100","1011010100","1011000100","1101001000","1011100100","0000000000","0000000000"),
("0000000000","0000000000","1011100100","1110111100","1111000000","1110101100","1110111000","1110110000","1110100100","1110011100","1110100100","1110110100","1110111100","1110111100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1111010000","1111000100","1110100000","1101010000","1011011000","1100010000","1101101100","1011100100","0000000000","0000000000"),
("0000000000","0000000000","1011100100","1110001000","1111001100","1110110100","1110110000","1110110100","1110101100","1110100100","1110101000","1110110100","1110111000","1110111000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1111110000","1111000100","1101110000","1111001100","1100100000","1010111100","1100111000","1011100100","0000000000","0000000000"),
("0000000000","0000000000","1011100100","1101000000","1111011100","1110111100","1110110100","1110111100","1110111000","1110110000","1110110000","1110110000","1110110000","1110101000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110100000","1110011000","1110001000","1111011000","1110010100","1110010000","1110000100","1011100100","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1010001000","1111100000","1111000100","1110111100","1111000100","1111000000","1110111100","1110110100","1110110000","1110101100","1110101000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1111011100","1111010100","1111000000","1111001000","1111000000","1111111000","1100111000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","1011100100","1110011100","1110110100","1110111000","1111000100","1111010000","1111000000","1110110000","1110101100","1110101100","1110101000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110101000","1110001100","1110000000","1111111100","1111111100","1110011000","1011101100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1011000100","1110110000","1110100100","1110111100","1111010100","1111000100","1110101100","1110101000","1110101100","1110111000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1111011100","1111000000","1110011100","1111010100","1111000100","1011110100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","1001011100","1101010100","1110000000","1110101100","1111010000","1111001000","1110101100","1110100000","1110101100","1111000000","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110100100","1110101100","1111001100","1110100000","1101001100","1001111100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","1100011100","1101101000","1110011100","1111001100","1111001000","1110101100","1110100000","1110110100","1111000100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1110110100","1111011100","1110010100","1110011000","1111001000","1100101100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011010000","1110010000","1111010000","1110011100","1110000000","1111001000","1111011100","1111010100","1110101100","1111010100","1111110000","1111011000","1110101100","1111011100","1110111100","1101110100","1110110000","1110111100","1110110000","1011100000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011011100","1110101100","1111101000","1110100000","1110001100","1111000100","1110001100","1110001000","1111100100","1110110100","1101111100","1110100000","1110100100","1110111100","1111001000","1111111100","1111001100","1011001100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011100100","1111001000","1110111000","1110111100","1110011100","1110111000","1110100100","1101111000","1110011100","1110010100","1110100100","1110011100","1111001000","1111100100","1110001100","1011010000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011110000","1111010000","1111000100","1110011100","1110110100","1110111000","1110111000","1110111100","1110001000","1110110000","1111001000","1110101100","1110111100","1010110000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011100100","1110110100","1111001100","1111111000","1111010100","1111111100","1111000000","1111000000","1111000100","1111010000","1110100100","1011001100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011110000","1110010000","1110110000","1111001000","1111100100","1111100000","1110101100","1110111100","1101110100","1010010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1010001100","1011100000","1101001000","1110111000","1110101000","1110100000","1100000000","1001101000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1010100100","1010111100","1101000100","1111000100","1100000000","1001111100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","1011100100","1011100100","1011100100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")

);

signal score_g: ram_type2:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0010010000","0100010000","0001110100","0000111100","0001010000","0000111100","0001000100","0001000100","0010100100","0010010000","0000000000","0000000000","0000000000","0000000000","0010100000","0001110100","0000111100","0001101000","0001001100","0001010000","0001001100","0001011100","0011000100","0010010000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0010010000","0001111100","0001110100","0001110100","0001100000","0001011000","0001010000","0001110000","0001111000","0001001000","0001010000","0010010000","0010010000","0010010000","0011000100","0001000100","0001100000","0001100100","0001010000","0001110000","0101011100","0100100000","0000100000","0000010100","0001001000","0010010000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011001100","0001101100","0010001100","0001110100","0001100100","0001100000","0010010100","0010001100","0001010000","0001010100","0001100000","0001101100","0101101100","0010000000","0001111100","0001011100","0001010000","0010001000","0010010000","0001010100","1001110000","1011111000","0100010000","0001001000","0001010000","0001110100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0010010000","0000111000","0000111000","0001011100","0001010100","0001110100","0001101000","0001110100","0001101100","0001011100","0010000000","0010001100","0010000100","0000101000","0001101000","0001010000","0001011000","0001100000","0001101100","0001011100","0001010100","0111001000","1010110000","1000011000","0101010000","0001110000","0000100100","0010010000","0000000000","0000000000"),
("0000000000","0000000000","0010010000","0001010000","0001100100","0001110100","0001101100","0010010100","0001111100","0001100100","0001110000","0001101100","0001110100","0010010000","0001001100","0001111100","0001000100","0010000000","0001110100","0001011000","0010000100","0000101100","0001100100","0001001000","0000111100","0110010000","1000011100","0010110000","0001100100","0010010000","0000000000","0000000000"),
("0000000000","0000000000","0010010000","0001101100","0001101100","0001111100","0001101100","0001111100","0010000000","0001111000","0001101000","0001101000","0001110000","0001110100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001110100","0001010100","0010010000","0001001000","0010110100","0100001100","0001000100","0010010000","0000000000","0000000000"),
("0000000000","0000000000","0010010000","0001101000","0001010100","0001111100","0001100100","0001101100","0001111000","0001110000","0001101100","0001101100","0001110000","0001110000","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001010000","0001101100","0001111100","0001110000","0001101100","0010000000","0001000100","0010010000","0000000000","0000000000"),
("0000000000","0000000000","0010010000","0001101100","0001001100","0001101000","0001011100","0001100100","0001101100","0001101000","0001101000","0001110100","0001110100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001011100","0010000100","0010001000","0001110000","0001101100","0001000000","0010010000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000101000","0001011000","0001100000","0001100100","0001100100","0001100000","0001100100","0001101100","0001110100","0001111000","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001111100","0001001000","0001110000","0001011000","0001001000","0010000100","0001011000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0010010000","0001110000","0001010100","0001110000","0001101100","0001100000","0001011100","0001101000","0001111000","0001111000","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001100000","0010001000","0010001000","0001101100","0000111000","0001011000","0010010100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0001010000","0010000000","0010000000","0001110100","0001100100","0001100000","0001100100","0001110100","0001111000","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001010100","0001110100","0001100000","0001010000","0001100100","0001101100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0010101100","0001110000","0010001000","0001111000","0001101100","0001100100","0001100100","0001110100","0001110000","0001101000","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101000","0001111000","0010000100","0001101000","0001101100","0010001100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0001110100","0010000000","0001111000","0001101100","0001100100","0001100100","0001110100","0001101100","0001100100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001101100","0001001100","0001111000","0001110100","0001101100","0010000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001101000","0010001100","0001011100","0010000100","0001111100","0001101000","0001101000","0001011000","0010001100","0001000100","0001000100","0010000000","0001100100","0001100100","0001100100","0010010100","0001011100","0001011000","0001110000","0001101100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001011000","0001110100","0010010100","0001111000","0001100000","0001001100","0001111000","0001101100","0010011000","0001011100","0001010000","0010000100","0001110000","0001100100","0001110100","0010001000","0001110000","0001010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001111000","0001010000","0001011100","0001111100","0010011100","0010001000","0010000000","0001011100","0010000000","0010000100","0010011100","0010000100","0001100100","0000110100","0000110100","0000110100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001100100","0001010100","0010000100","0001100100","0001001100","0001011100","0001110000","0010010000","0001101000","0001111000","0001101100","0001010000","0001100100","0001010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010010000","0001011100","0001000100","0001100100","0001011000","0001110000","0000111100","0001110100","0001010100","0001000100","0010010100","0001111000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001111000","0001010000","0001011100","0001111100","0001001000","0001000100","0001100000","0010001100","0001100100","0001011100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0001100100","0001100000","0001111100","0010000000","0001000000","0010001100","0001110000","0010000100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010101100","0001011000","0001111100","0010101000","0000100100","0010001100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010010000","0010010000","0010010000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")
);

signal score_b: ram_type2:=(
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010101000","0010101000","0010101000","0010101000","0010101000","0010101000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010101000","0010101000","0010101000","0010101000","0010101000","0010101000","0010101000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0010101000","0100000100","0010000000","0001111100","0010100000","0001110100","0001111100","0001111100","0010101100","0010101000","0000000000","0000000000","0000000000","0000000000","0011100100","0010101100","0001011100","0001110100","0010111100","0010001100","0001101100","0010010100","0100011000","0010101000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0010101000","0001110100","0010000000","0001101100","0010000000","0001110100","0001001100","0001111000","0010100100","0001110100","0001100000","0010101000","0010101000","0010101000","0011110000","0010100000","0010011000","0001110000","0001011100","0010000100","0101000000","0100101000","0010000000","0010010000","0001111100","0010101000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0011100100","0010010000","0010101000","0010011100","0010010100","0010000000","0010011000","0010011000","0010000000","0010011000","0010010000","0001111000","0101000100","0001100100","0010101000","0010100000","0001101100","0010000000","0010001100","0000110100","1000010100","1010111100","0100011100","0001111000","0001111000","0001110100","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0010101000","0001111000","0010000000","0001110000","0010010100","0010111000","0010100100","0010101000","0010100000","0010001100","0010100100","0010011000","0010100100","0000111100","0001111100","0001110000","0001111100","0010000000","0010010100","0010001000","0001010000","0110011000","1010001100","0111110100","0100100100","0010001100","0001101000","0010101000","0000000000","0000000000"),
("0000000000","0000000000","0010101000","0010100100","0010110000","0010000000","0010001000","0010110100","0010011000","0010001100","0010010100","0001111100","0001101100","0010000000","0001111100","0011000000","0010000100","0010100000","0010001100","0010011000","0011101000","0010100000","0010110100","0010101100","0010111000","0110110000","0111011100","0010111100","0010100100","0010101000","0000000000","0000000000"),
("0000000000","0000000000","0010101000","0010101000","0010000100","0010000000","0010010000","0010011000","0010011000","0010010000","0010001000","0010001100","0010010100","0010011000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010001000","0010000100","0010111000","0001110100","0010011100","0011110100","0010100100","0010101000","0000000000","0000000000"),
("0000000000","0000000000","0010101000","0010011100","0010000000","0010000100","0010001000","0010010000","0010010100","0010001100","0010001100","0010010000","0010010100","0010010100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010000100","0010010100","0010010100","0010110000","0001110100","0001110000","0010001100","0010101000","0000000000","0000000000"),
("0000000000","0000000000","0010101000","0010101000","0010010000","0010000000","0010000100","0010001100","0010010000","0010001100","0010001100","0010010100","0010010100","0010001100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010000000","0001111100","0010011000","0010111000","0010010000","0010010100","0010010100","0010101000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0001011100","0010110000","0010000100","0010001100","0010010000","0010001100","0010001100","0010010000","0010010100","0010010100","0010001100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010101000","0010001100","0010100000","0010001000","0001111100","0011001000","0010001000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0010101000","0011000000","0010000000","0010010100","0010010100","0010010000","0010001000","0010001100","0010010100","0010010100","0010001100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010000100","0010011100","0010010000","0010100000","0010001000","0010011000","0010111000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0001110100","0010100100","0010011000","0010011000","0010010100","0010001100","0010001000","0010010000","0010010100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010001100","0010011000","0010000000","0010001000","0010100000","0010011000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0010100000","0010000100","0010010000","0010010100","0010011000","0010010000","0010001000","0010001100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010001000","0010010100","0010101000","0010010000","0010010100","0010101100","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0001110100","0010000100","0010010000","0010011000","0010010000","0010001000","0010001100","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010010000","0010000000","0010001100","0010001100","0010101000","0010100100","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011011000","0011100000","0001111000","0001011000","0001101000","0010011100","0010110000","0010100100","0010010100","0001111000","0010001000","0010110000","0010010000","0010100000","0010001100","0010010100","0001101100","0010000100","0011001000","0010111000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010100000","0010101000","0010100100","0001110000","0001101100","0010001000","0010011100","0001111000","0010111100","0010000100","0001101000","0010011000","0010000100","0010000100","0010001100","0011000000","0010111000","0010001100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0011000000","0010101100","0001111000","0001110100","0010011000","0010101100","0010101000","0001111000","0010010100","0010001100","0010011100","0010001000","0010000100","0001101100","0010010100","0001111000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010111000","0010011100","0001111100","0001101100","0010000100","0010100100","0010100100","0010101000","0001110100","0010001000","0010001000","0001110000","0010001100","0010011000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010101000","0010001100","0001111100","0010110100","0010101100","0011001000","0001110100","0010010000","0010000100","0010010000","0011001100","0010000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010110000","0010101000","0010101100","0011000000","0010011000","0010001100","0010000100","0010111100","0010110100","0010010100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010011000","0010000000","0010001100","0010101000","0001111000","0010110000","0010001100","0010101000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010110000","0001000000","0001111100","0011000100","0000111000","0010001100","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0010101000","0010101000","0010101000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000"),
("0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000","0000000000")

);

type flag1 is array(integer range 0 to 14, integer range 0 to 19 ) of integer;
signal background: flag1:=(
( 0,0,0,0,0,0,l1,l2,l3,0,0,r3,r2,r1,0,0,0,0,0,0 ), --l3,l2,l1:left pad score; r3,r2,r1:right pad score;
( 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ),  
( 0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,0,0,0 ), 
( 0,0,0,0,1,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0 ), 
( 0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0 ), 
( 0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0 ), 
( 0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0 ), 
( 0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0 ), 
( 0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0 ), 
( 0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0 ), 
( 0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0 ), 
( 0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0 ), 
( 0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0 ),  
( 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ),  
( 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ) 
);

begin

--v1: entity work.rom_32_4 port map(
--Clk => clk,
--addr_x => to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ), 
--addr_y => to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)),
--addrg_x => to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ), 
--addrg_y => to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)),
--addrb_x => to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ),
--addrb_y => to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)),
--addr_r_x =>to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ), 
--addr_r_y =>to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)),
--addrg_r_x => to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ), 
--addrg_r_y => to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)),
--addrb_r_x => to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ), 
--addrb_r_y => to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)),
--
--
--data =>RGB,
--datag =>RGB_G,
--datab =>RGB_B,
--data_r =>RGB_r,
--datag_r =>RGB_G_r,
--datab_r =>RGB_B_r
--
--);


  process (clk)
  begin
    if rising_edge(clk) then
      clk25 <= not clk25;
    end if;
  end process;

  -- Horizontal and vertical counters

  -- new plug in

  one : process (clk)
  begin 
if rising_edge(clk) then 
    if chipselect = '1' then  
			if read ='1'then 
                case address(3 downto 0) is
                                            when "0000" => readdata <= RECTANGLE_HSTART;      
                                            when "0001" => readdata <= RECTANGLE_VSTART;
                                            when "0010" => readdata <= RECTANGLE_HSTART_paddle;
                                            when "0011" => readdata <= RECTANGLE_VSTART_paddle;
                                            when "0100" => readdata <= RECTANGLE_HSTART_paddle_2;
                                            when "0101" => readdata <= RECTANGLE_VSTART_paddle_2;
--                                            when "0110" => readdata <= to_unsigned(l3);
--                                            when "0111" => readdata <= to_unsigned(l2);  
--                                            when "1000" => readdata <= to_unsigned(l1);
--                                            when "1001" => readdata <= to_unsigned(r3);  
--                                            when "1010" => readdata <= to_unsigned(r2);  
--                                            when "1011" => readdata <= to_unsigned(r1); 
                                            when others=> readdata  <= X"0000";
                end case;
            elsif write='1' then

                
                case address(3 downto 0) is
                                            when "0000" => RECTANGLE_HSTART <= writedata;      
                                            when "0001" => RECTANGLE_VSTART <= writedata;
                                            when "0010" => RECTANGLE_HSTART_paddle   <= writedata;
                                            when "0011" => RECTANGLE_VSTART_paddle   <= writedata;
                                            when "0100" => RECTANGLE_HSTART_paddle_2 <= writedata;
                                            when "0101" => RECTANGLE_VSTART_paddle_2 <= writedata;   
                                            when "0110" => l1 <= to_integer(writedata);
                                            when "0111" => l2 <= to_integer(writedata); 
                                            when "1000" => l3 <= to_integer(writedata);
                                            when "1001" => r1 <= to_integer(writedata);
                                            when "1010" => r2 <= to_integer(writedata);
                                            when "1011" => r3 <= to_integer(writedata);
                                            when "1100" => RECTANGLE_HSTART_ball1 <= writedata;      
                                            when "1101" => RECTANGLE_VSTART_ball1 <= writedata;
                                            when "1110" => RECTANGLE_HSTART_ball2 <= writedata;      
                                            when "1111" => RECTANGLE_VSTART_ball2 <= writedata;                                                                 
                                            when others=> RECTANGLE_HSTART <= writedata;
                end case;
            end if;     
     end if;
end if;
  end process one;

  HCounter : process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;

      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        irq <= '0';
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
          
          if EndOfField = '1' then
		  	  Vcount <= (others => '0');
		  	  flag <= '1';
		  	  irq <= '1';
--          elsif write = '1' and chipselect = '1'  then
--			  irq <= '0';
--			  Vcount <= Vcount + 1;
--	  		  flag <= '0';
	      else
              Vcount <= Vcount + 1;
	  		  flag <= '0';
			  irq<= '0';
          end if;
      else
          if write = '1' and chipselect = '1' then
				irq <= '0';
		  end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
      if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;


  -- back ground generator
  background_x <= to_integer(Hcount - HSYNC - HBACK_PORCH - 1 );
  background_y <= to_integer(Vcount - VSYNC - VBACK_PORCH );
  -- Rectangle generator


  RectangleHGenball : process (clk25)
  begin
    if rising_edge(clk25) then 
   
      if reset = '1' or Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART  then
           rectangle_h_ball <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART + 16 then
        rectangle_h_ball <= '0';
      end if; 
    end if;  
  end process RectangleHGenball;

  RectangleHGenball1 : process (clk25)
  begin
    if rising_edge(clk25) then 
   
      if reset = '1' or Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1  then
           rectangle_h_ball1 <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1 + 16 then
        rectangle_h_ball1 <= '0';
      end if; 
    end if;  
  end process RectangleHGenball1;

  RectangleHGenball2 : process (clk25)
  begin
    if rising_edge(clk25) then 
   
      if reset = '1' or Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2  then
           rectangle_h_ball2 <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2 + 16 then
        rectangle_h_ball2 <= '0';
      end if; 
    end if;  
  end process RectangleHGenball2;





  RectangleHGenl : process (clk25)
  begin
    if rising_edge(clk25) then 
      if reset = '1' or Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle  then
           rectangle_h_paddle <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle + 21 then
        rectangle_h_paddle <= '0';
      end if;      
    end if;
  end process RectangleHGenl;

  RectangleHGenr : process (clk25)
  begin
    if rising_edge(clk25) then 
      if reset = '1' or Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2  then
           rectangle_h_paddle_2 <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2 + 21 then
        rectangle_h_paddle_2 <= '0';
      end if;      
    end if;
  end process RectangleHGenr;



  RectangleVGenball : process (clk25)--rectangle of the ball
  begin
    if rising_edge(clk25) then
      if reset = '1' then       
        rectangle_v_ball <= '0';
       elsif EndOfLine = '1' then  
          if Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART then
             rectangle_v_ball <= '1';
          elsif Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART + 16 then
             rectangle_v_ball <= '0';
          elsif Vcount < VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART or Vcount > VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART + 16  then
             rectangle_v_ball <= '0';
          end if;
       end if;      
     end if;
  end process RectangleVGenball;

  RectangleVGenball1 : process (clk25)--rectangle of the ball1
  begin
    if rising_edge(clk25) then
      if reset = '1' then       
        rectangle_v_ball1 <= '0';
       elsif EndOfLine = '1' then  
          if Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1 then
             rectangle_v_ball1 <= '1';
          elsif Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1 + 16 then
             rectangle_v_ball1 <= '0';
          elsif Vcount < VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1 or Vcount > VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1 + 16  then
             rectangle_v_ball1 <= '0';
          end if;
       end if;      
     end if;
  end process RectangleVGenball1;

  RectangleVGenball2 : process (clk25)--rectangle of the ball2
  begin
    if rising_edge(clk25) then
      if reset = '1' then       
        rectangle_v_ball2 <= '0';
       elsif EndOfLine = '1' then  
          if Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2 then
             rectangle_v_ball2 <= '1';
          elsif Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2 + 16 then
             rectangle_v_ball2 <= '0';
          elsif Vcount < VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2 or Vcount > VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2 + 16  then
             rectangle_v_ball2 <= '0';
          end if;
       end if;      
     end if;
  end process RectangleVGenball2;


 RectangleVGenl : process (clk25)--rectangle of the left paddle
  begin
    if rising_edge(clk25) then
      if reset = '1' then       
        rectangle_v_paddle <= '0';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle then
          rectangle_v_paddle <= '1';
        elsif Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 120 then
          rectangle_v_paddle <= '0';
     elsif Vcount < VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle or Vcount > VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 120  then
          rectangle_v_paddle <= '0';
        end if;
      end if;      
    end if;
  end process RectangleVGenl;

 RectangleVGenr : process (clk25)--rectangle of the right paddle
  begin
    if rising_edge(clk25) then
      if reset = '1' then       
        rectangle_v_paddle_2 <= '0';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 then
          rectangle_v_paddle_2 <= '1';
        elsif Vcount = VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 120 then
          rectangle_v_paddle_2 <= '0';

     elsif Vcount < VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 or Vcount > VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 120  then
          rectangle_v_paddle_2 <= '0';
        end if;
      end if;      
    end if;
  end process RectangleVGenr;

   rectangle_ball <= rectangle_h_ball and rectangle_v_ball;--ball area
   rectangle_ball1 <= rectangle_h_ball1 and rectangle_v_ball1;--ball_1  area
   rectangle_ball2 <= rectangle_h_ball2 and rectangle_v_ball2;--ball_2  area
   rectangle_paddle <= rectangle_h_paddle and rectangle_v_paddle;--left paddle area
   rectangle_paddle_2 <= rectangle_h_paddle_2 and rectangle_v_paddle_2;-- right paddle area
  -- Registered video signals going to the video DAC

backgroundgen: process(clk25)
begin
     if rising_edge(clk25) then
        if background_x >= 0 and background_x <= 640 and background_y >= 0 and background_y <= 480 then
            num <= background( background_y/32, (background_x mod 640)/32 );
               case num is
                          when 1 => RGB_bg <= background_r( background_y mod 32, background_x mod 32);
                                    RGB_G_bg<= background_g( background_y mod 32, background_x mod 32);
                                    RGB_B_bg<= background_b( background_y mod 32, background_x mod 32);
                                    bg_flag <='1';
                          when 2 => RGB_bg <= score_r( background_y mod 32, background_x mod 32);
                                    RGB_G_bg<= score_g( background_y mod 32, background_x mod 32);
                                    RGB_B_bg<= score_b( background_y mod 32, background_x mod 32);
                                    bg_flag <='1';
                          
                          when others => RGB_bg  <="1111111111";
                                         RGB_G_bg<="1111111111";
									     RGB_B_bg<="1111111111";
										 bg_flag <='0';
               end case;
         else 
             RGB_bg <="0000000000";
             RGB_G_bg<="0000000000";
			 RGB_B_bg<="0000000000";
			 bg_flag <='0';
		end if;
	 end if;	
 end process backgroundgen;

  VideoOut: process (clk25, reset)
  begin
    if reset = '1' then
      VGA_R <= "1111111111";
      VGA_G <= "1111111111";
      VGA_B <= "1111111111";
    elsif clk25'event and clk25 = '1' then
-- ball
       if rectangle_ball = '1' and 
        ball_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) >= "0000000010"  then
    --  ball_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"   and
    --  ball_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"  then
        VGA_R <= ball_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) ;
        VGA_G <= ball_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) ;
        VGA_B <= ball_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) ;

--end of ball

--ball1
       elsif rectangle_ball1 = '1' and 
        ball1_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1)-1)) /= "0000000000" then
    --  ball_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"   and
    --  ball_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"  then
        VGA_R <= ball1_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1)-1)) ;
        VGA_G <= ball1_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1)-1)) ;
        VGA_B <= ball1_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball1+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball1)-1)) ;
--end of ball1

--ball2
       elsif rectangle_ball2 = '1' and 
        ball2_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2)-1)) /= "0000000000" then
    --  ball_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"   and
    --  ball_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART)-1)) /=X"00"  then
        VGA_R <= ball2_r(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2)-1)) ;
        VGA_G <= ball2_g(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2)-1)) ;
        VGA_B <= ball2_b(to_integer (Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_ball2+1)),to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_ball2)-1)) ;

--end of ball2

-- left paddle
       elsif rectangle_paddle = '1' then
--		VGA_R <= rgb;
--		VGA_G <= rgb_g;
--		VGA_B <= rgb_b;
        VGA_R <= pad_r(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ) );
        VGA_G <= pad_g(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ) );
        VGA_B <= pad_b(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle)-1 ) );
--end of left paddle

--right paddle
       elsif rectangle_paddle_2 = '1' then
--		VGA_R <= rgb_r;
--		VGA_G <= rgb_g_r;
--		VGA_B <= rgb_b_r;
        VGA_R <= pad_r(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ) );
        VGA_G <= pad_g(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ) );
        VGA_B <= pad_b(to_integer(Vcount -( VSYNC + VBACK_PORCH - 1 + RECTANGLE_VSTART_paddle_2 + 1)), to_integer(Hcount - (HSYNC + HBACK_PORCH + RECTANGLE_HSTART_paddle_2)-1 ) );

----end of right paddle

-- back ground
       elsif bg_flag = '1' then
        VGA_R <=  RGB_bg;
        VGA_G <=  RGB_G_bg;
        VGA_B <=  RGB_B_bg; 
-- end of back ground     

       elsif vga_hblank = '0' and vga_vblank = '0' then 
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";
       else
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";  
     end if;  
  end if;
  end process VideoOut;

  VGA_clk <= clk25;
  VGA_SYNC <= '0'; 
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
