--
-- DE2 top-level module that includes the simple audio component
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity de2_audio is

  port (
clk        : in  std_logic;
reset_n    : in  std_logic;
read       : in  std_logic;
write      : in  std_logic;
chipselect : in  std_logic;
address    : in  unsigned(4 downto 0);
readdata   : out unsigned(15 downto 0);
writedata  : in  unsigned(15 downto 0);


    --CLOCK_50 :in std_logic;                                      -- 50 MHz
 
    I2C_SDAT : inout std_logic; -- I2C Data
    I2C_SCLK : out std_logic;   -- I2C Clock

    
    AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                          -- ADC Data
    AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    AUD_DACDAT : out std_logic;                         -- DAC Data
    AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
    AUD_XCK : out std_logic                            -- Chip Clock
    

    );
  
end de2_audio;

architecture datapath of de2_audio is

  component de2_wm8731_audio is
   port (
    clk : in std_logic;                 --    Audio CODEC Chip Clock AUD_XCK
    reset_n : in std_logic;
    test_mode : in std_logic;           --    Audio CODEC controller test mode
    audio_request : out std_logic;      --    Audio controller request new data
    data : in std_logic_vector(15 downto 0);
    signal_start : in std_logic;  

    -- Audio interface signals
    AUD_ADCLRCK  : out std_logic;       --    Audio CODEC ADC LR Clock
    AUD_ADCDAT   : in  std_logic;       --    Audio CODEC ADC Data
    AUD_DACLRCK  : out std_logic;       --    Audio CODEC DAC LR Clock
    AUD_DACDAT   : out std_logic;       --    Audio CODEC DAC Data
    AUD_BCLK     : inout std_logic      --    Audio CODEC Bit-Stream Clock
  );
  end component;

  component de2_i2c_av_config is
  port (
    iCLK : in std_logic;
    iRST_N : in std_logic;
    I2C_SCLK : out std_logic;
    I2C_SDAT : inout std_logic
  );
  end component;

  signal audio_clock : unsigned(1 downto 0) := "00";
  signal audio_request : std_logic;
  signal temp_signal_start : std_logic;
  signal ram : unsigned(15 downto 0);--useless, just for test

begin

  process (clk)
  begin
    if rising_edge(clk) then
       audio_clock <= audio_clock + "1";
	   if write = '1' and chipselect = '1' then
			temp_signal_start <= '1'; 
			ram <= writedata;--useless, just for test
	   elsif read = '1' and chipselect = '1' then		
			temp_signal_start <= '0';
			readdata <= ram;--useless, just for test
       end if;
    end if;
  end process;

  AUD_XCK <= audio_clock(1);

  i2c : de2_i2c_av_config port map (
    iCLK     => clk,
    iRST_n   => '1',
    I2C_SCLK => I2C_SCLK,
    I2C_SDAT => I2C_SDAT
  );

  V1: de2_wm8731_audio port map (
    clk => audio_clock(1),
    reset_n => '1',
    test_mode => '1',                   -- Output a sine wave
    audio_request => audio_request,
    data => "0000000000000000",
    signal_start => temp_signal_start,
  
    -- Audio interface signals
    AUD_ADCLRCK  => AUD_ADCLRCK,
    AUD_ADCDAT   => AUD_ADCDAT,
    AUD_DACLRCK  => AUD_DACLRCK,
    AUD_DACDAT   => AUD_DACDAT,
    AUD_BCLK     => AUD_BCLK
  );
end datapath;
