library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Project is
  
  port (
    signal CLOCK_50 : in std_logic;                -- 50 MHz clock
    signal key : IN STD_LOGIC_VECTOR (3 DOWNTO 0);
    signal LEDR : out std_logic_vector(17 downto 0); -- Red LEDs
    signal GPIO_1   : inout std_logic_vector(35 downto 0);
    SRAM_DQ : inout std_logic_vector(15 downto 0); -- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); -- Address bus 18 Bits
    SRAM_UB_N,                                     -- High-byte Data Mask
    SRAM_LB_N,                                     -- Low-byte Data Mask
    SRAM_WE_N,                                     -- Write Enable
    SRAM_CE_N,                                     -- Chip Enable
    SRAM_OE_N : out std_logic;                      -- Output Enable

    VGA_CLK,                                            -- Clock
    VGA_HS,                                             -- H_SYNC
    VGA_VS,                                             -- V_SYNC
    VGA_BLANK,                                          -- BLANK
    VGA_SYNC : out std_logic;                           -- SYNC
    VGA_R,                                              -- Red[9:0]
    VGA_G,                                              -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0);           -- Blue[9:0]

    AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                          -- ADC Data
    AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    AUD_DACDAT : out std_logic;                         -- DAC Data
    AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
    AUD_XCK : out std_logic;                            -- Chip Clock

    ENET_DATA : inout std_logic_vector(15 downto 0);    -- DATA bus 16Bits
    ENET_CMD,           -- Command/Data Select, 0 = Command, 1 = Data
    ENET_CS_N,                                          -- Chip Select
    ENET_WR_N,                                          -- Write
    ENET_RD_N,                                          -- Read
    ENET_RST_N,                                         -- Reset
    ENET_CLK : out std_logic;                           -- Clock 25 MHz
    ENET_INT : in std_logic;                            -- Interrupt

    I2C_SDAT : inout std_logic; -- I2C Data
    I2C_SCLK : out std_logic   -- I2C Clock
    );
  
end Project;

architecture rtl of Project is
  
  signal counter : unsigned(15 downto 0);
  signal reset_n : std_logic;
  signal clk25 : std_logic;
  
begin

  process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
      if counter = x"ffff" then
        reset_n <= '1';
      else
        reset_n <= '0';
        counter <= counter + 1;
      end if;
    end if;
  end process;

  process (CLOCK_50)
  begin
	if rising_edge(CLOCK_50) then
		clk25 <= not clk25;
	end if;
  end process;
  ENET_CLK <= clk25;

  nios : entity work.nios_system port map (
    clk                          => CLOCK_50,
    reset_n                      => reset_n,

    key_to_the_rotary              => key,
    GPIO_1_to_and_from_the_rotary  => GPIO_1,
    leds_from_the_rotary           => LEDR,
    -- the_sram
    SRAM_ADDR_from_the_sram      => SRAM_ADDR,
    SRAM_CE_N_from_the_sram      => SRAM_CE_N,
    SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
    SRAM_LB_N_from_the_sram      => SRAM_LB_N,
    SRAM_OE_N_from_the_sram      => SRAM_OE_N,
    SRAM_UB_N_from_the_sram      => SRAM_UB_N,
    SRAM_WE_N_from_the_sram      => SRAM_WE_N,

    VGA_BLANK_from_the_vga => VGA_BLANK,
    VGA_B_from_the_vga => VGA_B,
    VGA_CLK_from_the_vga => VGA_CLK,
    VGA_G_from_the_vga => VGA_G,
    VGA_HS_from_the_vga => VGA_HS,
    VGA_R_from_the_vga => VGA_R,
    VGA_SYNC_from_the_vga => VGA_SYNC,
    VGA_VS_from_the_vga => VGA_VS,
    -- the_DM9000A
    ENET_CMD_from_the_DM9000A => ENET_CMD,
    ENET_CS_N_from_the_DM9000A => ENET_CS_N,
    ENET_DATA_to_and_from_the_DM9000A => ENET_DATA,
    ENET_INT_to_the_DM9000A => ENET_INT,
    ENET_RD_N_from_the_DM9000A => ENET_RD_N,
    ENET_RST_N_from_the_DM9000A => ENET_RST_N,
    ENET_WR_N_from_the_DM9000A => ENET_WR_N,
    -- the_audio
	AUD_ADCDAT_to_the_audio => AUD_ADCDAT,
	AUD_ADCLRCK_to_and_from_the_audio => AUD_ADCLRCK,
	AUD_BCLK_to_and_from_the_audio => AUD_BCLK,
	AUD_DACDAT_from_the_audio => AUD_DACDAT,
	AUD_DACLRCK_to_and_from_the_audio => AUD_DACLRCK,
	AUD_XCK_from_the_audio => AUD_XCK,
	I2C_SCLK_from_the_audio => I2C_SCLK,
	I2C_SDAT_to_and_from_the_audio => I2C_SDAT

    );

end rtl;
