---------------------------------------------------------------------
--Color_LUT.vhd
--
--A device that outputs RGB to the VGA depending on the count signal
--and the colorization setting given to it.
--
--Author: Richard Nwaobasi
---------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity Color_LUT is
  port (count   : in unsigned(7 downto 0);
        switch  : in std_logic_vector(2 downto 0);
        VGA_RGB : out unsigned(29 downto 0));
end Color_LUT;

architecture imp of Color_LUT is
signal index	: unsigned(6 downto 0);

type rom_type is array (0 to 127) of unsigned (29 downto 0);
constant CLUT0 : rom_type :=
 (
"111111111100000000000000000000",
"111111110000000000000000000000",
"111111010000000000000000000000",
"111110110000000000000000000000",
"111110010000000000000000000000",
"111101110000000000000000000000",
"111101010000000000000000000000",
"111100110000000000000000000000",
"111100010000000000000000000000",
"111011110000000000000000000000",
"111011010000000000000000000000",
"111010110000000000000000000000",
"111010010000000000000000000000",
"111001110000000000000000000000",
"111001010000000000000000000000",
"111000110000000000000000000000",
"111000010000000000000000000000",
"110111110000000000000000000000",
"110111010000000000000000000000",
"110110110000000000000000000000",
"110110010000000000000000000000",
"110101110000000000000000000000",
"110101010000000000000000000000",
"110100110000000000000000000000",
"110100010000000000000000000000",
"110011110000000000000000000000",
"110011010000000000000000000000",
"110010110000000000000000000000",
"110010010000000000000000000000",
"110001110000000000000000000000",
"110001010000000000000000000000",
"110000110000000000000000000000",
"110000001100000000000000000000",
"101111101100000000000000000000",
"101111001100000000000000000000",
"101110101100000000000000000000",
"101110001100000000000000000000",
"101101101100000000000000000000",
"101101001100000000000000000000",
"101100101100000000000000000000",
"101100001100000000000000000000",
"101011101100000000000000000000",
"101011001100000000000000000000",
"101010101100000000000000000000",
"101010001100000000000000000000",
"101001101100000000000000000000",
"101001001100000000000000000000",
"101000101100000000000000000000",
"101000001100000000000000000000",
"100111101100000000000000000000",
"100111001100000000000000000000",
"100110101100000000000000000000",
"100110001100000000000000000000",
"100101101100000000000000000000",
"100101001100000000000000000000",
"100100101100000000000000000000",
"100100001100000000000000000000",
"100011101100000000000000000000",
"100011001100000000000000000000",
"100010101100000000000000000000",
"100010001100000000000000000000",
"100001101100000000000000000000",
"100001001100000000000000000000",
"100000101100000000000000000000",
"100000001100000000000000000000",
"011111101100000000000000000000",
"011111001100000000000000000000",
"011110101100000000000000000000",
"011110001100000000000000000000",
"011101101100000000000000000000",
"011101001100000000000000000000",
"011100101100000000000000000000",
"011100001100000000000000000000",
"011011101100000000000000000000",
"011011001100000000000000000000",
"011010101100000000000000000000",
"011010001100000000000000000000",
"011001101100000000000000000000",
"011001001100000000000000000000",
"011000101100000000000000000000",
"011000001100000000000000000000",
"010111101100000000000000000000",
"010111001100000000000000000000",
"010110101100000000000000000000",
"010110001100000000000000000000",
"010101101100000000000000000000",
"010101001100000000000000000000",
"010100101100000000000000000000",
"010100001100000000000000000000",
"010011101100000000000000000000",
"010011001100000000000000000000",
"010010101100000000000000000000",
"010010001100000000000000000000",
"010001101100000000000000000000",
"010001001100000000000000000000",
"010000101100000000000000000000",
"010000001100000000000000000000",
"001111101100000000000000000000",
"001111001100000000000000000000",
"001110101100000000000000000000",
"001110001100000000000000000000",
"001101101100000000000000000000",
"001101001100000000000000000000",
"001100101100000000000000000000",
"001100001100000000000000000000",
"001011101100000000000000000000",
"001011001100000000000000000000",
"001010101100000000000000000000",
"001010001100000000000000000000",
"001001101100000000000000000000",
"001001001100000000000000000000",
"001000101000000000000000000000",
"001000001000000000000000000000",
"000111101000000000000000000000",
"000111001000000000000000000000",
"000110101000000000000000000000",
"000110001000000000000000000000",
"000101101000000000000000000000",
"000101001000000000000000000000",
"000100101000000000000000000000",
"000100001000000000000000000000",
"000011101000000000000000000000",
"000011001000000000000000000000",
"000010101000000000000000000000",
"000010001000000000000000000000",
"000001101000000000000000000000",
"000001001000000000000000000000",
"000000101000000000000000000000"
);

constant CLUT1 : rom_type :=
(
"100000010101111110111111111111",
"100000100110000000101110101100",
"100000110110000010101101010010",
"100001000110000100101011111000",
"100001010110000110101010011110",
"100001100110001000011001000101",
"100001110110001010010111101011",
"100010000010001100010110010001",
"100010010010001110000100110111",
"100010100010010000000011011110",
"100010101110010010000010000100",
"100010111010010011110000101010",
"100011001010010101110000000000",
"100011010110010111100000000000",
"100011100010011001010000000000",
"100011101110011011010000000000",
"100011110110011101000000000000",
"100100000010011110110000000000",
"100100001010100000100000000000",
"100100010110100010010000000000",
"100100011110100100000000000000",
"100100100110100101110000000000",
"100100101010100111100000000000",
"100100110010101001000000000000",
"100100110110101010110000000000",
"100100111010101100010000000000",
"100100111010101110000000000000",
"100100111110101111100000000000",
"100100111110110001000000000000",
"100100111110110010100000000000",
"100100111010110100000000000000",
"100100111010110101010000000000",
"100100110110110110110000000000",
"100100101110111000000000000000",
"100100100110111001100000000000",
"100100011110111010110000000000",
"100100010110111100000000000000",
"100100001010111101000000000000",
"100011111110111110010000000000",
"100011110010111111100000000000",
"100011100011000000100000000000",
"100011001111000001100000000000",
"100010111111000010100000000000",
"100010101011000011100000000000",
"100010010011000100010000000000",
"100001111011000101010000000000",
"100001100011000110000000000000",
"100001000111000110110000000000",
"100000101011000111010000000000",
"100000001011001000000000000000",
"011111101011001000100000000000",
"011111001011001001000000000000",
"011110100111001001100000000000",
"011110000011001010000000000000",
"011101011111001010010000000000",
"011100111011001010100000000000",
"011100010111001010110000000000",
"011011101111001011000000000000",
"011011001011001011000000000000",
"011010100011001011010000000000",
"011001111011001011010000000000",
"011001010011001011000000000000",
"011000101111001011000000000000",
"011000000111001010110000000000",
"010111011111001010010000000000",
"010110110111001010000000000000",
"010110010011001001100000000000",
"010101101011001001000000000000",
"010101000111001000100000000000",
"010100100011000111110000000000",
"010011111111000111000000000000",
"010011011011000110010000000000",
"010010111011000101010000000000",
"010010010111000100010000000000",
"010001111011000011010000000000",
"010001011011000010010000000000",
"010000111111000001000000000000",
"010000100010111111100000000000",
"010000001010111110010000000000",
"001111110010111100110000000000",
"001111011110111011010000000000",
"001111001010111001100000000000",
"001110110110110111110000000000",
"001110100110110110000000000000",
"001110011010110100000000000000",
"001110001110110010000000000000",
"001110000110101111110000000000",
"001101111110101101110000000000",
"001101110110101011100000000000",
"001101110010101001000000000000",
"001101110010100110110000000000",
"001101110010100100010000000000",
"001101110010100001100000000000",
"001101110110011111000000000000",
"001101111010011100010000000000",
"001101111110011001100000000000",
"001110000110010110100000000000",
"001110001110010011110000000000",
"001110010110010000110000000000",
"001110100010001101110000000000",
"001110101110001010100000000000",
"001110111110000111100000000000",
"001111001010000100010000000000",
"001111011010000001000000000000",
"001111101101111101110000000000",
"001111111101111010010000000000",
"010000010001110111000000000000",
"010000100101110011100000000000",
"010000111001110000000000000000",
"010001010001101100100000000000",
"010001101001101001000000000000",
"010010000001100101100000000000",
"010010011001100001110000000000",
"010010110001011110000000000000",
"010011001001011010100000000000",
"010011100101010110110000000000",
"010100000001010011000000000000",
"010100011101001111010000000000",
"010100111001001011100000000000",
"010101010101000111110000000000",
"010101110001000011110000000000",
"010110001101000000000000000000",
"010110101100111100010000000000",
"010111001000111000010000000000",
"010111101000110100100000000000",
"011000000100110000100000000000",
"011000100100101100110000000000",
"011001000000101000110000000000"
);

constant CLUT2 : rom_type :=
(
"000000000000000000001111111111",
"000001100000000110001111111111",
"000011000000001100001111111111",
"000100100000010010001111111111",
"000110000000011000001111111111",
"000111100000011110001111111111",
"001001000000100100001111111111",
"001010100000101010001111111111",
"001100000000110000001111111111",
"001101011100110101111111111111",
"001110111100111011111111111111",
"010000011001000001101111111111",
"010001111001000111101111111111",
"010011010101001101011111111111",
"010100110001010011001111111111",
"010110001101011000111111111111",
"010111100101011110011111111111",
"011001000001100100001111111111",
"011010011001101001101111111111",
"011011110001101111001111111111",
"011101001001110100101111111111",
"011110100001111010001111111111",
"011111110101111111011111111111",
"100001001010000100101111111111",
"100010011110001001111111111111",
"100011101110001110111111111111",
"100101000010010100001111111111",
"100110010010011001001111111111",
"100111011110011101111111111111",
"101000101110100010111111111111",
"101001111010100111101111111111",
"101011000010101100001111111111",
"101100001010110000101111111111",
"101101010010110101001111111111",
"101110011010111001101111111111",
"101111011110111101111111111111",
"110000100011000010001111111111",
"110001100011000110001111111111",
"110010100011001010001111111111",
"110011011111001101111111111111",
"110100011011010001101111111111",
"110101010011010101001111111111",
"110110001011011000101111111111",
"110111000011011100001111111111",
"110111110111011111011111111111",
"111000100111100010011111111111",
"111001010111100101011111111111",
"111010000011101000001111111111",
"111010101111101010111111111111",
"111011011011101101101111111111",
"111011111111101111111111111111",
"111100100011110010001111111111",
"111101000111110100011111111111",
"111101100111110110011111111111",
"111110000011111000001111111111",
"111110011111111001111111111111",
"111110110111111011011111111111",
"111111001011111100101111111111",
"111111011111111101111111111111",
"111111101111111110111111111111",
"111111111011111111101111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111111111111111111111111",
"111111111011111111101111111111",
"111111101111111110111111111111",
"111111011111111101111111111111",
"111111001011111100101111111111",
"111110110111111011011111111111",
"111110011111111001111111111111",
"111110000011111000001111111111",
"111101100111110110011111111111",
"111101000111110100011111111111",
"111100100111110010011111111111",
"111100000011110000001111111111",
"111011011011101101101111111111",
"111010110011101011001111111111",
"111010000111101000011111111111",
"111001011011100101101111111111",
"111000101011100010101111111111",
"110111110111011111011111111111",
"110111000011011100001111111111",
"110110001111011000111111111111",
"110101010111010101011111111111",
"110100011011010001101111111111",
"110011011111001101111111111111",
"110010100011001010001111111111",
"110001100011000110001111111111",
"110000100011000010001111111111",
"101111011110111101111111111111",
"101110011010111001101111111111",
"101101010010110101001111111111",
"101100001110110000111111111111",
"101011000010101100001111111111",
"101001111010100111101111111111",
"101000101110100010111111111111",
"100111011110011101111111111111",
"100110010010011001001111111111",
"100101000010010100001111111111",
"100011101110001110111111111111",
"100010011110001001111111111111",
"100001001010000100101111111111",
"011111110101111111011111111111",
"011110011101111001111111111111",
"011101001001110100101111111111",
"011011110001101111001111111111",
"011010011001101001101111111111",
"011000111101100011111111111111",
"010111100101011110011111111111",
"010110001001011000101111111111",
"010100101101010010111111111111",
"010011010001001101001111111111",
"010001110101000111011111111111",
"010000011001000001101111111111",
"001110111000111011101111111111",
"001101011100110101111111111111",
"001011111100101111111111111111",
"001010011100101001111111111111",
"001000111100100011111111111111",
"000111011100011101111111111111",
"000101111100010111111111111111",
"000100011100010001111111111111",
"000010111100001011111111111111",
"000001011100000101111111111111"
);

constant CLUT3 : rom_type :=
(
"111111111111111111111111111111",
"111100100011111010111111111111",
"111000110011110100011111111111",
"110101000111101110001111111111",
"110001011111100111111111111111",
"101101111011100001101111111111",
"101010011011011011011111111111",
"100111000011010101001111111111",
"100011110011001111001111111111",
"100000100111001000111111111111",
"011101100111000010111111111111",
"011010110010111100101111111111",
"011000001010110110101111111111",
"010101101110110000111111111111",
"010011011110101010111111111111",
"010001011110100101001111111111",
"001111101010011111011111111111",
"001101111110011001101111111111",
"001100011110010011111111111111",
"001011001010001110011111111111",
"001001111010001000111111111111",
"001000110110000011101111111111",
"000111110001111110011111111111",
"000110110101111001001111111111",
"000101111101110100001111111111",
"000101001001101111001111111111",
"000100010101101010011111111111",
"000011100101100101101111111111",
"000010110001100000111111111111",
"000001111101011100011111111111",
"000001000101010111111111111111",
"000000001001010011011111111111",
"000000000001001110111111111111",
"000000000001001010101111111111",
"000000000001000110011111111111",
"000000000001000010001111111111",
"000000000000111101111111111111",
"000000000000111001101111111111",
"000000000000110101011111111111",
"000000000000110001001111111111",
"000000000000101100111111111111",
"000000000000101000101111111111",
"000000000000100100011111111111",
"000000000000100000001111111111",
"000000000000011011111111111111",
"000000000000010111011111111111",
"000000000000010010111111111111",
"000000000000001110101111111111",
"000000000000001001111111111111",
"000000000000000101011111111111",
"000000000000000000101111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000000000001111111111",
"000000000000001001011111111111",
"000000000000010101101111111111",
"000000000000100010011111111111",
"000000000000101111111111111111",
"000000000000111110001111111111",
"000000110001001100101111111111",
"000101110101011011111111111111",
"001011000101101011011111111111",
"010000100001111011011111111111",
"010110001110001011111111111111",
"011100000010011100101111111111",
"100010000010101101011111111111",
"101000001010111110101111111111",
"101110010111001111111111111111",
"110100101011100001011111111111",
"111010111111110011001111111111"
);

constant CLUT4 : rom_type :=
(
"111111111110000001100000000000",
"111111111101110111000000000010",
"111111111101101100110000000100",
"111111111101100010100000000110",
"111111111101011000110000001000",
"111111111101001111000000001010",
"111111110101000101110000001100",
"111111101000111100110000001110",
"111111011100110100100000010000",
"111111010000101100100000010011",
"111110111100100101010000010101",
"111110101000011110110000011000",
"111110010000011001000000011011",
"111101111000010100010000011110",
"111101011000010000010000100001",
"111100110100001101010000100101",
"111100001100001011010000101000",
"111011011100001010100000101100",
"111010101100001011000000110000",
"111001110100001100110000110101",
"111000110100001111110000111001",
"110111110000010100000000111110",
"110110100100011001100001000100",
"110101010100100000000001001001",
"110011111100100111100001001111",
"110010011100110000000001010110",
"110000111000111001010001011100",
"101111001101000011000001100011",
"101101011001001101010001101011",
"101011100101011000010001110011",
"101001101001100011010001111011",
"100111101101101110110010000011",
"100101101001111010010010001101",
"100011100110000101110010010110",
"100001011110010001000010100000",
"011111010010011100010010101011",
"011101000110100111000010110110",
"011010111010110001100011000010",
"011000101010111011010011001110",
"010110011011000100110011011011",
"010100001111001101100011101000",
"010001111111010101100011110110",
"001111101111011101010100000100",
"001101100011100100010100010010",
"001011011011101010110100100001",
"001001001111110000100100110000",
"000111001011110110000101000000",
"000101000111111010110101010000",
"000011000111111111010101100000",
"000001001011111111110101110001",
"000000000011111111110110000001",
"000000000011111111110110010011",
"000000000011111111110110100100",
"000000000011111111110110110101",
"000000000011111111110111000111",
"000000000011111111110111011001",
"000000000011111111110111101010",
"000000000011111111110111111100",
"000000000011111111111000001110",
"000000000011111111111000100000",
"000000000011111111111000110011",
"000000000011111111111001000101",
"000000000011111111111001010111",
"000000000011111111111001101001",
"000000000011111111111001111011",
"000000000011111111111010001101",
"000000000011111100011010011111",
"000000000011111000001010110000",
"000000000011110011101011000010",
"000000000011101110111011010011",
"000000000011101001101011100100",
"000000000011100100001011110101",
"000000000011011110011100000110",
"000000000011011000101100010110",
"000000000011010010011100100101",
"000000000011001011111100110101",
"000000000011000101011101000011",
"000000000010111110111101010001",
"000000000010110111111101011111",
"000000000010110001001101101100",
"000000000010101010001101111000",
"000000110110100011001110000100",
"000011100110011011111110001111",
"000110100110010100111110011001",
"001001101110001101101110100010",
"001100111010000110101110101010",
"010000000001111111101110110010",
"010011000001111000101110111000",
"010101111001110001101110111101",
"011000100001101010111111000010",
"011010110101100100001111000101",
"011100101101011101101111000111",
"011110001001010111011111001000",
"011111000001010001001111001000",
"011111011101001011011111000110",
"011111100001000101101111000011",
"011111001001000000011110111111",
"011110011000111011001110111001",
"011101011000110110011110110010",
"011100000100110001111110101010",
"011010100100101101111110011111",
"011000111000101010001110010100",
"010111000100100110101110000110",
"010101001100100011101101111000",
"010011001100100001001101100111",
"010001010000011111001101010101",
"001111010000011101101101000000",
"001101011100011100101100101010",
"001011101100011100001100010011",
"001010000100011100001011111001",
"001000101100011100101011011101",
"000111100000011101111010111111",
"000110101000011111101010100000",
"000110000100100010001001111110",
"000101111000100101001001011011",
"000110001000101000111000110110",
"000110110000101101011000010000",
"000111111100110010010111101000",
"001001101100110111110110111111",
"001100010000111101110110010101",
"001111101001000100010101101010",
"010011111101001011010100111110",
"011001000001010010100100010001",
"011110110001011010000011100100",
"100101000101100001110010110110",
"101011110001101001100010000111",
"110010110101110001110001011000",
"111010001001111010000000101001"
);

constant CLUT5 : rom_type :=
(
"111111111111111111111111111111",
"011101101111111111111110100001",
"010100101111111011111100100001",
"011100010011110010001010010001",
"100011110011100001000111111100",
"100110011011001001110101101101",
"100100110010101101100011101111",
"011111100110001101110010001100",
"010111100101101011110001001000",
"001101100001001001010000011110",
"000010000000100111010000001101",
"000000000000000111100000010010",
"000000000000000000000000101001",
"000000000000000000000001010001",
"000000000000000000000010000110",
"000000000000000000000011000110",
"000000000000000000000100001110",
"000000000000000000000101011011",
"000000000000000000000110101100",
"000000000000000000100111111100",
"000000000000101110001001001001",
"000000000001101001011010010001",
"010100011010100100101011010001",
"110100110111011000001100000110",
"111111111111111111001100101110",
"111111111111111111111101000101",
"111111111111111111111101001001",
"111111111111111111111100111001",
"111111111111111111111100010110",
"111111111111111111111011100011",
"111111111111111111111010100101",
"111111111111111111111001011110",
"111111111111111111111000010001",
"111111111111111111110111000010",
"111111111111111111110101110100",
"111111111111110100110100101011",
"111111111111011101000011101001",
"111111111111000100100010110010",
"111111111110101100010010001000",
"111111111110010100110001101011",
"111111111101111110110001011010",
"111111111101101010110001010100",
"111111111101011001100001011001",
"111111111101001011010001101000",
"111111111101000000110010000000",
"111111111100111010110010100001",
"111111111100111001100011001011",
"111110011100111101110011111100",
"110011001101000110010100110100",
"101000100101010010110101110010",
"011110111101100010110110110101",
"010110100001110101000111111001",
"001111100010001001011000111101",
"001010000010011110101001111101",
"000110011010110100011010111000",
"000100101011001010001011101011",
"000100110011011110111100010011",
"000110100111110010001100101111",
"001001110011111111111100111010",
"001110010011111111111100110100",
"010011110011111111111100011100",
"011010001011111111111011110100",
"100001001111111111111010111111",
"101000101111111111111010000000",
"110000000011111111111000111001",
"110110010111111111110111101101",
"111010101111100110110110011110",
"111100010011000111110101010000",
"111010001010100101110100000100",
"110011011010000010110010111110",
"100111101001100001100001111111",
"011010001001000011110001001100",
"001111111000101100010000100101",
"001100111100011100010000001110",
"001111111100010011110000001001",
"010101101100010001110000011010",
"011011000100010101100001000010",
"011100111000011110100010000100",
"011000101100101100000011100011",
"010000010100111101000101011101",
"000111000001010001000111100100",
"000000001001100111011001101100",
"000000000001111111001011101000",
"000110001010010111011101001011",
"010111111110110000001110001000",
"101110011111000111111110011001",
"111111111011011110011110000110",
"111111111111110010101101010101",
"111111111111111111111100001100",
"111111111111111111111010110010",
"111111111111111111111001001110",
"111111111111111111110111100110",
"111111111111111111110110000010",
"111111111111111111110100100111",
"110110101011111111110011011100",
"101100001111111111110010101000",
"100010101011111111110010001010",
"011010100111111111110010000001",
"010100001011111111110010001010",
"001111011111111111110010100010",
"001100100011111111110011000111",
"001011011111111111100011110111",
"001100010111110011110100101110",
"001110110111100101100101101010",
"010010011111010110010110101001",
"010110101011000110000111100111",
"011010110010110101011000100100",
"011110011010100011111001011011",
"100000110010010001111010001011",
"100001100001111111101010110001",
"100000000001101101011011001010",
"011100101001011010111011010100",
"011000000101001000101011010000",
"010010111100110111011011000001",
"001110000000101001001010101011",
"001001111100100000001010010001",
"000111011100011100101001110110",
"000111000000011110011001011111",
"001000101100100100101001001111",
"001011110100101111011001001000",
"001111111100111101111001010000",
"010100110001001111101001100110",
"011010000101100100011010001011",
"011111111101111011111010111011",
"100110001010010101001011110100",
"101100101110110000001100110110",
"110011100011001100101101111101",
"111010011111101001101111000111"
);

constant CLUT6 : rom_type :=
(
"000000000011110000100000000100",
"011000101111101101100001001101",
"101011110111100110100010010101",
"110100100011011100010011011011",
"110011101111001111110100011111",
"101100111011000001100101011111",
"100011101010110010010110011010",
"011010110010100010110111010000",
"010010101110010100000111111111",
"001011101010000110101000101000",
"000101101101111011001001001010",
"000001000001110010011001100011",
"000000000001101101001001110100",
"000000000001101100001001111100",
"000000000001110000001001111010",
"000000000001111001101001101110",
"000010000010000111001001010111",
"001000000110010111011000111000",
"010000000110101000011000010011",
"011001001110111000010111101001",
"100010101111000101010110111101",
"101011110111001101110110010001",
"110011110111010000000101101000",
"111001111011001010000101000100",
"111101101010111010010100100110",
"111111001110100001110100010001",
"111110110110000011110100000111",
"111100111001100011010100001011",
"111001100101000011010100011110",
"110101001100100111000101000011",
"110000000100010010000101111100",
"101010011100000110110111001011",
"100100100100000101011000101110",
"011110110000001011111010011001",
"011001001100011000111100000010",
"010100001100101010111101011101",
"001111111000111111101110100000",
"001100100001010101111110111110",
"001010001001101011111110110001",
"001000110010000000001101111101",
"001000100010010000011100101011",
"001001011010011011011011000010",
"001011100010011111101001001001",
"001110110110011100010111001001",
"010011100010010100000101001001",
"011001100110001000000011010001",
"100001000001111010100001101000",
"101001011101101101100000011000",
"110001000101100010100000000000",
"110111000001011011110000000000",
"111011010001011011000000000011",
"111101110101100001000001010110",
"111110101101101100000011010001",
"111101111101111010110101011001",
"111011100110001011110111100000",
"110111101010011101101001011111",
"110010000110101110101011010101",
"101010111110111101001101000000",
"100010010011001000001110011101",
"011000011011001101011111101011",
"001110000111001011111111111111",
"000011111011000010001111111111",
"000000000010101110101111111111",
"000000000010010011001111111111",
"000000000001110110011111111111",
"000000000001011110101111101111",
"000000000001010001001110001110",
"000000000001001011101100001011",
"000000000001001010101001100111",
"001101111101001010000110111100",
"011110011001000111010100110001",
"101000100101000010000011101100",
"101101000000111010100011111010",
"101100110000110001110101000100",
"101000111100101000010110101100",
"100010011100011110101000011010",
"011010100000010101011001111010",
"010010000100001101001011001101",
"001010001100000110011100010100",
"000011110000000001111101010000",
"000000000000000000001110000000",
"000000000000000001111110100101",
"000000000000000111101110111011",
"000000000000010001111111000011",
"000000000000100001001110111010",
"000000000000110100111110100000",
"000100111001001100011101110010",
"001100000001100110011100110001",
"010100111110000010101011011001",
"011110110110011111111001101011",
"100110110010111101010111101011",
"101001100111011000010101110100",
"100110001111101110100100101010",
"011110101111111110010100101110",
"010101011111111111110101111110",
"001100110011111111010111111010",
"000110111111101101111001111101",
"000110011111001011111011100101",
"001101100110010111111100010011",
"011101111001010110001100000100",
"110010001100011110001011001101",
"111111111100000000001001111111",
"111111111100000000001000101110",
"111001011000000000000111101101",
"101010011000000000000111001110",
"011001110100000000000111100100",
"001011111100001000101000101100",
"000101010100100011101010001000",
"001000000001000000101011011011",
"010001001001011101111100000101",
"011100111001111001001011101010",
"100111110010010010001010011100",
"101110000110100111111001001111",
"101101000110111010011000011011",
"100110011111001000010111111100",
"011101001011010001110111101100",
"010011111111010110000111100111",
"001100110011010101000111101000",
"000111110011001111110111101001",
"000100111011000110010111100110",
"000100000010111001000111011011",
"000101010010101000010111001001",
"001000011110010100110110110000",
"001101101001111111000110010010",
"010100101101100111000101101110",
"011101001101001101100101000111",
"100110110000110010110100011101",
"110001000000010111010011110010"
);

constant CLUT7 : rom_type :=
(
"010111111000000001001111111111",
"011000100000000101001111110100",
"011001001000001001001111100100",
"011001110000001101001111010100",
"011010011000010001001111000100",
"011011000000010101001110110100",
"011011101000011001001110100100",
"011100010000011101001110010100",
"011100111000100001001110000100",
"011101100000100101001101110100",
"011110001100101001001101100100",
"011110110100101101001101010100",
"011111011100110001011101000100",
"100000000100110101011100110100",
"100000101100111001011100100100",
"100001010100111101011100010100",
"100001111101000001011100000100",
"100010100101000101011011110100",
"100011001101001001011011100100",
"100011110101001101011011010100",
"100100100001010001011011000100",
"100101001001010101011010110100",
"100101110001011001011010100100",
"100110011001011101011010010100",
"100111000001100001011010000100",
"100111101001100101011001110100",
"101000010001101001011001100100",
"101000111001101101011001010100",
"101001100001110001011001000100",
"101010001001110101011000110100",
"101010110101111001011000100100",
"101011011101111101011000010100",
"101100000110000001101000000100",
"101100101110000101100111110100",
"101101010110001001100111100100",
"101101111110001101100111010100",
"101110100110010001100111000100",
"101111001110010101100110110100",
"101111110110011001100110100100",
"110000011110011101100110010100",
"110001001010100001100110000100",
"110001110010100101100101110100",
"110010011010101001100101100100",
"110011000010101101100101010100",
"110011101010110001100101000100",
"110100010010110101100100110100",
"110100111010111001100100100100",
"110101100010111101100100010100",
"110110001011000001100100000100",
"110110110011000101100011110100",
"110111011111001001100011100100",
"111000000111001101100011010100",
"111000101111010001110011000100",
"111001010111010101110010110100",
"111001111111011001110010100100",
"111010100111011101110010010100",
"111011001111100001110010000100",
"111011110111100101110001110100",
"111100011111101001110001100100",
"111101000111101101110001010100",
"111101101111110001110001000100",
"111110011011110101110000110100",
"111111000011111001110000100100",
"111111101011111101110000010100",
"111111111111111111110000000100",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000",
"111111111111111111110000000000"
);

begin
	index	<= count(6 downto 0);
	with switch select VGA_RGB <=
	CLUT0(to_integer(index)) when "000",
	CLUT1(to_integer(index)) when "001",
	CLUT2(to_integer(index)) when "010",
	CLUT3(to_integer(index)) when "011",
	CLUT4(to_integer(index)) when "100",
	CLUT5(to_integer(index)) when "101",
	CLUT6(to_integer(index)) when "110",
	CLUT7(to_integer(index)) when "111";
end imp;