--
-- DE2 top-level module that includes the simple VGA raster generator
--
-- Stephen A. Edwards, Columbia University, sedwards@cs.columbia.edu
--
-- From an original by Terasic Technology, Inc.
-- (DE2_TOP.v, part of the DE2 system board CD supplied by Altera)
--

 library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity packet_hard_soft is

  port (
    -- Clocks
    
    CLOCK_27,                                      -- 27 MHz
    CLOCK_50,                                      -- 50 MHz
    EXT_CLOCK : in std_logic;                      -- External Clock

    -- Buttons and switches
    
    KEY : in std_logic_vector(3 downto 0);         -- Push buttons
    DPDT_SW : in std_logic_vector(17 downto 0);         -- DPDT switches

    -- LED displays

    HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7 -- 7-segment displays
       : out std_logic_vector(6 downto 0);
    LED_GREEN : out std_logic_vector(8 downto 0);       -- Green LEDs
    LED_RED : out std_logic_vector(17 downto 0);      -- Red LEDs

    -- RS-232 interface

    UART_TXD : out std_logic;                      -- UART transmitter   
    UART_RXD : in std_logic;                       -- UART receiver

    -- IRDA interface

--    IRDA_TXD : out std_logic;                      -- IRDA Transmitter
--    IRDA_RXD : in std_logic;                       -- IRDA Receiver

    -- SDRAM
   
    DRAM_DQ : inout std_logic_vector(15 downto 0); -- Data Bus
    DRAM_ADDR : out std_logic_vector(11 downto 0); -- Address Bus    
    DRAM_LDQM,                                     -- Low-byte Data Mask 
    DRAM_UDQM,                                     -- High-byte Data Mask
    DRAM_WE_N,                                     -- Write Enable
    DRAM_CAS_N,                                    -- Column Address Strobe
    DRAM_RAS_N,                                    -- Row Address Strobe
    DRAM_CS_N,                                     -- Chip Select
    DRAM_BA_0,                                     -- Bank Address 0
    DRAM_BA_1,                                     -- Bank Address 0
    DRAM_CLK,                                      -- Clock
    DRAM_CKE : out std_logic;                      -- Clock Enable

    -- FLASH
    
    FL_DQ : inout std_logic_vector(7 downto 0);      -- Data bus
    FL_ADDR : out std_logic_vector(21 downto 0);  -- Address bus
    FL_WE_N,                                         -- Write Enable
    FL_RST_N,                                        -- Reset
    FL_OE_N,                                         -- Output Enable
    FL_CE_N : out std_logic;                         -- Chip Enable

    -- SRAM
    
    SRAM_DQ : inout std_logic_vector(15 downto 0); -- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); -- Address bus 18 Bits
    SRAM_UB_N,                                     -- High-byte Data Mask 
    SRAM_LB_N,                                     -- Low-byte Data Mask 
    SRAM_WE_N,                                     -- Write Enable
    SRAM_CE_N,                                     -- Chip Enable
    SRAM_OE_N : out std_logic;                     -- Output Enable

    -- USB controller
    
    OTG_DATA : inout std_logic_vector(15 downto 0); -- Data bus
    OTG_ADDR : out std_logic_vector(1 downto 0);    -- Address
    OTG_CS_N,                                       -- Chip Select
    OTG_RD_N,                                       -- Write
    OTG_WR_N,                                       -- Read
    OTG_RST_N,                                      -- Reset
    OTG_FSPEED,                     -- USB Full Speed, 0 = Enable, Z = Disable
    OTG_LSPEED : out std_logic;     -- USB Low Speed, 0 = Enable, Z = Disable
    OTG_INT0,                                       -- Interrupt 0
    OTG_INT1,                                       -- Interrupt 1
    OTG_DREQ0,                                      -- DMA Request 0
    OTG_DREQ1 : in std_logic;                       -- DMA Request 1   
    OTG_DACK0_N,                                    -- DMA Acknowledge 0
    OTG_DACK1_N : out std_logic;                    -- DMA Acknowledge 1

--ETHERNET INTERFACE
    ENET_DATA: inout std_logic_vector(15 downto 0);
    ENET_CMD: out std_logic;
    ENET_CS_N: out std_logic;
    ENET_WR_N: out std_logic;
    ENET_RD_N: out std_logic;
    ENET_RST_N: out std_logic;
    ENET_INT: in std_logic;
    ENET_CLK: inout std_logic:='0';
    

    -- 16 X 2 LCD Module
    
    LCD_ON,                     -- Power ON/OFF
    LCD_BLON,                   -- Back Light ON/OFF
    LCD_RW,                     -- Read/Write Select, 0 = Write, 1 = Read
    LCD_EN,                     -- Enable
    LCD_RS : out std_logic;     -- Command/Data Select, 0 = Command, 1 = Data
    LCD_DATA : inout std_logic_vector(7 downto 0); -- Data bus 8 bits

    -- SD card interface
    
    SD_DATA: inout std_logic;                   -- SD Card Data
    --SD_DAT3,                    -- SD Card Data 3
    SD_CMD : out std_logic;   -- SD Card Command Signal
    SD_CLK : out std_logic;     -- SD Card Clock

    -- USB JTAG link
    
    --TDI,                        -- CPLD -> FPGA (data in)
    --TCK,                        -- CPLD -> FPGA (clk)
    --TCS : in std_logic;         -- CPLD -> FPGA (CS)
    --TDO : out std_logic;        -- FPGA -> CPLD (data out)

    -- I2C bus
    
    I2C_DATA : inout std_logic; -- I2C Data
    I2C_CLK : inout std_logic;   -- I2C Clock

    -- PS/2 port

    PS2_DATA,                    -- Data
    PS2_CLK : inout std_logic;     -- Clock

    -- VGA output
    
    VGA_CLK,                                            -- Clock
    VGA_HS,                                             -- H_SYNC
    VGA_VS,                                             -- V_SYNC
    VGA_BLANK,                                          -- BLANK
    VGA_SYNC : out std_logic;                           -- SYNC
    VGA_R,                                              -- Red[9:0]
    VGA_G,                                              -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0);                   -- Blue[9:0]

    TD_RESET: out std_logic
    

    
    
    -- Audio CODEC
    
    --AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    --AUD_ADCDAT : in std_logic;                          -- ADC Data
    --AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    --AUD_DACDAT : out std_logic;                         -- DAC Data
    --AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
    --AUD_XCK : out std_logic;                            -- Chip Clock
    
    -- Video Decoder
    
    --TD_DATA : in std_logic_vector(7 downto 0);  -- Data bus 8 bits
    --TD_HS,                                      -- H_SYNC
    --TD_VS : in std_logic;                       -- V_SYNC
    --TD_RESET : out std_logic;                   -- Reset
    
    -- General-purpose I/O
    
    --GPIO_0,                                      -- GPIO Connection 0
    --GPIO_1 : inout std_logic_vector(35 downto 0) -- GPIO Connection 1   
    );
  
end packet_hard_soft;

architecture datapath of packet_hard_soft is

--signal mSEG7_HEX: std_logic_vector(31 downto 0);
signal DATA_to_OTG: std_logic_vector(15 downto 0);
signal DATA_to_SRAM: std_logic_vector(15 downto 0);

signal SCL_OE_N: std_logic;
signal SDA_OE_N: std_logic;
signal SCL: std_logic;
signal SDA: std_logic;
signal clk: std_logic:='0';
signal timer_irq:std_logic;
signal sig_ENET_DATA:std_logic_vector(15 downto 0):=x"0000";
signal CPU_RESET: std_logic;
signal check_out1:std_logic_vector(3 downto 0):="0000";
signal check_out2:std_logic_vector(3 downto 0):="0000";
signal check_out3:std_logic_vector(3 downto 0):="0000";
signal check_out4:std_logic_vector(3 downto 0):="0000";
--variable ENET_CLK: std_logic;
--always@(posedge OSC_50)	ENET_CLK=~ENET_CLK;


component reset_delay is
port (
	iCLK: in std_logic;

	signal oRESET: out  std_logic;
	signal Cont: buffer unsigned(15 downto 0):="0000000000000000"
	);
end component;
begin
TD_RESET <= '1';
LCD_ON <= '1';
LCD_BLON <= '1';
FL_RST_N <= '1';
FL_ADDR(21) <= '0';
FL_ADDR(20) <= '0';

process(CLOCK_50)
begin
if rising_edge (CLOCK_50) then
ENET_CLK <= NOT ENET_CLK;
clk <= NOT clk;
end	if;	
end process;
  




U2: reset_delay port map(
oRESET => CPU_RESET,
iCLK => CLOCK_50
);

U3: entity work.packet_soft_hard port map(
	--iCLK_to_the_MUX => CLOCK_50,
	clk => CLOCK_50,
    reset_n => CPU_RESET,                              		

-- the_DM9000A
				  
                  ENET_CMD_from_the_MUX => ENET_CMD,
                  ENET_CS_N_from_the_MUX => ENET_CS_N ,
                  ENET_DATA_to_and_from_the_MUX => ENET_DATA,
                  ENET_INT_to_the_MUX =>ENET_INT,
                  ENET_RD_N_from_the_MUX =>ENET_RD_N,
                  ENET_RST_N_from_the_MUX => ENET_RST_N,
                  ENET_WR_N_from_the_MUX => ENET_WR_N,
				STATE_OUT_from_the_MUX => check_out1(3 downto 0),
				dbug_ENET_DATA_from_the_MUX => sig_ENET_DATA,
                dbug_io_rw_cmd_from_the_MUX => check_out2(1 DOWNTO 0),
                dbug_req_update_from_the_MUX => check_out3(0),
                dbug_state_out_iter_from_the_MUX => check_out4 (2 DOWNTO 0),
				--  STATE_OUT_from_the_MUX => check_out, 
				--iCMD_to_the_MUX=>iCMD,--KEY(1 downto 0),
				--iCMD_chk_from_the_MUX=> HEX0(1 downto 0),
				
              -- the_SRAM
                  SRAM_ADDR_from_the_SRAM => SRAM_ADDR,
                  SRAM_CE_N_from_the_SRAM =>SRAM_CE_N ,
                  SRAM_DQ_to_and_from_the_SRAM =>SRAM_DQ,
                  SRAM_LB_N_from_the_SRAM => SRAM_LB_N,
                  SRAM_OE_N_from_the_SRAM => SRAM_OE_N,
                  SRAM_UB_N_from_the_SRAM => SRAM_UB_N,
                  SRAM_WE_N_from_the_SRAM =>SRAM_WE_N
     
  
);
U4: entity work.hex7seg port map(
     input=>check_out1,
     output=>HEX0
);

U5: entity work.hex7seg port map(
     input=>check_out2,
     output=>HEX1
);
U6: entity work.hex7seg port map(
     input=>check_out3,
     output=>HEX2
);
U7: entity work.hex7seg port map(
     input=>check_out4,
     output=>HEX3
);

U8: entity work.hex7seg port map(
     input=>sig_ENET_DATA(3 downto 0),
     output=>HEX4
);

U9: entity work.hex7seg port map(
    input=>sig_ENET_DATA(7 downto 4),
    output=>HEX5
);


--HEX0(6)<='1';
--HEX1(6 downto 4)<="111";

--Hex0<="1111111";
--Hex1<="1111111";
--Hex2<="1111111";
--Hex3<="1111111";
--Hex4<="1111111";
--Hex5<="1111111";
Hex6<="1111111";
Hex7<="1111111";
end datapath;
