--this file iterates over the FSM defined in  custom_hardware.vhd which is basically a simple generic read/write to 
--registers, the state diagram for this is file is;
--+------+	+-----------------------------+	    +-----------------+	    +-----------+
--| INIT | -->  |Transmit_init(1 half write)  | --> |Transmit_write(n)|	--> | Poll_write |
--+------+ 	+-----------------------------+	    +-----------------+	    +-----------+
--										|
--                         						+-------+:-------------------------------------------+            
--									|Read wait(1 infinite read) --> write_final(2 writes)|
--									+----------------------------------------------------+
--
--
--
library ieee;
 use ieee.std_logic_1164.all;
 use ieee.numeric_std.all;

 entity iterator is 
 	port(ENET_CLK: in std_logic;
		req_update: in std_logic;
		input_data: in std_logic_vector(15 downto 0);
		ENET_DATA:out std_logic_vector(15 downto 0);--for verifying when looping over read,and for writing data 
		is_read : out std_logic;	--simply means do not write to the bus(if high)
		ENET_CMD: out std_logic;
		-- DEBUG interface
		dbug_io_rw_cmd: out std_logic_vector(1 downto 0);
		dbug_reg_index: out std_logic_vector(1 downto 0);
		dbug_state_out: out std_logic_vector(2 downto 0);
		dbug_req_update:out std_logic;
		--Defining the ports to get the values of various fields
    BUY_SELL_i : in std_logic;
    PRICE_i:  in std_logic_vector(31 downto 0);
    NAME_i :  in std_logic_vector(31 downto 0);
    wait_t_i: in std_logic;
    QUANT_i : in std_logic_vector(31 downto 0);
    sent_state_i: out std_logic --Set high when packet sent successfully
);
		
 end iterator; 
 architecture behav of iterator is 

 constant RAM_MAX_INDEX :integer := 54; --Actual size of RAM is 55 bytes ,
					--42 bytes of header, 13 bytes of header
--indicating position in RAM
 signal sig_input_data:std_logic_vector(15 downto 0):=x"0000";
 type finance_data is array(3 downto 0)of std_logic_vector(7 downto 0);
  
  constant PRICE: finance_data:= (x"00",x"00",x"00",x"26"); 
  constant NAME: finance_data:= (x"00",x"00",x"00",x"27"); 
  constant BUY_SELL: std_logic_vector:= "00000001"; 
  constant QUANT: finance_data:= (x"00",x"00",x"00",x"28"); 

  --signal  PRICE: finance_data:= (x"00",x"00",x"00",x"26"); 
  --signal  NAME: finance_data:= (x"00",x"00",x"00",x"27"); 
  --signal  QUANT: finance_data:= (x"00",x"00",x"00",x"28"); 
  --signal BUY_SELL: std_logic_vector(7 downto 0):= "00000001"; 
  
--declaring register addresses for DMA9000a PHY
  constant NCR: std_logic_vector(7 downto 0):= x"00"; --Network  Control Register REG. 00 
  constant NSR: std_logic_vector(7 downto 0):= x"01"; --Network  Status Register  REG. 01
  constant IMR:std_logic_vector(7 downto 0):=x"FF";  -- NIC Interrupt Mask   Register REG. FFH 
  constant PAR_set:std_logic_vector(7 downto 0):=x"80"; -- IMR REG. FFH: PAR only, RX/TX FIFO R/W
  constant MWCMD:std_logic_vector(7 downto 0):=x"F8"; --TX FIFO I/O port command WRITE into TX FIFO
  constant IO_addr:std_logic:= '0';
  constant IO_data:std_logic:= '1';
  constant TCR:std_logic_vector(7 downto 0):= X"02";
  constant TCR_set:std_logic_vector(7 downto 0):= X"00";
  constant TX_REQUEST:std_logic_vector(7 downto 0):= X"01";
  constant INTR_set:std_logic_vector(7 downto 0):= X"81";
  type init_address_data_type is array(integer range 0 to 2)of std_logic_vector(7 downto 0);
  type state is (preINIT,INIT,  Transmit_init, Transmit_write, Poll_write, Read_wait, Write_final);--see state digram for explanations
  signal state_sig:state:= preINIT;
  signal state_sig_out:integer:=0;
  
  signal io_rw_cmd:unsigned(1 downto 0):="00";-- Write Cycle(00 -address,01 data), Read Cycle(10 add,11 data)
  --declaring arrarys 
  -- Intial 3 register that are written to via phy_write
  type address_data_type is array(integer range 0 to 2)of std_logic_vector(7 downto 0);
  signal addr_tx_init:address_data_type:=(IMR,x"FD",x"FC"); 
  --signal addr_tx_init:address_data_type:=(x"28",x"29",x"FC"); --trying to read product id
  signal data_tx_init:address_data_type:=(PAR_set,x"00",x"37"); --PAR_set address and data values used in the tx intialization stored sequentially inthe same seq as used in the C file
  signal init_index_counter:unsigned(1 downto 0):="00";
 --MWCMD
 --writing data from RAM array
 type byte_array is array(integer range 0 to RAM_MAX_INDEX)of std_logic_vector(7 downto 0);
 signal RAM : byte_array:=( x"FF", x"FF", "11111111", "11111111", "11111111", "11111111", 
 x"01", x"60", x"6E", x"11", x"02", x"0F", 
 x"08", x"00",                         
		       
 
 x"45",                
 x"00",                
 x"00",x"9C",           
		      
 x"3d", x"35",          
 x"00",                
 x"00",         
 
 x"80",                
 x"11",                
 x"00",x"00",           
 x"c0",x"a8",x"01",x"01", 
 x"c0",x"a8",x"01",x"ff", 
			 
 
 x"67",x"d9", 
 x"27",x"2b", 
 x"00",x"88", 
 x"00",x"00", -- 41 upto here
 PRICE(3),PRICE(2),PRICE(1),PRICE(0),
  NAME(3),NAME(2),NAME(1),NAME(0),
 BUY_SELL,
  QUANT(3),QUANT(2),QUANT(1),QUANT(0));
 signal ram_index_counter:unsigned(5 downto 0):="000000";  	

 ---register written to after transmit data is written
-- dm9000a_iow(TCR , TCR_set | TX_REQUEST)

--read poll register address
---dm9000a_ior(NSR)

--final writes
 --address and data values used in the tx intialization stored sequentially inthe same seq as used in the C file
type final_data_type is array(integer range 0 to 1)of std_logic_vector(7 downto 0);
signal final_index_counter:unsigned(0 downto 0):="0";
signal addr_tx_final:final_data_type:=(NSR,IMR); 
signal data_tx_final:final_data_type:=(x"00",INTR_SET);

begin

process(req_update,ENET_CLK,input_data) -- only sensitive when the 'delay state starts',changes state and counters
begin
		--defaults --
		if rising_edge(ENET_CLK) then
		dbug_req_update <= req_update;
		if req_update = '1' then --if it is init or delay

			case state_sig is

			when preINIT=> --hack for causing a change in stage_sig
				state_sig <= INIT;
				ram_index_counter <= "000000";
			when INIT =>
				sent_state_i <= '0';
				if io_rw_cmd = "11" then 
					io_rw_cmd <= "00";
					if init_index_counter < 2 then 
						init_index_counter <= init_index_counter +1;
						state_sig <= INIT;
					else
						state_sig <= Transmit_Init;
						init_index_counter <= "00";

					end if;
				else 
					io_rw_cmd <= io_rw_cmd + 1;
					state_sig <= INIT;
					
				end if;
						
			when Transmit_Init =>
				io_rw_cmd <= io_rw_cmd + 1; --packets to be written in DATA_WRITE mode
				state_sig <= Transmit_write;

			when Transmit_write =>
				if ram_index_counter < RAM_MAX_INDEX then 
					ram_index_counter <= ram_index_counter +2;
					state_sig <= Transmit_write;
					io_rw_cmd <= "01";
				else
					state_sig <= Poll_write;
					ram_index_counter <= "000000";
					io_rw_cmd <= "00";
				end if;

			when Poll_write =>
				if io_rw_cmd = "11" then
					io_rw_cmd <= "10"; --Intiating Read Cycle(Address write) for Poll_write
					state_sig <= Read_wait;
				else
					state_sig <= Poll_write;
					io_rw_cmd <= io_rw_cmd + 1;
				end if;
			when Read_wait=>
				if io_rw_cmd ="11" then 
					if (input_data(2) or input_data(3)) = '1' then 
						io_rw_cmd<="00";
						state_sig <= write_final;
					else
						io_rw_cmd <= "10";
						state_sig <= Read_wait;
					end if;
				else
					io_rw_cmd <= "11";
				end if;

			when Write_final=>
				if io_rw_cmd = "11" then 
					io_rw_cmd <= "00";
					if final_index_counter = "0"  then 
						final_index_counter <= "1";
						state_sig <= Write_final;
					else
						--state_sig <= INIT;
						final_index_counter <= "0";
						sent_state_i <= '1';
						if wait_t_i = '0'  then
						RAM(50) <=  "0000000" & BUY_SELL_i;
    
    						RAM(45) <= PRICE_i(7 downto 0);
    						--RAM(45) <= "11111111";
						RAM(44) <= PRICE_i(15 downto 8);
						RAM(43) <= PRICE_i(23 downto 16);
    						RAM(42) <= PRICE_i(31 downto 24);
    	
    						RAM(49) <= NAME_i(7 downto 0);
    						RAM(48) <= NAME_i(15 downto 8);
    						RAM(47) <= NAME_i(23 downto 16);
    						RAM(46) <= NAME_i(31 downto 24);
    
    						RAM(54) <= QUANT_i(7 downto 0);
    						RAM(53) <= QUANT_i(15 downto 8);
    						RAM(52) <= QUANT_i(23 downto 16);
    						RAM(51) <= QUANT_i(31 downto 24);
    						
    						
    						state_sig <= INIT;
    						 
    						end if;
						

					end if;
				else 
					io_rw_cmd <= io_rw_cmd + 1;
					state_sig <= Write_final;
					
				end if;
					
			when others=>


			end case;

		end if;
	end if;
end process;

process(state_sig,init_index_counter,io_rw_cmd,ram_index_counter,final_index_counter) --changes the outputs
begin
	
	ENET_DATA <= x"0000";
	is_read <='0';
	ENET_CMD<= io_rw_cmd(0);
	dbug_io_rw_cmd<= std_logic_vector(io_rw_cmd);		
	dbug_state_out <=std_logic_vector(to_unsigned(state_sig_out,3));
	dbug_reg_index <= std_logic_vector(init_index_counter);
	case state_sig is
		when preINIT=>
			state_sig_out <= 1;
		when INIT => 
			state_sig_out <= 2;
			case io_rw_cmd is
				--write cycle
				when "00" => --write addr to DM9000a
					ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(init_index_counter));
				when "01" =>--write data to DM9000a
					ENET_DATA(7 downto 0) <= data_tx_init(to_integer(init_index_counter));
				--read cycle
				when "10"=> --write addr to DM9000a
					ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(init_index_counter));
				when "11"=> --read from DM9000a
					is_read <= '1';	
			end case;			
					
		when Transmit_Init =>
			ENET_DATA(7 downto 0) <= MWCMD; 		
			state_sig_out <= 3;

		when Transmit_write =>
			if ram_index_counter = 54 then
				ENET_DATA <= x"00" & RAM(to_integer(ram_index_counter));
			else
				ENET_DATA <= RAM(to_integer(ram_index_counter +1)) & RAM(to_integer(ram_index_counter));
			end if;
			state_sig_out <= 4;
		when Poll_write =>
			state_sig_out <= 5;
		case io_rw_cmd is
				--write cycle
				when "00" => --write addr to DM9000a
					ENET_DATA(7 downto 0) <= TCR; 
				when "01" =>--write data to DM9000a
					ENET_DATA(7 downto 0)<= (TCR_set or TX_REQUEST); 
				--read cycle
				when "10"=> --write addr to DM9000a
					ENET_DATA(7 downto 0) <= TCR; 
				when "11"=> --read from DM9000a
					is_read <= '1';	
		end case;			
	
		when Read_wait=>
			state_sig_out <= 6;
		case io_rw_cmd is
				--read cycle
				when "10"=> --write addr to DM9000a
					ENET_DATA(7 downto 0) <= NSR; 
				when "11"=> --read from DM9000a
					is_read <= '1';	
				when others=>
		end case;			
			
		when write_final=>
			state_sig_out <= 7;
		case io_rw_cmd is
				--write cycle
				when "00" => --write addr to DM9000a
					ENET_DATA(7 downto 0) <= addr_tx_final(to_integer(final_index_counter)); 
				when "01" =>--write data to DM9000a
					ENET_DATA(7 downto 0) <= data_tx_final(to_integer(final_index_counter)); 
				--read cycle
				when "10"=> --write addr to DM9000a
					ENET_DATA(7 downto 0) <= addr_tx_final(to_integer(final_index_counter)); 
				when "11"=> --read from DM9000a
					is_read <= '1';	
		end case;			
		
		when others=>


	end case;

end process;
end behav;
