#include <io.h>
#include <system.h>
#include <stdio.h>
#include <sys/alt_irq.h>  // the irq functions
#include <alt_types.h>
#include "basic_io.h"
#include "DM9000A.h"
#include <alt_types.h>
//#include "LCD.h"
#define MAX_MSG_LENGTH 128

#define IOWR_packet_data(base, offset, data) \
  IOWR_16DIRECT(base, (offset) * 2, data) 
  
#define price 0
#define name 1
#define quant 2
#define buy_sell 3


// Ethernet (source) MAC address.  Choose the last three bytes yourself
unsigned char mac_address[6] = { 0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F  };

unsigned int interrupt_number;

unsigned int receive_buffer_length;
unsigned char receive_buffer[1600];

#define UDP_PACKET_PAYLOAD_OFFSET 42
#define UDP_PACKET_LENGTH_OFFSET 38

#define IP_PACKET_LENGTH_OFFSET 16

#define UDP_PACKET_PAYLOAD (transmit_buffer + UDP_PACKET_PAYLOAD_OFFSET)

unsigned char transmit_buffer[] = {
  // Ethernet MAC header
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Destination MAC address
  0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F, // Source MAC address
  0x08, 0x00,                         // Packet Type: 0x800 = IP
                          
  // IP Header
  0x45,                // version (IPv4), header length = 20 bytes
  0x00,                // differentiated services field
  0x00,0x9C,           // total length: 20 bytes for IP header +
                       // 8 bytes for UDP header + 128 bytes for payload (change according to payload size)
                       // 16,17
  0x3d, 0x35,          // packet ID (increment it!!)
  0x00,                // flags
  0x00,                // fragment offset
  0x80,                // time-to-live
  0x11,                // protocol: 11 = UDP
  0x00,0x00,           // header checksum: *incorrect*(24,25 index)
  0xc0,0xa8,0x01,0x01, // source IP address
  0xc0,0xa8,0x01,0xff, // destination IP address
                          
  // UDP Header
  0x67,0xd9, // source port port (26585: garbage)
  0x27,0x2b, // destination port (10027: garbage)
  0x00,0x88, // length (136: 8 for UDP header + 128 for data)
  0x00,0x00 // checksum: 0 = none
                           
};   


unsigned char market_packet[] = {
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67
};


int market_packet_length = 128;
unsigned char *p = market_packet;

static void ethernet_interrupt_handler() {
  unsigned int receive_status;
  int i;
      printf("\n\n\n\n\n\n\nPACKET RECEIVED");
  receive_status = ReceivePacket(receive_buffer, &receive_buffer_length);

  if (receive_status == DMFE_SUCCESS) {

#if 1
    printf("\n\nReceived Packet Length = %d", receive_buffer_length);
    for(i=0;i<receive_buffer_length;i++) {
      if (i%8==0) printf("\n");
      printf("0x%.2X,", receive_buffer[i]);
    }
    printf("\n");
#endif

    
    if (receive_buffer_length >= 14) {
      //  A real Ethernet packet
      if (receive_buffer[12] == 8 && receive_buffer[13] == 0 &&
      receive_buffer_length >= 34) {
    // An IP packet
    if (receive_buffer[23] == 0x11) {
      // A UDP packet
      if (receive_buffer_length >= UDP_PACKET_PAYLOAD_OFFSET) {
        printf("Received: %s\n",
           receive_buffer + UDP_PACKET_PAYLOAD_OFFSET);
   
      }
    } else {
      printf("Received non-UDP packet\n");
    }
      } else {
    printf("Received non-IP packet\n");
      }
    } else {
      printf("Malformed Ethernet packet\n");
    }

  } else {
    printf("Error receiving packet\n");
  }
    interrupt_number++;
  /* Display the number of interrupts on the LEDs */
  
  /* Clear the DM9000A ISR: PRS, PTS, ROS, ROOS 4 bits, by RW/C1 */
  dm9000a_iow(ISR, 0x3F);   //interrupt status register
              
  /* Re-enable DM9000A interrupts */
  dm9000a_iow(IMR, INTR_set);   //interrupt mask register
}

int main()
{
    
 // int price_1 = 32767, price_2 = 32767, price_3 = 0;
   int price_1 = 32767, price_2 =32767, price_3 = 3;
  //int price_11 = 32767, price_22 = 32767, price_33 = 0;
  int name_1 = 32765, name_2 = 32767, name_3 =3;
  int quant_1 = 32767, quant_2 =32767, quant_3=3;
  int buy_sell_1 = 32767;
  int j;
  int curMsgChar = 0;
  printf("nios up");
  unsigned int packet_length;

    /*while(p != NULL)
    {
        market_packet_length++;
        p++;
    }
    */

  // Initalize the DM9000 and the Ethernet interrupt handler
  unsigned int status=DM9000_init(mac_address);
 
  if (status==DMFE_SUCCESS){printf("DM9000 initialized succesfully\n");
  //write to DM9000A custom hardware, Init done !!
    IOWR(MUX_BASE, Initialized, 5);
  }
  else{printf("DM9000 initialized FAILED!!!\n");}
  interrupt_number = 0;
  //alt_irq_register(DM9000A_IRQ, NULL, (void*)ethernet_interrupt_handler); 

 printf("4840 Lab 2 started\n");
  // Initialize the keyboard
  
  printf("Ready to send messages\n");
  
for(j = 0; j<100000; j++);
for(j = 0; j<1000000; j++);{
printf("Calling IOWR1");
IOWR_packet_data(MUX_BASE, price, price_1) ;
IOWR_packet_data(MUX_BASE, price, price_2) ;
IOWR_packet_data(MUX_BASE, price, price_3) ;

}

   //for(;;){
  // Clear the payload
  for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) {
    UDP_PACKET_PAYLOAD[curMsgChar] = 0;
  }

  for (curMsgChar = 0; curMsgChar < market_packet_length; curMsgChar++) {
    UDP_PACKET_PAYLOAD[curMsgChar] = market_packet[curMsgChar];
  }
  
  printf("\nCurMsgChar length after insert = %d",curMsgChar);
   
    
      UDP_PACKET_PAYLOAD[curMsgChar++] = 0; // Terminate the string
      packet_length = UDP_PACKET_PAYLOAD_OFFSET + curMsgChar;
      
      //do 0 padding to make packet length min 64 bytes
      while(packet_length < 64){
                                UDP_PACKET_PAYLOAD[curMsgChar++] = 0;
                                packet_length++;
                               }   
             
      transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = (packet_length - 34) >> 8;
      
      transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = (packet_length - 34) & 0xff;
      
      //increment packet ID 19, 20 posn from strt of packet header
      transmit_buffer[19]+=0x01;
      
      //39 and 40 contain UDP packet length
      transmit_buffer[IP_PACKET_LENGTH_OFFSET] = (packet_length - 14) >> 8;
      
      transmit_buffer[IP_PACKET_LENGTH_OFFSET + 1] = (packet_length - 14) & 0xff;
      
      printf("\n packet length set to: %d",transmit_buffer[39]);
      
      //setting checksum//
      //take 2s compliment den add
      transmit_buffer[25]=transmit_buffer[15]+transmit_buffer[17]+transmit_buffer[19]+transmit_buffer[21]+transmit_buffer[23]+transmit_buffer[27]+transmit_buffer[29]+transmit_buffer[31]+transmit_buffer[33];
      transmit_buffer[24]=transmit_buffer[14]+transmit_buffer[16]+transmit_buffer[18]+transmit_buffer[20]+transmit_buffer[22]+transmit_buffer[26]+transmit_buffer[28]+transmit_buffer[30]+transmit_buffer[32];
      printf("\n before inversion %d %d",transmit_buffer[24],transmit_buffer[25]);
      //ones compliment or inversion
      transmit_buffer[25]=~transmit_buffer[25];
      transmit_buffer[24]=~transmit_buffer[24];
          
      
      if (TransmitPacket(transmit_buffer, UDP_PACKET_PAYLOAD_OFFSET + curMsgChar + 1) == DMFE_SUCCESS) { 
        printf("\nMessage sent successfully\n");
        //enter packet send
         
         printf("\n\nSending Packet Length = %d", packet_length);
         int i;
                for(i=0;i<packet_length;i++) {
                        if (i%8==0) 
                        printf("\n");
                        printf("0x%.2X,", transmit_buffer[i]);
                    }       
            printf("\n");
            
        
      } else 
        printf("\nMessage sending failed\n"); 
      
        // reset data
    for (curMsgChar=MAX_MSG_LENGTH-1; curMsgChar>0; curMsgChar--) { 
    UDP_PACKET_PAYLOAD[curMsgChar] = 0;
        printf("Msg to Send: "); 
      
      int delay;
     for(delay = 0;delay < 8000000;delay++)
        {
        }
    
  //}
  
    
  return 0;
    }       
}
