--The avalon bus for writedata is 16 bits wide
-- Out of 16 bits, higher 2 bits are offset
-- 00 offset means price field is being sent, 01 means name field, 10 means quantity and 11 means buy_sell
-- price_t, name_t and quant_t are 32 bit vectors containing the corresponding values received from NIOS
-- wait_t signal is active low when there is no more data is being sent by NIOS and the values can be passed to the iterator
-- When WAIT signal from the nios is high it means that there are further changes to be made to the document else not. 

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use ieee.std_logic_unsigned.all;

entity change_pack is
  
  port (
  
    clk   : in std_logic;                    -- Should be 25.125 MHz
    reset_n : in std_logic;
    read_n: in std_logic;
    write_n : in std_logic;
    chipselect_n : in std_logic;
    --address : in std_logic_vector(15 downto 0); -- this sends the offset value of the data that is being sent. Only 1 downto 0 is to be used
    address : in std_logic_vector(1 downto 0);
    --readdata : out std_logic_vector(15 downto 0);-- this is the data that the nios wants us to wite 
    writedata : in std_logic_vector(15 downto 0); -- this is sent from the nios

    -- these are the output ports that have to be port mapped to the top level entity
    BUY_SELL: out std_logic;
    PRICE : out std_logic_vector(31 downto 0);
    NAME :  out std_logic_vector(31 downto 0);
    wait_t: out std_logic; --active low, checks if more packet fields are being sent from NIOS
    QUANT : out std_logic_vector(31 downto 0);
    sent_state: in std_logic -- Set high from iterator when packet sent successfully
    
    --HEX00, HEX11, HEX22, HEX33, HEX44, HEX55, HEX66, HEX77 -- to give to 7-segment displays
     --  : out std_logic_vector(6 downto 0):="1111111"
    
	);
	
	
end change_pack;

architecture packet of change_pack is

 signal packet_type:std_logic;
 signal counter:std_logic_vector(1 downto 0):="00";
 signal price_t: std_logic_vector(31 downto 0);
 signal name_t: std_logic_vector(31 downto 0);
 signal quant_t: std_logic_vector(31 downto 0);

 signal ram_address: std_logic_vector(1 downto 0); -- this is the signal that will store the offset value from the bus
 --signal sent_state: std_logic := '1'; 
 
 begin
 
 process (clk)
	begin 
	if rising_edge(clk) then
	  if reset_n = '0' then
	  --readdata <= (others => '0');
          counter <= (others => '0');
          wait_t <= '1';
          
          else
          --PRICE <= price_t(31 downto 0);
          PRICE <= X"00000000";
            if chipselect_n = '0' then
		--if (address >= X"0000" and address <= X"ffff") then
		
	      --Storing the offset value sent from nios and using the case statement to check what type of packet it is
		ram_address <= address(1 downto 0); 
		if write_n = '0' then
		
			case ram_address is	
			    when "00" =>  --The total size of the packet is 32 bits and is sent in 3 packets from nios
			    		    if counter = "00" then
			    		  --Storing the first part of the packet
			    		    price_t(14 downto 0) <= writedata(14 downto 0);
					    counter <= counter + 1;
					    elsif counter = "01" then
					  --Storing the second part of the packet
					    price_t(29 downto 15) <= writedata(14 downto 0);
					    counter <= counter + 1;
					    elsif counter = "10" then
					  --Storing the last part of the packet
					    price_t(31 downto 30) <= writedata(1 downto 0);
					    counter <= "00";
					    --PRICE(31 downto 0) <= price_t(31 downto 0);
					    
					    	if writedata(15) = '0' then
			     			wait_t <= '0';
			     			elsif writedata(15) = '1' then
			     			wait_t <= '1';			     	
			       			 end if;
					    end if;
					    					    
					    
			    when "01" =>    if counter = "00" then
			    		    name_t(14 downto 0) <= writedata(14 downto 0);
			    		    
					    counter <= counter + 1;
					    	
					    elsif counter = "01" then
					    
					    name_t(29 downto 15) <= writedata(14 downto 0);
					    counter <= counter + 1;
					    
					    elsif counter = "10" then
					    
					    name_t(31 downto 30) <= writedata(1 downto 0);
					    counter <= "00";
					    
	 				    NAME(31 downto 0) <= name_t(31 downto 0);
	 				    
					    	if writedata(15) = '0' then
			     			wait_t <= '0';
			     			else 
			     			wait_t <= '1';			     	
			       			 end if;
					    end if;
					    
					    
			    when "10" =>    if counter = "00" then
			    		    quant_t(14 downto 0) <= writedata(14 downto 0);
					    counter <= counter + 1;
					    elsif counter = "01" then
					    quant_t(29 downto 15) <= writedata(14 downto 0);
					    counter <= counter + 1;
					    elsif counter = "10" then
					    quant_t(31 downto 30) <= writedata(1 downto 0);
					    counter <= "00";
					    QUANT(31 downto 0) <= quant_t(31 downto 0);
					    	if writedata(15) = '0' then
			     			wait_t <= '0';
			     			else 
			     			wait_t <= '1';			     	
			       			 end if;
					    end if;
					    
					    
			    when "11" =>    BUY_SELL <= writedata(0);
			    		        if writedata(15) = '0' then
			     			wait_t <= '0';
			     			else 
			     			wait_t <= '1';			     	
			       			 end if;
					    
					    
			    end case;
			    
			    
			
		end if;	
		else
			--PRICE(31 downto 0) <= price_t(31 downto 0);	
			PRICE <= price_t(31 downto 0);
	    end if;   
	   -- PRICE <= X"00000000";	   
          end if;    
       end if;
		
		
end process;

--process(sent_state)
--begin
--	if(sent_state = '1') then
--	wait_t <= '1';
--	end if;
--end process;

--Check if packet has been sent successfully by the iterator


--process (clk)
--  begin
--    if rising_edge(clk) then
--      if reset_n = '0' then
--        irq <= '0';
--      else
--        if sent_state ='1' then --ideally there should only be 1 packet that should be transmitted
--          irq <= '1';
--          --sent_state <= '0';
--          wait_t <= '1';
--        elsif write_n = '0' and chipselect_n = '0' and address(2 downto 0) = "100" then
--          irq <= '0';  -- important to reset the irq
--        end if;
--      end if;
--    end if;
--  end process;
  
  
    
    end packet;
