library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity MUX_statemachine is
port(
-- NIOS Avalon Interface	
iDATA : in std_logic_vector(15 downto 0); --data

iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
iCS_N: in std_logic;--chipselect
iRST_N: in std_logic;--reset_n
oDATA: out std_logic_vector(15 downto 0);---writedata
oINT: out std_logic;--Interrupt irq
CLK : in std_logic;
--DM9000A interface

ENET_DATA:inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;

--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
debug_custom:out std_logic_vector(6 downto 0);
CUSTOM_FREE: out std_logic;

--from switch
iCMD: in std_logic_vector(1 downto 0);--address
iCMD_chk:out std_logic_vector(1 downto 0)
);
end MUX_statemachine;

architecture behav of MUX_statemachine is

--lab2_Dm9000A signals	

signal sig_cust_free:std_logic:='0';

type state is (lab2,cust);
signal state_sig: state:=lab2;
signal initialized: std_logic:='0';
signal check_intialized: std_logic_vector(3 downto 0):=x"3";
signal sig_iCMD:std_logic;
begin
 
					
  
--------State Machine of MUX-----------------------
 --ENET_CMD <= iCMD;--(0);
 sig_iCMD <= iCMD(1);
--ENET_DATA <= iDATA when iWR_N='0' else (others => 'Z');
oData <= ENET_DATA;

process(iRD_N,iWR_N,iCS_N,iRST_N)
begin
--if (rising_edge(CLK)) then
     if initialized = '0' then		
	state_sig<= lab2;
				
		
	--input to Lab2 from NiOS	
	  ENET_RD_N <= iRD_N ;
	  ENET_WR_N <= iWR_N ;
	  ENET_CS_N <= iCS_N ;
	  ENET_RST_N <= iRST_N ;

	--outputs from Lab2
	 -- oINT <= ENET_INT;
	
    --end if;

--iCMD_CHK<=iCMD"(0);
end if;
			
end process;
---capture if intialized DM9000A
process(clk)
begin
 --avalon logic for intialization 
if rising_edge(clk) then
	if iCS_N = '0' then 
		if sig_iCMD = '1' then
			if iWR_N = '0' then 
				check_intialized <= iDATA(3 downto 0);
			end if;
		end if;
	end if;
	if check_intialized = x"5" then 
		initialized <= '1';
	end if;
	end if;
end process;
end behav;
