--this file as of 7 th Arpil 2012 6:17 pm is modified version of the ...software_like file in 
--dp2575 account. This adds the ability to write and subsequently read the same register . This 
--is done for 3 registers. 
--this file is a copy of Dm9000A-custom_software_like_dj.vhd , name changed for simlation
--dhananjay



library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DM9000A_custom_all is
port(
-- NIOS Avalon Interface	
--			iDATA : in std_logic_vector(15 downto 0); --data
--			iCMD: in std_logic;--address
--			iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
--			iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
--			iCS_N: in std_logic;--chipselect
--			iRST_N: in std_logic;--reset_n
--			oDATA: out std_logic_vector(15 downto 0);---writedata
--			oINT: out std_logic;--Interrupt irq
iCLK : in std_logic;
--DM9000A interface

       	ENET_DATA:inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;

--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
dbug_io_rw_cmd:out std_logic_vector(1 downto 0);
dbug_state_out_iter: out std_logic_vector(2 downto 0);
dbug_req_update:out std_logic

);
end DM9000A_custom_all;

architecture behav of DM9000A_custom_all is		
--mealy machine 
 type state is (LAB2,INIT,IDLE,DELAY,IState_1,IState_2,IState_3,IState_4); -- READ , WRITE from the perpective 
--of this device
  signal state_sig: state:=LAB2;
 signal sig_req_update:std_logic:='0';
 signal sig_ENET_DATA: std_logic_vector(7 downto 0);
 signal sig_ENET_CMD:std_logic:='0';
 signal sig_is_read:std_logic:='0';
 signal address_done:bit:='0'; 
 signal input_data: unsigned(15 downto 0):=x"0000";
 signal data_done,init_done:bit:='0'; 
 constant STD_DELAY_PHY:unsigned(27 downto 0):=x"EE6B280"; --10 secs (freq of NIOS=50MHz) 
 signal delay_std_counter:unsigned(27 downto 0):=STD_DELAY_PHY;--2000

--- this handles the global state and the outputs
---can relate to the lines of code in C,see its file for more on this
component iterator 
port(	ENET_CLK: in std_logic;
 	req_update: in std_logic;
ENET_CMD :out std_logic;
ENET_DATA:inout std_logic_vector(7 downto 0);--for verifying when looping over read,and for writing data 
ENET_DATA_IN:in std_logic_vector(7 downto 0);
is_read : out std_logic;	--simply means do not write to the bus(if high)
input_data:in std_logic_vector(7 downto 0);		-- DEBUG interface
dbug_io_rw_cmd: out std_logic_vector(1 downto 0);
dbug_reg_index: out std_logic_vector(1 downto 0);
dbug_state_out: out std_logic_vector(2 downto 0);
dbug_req_update: out std_logic

);
end component;		

begin
--main process 


E1: iterator port map(
ENET_CLK=>iCLK,
req_update=> sig_req_update,
ENET_DATA_IN => input_data,
ENET_DATA=> sig_ENET_DATA,
is_read=> sig_is_read,
ENET_CMD => sig_ENET_CMD,
input_data=>std_logic_vector(input_data(7 downto 0)),
dbug_io_rw_cmd=>dbug_io_rw_cmd,
dbug_reg_index=> DBUG_Reg_Index(1 downto 0),
dbug_state_out=> dbug_state_out_iter,
dbug_req_update=>dbug_req_update
);
process (iCLK)
begin 
if (rising_edge(iCLK)) then

sig_req_update <= '0';
case state_sig is
 			when LAB2=>
sig_cust_free <= '1';
if intialized = '1' then
state_sig <= INIT;
else
state_sig<= LAB2;
end if;
when INIT=>
state_sig <= IDLE;
delay_std_counter <= STD_DELAY_PHY;
sig_req_update <= '1';

when IDLE=>
state_sig <= IState_1;
delay_std_counter <= STD_DELAY_PHY;
when IState_1=>
state_sig <= IState_2;
delay_std_counter <= STD_DELAY_PHY;

when IState_2=>
state_sig <= IState_3;
delay_std_counter <= STD_DELAY_PHY;

when IState_3=>
state_sig <= IState_4;
delay_std_counter <= STD_DELAY_PHY;
when IState_4=>
state_sig <= DELAY;
delay_std_counter <= STD_DELAY_PHY;

when DELAY=>

if delay_std_counter > x"00000" then
delay_std_counter <= delay_std_counter -1;
state_sig <= DELAY;
else  --delay afer idle state
delay_std_counter <= STD_DELAY_PHY;
sig_req_update <= '1';
state_sig <= IDLE;

end if;
when others=>


end case;
end if;	
end process;



process (state_sig,delay_std_counter,ENET_CMD,ENET_CS_N,ENET_WR_N)
begin
--Defualt
ENET_CMD <= '0';	
ENET_CS_N <= '1';	
ENET_WR_N <='1';
ENET_RD_N <='1';
ENET_DATA <=(others=>'Z');
--sig_req_update <= '0';

case state_sig is
when LAB2=>
ENET_RD_N <= iRD_N ;
ENET_WR_N <= iWR_N ;
ENET_CS_N <= iCS_N ;
ENET_RST_N <= iRST_N ;
ENET_CMD <= iCMD;
ENET_DATA <= iDATA when iWR_N='0' else (others => 'Z');
oINT <= ENET_INT;
when INIT=>
STATE_OUT <= x"0";
--	sig_req_update <= '1';

when IDLE=>
STATE_OUT <= x"1";
ENET_CMD <= sig_ENET_CMD;				
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
end if;			

when IState_1 =>
STATE_OUT <= x"2";	
ENET_WR_N <= '1';
ENET_RD_N <= '1';
ENET_CMD <= sig_ENET_CMD;				
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
end if;			

when IState_2 =>
STATE_OUT <= x"3";
ENET_CMD <= sig_ENET_CMD;				
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
ENET_WR_N <= '0';
else 
input_data <= unsigned(ENET_DATA);
ENET_RD_N <= '0';
end if;			


when IState_3 =>
STATE_OUT <= x"4";
ENET_CMD <= sig_ENET_CMD; 
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
end if;			


when IState_4 =>
STATE_OUT <= x"5";
ENET_CMD <= sig_ENET_CMD;				
ENET_CS_N <= '1';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
end if;			
--	sig_req_update <= '1';		

when DELAY=>
--	sig_req_update <= '1';		
STATE_OUT <= x"6";
ENET_CMD <= sig_ENET_CMD;
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
ENET_WR_N <= '1';
ENET_DATA <= std_logic_vector(input_data);
when others=>
STATE_OUT <= x"1";
DELAY_COUNTER <= std_logic_vector(delay_std_counter);

end  case;



end process;


end behav;



