--This is the only Component that should go into NIOS. this assumes iCMD is 2 bit. 
-- iCMD B1(Sel) B0(IO_data), Sel==0 => DM9000A_LAB2; Sel == 1 => DM9000A_custom
  


library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DM9000A_MUX is
port(
-- NIOS Avalon Interface	
iDATA : in std_logic_vector(15 downto 0); --data
iCMD: in std_logic_vector(1 downto 0);--address
iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
iCS_N: in std_logic;--chipiCMD(1)ect
iRST_N: in std_logic;--reset_n
oDATA: out std_logic_vector(15 downto 0);---writedata
oINT: out std_logic;--Interrupt irq
iCLK : in std_logic;
--DM9000A interface

       	ENET_DATA: inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;
--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
debug_lab2:out std_logic_vector(6 downto 0);
debug_custom:out std_logic_vector(6 downto 0)
);
end DM9000A_MUX;

architecture behav of DM9000A_MUX is	


-- custom_DM9000A signals	
signal	cust_ENET_DATA:std_logic_vector(15 downto 0); 
signal	cust_ENET_CMD: std_logic;
signal cust_ENET_RD_N: std_logic;
signal cust_ENET_WR_N: std_logic;
signal cust_ENET_CS_N: std_logic;
signal	cust_ENET_RST_N:  std_logic;
signal cust_ENET_INT: std_logic;

signal cust_iDATA: std_logic_vector(15 downto 0); --data
signal	cust_iCMD: std_logic_vector(1 downto 0);--address
signal	cust_iRD_N: std_logic;--read_n active low, when 0, NIOS wants to read
signal	cust_iWR_N: std_logic;--write_n active low, when 0, NIOs wants to read
signal	cust_iCS_N: std_logic;--chipiCMD(1)ect
signal	cust_iRST_N: std_logic;--reset_n
signal	cust_oDATA: std_logic_vector(15 downto 0);---writedata
signal	cust_oINT: std_logic;--Interrupt irq
signal	cust_iCLK : std_logic;
signal cust_debug: std_logic_vector(6 downto 0);

--lab2_Dm9000A signals	
signal	lab2_ENET_DATA:std_logic_vector(15 downto 0); 
signal	lab2_ENET_CMD: std_logic;
signal lab2_ENET_RD_N: std_logic;
signal lab2_ENET_WR_N: std_logic;
signal lab2_ENET_CS_N: std_logic;
signal	lab2_ENET_RST_N:  std_logic;
signal lab2_ENET_INT: std_logic;

signal lab2_iDATA:std_logic_vector(15 downto 0); --data
signal	lab2_iCMD: std_logic_vector(1 downto 0)	;--address
signal	lab2_iRD_N: std_logic:='Z';--read_n active low, when 0, NIOS wants to read
signal	lab2_iWR_N: std_logic:='Z';--write_n active low, when 0, NIOs wants to read
signal	lab2_iCS_N: std_logic:='Z';--chipiCMD(1)ect
signal	lab2_iRST_N: std_logic:='Z';--reset_n
signal	lab2_oDATA: std_logic_vector(15 downto 0);---writedata
signal	lab2_oINT: std_logic;--Interrupt irq
signal lab2_debug: std_logic_vector(6 downto 0);
signal ones: std_logic_vector(1 downto 0):="11";
signal	cust_free: std_logic:='1';
signal save_iCMD:std_logic_vector(1 downto 0):="00";


component DM9000A_custom
port(
-- NIOS Avalon Interface	
iDATA : in std_logic_vector(15 downto 0); --data
iCMD: in std_logic_vector(1 downto 0);--address
iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
iCS_N: in std_logic;--chipselect
iRST_N: in std_logic;--reset_n
oDATA: out std_logic_vector(15 downto 0);---writedata
oINT: out std_logic;--Interrupt irq
iCLK : in std_logic;
--DM9000A interface

ENET_DATA:inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;

--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
debug_custom:out std_logic_vector(6 downto 0);
CUSTOM_FREE: out std_logic

);
end component;

component DM9000A_lab2 
port(
 	 	iCMD,iRD_N,iWR_N, iCS_N,iRST_N: in std_logic; 
 	iDATA: in std_logic_vector(15 downto 0);
 	 	oDATA: out std_logic_vector(15 downto 0); 
 	oINT: out std_logic; -- DM9000A Side 
 	ENET_DATA_in: in std_logic_vector(15 downto 0); 
    ENET_DATA_out: out std_logic_vector(15 downto 0); 
 	ENET_CMD, ENET_RD_N,ENET_WR_N, ENET_CS_N,ENET_RST_N: out std_logic; 
 	ENET_INT: in std_logic;
debug_lab2:out std_logic_vector(6 downto 0) ); 
end component;

begin
U1: DM9000A_custom port map(
          iDATA => cust_iDATA,
         iCMD => cust_iCMD,
         iRD_N => cust_iRD_N,
         iWR_N => cust_iWR_N,
         iCS_N => cust_iCS_N,
         iRST_N => cust_iRST_N,
         oDATA => cust_oDATA,
         oINT => cust_oINT,
         iCLK => cust_iCLK,
         ENET_CMD => cust_ENET_CMD,
         ENET_CS_N => cust_ENET_CS_N ,
                 ENET_DATA => cust_ENET_DATA,
                 ENET_RD_N => cust_ENET_RD_N,
                 ENET_RST_N => cust_ENET_RST_N,
                 ENET_WR_N => cust_ENET_WR_N,
                 ENET_INT => cust_ENET_INT,
                 --STATE_OUT => STATE_OUT,
                 DELAY_COUNTER => DELAY_COUNTER,
                 DBUG_Reg_Index => DBUG_Reg_Index,               
                 debug_custom=>cust_debug
--CUSTOM_FREE  => cust_free      
                  
                  );
          U2: DM9000A_LAB2 port map(
          iDATA => lab2_iDATA,
          iCMD =>lab2_iCMD(0),
          iRD_N => lab2_iRD_N,
          iWR_N => lab2_iWR_N,
          iCS_N => lab2_iCS_N,
          iRST_N => lab2_iRST_N,
          oDATA => lab2_oDATA,
          oINT => lab2_oINT,
          ENET_CMD => lab2_ENET_CMD,
          ENET_CS_N => lab2_ENET_CS_N ,
                  ENET_DATA_in => lab2_ENET_DATA,
                  ENET_RD_N => lab2_ENET_RD_N,
                  ENET_RST_N => lab2_ENET_RST_N,
                  ENET_WR_N => lab2_ENET_WR_N,
                  ENET_INT => lab2_ENET_INT
                  --debug_lab2 =>lab2_debug       

                                    
                  );
ENET_DATA_in<= lab2_ENET_DATA;-- when  iWR_N='1' else (others=>'Z');
oDATA <= ENET_DATA_out;-- when iCMD(1)='1' else cust_ENET_DATA;	
 lab2_iCMD <= iCMD; 


process (iCLK,iCS_N,iWR_N,iRD_N)
begin
      if rising_edge(iCLK) then	
--if (save_iCMD(1)='0') then --and cust_free='1') then
--lab2 inputs
  lab2_iDATA <= iDATA ;
         
          lab2_iRD_N <= iRD_N ;
          lab2_iWR_N <= iWR_N ;
     	  iCMD_chk => internal_iCMD_chk;
          lab2_iCS_N <= iCS_N ;
          lab2_iRST_N <= iRST_N ;
          lab2_ENET_INT <= ENET_INT ;

--oDATA <= ENET_DATA;
oINT <= lab2_oINT;
ENET_CMD <= lab2_ENET_CMD;
ENET_CS_N <= lab2_ENET_CS_N;

--if (iWR_N = '0') then
--	ENET_DATA <= lab2_ENET_DATA ;
--else
--	ENET_DATA <= (others=>'Z');
--end if;
ENET_RD_N <= lab2_ENET_RD_N;
ENET_RST_N <= lab2_ENET_RST_N;
ENET_WR_N <= lab2_ENET_WR_N;
STATE_OUT <= x"1";
--debug_lab2(1 downto 0)  <= iCMD;
--debug_lab2(6 downto 2) <= "11111";
--	debug_lab2(6 downto 0) <= "0000000";

--added
--	debug_custom(6 downto 0) <= "1111111"; 
 
if (iCMD(1)='1') then
--else
          --cust_inputs
        cust_iDATA <= iDATA;
         cust_iCMD <=  iCMD;
         cust_iRD_N <=  iRD_N;
         cust_iWR_N <= iWR_N;
         cust_iCS_N <=  iCS_N;
         cust_iRST_N <=  iRST_N;
         cust_iCLK <=  iCLK;
          cust_ENET_INT <=  ENET_INT;
          
--	          oDATA <=  cust_oDATA;
       oINT <=  cust_oINT;
          
          
       ENET_CMD <= cust_ENET_CMD;
--	    	  if (iWR_N = '0') then
  --              	ENET_DATA <= cust_ENET_DATA ;
--	        else
--	                ENET_DATA <= (others=>'Z');
  --      	end if;
         ENET_CS_N <= cust_ENET_CS_N;
                 --ENET_DATA <= cust_ENET_DATA;
                ENET_RD_N <=  cust_ENET_RD_N;
                ENET_RST_N <= cust_ENET_RST_N;
                ENET_WR_N <= cust_ENET_WR_N;
STATE_OUT <= x"2";
--DEBUGGING
--debug_custom(1 downto 0) <=iCMD;  
--debug_custom(6 downto 2) <= "11111"; 

end if;
end if;
end process;

process(iCLK,iCS_N)
begin
if rising_edge(iCLK) then
  if iCS_N='0' then
--            save_iCMD<=iCMD;
  end if;
end if;
end process;
debug_lab2(1 downto 0)<=save_iCMD;                                
end behav;
