--this file as of 7 th Arpil 2012 6:17 pm is modified version of the ...software_like file in 
--dp2575 account. This adds the ability to write and subsequently read the same register . This 
--is done for 3 registers. 
--this file is a copy of Dm9000A-custom_software_like_dj.vhd , name changed for simlation
--dhananjay



library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DM9000A_custom_all is
port(
-- NIOS Avalon Interface	
		iDATA : in std_logic_vector(15 downto 0); --data
		iCMD: in std_logic_vector (1 downto 0);--address
		iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
		iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
			iCS_N: in std_logic;--chipselect
			iRST_N: in std_logic;--reset_n
			oDATA: out std_logic_vector(15 downto 0);---writedata
			oINT: out std_logic;--Interrupt irq
iCLK : in std_logic;
--DM9000A interface

       	ENET_DATA:inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;

--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
dbug_io_rw_cmd:out std_logic_vector(1 downto 0);
dbug_state_out_iter: out std_logic_vector(2 downto 0);
dbug_ENET_DATA:out std_logic_vector(15 downto 0);
dbug_req_update:out std_logic

);
end DM9000A_custom_all;

architecture behav of DM9000A_custom_all is	

--signals to map the data from the change packet to the iterator
signal BUY_SELL_p: std_logic;
signal PRICE_p: std_logic_vector(31 downto 0);
signal NAME_p: std_logic_vector(31 downto 0);
signal wait_t_p: std_logic;
signal QUANT_p:  std_logic_vector(31 downto 0);
signal sent_state_p: std_logic;

	
--mealy machine 
 type state is (LAB2,INIT,IDLE,DELAY,IState_1,IState_2,IState_3,IState_4); -- READ , WRITE from the perpective 
--of this device
  signal state_sig: state:=LAB2;
 signal sig_req_update:std_logic:='0';
 signal sig_ENET_DATA: std_logic_vector(15 downto 0):=x"0000";
 signal sig_ENET_CMD:std_logic:='0';
 signal sig_is_read:std_logic:='0';
signal sig_iCMD:std_logic_vector(1 downto 0):="00";
 signal address_done:bit:='0'; 
 signal input_data: unsigned(15 downto 0):=x"0000";
 signal data_done,init_done:bit:='0'; 
 constant STD_DELAY_PHY:unsigned(27 downto 0):=x"00001F4"; --"EE6B280";10 secs (freq of NIOS=50MHz) 
 signal delay_std_counter:unsigned(27 downto 0):=STD_DELAY_PHY;--2000
signal sig_cust_free: std_logic:='1';
signal initialized: std_logic:='0';
signal check_intialized: std_logic_vector(3 downto 0):=x"3";
signal reg_state_sig:state:= LAB2;
signal input_data_internal:std_logic_vector(15 downto 0):= x"0000";
signal read_now_N:std_logic:='1'; -- same as ENET_RD_N, used for reading exactly when the data is to be read
--- this handles the global state and the outputs
---can relate to the lines of code in C,see its file for more on this
signal sig_iCLK: std_logic;
    signal sig_iRST_N: std_logic;
    signal sig_iRD_N: std_logic;
    signal sig_iWR_N: std_logic;
    signal sig_iCS_N: std_logic;
    signal sig_iCMD1: std_logic_vector (1 downto 0);
    signal sig_oDATA: std_logic_vector(15 downto 0);
    signal sig_iDATA:  std_logic_vector(15 downto 0);
signal read_flag:std_logic:='0';
component iterator 
port(	ENET_CLK: in std_logic;
 	req_update: in std_logic;
	ENET_CMD :out std_logic;
	ENET_DATA:out std_logic_vector(15 downto 0);--for verifying when looping over read,and for writing data 
	input_data: in std_logic_vector(15 downto 0); -- for reading ENET_DATA, inout is not the best option,need to have 2 separate I/O
	is_read : out std_logic;	--simply means do not write to the bus(if high)dbug_io_rw_cmd: out std_logic_vector(1 downto 0);
	BUY_SELL_i : in std_logic;
    PRICE_i: in std_logic_vector(31 downto 0);
    NAME_i :  in std_logic_vector(31 downto 0);
    wait_t_i: in std_logic;
    QUANT_i : in std_logic_vector(31 downto 0);
    sent_state_i: out std_logic; --Set high when packet sent successfully
	dbug_io_rw_cmd: out std_logic_vector(1 downto 0);
	dbug_reg_index: out std_logic_vector(1 downto 0);
	dbug_state_out: out std_logic_vector(2 downto 0);
	dbug_req_update: out std_logic

);
end component;	

component change_pack
port (
  
    clk   : in std_logic;                    -- Should be 25.125 MHz
    reset_n : in std_logic;
    read_n: in std_logic;
    write_n : in std_logic;
    chipselect_n : in std_logic;
    --address : in std_logic_vector(15 downto 0); -- this sends the offset value of the data that is being sent. Only 1 downto 0 is to be used
    address : in std_logic_vector(1 downto 0);
    writedata : in std_logic_vector(15 downto 0); -- this is sent from the nios

    -- these are the output ports that have to be port mapped to the top level entity
    BUY_SELL: out std_logic;
    PRICE : out std_logic_vector(31 downto 0);
    NAME :  out std_logic_vector(31 downto 0);
    wait_t: out std_logic; --active low, checks if more packet fields are being sent from NIOS
    QUANT : out std_logic_vector(31 downto 0);
    sent_state: in std_logic -- Set high from iterator when packet sent successfully
    
	);
end component;

begin
--main process 


E1: iterator port map(
	ENET_CLK=>iCLK,
	req_update=> sig_req_update,
	ENET_DATA=> sig_ENET_DATA,
	is_read=> sig_is_read,
	ENET_CMD => sig_ENET_CMD,
	input_data=>input_data_internal,
	dbug_io_rw_cmd=>dbug_io_rw_cmd,
	dbug_reg_index=> DBUG_Reg_Index(1 downto 0),
	dbug_state_out=> dbug_state_out_iter,
	dbug_req_update=>dbug_req_update,
	
    BUY_SELL_i => BUY_SELL_p,
    PRICE_i => PRICE_p,
    NAME_i => NAME_p,
    wait_t_i=> wait_t_p,
    QUANT_i => QUANT_p,
    sent_state_i => sent_state_p
	
);

E2: change_pack port map(
    clk   => iCLK,
    reset_n => iRST_N,
    read_n => iRD_N,
    write_n => iWR_N,
    chipselect_n => iCS_N,
    address => iCMD,
    writedata => iDATA,

  BUY_SELL => BUY_SELL_p,
  PRICE => PRICE_p,
  NAME => NAME_p,
  QUANT => QUANT_p,
  wait_t => wait_t_p,
  sent_state => sent_state_p 
);


process (iCLK)
begin 
if (rising_edge(iCLK)) then

sig_req_update <= '0';
reg_state_sig <= state_sig;
state_sig <= LAB2;
case state_sig is
		when LAB2=>
			sig_cust_free <= '1';
			if initialized = '1' then
				state_sig <= INIT;
			else
				state_sig<= LAB2;
			end if;

when INIT=>
	state_sig <= IDLE;
	delay_std_counter <= STD_DELAY_PHY;
	sig_req_update <= '1';


when IDLE=>

	state_sig <= IState_1;
	delay_std_counter <= STD_DELAY_PHY;
	
when IState_1=>
	state_sig <= IState_2;
	delay_std_counter <= STD_DELAY_PHY;

when IState_2=>
	state_sig <= IState_3;
	delay_std_counter <= STD_DELAY_PHY;

when IState_3=>
	state_sig <= IState_4;
	delay_std_counter <= STD_DELAY_PHY;

when IState_4=>
	state_sig <= DELAY;
	delay_std_counter <= STD_DELAY_PHY;


when DELAY=>

if delay_std_counter > x"00000" then
	delay_std_counter <= delay_std_counter -1;
	state_sig <= DELAY;
else  --delay afer idle state
	delay_std_counter <= STD_DELAY_PHY;
	sig_req_update <= '1';
	state_sig <= IDLE;

end if;
when others=>


end case;
end if;	
end process;


oData <= ENET_DATA ;
input_data_internal <= ENET_DATA(15 downto 0) when read_now_N = '0';

sig_iCMD <= iCMD;
--ENET_CMD <= iCMD(0) when state_sig=LAB2 else sig_ENET_CMD;

dbug_ENET_DATA <= std_logic_vector(input_data);
ENET_DATA <= iDATA when iWR_N='0' and state_sig=LAB2 
else sig_ENET_DATA when sig_is_read='0' and state_sig/=LAB2 
else (others=>'Z');

process (state_sig,delay_std_counter,iCMD,iRD_N,ENET_INT,iCS_N,iWR_N,iRST_N,input_data_internal)
begin
--Defualt
	ENET_CS_N <= '1';	
	ENET_WR_N <='1';
	ENET_RD_N <='1';
	ENET_RST_N <= '1' ;
	oINT <= '0';
	ENET_CMD <= '0';
	read_now_N <= '1';
	STATE_OUT <= x"A";
--	ENET_DATA <= (others => 'Z');
	input_data <= (others => 'Z');

case state_sig is
when LAB2=>
	STATE_OUT <= x"9";
	ENET_RD_N <= iRD_N ;
	ENET_WR_N <= iWR_N ;
	ENET_CS_N <= iCS_N ;
	ENET_RST_N <= iRST_N ;
	ENET_CMD <= sig_iCMD(0);
	--if iWR_N ='0' then
	--	ENET_DATA <= iDATA;
--	 else 
	--	ENET_DATA <= (others => 'Z');
--	end if;
	ENET_CMD <= iCMD(0);
	oINT <= ENET_INT;
when INIT=>
	STATE_OUT <= x"0";

when IDLE=>
	STATE_OUT <= x"1";
	ENET_CMD <= sig_ENET_CMD;				
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
--	if sig_is_read ='0' then
--		ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
--	end if;			

when IState_1 =>
	STATE_OUT <= x"2";	
	ENET_WR_N <= '1';
	ENET_RD_N <= '1';
	ENET_CMD <= sig_ENET_CMD;				
	ENET_CS_N <= '0';
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
--if sig_is_read ='0' then
--	ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
--end if;			
--	

when IState_2 =>
	STATE_OUT <= x"3";
	ENET_CMD <= sig_ENET_CMD;				
	ENET_CS_N <= '0';
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
if sig_is_read ='0' then
--	ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
	ENET_WR_N <= '0';
else 
--	--input_data_internal <= (ENET_DATA(7 downto 0));
----	input_data <= unsigned(ENET_DATA);
	ENET_RD_N <= '0';
	read_now_N <= '0';
end if;			

when IState_3 =>
	STATE_OUT <= x"4";
	ENET_CMD <= sig_ENET_CMD; 
	ENET_CS_N <= '0';
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
--if sig_is_read ='0' then
--	ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
--end if;			


when IState_4 =>
	STATE_OUT <= x"5";
	ENET_CMD <= sig_ENET_CMD;				
	ENET_CS_N <= '1';
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
--if sig_is_read ='0' then
--	ENET_DATA(7 downto 0) <= sig_ENET_DATA;	--eventually a reset should also be used	
--end if;			

when DELAY=>
	STATE_OUT <= x"6";
	ENET_CMD <= sig_ENET_CMD;
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);
	ENET_WR_N <= '1';
	input_data <= unsigned(input_data_internal);	
	
		--ENET_DATA <= std_logic_vector(input_data);
when others=>
	STATE_OUT <= x"1";
	DELAY_COUNTER <= std_logic_vector(delay_std_counter);

end  case;



end process;


process(iClk)
begin
 --avalon logic for intialization 
if rising_edge(iClk) then
	if iCS_N = '0' then 
		if sig_iCMD(1) = '1' then
			if iWR_N = '0' then 
				check_intialized <= iDATA(3 downto 0);
			end if;
		end if;
	end if;
	if check_intialized = x"5" then 
		initialized <= '1';
	end if;
	end if;
end process;



end behav;



