--this file as of 7 th Arpil 2012 6:17 pm is modified version of the ...software_like file in 
--dp2575 account. This adds the ability to write and subsequently read the same register . This 
--is done for 3 registers. 
--this file is a copy of Dm9000A-custom_software_like_dj.vhd , name changed for simlation
--dhananjay



library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity DM9000A_custom is
port(
-- NIOS Avalon Interface	
iDATA : in std_logic_vector(15 downto 0); --data
iCMD: in std_logic_vector(1 downto 0);--address
iRD_N: in std_logic;--read_n active low, when 0, NIOS wants to read
iWR_N: in std_logic;--write_n active low, when 0, NIOs wants to read
iCS_N: in std_logic;--chipselect
iRST_N: in std_logic;--reset_n
oDATA: out std_logic_vector(15 downto 0);---writedata
oINT: out std_logic;--Interrupt irq
iCLK : in std_logic;
--DM9000A interface

       	ENET_DATA:inout std_logic_vector(15 downto 0); 
ENET_CMD: out std_logic;
ENET_RD_N: out std_logic;
ENET_WR_N: out std_logic;
ENET_CS_N: out std_logic;
ENET_RST_N: out std_logic;
ENET_INT: in std_logic;

--DEBUG interface
STATE_OUT: out std_logic_vector(3 downto 0);
DELAY_COUNTER:out std_logic_vector(27 downto 0);
DBUG_Reg_Index:out std_logic_vector(5 downto 0);
debug_custom:out std_logic_vector(6 downto 0);
CUSTOM_FREE: out std_logic
);
end DM9000A_custom;

architecture behav of DM9000A_custom is		


--signal temp:std_logic_vector(6 downto 0):="1111001";


  constant RAM_MAX_INDEX :integer := 54; --Actual size of RAM is 55 bytes ,
--42 bytes of header, 13 bytes of header
--indicating position in RAM
  type finance_data is array(3 downto 0)of std_logic_vector(7 downto 0);
  constant PRICE: finance_data:= (x"00",x"00",x"00",x"26"); 
  constant NAME: finance_data:= (x"00",x"00",x"00",x"27"); 
  constant BUY_SELL: std_logic_vector:= "00000001"; 
  constant QUANT: finance_data:= (x"00",x"00",x"00",x"28"); 

--declaring register addresses for DMA9000a PHY
  constant NCR: std_logic_vector(7 downto 0):= x"00"; --Network  Control Register REG. 00 
  constant NSR: std_logic_vector(7 downto 0):= x"01"; --Network  Status Register  REG. 01
  constant IMR:std_logic_vector(7 downto 0):="11111111";  -- NIC Interrupt Mask   Register REG. FFH 
  constant PAR_set:std_logic_vector(7 downto 0):=x"80"; -- IMR REG. FFH: PAR only, RX/TX FIFO R/W
  constant MWCMD:std_logic_vector(7 downto 0):=x"F8"; --TX FIFO I/O port command WRITE into TX FIFO
  constant IO_addr:std_logic:= '0';
  constant IO_data:std_logic:= '1';
  constant STD_DELAY:std_logic_vector(7 downto 0):= x"40"; -- might have to change the delay
  constant TCR:std_logic_vector(7 downto 0):= X"02";
  constant TCR_set:std_logic_vector(7 downto 0):= X"00";
  constant TX_REQUEST:std_logic_vector(7 downto 0):= X"01";
  constant INTR_set:std_logic_vector(7 downto 0):= X"81";
  type init_address_data_type is array(integer range 0 to 2)of std_logic_vector(7 downto 0);
  
  
  type address_data_type is array(integer range 0 to 2)of std_logic_vector(7 downto 0);
  signal addr_tx_init:address_data_type:=(IMR,x"FD",x"FC"); 
  signal data_tx_init:address_data_type:=(PAR_set,x"03",x"07"); --address and data values used in the tx intialization stored sequentially inthe same seq as used in the C file
  
  

  constant INIT_delay:integer:=3000000000;	--1 min
--mealy machine 
 type state is (INIT,IDLE,DELAY,TX_INIT,TX_DATA,TX_DELAY,IState_1,IState_2,IState_3,IState_4,stopr,stopf,FREE); -- READ , WRITE from the perpective 
--of this device
 --type state_type_delay is (INFINITE, STD_DELAY, I_O_DELAY); --
--INFINITE:resets the counter each time, it goes to 0
--STD_DELAY :sets the counter to std_delay from any previosu value of counter
--I_O_DELAY: setst to standard delay

 -- Register to hold the current state
 signal state_sig: state:=INIT;
 signal state_prev:state:=INIT;
 signal address_done:bit:='0'; 
 signal input_data: unsigned(15 downto 0):=x"0000";
 signal data_done:bit:='0'; 
 constant STD_DELAY_PHY:unsigned(27 downto 0):=x"EE6B280"; --40 micro secs (freq of NIOS=50MHz) 7D0
 signal delay_std_counter:unsigned(27 downto 0):=STD_DELAY_PHY;--2000
 signal reg_index_counter:unsigned(1 downto 0):="00";--keeps a track of what we are writing from addr..data_tx_init
 signal io_rw_cmd:unsigned(1 downto 0):="00"; --this keeps track of what should go to ENET_CMD
 					     --		WRITE MODE	READ MODE
 					     -- IO_addr 00  		10
 					     -- IO_data 01 		11
 					     
 signal i:integer:=55;						--RAM_MAX_INDEX);
 type byte_array is array(RAM_MAX_INDEX downto 0) of std_logic_vector(7 downto 0);
 signal RAM : byte_array;
 signal ram_address, display_address : unsigned(3 downto 0);  

--To enable blocking
signal cust_free:std_logic:= '1';	

begin
--main process 

RAM<=( x"FF", x"FF", "11111111", "11111111", "11111111", "11111111", 
  x"01", x"60", x"6E", x"11", x"02", x"0F", 
  x"08", x"00",                         
                        
  
  x"45",                
  x"00",                
  x"00",x"9C",           
                       
  x"3d", x"35",          
  x"00",                
  x"00",                
  x"80",                
  x"11",                
  x"00",x"00",           
  x"c0",x"a8",x"01",x"01", 
  x"c0",x"a8",x"01",x"ff", 
                          
  
  x"67",x"d9", 
  x"27",x"2b", 
  x"00",x"88", 
  x"00",x"00",
  PRICE(3),PRICE(2),PRICE(1),PRICE(0),
   NAME(3),NAME(2),NAME(1),NAME(0),
  BUY_SELL,
   QUANT(3),QUANT(2),QUANT(1),QUANT(0));
 
process (iCLK)
begin 
if (rising_edge(iCLK)) then
cust_free <= '0';
case state_sig is
when INIT=>
state_sig <= IDLE;
delay_std_counter <= STD_DELAY_PHY;
reg_index_counter <= "00";
io_rw_cmd <= "00";

when IDLE=>
if reg_index_counter>=x"3" then
state_sig <= FREE;
reg_index_counter <= "00";
else
state_sig <= IState_1;
end if;


when IState_1=>
state_sig <= IState_2;
delay_std_counter <= STD_DELAY_PHY;
i<=55;

when IState_2=>
state_sig <= IState_3;
delay_std_counter <= STD_DELAY_PHY;
i<=55;

when IState_3=>
state_sig <= IState_4;
delay_std_counter <= STD_DELAY_PHY;
i<=55;
when IState_4=>
state_sig <= DELAY;
delay_std_counter <= STD_DELAY_PHY;
i<=55;		

when DELAY=>

if delay_std_counter > x"00000" then
delay_std_counter <= delay_std_counter -1;
state_sig <= DELAY;
else  --delay afer idle state
delay_std_counter <= STD_DELAY_PHY;
state_sig <= IDLE;
io_rw_cmd <= io_rw_cmd + 1;
if io_rw_cmd = "11" then -- one write and read cycle over
reg_index_counter <= reg_index_counter + 1;
io_rw_cmd <= "00";
end if;

end if;
--states not entered	
when TX_INIT=>

state_sig <= TX_DELAY;
delay_std_counter <= STD_DELAY_PHY;
when TX_DATA=>
if i>0 then
state_sig <= TX_DELAY;
delay_std_counter <= STD_DELAY_PHY;
else
state_sig<=IDLE;
end if;	
when TX_DELAY=>
if delay_std_counter > x"000" then
delay_std_counter <= delay_std_counter -1;
else  --delay afer idle state
state_sig <= TX_DATA;
i<=i-1;

end if;				--now delay is being used after TX_INIT state

when FREE=>
state_sig <= FREE;
cust_free <= '1';


when others=>

state_sig <=  stopr;

end case;
end if;

end process;



process (state_sig,reg_index_counter,delay_std_counter,i)
begin
--Defualt
ENET_CMD <= '0';	
ENET_CS_N <= '1';	
ENET_WR_N <='1';
ENET_RD_N <='1';
ENET_DATA <=(others=>'Z');
DBUG_Reg_Index(5 downto 2)<="0000";

case state_sig is
when INIT=>
STATE_OUT <= x"0";

when IDLE=>
STATE_OUT <= x"1";
if reg_index_counter < x"3" then
ENET_CMD <= io_rw_cmd(0);				
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0) <= std_logic_vector(reg_index_counter);

case io_rw_cmd is 
when "00" | "10" =>
ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(reg_index_counter));
when "01" =>
ENET_DATA(7 downto 0) <= data_tx_init(to_integer(reg_index_counter));
when "11" =>
end case;

else

end if;
when IState_1 =>
STATE_OUT <= x"2";	

if reg_index_counter < x"3" then
ENET_WR_N <= '1';
ENET_RD_N <= '1';
ENET_CMD <= io_rw_cmd(0);				
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0) <= std_logic_vector(reg_index_counter);

case io_rw_cmd is 
when "00" | "10" =>
ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(reg_index_counter));
when "01" =>
ENET_DATA(7 downto 0) <= data_tx_init(to_integer(reg_index_counter));
when "11" =>
end case;

else

end if;

when IState_2 =>
STATE_OUT <= x"3";

if reg_index_counter < x"3" then

ENET_CMD <= io_rw_cmd(0);				
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0) <= std_logic_vector(reg_index_counter);

case io_rw_cmd is 
when "00" | "10" =>
ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(reg_index_counter));
ENET_WR_N <='0';
when "01" =>
ENET_DATA(7 downto 0) <= data_tx_init(to_integer(reg_index_counter));
ENET_WR_N <='0';
when "11" =>
input_data <= unsigned(ENET_DATA);
ENET_RD_N <='0';
end case;



else

end if;	

when IState_3 =>
STATE_OUT <= x"4";
ENET_WR_N <= '1';

if reg_index_counter < x"3" then
ENET_CMD <= io_rw_cmd(0);				
ENET_CS_N <= '0';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0) <= std_logic_vector(reg_index_counter);

case io_rw_cmd is 
when "00" | "10" =>
ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(reg_index_counter));
when "01" =>
ENET_DATA(7 downto 0) <= data_tx_init(to_integer(reg_index_counter));
when "11" =>

end case;

else

end if;	

when IState_4 =>
STATE_OUT <= x"5";
ENET_WR_N <= '1';

if reg_index_counter < x"3" then
ENET_CMD <= io_rw_cmd(0);				
ENET_CS_N <= '1';
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0) <= std_logic_vector(reg_index_counter);

case io_rw_cmd is 
when "00" | "10" =>
ENET_DATA(7 downto 0) <= addr_tx_init(to_integer(reg_index_counter));
when "01" =>
ENET_DATA(7 downto 0) <= data_tx_init(to_integer(reg_index_counter));
when "11" =>

end case;

else

end if;	
when DELAY=>
STATE_OUT <= x"6";
ENET_CMD <= io_rw_cmd(0);
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(1 downto 0)<= std_logic_vector(reg_index_counter);	

ENET_WR_N <= '1';
ENET_DATA <= std_logic_vector(input_data);
--when START_R_W_DATA=>
--	STATE_OUT <="4";
--	ENET_WR
when TX_INIT=>
STATE_OUT <= x"7";
ENET_CMD <= IO_addr; --temporary
ENET_DATA(7 downto 0) <=MWCMD;
DELAY_COUNTER <= std_logic_vector(delay_std_counter);

when TX_DELAY=>
STATE_OUT <= x"8";
ENET_CMD <= IO_data; --temporary
ENET_DATA(7 downto 0) <=RAM(i);

DELAY_COUNTER <= std_logic_vector(delay_std_counter);
when TX_DATA=>
STATE_OUT <= x"9";
ENET_CMD <= IO_data; --temporary
ENET_DATA(7 downto 0) <=RAM(i);
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(5 downto 0)<= std_logic_vector(to_unsigned(i,6));
when others=>
STATE_OUT <= x"1";
ENET_CMD <= IO_data; --temporary
ENET_DATA(7 downto 0) <=RAM(i);
DELAY_COUNTER <= std_logic_vector(delay_std_counter);
DBUG_Reg_Index(5 downto 0)<= std_logic_vector(to_unsigned(i,6));

end  case;



end process;

CUST_FREE<=cust_free;
--process(iCLK,iCS_N)
--begin
--if iCS_N='0' then 
--debug_custom<="0010010";--5
--end if;
--end process;
--debug<=temp;
end behav;



