LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

ENTITY lights IS
PORT ( SW : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
KEY : IN STD_LOGIC_VECTOR(0 DOWNTO 0);
CLOCK_50 : IN STD_LOGIC;
LEDG : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
DRAM_CLK, DRAM_CKE : OUT STD_LOGIC;
DRAM_ADDR : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
DRAM_BA_1, DRAM_BA_0 : BUFFER STD_LOGIC;
DRAM_CS_N, DRAM_CAS_N, DRAM_RAS_N, DRAM_WE_N : OUT STD_LOGIC;
DRAM_DQ : INOUT STD_LOGIC_VECTOR(15 DOWNTO 0);
DRAM_UDQM, DRAM_LDQM : BUFFER STD_LOGIC );
END lights;


ARCHITECTURE Structure OF lights IS

COMPONENT nios_system
PORT ( 
		clk : IN STD_LOGIC;
		reset_n : IN STD_LOGIC;

		zs_addr_from_the_sdram_ctrl : OUT STD_LOGIC_VECTOR(11 DOWNTO 0);
		zs_ba_from_the_sdram_ctrl : BUFFER STD_LOGIC_VECTOR(1 DOWNTO 0);
		zs_cas_n_from_the_sdram_ctrl : OUT STD_LOGIC;
		zs_cke_from_the_sdram_ctrl : OUT STD_LOGIC;
		zs_cs_n_from_the_sdram_ctrl : OUT STD_LOGIC;
		zs_dq_to_and_from_the_sdram_ctrl : INOUT STD_LOGIC_VECTOR(15 DOWNTO 0);
		zs_dqm_from_the_sdram_ctrl : BUFFER STD_LOGIC_VECTOR(1 DOWNTO 0);
		zs_ras_n_from_the_sdram_ctrl : OUT STD_LOGIC;
		zs_we_n_from_the_sdram_ctrl : OUT STD_LOGIC;

        SRAM_ADDR_from_the_sram : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
        SRAM_CE_N_from_the_sram : OUT STD_LOGIC;
        SRAM_DQ_to_and_from_the_sram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
        SRAM_LB_N_from_the_sram : OUT STD_LOGIC;
        SRAM_OE_N_from_the_sram : OUT STD_LOGIC;
        SRAM_UB_N_from_the_sram : OUT STD_LOGIC;
        SRAM_WE_N_from_the_sram : OUT STD_LOGIC );


END COMPONENT;

COMPONENT sdram_pll
PORT ( inclk0 : IN STD_LOGIC;
c0 : OUT STD_LOGIC;
c1 : OUT STD_LOGIC );
END COMPONENT;

SIGNAL BA : STD_LOGIC_VECTOR(1 DOWNTO 0);
SIGNAL DQM : STD_LOGIC_VECTOR(1 DOWNTO 0);

SIGNAL pll_c1: STD_LOGIC;
BEGIN
DRAM_BA_1 <= BA(1); 
DRAM_BA_0 <= BA(0);
DRAM_UDQM <= DQM(1); 
DRAM_LDQM <= DQM(0);
--Instantiate the Nios II system entity generated by the SOPC Builder.
NiosII: nios_system PORT MAP (
		clk     => pll_c1, 
		reset_n => '1',
		
		zs_addr_from_the_sdram_ctrl        => DRAM_ADDR,
		zs_ba_from_the_sdram_ctrl          => BA,
		zs_cas_n_from_the_sdram_ctrl       => DRAM_CAS_N,
		zs_cke_from_the_sdram_ctrl         => DRAM_CKE,
		zs_cs_n_from_the_sdram_ctrl        => DRAM_CS_N,
		zs_dq_to_and_from_the_sdram_ctrl   => DRAM_DQ,
		zs_dqm_from_the_sdram_ctrl         => DQM,
		zs_ras_n_from_the_sdram_ctrl       => DRAM_RAS_N,
		zs_we_n_from_the_sdram_ctrl        => DRAM_WE_N,
		
        SRAM_ADDR_from_the_sram : OUT STD_LOGIC_VECTOR (17 DOWNTO 0);
        SRAM_CE_N_from_the_sram : OUT STD_LOGIC;
        SRAM_DQ_to_and_from_the_sram : INOUT STD_LOGIC_VECTOR (15 DOWNTO 0);
        SRAM_LB_N_from_the_sram : OUT STD_LOGIC;
        SRAM_OE_N_from_the_sram : OUT STD_LOGIC;
        SRAM_UB_N_from_the_sram : OUT STD_LOGIC;
        SRAM_WE_N_from_the_sram : OUT STD_LOGIC );
 );

neg_3ns: sdram_pll port map(CLOCK_50, DRAM_CLK, pll_c1);

END Structure;




