#ifndef _VGA_UPDATE_H_
#define _VGA_UPDATE_H_
//---------basic parameters-----
#define FULL_TIME          90
#define SPEED               2
#define JSPEED              5
#define LIGHT_WOUND         4
#define MID_WOUND           8
#define HEAVY_WOUND         12
#define FULL_BLOOD          212

//-------color table------------
#define BACKGROUND                    0
#define BODY1                         1
#define BODY2                         2
#define ORANGE                        3
#define BLACK                          4
#define WHITE                          5
#define EFFECT1                       6
#define EFFECT2                       7

//-------fixed position---------
#define SHADOW_Y                  45
#define SHADOW_CENTER            40
#define HIT_CENTER                   30
#define GUN_CENTER                 20
#define GUN_Y                    50
#define GUN_W                   16
#define HG_FIRE_W                  20
#define HG_FIRE_Y                50
#define HG_FIRE_TOP              400

//-------state index--------------
#define W1           0
#define W2           1
#define W3           2
#define W4          3
#define W5           4
#define W6          5
#define W7          6
#define W8         7
#define W9         8
#define W10       9
//------------
#define HP1          10
#define HP2          11
#define HP3          12
#define HP4          13
//------------
#define HK1          14
#define HK2          15
#define HK3         16
//------------
#define LP1          17
#define LP2          18
//------------
#define LK1          19
#define LK2          20
//------------
#define L1             21
//------------
#define LHP1         22
#define LHP2         23
#define LHP3         24
#define LHP4         25
//------------
#define LLP1         26
#define LLP2         27
//------------
#define LHK1         28
#define LHK2         29
#define LHK3        30
//------------
#define LLK1         31
#define LLK2         32
//------------
#define J1           33
#define J2          34
#define J3           35
#define J4           36
#define J5          37
#define J6          38
//------------
#define JK1          39
#define JK2          40
#define JK3         41
#define JK4         42
#define JK5        43
#define JK6         44
//------------
#define JP1          45
#define JP2         46
#define JP3         47
#define JP4         48
#define JP5         49
#define JP6         50
//------------
#define GUN1        51
#define GUN2        52
#define GUN3         53
#define GUN4         54
#define GUN5         55
//------------
#define DASH1       56
#define DASH2       57
#define DASH3       58
#define DASH4       59
#define DASH5       60
#define DASH6       61
//------------  
#define LASER1       62
#define LASER2       63
#define LASER3       64
#define LASER4       65
#define LASER5       66
#define LASER6       67
//------------
#define UP1          68
#define UP2          69
#define UP3          70
#define UP4          71
#define UP5          72
//------------
#define HG1          73
#define HG2          74
#define HG3          75
#define HG4          76
//------------
#define S1             77
//------------
#define H1             78
#define H2             79
#define H3             80
//------------
#define D1             81
#define D2             82
#define D3             83
#define D4             84
//------------
#define LD1           85
#define LD2           86
#define LD3           87
#define LD4           88
//------------
#define WIN1        89
//------------
#define LOSE1       90
//-------------
#define KD1           91
#define KD2           92
#define KD3           93
#define KD4           94
//--------------
#define HG5          95
#define HG6          96
#define HG7          97
#define HG8          98
#define HG9          99
#define HG10          100
#define HG11          101
#define HG12          102
#define HG13          103
#define HG14          104
#define HG15          105
#define HG16          106
//----motion category---------------
#define LW           0
#define RW           1
#define HP            2
#define HK            3
#define LP             4
#define LK             5
#define L               6
#define LHP          7
#define LLP           8
#define LHK          9
#define LLK         10
#define J             11
#define LJ           12
#define RJ           13
#define JK           14
#define JP           15
#define GUN       16
#define DASH      17   
#define LASER     18
#define UP           19
#define HG          20
#define S             21
#define H            22
#define D            23
#define LD          24
#define WIN       25
#define LOSE      26
#define KD	   27

//-----------------------------------------------------------------
#define IOWR_SET_SPRITE(x, y, rom, sprite, flip, color) \
    IOWR_32DIRECT( SPRITE_BUF_BASE, 4*(rom + (sprite<<7)), x + (y<<10) + (flip<<30) + (color<<20) )
    
#define IOWR_LEFT_CUT(x, sprite) \
    IOWR_32DIRECT( SPRITE_BUF_BASE, 4*(sprite<<7), (1<<29) + x )
    
#define IOWR_RIGHT_CUT(x, sprite) \
    IOWR_32DIRECT( SPRITE_BUF_BASE, 4*(sprite<<7), (1<<28) + x )
    
#define IOWR_SET_BG_COLOR(color) \
    IOWR_32DIRECT( SPRITE_BUF_BASE, 4*(21<<7), (color<<20) )
    
#define IOWR_END_IRQ() \
    IOWR_32DIRECT( SPRITE_BUF_BASE, 0, (1<<31) + 1023 + (1023<<10) )

void sprite_refresh();
void fight_environment(int p1_hp_off, int p2_hp_off, int time);
void game_menu(int cursor_position);
void sprite_clear_all();

#endif /*VGA_UPDATE_H_*/
