#include <io.h>
#include <system.h>
#include <stdio.h>
#include "vga_update.h"
//------------------------------------------------
  extern int time;
  extern int p1_x[2], p1_y[2], p2_x[2], p2_y[2];
  extern int p1_center[2], p2_center[2];
  extern int p1_width[2], p2_width[2];
  extern int p1_image[2], p2_image[2];
  extern int p1_flip[2], p2_flip[2];
  extern int p1_color[2], p2_color[2];
  //=================================
  extern int p1_hp_off[2], p2_hp_off[2];
  //---------------------------------------------
  extern int hit1[2], hit2[2];
  extern int hit1_x[2], hit1_y[2], hit2_x[2], hit2_y[2];
  //---------------------------------------------
  extern int gunn1[2], gunn2[2];
  extern int gun1_flip[2], gun2_flip[2];
  extern int gun1_x[2], gun1_y[2], gun2_x[2], gun2_y[2];
  //---------------------------------------------------
  extern int phantom1[2], phantom2[2];
  //--------------------------------------------------
  extern int effect1[2], effect2[2];
  extern int effect1_image[2], effect2_image[2];
  extern int effect1_x[2], effect1_y[2], effect2_x[2], effect2_y[2];
  //====================================
  extern int ds;
  //------------------------------------------------
int vga_cnt = 0;
int second = 0;
int sixth_second = 0;
int minute = 0;
int fifteen_second = 0;

//------------------------------------------------
void sprite_refresh()
{
//close interrupt for this cycle and clear sprites
    IOWR_END_IRQ();
    //if (time == 0) return;
    sprite_clear_all();
    
//update timer variables
    if(vga_cnt < 60)    vga_cnt++;
    else {
        vga_cnt = 0;    
        second++; 
        if(time > 0)time--; 
        }
    if(vga_cnt%8 == 4) sixth_second++;
    sixth_second = sixth_second%10;
    fifteen_second = vga_cnt;
    fifteen_second = fifteen_second%5;
    second = second%60;
    if(second == 59) minute++;
    fight_environment(p1_hp_off[ds], p2_hp_off[ds], time);
        
        
        //=============================================
        IOWR_SET_SPRITE( p1_x[ds] - SHADOW_CENTER, 450-SHADOW_Y, 66, 0, 0, BLACK);
        IOWR_SET_SPRITE( p2_x[ds] - SHADOW_CENTER, 450-SHADOW_Y, 66, 1, 0, BLACK);
        
        //update player body images and phantoms
        if(!p1_flip[ds]){
            if(phantom1[ds])    IOWR_SET_SPRITE( p1_x[ds] - p1_center[ds] - 10, p1_y[ds], p1_image[ds], 2, p1_flip[ds], EFFECT1);
            IOWR_SET_SPRITE( p1_x[ds] - p1_center[ds], p1_y[ds], p1_image[ds], 4, p1_flip[ds], p1_color[ds]);
        }else{
            if(phantom1[ds])    IOWR_SET_SPRITE( p1_x[ds] - p1_width[ds] + p1_center[ds] + 10, p1_y[ds], p1_image[ds], 2, p1_flip[ds], EFFECT1); 
            IOWR_SET_SPRITE( p1_x[ds] - p1_width[ds] + p1_center[ds], p1_y[ds], p1_image[ds], 4, p1_flip[ds], p1_color[ds] );  
        }
        if(!p2_flip[ds]){
            if(phantom2[ds])    IOWR_SET_SPRITE( p2_x[ds] - p2_center[ds] - 10, p2_y[ds], p2_image[ds], 3, p2_flip[ds], EFFECT2);
            IOWR_SET_SPRITE( p2_x[ds] - p2_center[ds], p2_y[ds], p2_image[ds], 5, p2_flip[ds], p2_color[ds] );
        }else{
            if(phantom2[ds])    IOWR_SET_SPRITE( p2_x[ds] - p2_width[ds] + p2_center[ds] + 10, p2_y[ds], p2_image[ds], 4, p2_flip[ds], EFFECT2); 
            IOWR_SET_SPRITE( p2_x[ds] - p2_width[ds] + p2_center[ds], p2_y[ds], p2_image[ds], 5, p2_flip[ds], p2_color[ds] );
        }
        //update hit effects
        if(hit1[ds])    IOWR_SET_SPRITE( hit1_x[ds] - HIT_CENTER, hit1_y[ds], 60, 6, 0, ORANGE);
        if(hit2[ds])    IOWR_SET_SPRITE( hit2_x[ds] - HIT_CENTER, hit2_y[ds], 60, 7, 0, ORANGE);
        
        //update energy gun bullets
        if(gunn1[ds])    IOWR_SET_SPRITE( gun1_x[ds] - GUN_CENTER, 410-GUN_Y, 61+sixth_second%2, 8, gun1_flip[ds], EFFECT1);
        if(gunn2[ds])    IOWR_SET_SPRITE( gun2_x[ds] - GUN_CENTER, 410-GUN_Y, 61+sixth_second%2, 9, gun2_flip[ds], EFFECT2);
                      
        //update combo effects
        if(effect1[ds])    IOWR_SET_SPRITE( effect1_x[ds] - HIT_CENTER, effect1_y[ds], effect1_image[ds], 6, 10, EFFECT1);
        if(effect2[ds])    IOWR_SET_SPRITE( effect2_x[ds] - HIT_CENTER, effect2_y[ds], effect2_image[ds], 7, 11, EFFECT2);               
     
}

void fight_environment(int p1_hp_off, int p2_hp_off, int time)
{
    IOWR_SET_BG_COLOR(BACKGROUND); //turn on background image
    IOWR_SET_SPRITE( 12, 10, 55, 15, 1, ORANGE);// update P1 hp boundary
    IOWR_SET_SPRITE( 12, 10, 54, 14, 1, ORANGE);// update P1 hp value   
    IOWR_LEFT_CUT( 16 + p1_hp_off, 14 );         // update current P1 hp off value
    IOWR_SET_SPRITE( 380, 10, 55, 17, 0, ORANGE);// update P2 hp boundary
    IOWR_SET_SPRITE( 380, 10, 54, 16, 0, ORANGE);// update P2 hp value
    IOWR_RIGHT_CUT( 16 + p2_hp_off, 16 );        // update current P2 hp off value
    IOWR_SET_SPRITE( 273, 5, 44+(time/10), 12, 0, ORANGE);//update time second tens
    IOWR_SET_SPRITE( 316, 5, 44+(time%10), 13, 0, ORANGE);//update time second ones
    if (time == 0){ 
        IOWR_SET_SPRITE( 197, 150, 57, 19, 0, ORANGE);
        if(p1_hp_off > p2_hp_off)   IOWR_SET_SPRITE( 264, 220, 59, 18, 0, ORANGE);
        else    IOWR_SET_SPRITE( 264, 220, 58, 18, 0, ORANGE);
    }// show up winner words when the fight ends
}

void game_menu(int cursor_position)
{
    IOWR_SET_BG_COLOR(BLACK);  
}// show game menu image

void sprite_clear_all()
{
    int i;
    for(i = 0; i<21; i++) IOWR_SET_SPRITE( 1023, 1023, 0, i, 0, 0 );
}//clear all sprite before a new cycle



