#include <io.h>
#include <system.h>
#include <stdio.h>
#include <sys/alt_irq.h> // the irq functions
#include <alt_types.h>
#include <keyboard_ctrl.h>
#include "vga_update.h"

//-----------------------------
KB_CODE_TYPE decode_mode;

int time_count = 0;
int currentT;

int keyBuf1[10] ={0,0,0,0,0,0,0,0,0,0};
int timeBuf1[10]={0,0,0,0,0,0,0,0,0,0};
int buf1_e=0;

int keyBuf2[10] ={0,0,0,0,0,0,0,0,0,0};
int timeBuf2[10]={0,0,0,0,0,0,0,0,0,0};
int buf2_e=0;
//------------------------------------------
//--------------WIDTH-----------------
const int romImage[107] = {
    16, 17, 17, 18, 18, 19, 19, 20, 20, 21,     //WALK
    1, 1, 2, 3,                         //HP
    26, 27, 27,                     //HK
    5, 5,                               //LP
    4, 4,                             //LK
    7,                              //L
    12, 12, 13, 14,                     //LHP
    10, 11,                         //LLP
    36, 36, 36,                     //LHK
    8, 9,                         //LLK
    28, 30, 30, 30, 28, 28,             //J
    8, 8, 8, 8, 8, 8,             //JK
    29, 29, 29, 29, 29, 29,             //JP
    38, 39, 40, 41, 41,                 //GUN
    37, 37, 37, 37, 37, 37,                 //DASH
    42, 42, 43, 43, 43, 43,             //LASER
    31, 32, 32, 33, 33,                 //UP
    23, 23, 24, 25,                     //HG
    15,                             //S
    22, 22, 22,                     //H
    0, 0, 0, 0,                         //D
    6, 6, 6, 6,                         //LD
    0,                              //WIN
    35,                             //LOSE
    34, 34, 34, 34,                     //KD 
    25, 25, 25, 25,                     //HG2 
    25, 25, 25, 25,                     //HG3 
    25, 25, 25, 25                     //HG4   
};
//-------------------------------------------
const int romWidth [28] = 
{68, 68,  132, 136,  76,   84,  76, 112, 112, 152, 112, 
 52, 52, 52, 112,  76, 104,  112, 116,  68, 100,  60,  72, 
 64,   76,  44,  44,  152   
 };
//---------------HEIGHT----------------
const int imageHeight [28] = 
 {150, 150, 150, 150, 150, 150, 110, 110, 110,  88, 110, 
  162, 162, 162, 110, 120, 150, 150, 150, 162, 162, 150, 150,
  150, 110, 150, 150, 37
  };
 //--------------CNETER------------------
const int romCenter [28] =
{ 
40, 40, 50, 44, 22, 37, 40, 40, 34, 30, 40, 
18, 18, 18, 40, 15, 54, 18, 43, 22, 43, 24, 43, 
20, 40, 18, 18, 75
};

const int attackRangeX[28] = {
    0, 0, 78, 88, 52, 52, 0, 71, 50, 118,
   70, 0,  0,  0, 71, 56,43,  78, 70,  36,
   50, 0,  0,  0,  0,  0, 0,  0
};
    

const int attackRangeY[28] = {
    0, 0, 120, 98, 115, 22, 0, 90, 75, 56,
   18, 0,   0,  0,  18, 43, 120,  120,  110, 146,
    0, 0,   0,  0,   0,  0, 0,  0
};
    

const int hitRangeX1[28] = {
    15, 20, 25, 40, 20, 34, 30, 33, 30, 0,
    37, 18, 18, 18, 37, 15, 24, 18, 35, 22,
    30, 24, 22, 20, 37,  0, 13, 0
};

const int hitRangeX2[28] = { 
    20, 15, 35, 30, 22, 17, 30, 24, 21, 0,
    26, 18, 18, 18, 31, 45, 26, 50, 40, 28,
    53, 28, 44, 40, 20,  0, 20, 0
};

const int hitRangeY[28] = {
   0,  0,  0, 15, 0, 0, 0, 0, 10, 0,
   2, 16, 16, 16, 0, 0, 0, 0,  5, 15,
  10,  8, 10,  0, 3, 0, 0, 0
};

const int Wound[28] = {
   0,  0,  8,  8, 4, 4, 0, 8, 4, 8,
   4, 0, 0, 0, 4, 4, 12, 12,  12, 12, 16,
   0, 0,  0, 0, 0, 0, 0
};

const int startMotion[28] = {
0, 0, 10, 14, 17, 19, 21, 22, 26, 28, 
31, 33, 33, 33, 39, 45, 51, 56, 62, 68, 
73, 77, 78, 81, 85, 89, 90, 91};
//-----------------------------------------
int dir1=0,dir2=1;


//====================================
int time = FULL_TIME;
//int is_fighting, cursor_position, fight_time;
int p1_x[2], p1_y[2], p2_x[2], p2_y[2];
int p1_center[2], p2_center[2];
int p1_width[2], p2_width[2];
int p1_image[2], p2_image[2];
int p1_flip[2], p2_flip[2];
int p1_color[2], p2_color[2];
//===================================
 int p1_hp_off[2], p2_hp_off[2];
  //---------------------------------------------
 int hit1[2], hit2[2];
 int hit1_x[2], hit1_y[2], hit2_x[2], hit2_y[2];
  //---------------------------------------------
 int gunn1[2], gunn2[2];
 int gun1_flip[2], gun2_flip[2];
 int gun1_x[2], gun1_y[2], gun2_x[2], gun2_y[2];
  //---------------------------------------------------
 int phantom1[2], phantom2[2];
  //--------------------------------------------------
 int effect1[2], effect2[2];
 int effect1_image[2], effect2_image[2];
 int effect1_x[2], effect1_y[2], effect2_x[2], effect2_y[2];
 //-------------------------------------
int ds=0;
//---------------------------------------
int key=0;
int key1=0, key2=0;

int motionJudge(int key,int* bufferhold);
int priority(int state, int input, int* bufferhold);
int attackRange(int state);
int nextState(int currentState);
int nextJK(int currentState);
int nextJP(int currentState);
int generateY(int currentMotion);
int bufferhold1[9];
int bufferhold2[9];
//------------------------------------------
int attack_rangeX1_t;
int attack_rangeY1_t;
int attack_rangeX2_t;
int attack_rangeY2_t;
int attack_rangeX1;
int attack_rangeY1;
int attack_rangeX2;
int attack_rangeY2;
int bullet_attackX1;
int bullet_attackX2;
///-----------------------------------------
int hit_rangeXL1_t;
int hit_rangeXR1_t;
int hit_rangeXL2_t;
int hit_rangeXR2_t;
       
int hit_rangeXL1;
int hit_rangeXR1;
int hit_rangeXL2;
int hit_rangeXR2;

//============================================

extern int sixth_second;
extern int fifteen_second;

int main()
{   
    int i;
    int fast_tick_buf = 1;
    int fast_tick = 11; 
    int slow_tick_buf = 1;
    int slow_tick = 11; 
    int keyMotion1, selfState1, currentState1 = S, currentMotion1 = S1;
    int keyMotion2, selfState2, currentState2 = S, currentMotion2 = S1;
    int buf_switch = 0;
    int y1, y2;
    int wound1=0, wound2=0;
    int center1 = 100, center2 = 500;
    int color1, color2;
    //===============================================
    int bullet_attackX1 = 0, bullet_attackX2 = 0;
    int bullet_attackY1 = 0, bullet_attackY2 = 0;
    int gun1 = 0, gun2 = 0;
    int gunX1 = 0, gunX2 = 0;
    int gun_dir1 = 0, gun_dir2 = 0; 
    //===============================================
    int hg_fire1=0, hg_fire2=0;
       
    printf("start\n");
    void comb_judg(int *keybuffer, int *time, int* bufEnd, int* key, int dir );
    void reset_buffer9( int *buffer );
    static void timer_irqhandler (void * context, alt_u32 id);
    static void key_irqhandler (void * context, alt_u32 id);
 //--------------------------------------------------------------------   
    alt_irq_register( SPRITE_BUF_IRQ, NULL, sprite_refresh );
    alt_irq_register( DE2_PS2_INST_IRQ, NULL,( void*)key_irqhandler ); // register the irq
    alt_irq_register( IRTIMER_INST_IRQ, NULL,( void*)timer_irqhandler );
     
    reset_buffer9( P1_holdBuf );
    reset_buffer9( P2_holdBuf );
    
    while(1){
             for (i=1;i<=8;i++){
              bufferhold1[i]=P1_holdBuf[i];
              bufferhold2[i]=P2_holdBuf[i];
             }

    	    if (sixth_second != slow_tick_buf){
    	    	    slow_tick = 1;
    	    	    slow_tick_buf = sixth_second;
    	    }else slow_tick = 0;
    	    if (fifteen_second != fast_tick_buf){
    	    	    fast_tick = 1;
    	    	    fast_tick_buf = fifteen_second;
    	    	    buf_switch = 1-buf_switch;
    	    	    ds = 1-buf_switch;
    	    }else fast_tick = 0; 
        //-----------------------------------------
        if(currentMotion1 == S1) currentState1 = S;
        if(currentMotion2 == S1) currentState2 = S;

        //-----------------------------------------
        attack_rangeX1 = 0;
       bullet_attackX1 = 0;
        attack_rangeX2 = 0;
       bullet_attackX2 = 0;

        //------------get key value------------------
        comb_judg( keyBuf1, timeBuf1, &buf1_e, &key1, dir1); 
        comb_judg( keyBuf2, timeBuf2, &buf2_e, &key2, dir2); 
        //-----------decode key motion----------------
        if(time > 0){
            keyMotion1 = motionJudge(key1, bufferhold1);   
            keyMotion2 = motionJudge(key2, bufferhold2);
        }else{
            keyMotion1 = S;   
            keyMotion2 = S;            
        }
//        hit1[buf_switch] = 0; 
//        hit2[buf_switch] = 0;
         //------------player color------------------------
        color1 = BODY1;
        color2 = BODY2;       
        
        //-------------------------------------------
        selfState1 = priority(currentState1 ,keyMotion1, bufferhold1);
        selfState2 = priority(currentState2 ,keyMotion2, bufferhold2);

        //--------direction change---------
        if(center2 < center1){ dir1 = 1; dir2 = 0;}
        else{ dir2 = 1; dir1 = 0;}
        //===================================
        //---------GUN attack range and position-----------------
        if(gun1 && fast_tick){   
                bullet_attackY1 = GUN_Y+20;
                if(!gun_dir1) {
                    gunX1 += SPEED;
                    bullet_attackX1 = gunX1 + GUN_W;
                }else{
                    gunX1 -= SPEED;
                    bullet_attackX1 = gunX1 - GUN_W;
                }
        }
        if(gun2 && fast_tick){   
                bullet_attackY2 = GUN_Y+20;
                if(!gun_dir2) {
                    gunX2 += SPEED;
                    bullet_attackX2 = gunX2 + GUN_W;
                }
                else{
                    gunX2 -= SPEED;
                    bullet_attackX2 = gunX2 - GUN_W;
                }
        }
        //===================================
//---------generate hg fire-----------------------
       if(currentMotion1 >= HG5 && currentMotion1 <= HG16){
               hg_fire1 = 1;
               attack_rangeX1 += HG_FIRE_W ;
               attack_rangeY1 = HG_FIRE_Y;
               bullet_attackX1 = attack_rangeX1;
               bullet_attackY1 = HG_FIRE_TOP;
       }else    hg_fire1 = 0;
       if(currentMotion2 >= HG5 && currentMotion2 <= HG16){
               hg_fire2 = 1;
               attack_rangeX2 += HG_FIRE_W ;
               attack_rangeY2 = HG_FIRE_Y;
               bullet_attackX2 = attack_rangeX2;
               bullet_attackY2 = HG_FIRE_TOP;
       }else    hg_fire2 = 0;
               
        //--------attack range------------------
         attack_rangeX1_t= attackRangeX[ currentState1 ];
         attack_rangeY1_t= attackRangeY[ currentState1 ];
         attack_rangeX2_t= attackRangeX[ currentState2 ];
         attack_rangeY2_t= attackRangeY[ currentState2 ];
         if(currentMotion1 == HP1 || currentMotion1 == HP2|| currentMotion1 == HP3||
         currentMotion1 == LHP1 || currentMotion1 == LHP2|| currentMotion1 == LHP3)attack_rangeX1_t = 0;
         if(currentMotion2 == HP1 || currentMotion2 == HP2|| currentMotion2 == HP3||
         currentMotion2 == LHP1 || currentMotion2 == LHP2|| currentMotion2 == LHP3)attack_rangeX2_t = 0;
         
         if ( !dir1 ) attack_rangeX1= center1 + attack_rangeX1_t;
             else attack_rangeX1= center1 - attack_rangeX1_t;
         if ( !dir2 ) attack_rangeX2= center2 + attack_rangeX2_t;
             else attack_rangeX2= center2 - attack_rangeX2_t;
             
       //==============================================
        //--------generate gun effect--------------
        if (currentMotion1 == GUN4) {
        gun1 = 1;
        gunX1 = attack_rangeX1;
        gun_dir1 = dir1;
        }
        if (currentMotion2 == GUN4){
        gun2 = 1;
        gunX2 = attack_rangeX2;
        gun_dir2 = dir2;
        }       
             
       //-----------hit range-------------------------------
         hit_rangeXL1_t= hitRangeX1[ currentState1 ];
         hit_rangeXR1_t= hitRangeX2[ currentState1 ];
         hit_rangeXL2_t= hitRangeX1[ currentState2 ];
         hit_rangeXR2_t= hitRangeX2[ currentState2 ];
       
         hit_rangeXL1 = center1 - hit_rangeXL1_t;
         hit_rangeXR1 = center1 + hit_rangeXR1_t;
         hit_rangeXL2 = center2 - hit_rangeXL2_t;
         hit_rangeXR2 = center2 + hit_rangeXR2_t;
         //---------defence---------------------------------------
        if(attack_rangeX2_t && (( dir1 && selfState1 == RW)||(!dir1 && selfState1 ==LW)) ) selfState1 = D;
        if(attack_rangeX1_t && (( dir2 && selfState2 == RW)||(!dir2 && selfState2 ==LW)) ) selfState2 = D;
        if(attack_rangeX2_t && (( dir1 && selfState1 == RW)||(!dir1 && selfState1 ==LW)) && currentState1 == L) selfState1 = LD;
        if(attack_rangeX1_t && (( dir2 && selfState2 == RW)||(!dir2 && selfState2 ==LW)) && currentState2 == L) selfState2 = LD;
        
       //------------attack & hit---------------------------------
       if (attack_rangeX1_t)  
          if( ( currentState2 != D && currentState2 != LD) && ( attack_rangeX1 >= hit_rangeXL2) && (attack_rangeX1 <= hit_rangeXR2) 
              && ( y1 + attack_rangeY1_t > y2) && (y1 + attack_rangeY1_t < y2 + imageHeight[currentState2] - hitRangeY[ currentState2 ] ) ) 
               selfState2 = H;
       if ( gun1==1 )
            if(( bullet_attackX1 >=hit_rangeXL2 ) && (attack_rangeX1 <= hit_rangeXR2) 
              && ( bullet_attackY1 > y2 ) && ( bullet_attackY1 < y2 + imageHeight[currentState2] - hitRangeY[ currentState2 ] ))
              selfState2 = H;
//          else if( ( currentState2 != D && currentState2 != LD) && !dir1 &&( attack_rangeX1 >= hit_rangeXL2) && (attack_rangeX1 <= hit_rangeXR2) 
//              && ( y1 + attack_rangeY1_t > y2) && (y1 + attack_rangeY1_t < y2 + imageHeight[currentState2] - hitRangeY[ currentState2 ] ) 
//              || (( bullet_attackX1 >=hit_rangeXL2 ) && (attack_rangeX1 <= hit_rangeXR2) 
//              && ( bullet_attackY1 > y2 ) && ( bullet_attackY1 < y2 + imageHeight[currentState2] - hitRangeY[ currentState2 ] )) )
//               selfState2 = H;
       if(attack_rangeX2_t) 
          if( ( currentState1 != D && currentState1 != LD) && ( attack_rangeX2 >= hit_rangeXL1) && (attack_rangeX2 <= hit_rangeXR1) 
              && ( y2 + attack_rangeY2_t > y1) && (y2 +attack_rangeY2_t < y1+ imageHeight[currentState1] - hitRangeY[ currentState1 ] ) ) 
               selfState1 = H;
       if( gun2==1 )
           if((( bullet_attackX2 >=hit_rangeXL1 ) && (attack_rangeX2 <= hit_rangeXR1) 
              && ( bullet_attackY2 > y1 ) && ( bullet_attackY2 < y1 + imageHeight[currentState1] - hitRangeY[ currentState1 ] )))
               selfState1 = H;
//          else if( ( currentState1 != D && currentState1 != LD) && dir2 &&( attack_rangeX2 >= hit_rangeXL1) && (attack_rangeX2 <= hit_rangeXR1) 
//              && ( y2+ attack_rangeY2_t > y1) && (y2 + attack_rangeY2_t < y1 + imageHeight[currentState1] - hitRangeY[ currentState1 ] ) 
//              || (( bullet_attackX2>=hit_rangeXL1 ) && (attack_rangeX2 <= hit_rangeXR1) 
//              && ( bullet_attackY2> y1 ) && ( bullet_attackY2 < y1 + imageHeight[currentState1] - hitRangeY[ currentState1 ] )) )
//               selfState1 = H; 
        
        
        //--------------wound generation--------------------
        if(selfState1 == H ) {
            if( fast_tick && dir1 && center1<630) center1++;
            if (fast_tick && !dir1 && center1>10) center1--;
            if (slow_tick) wound1 += Wound[currentState2]; 
            color1 = EFFECT2;
            if (gun2 && fast_tick) wound1+=12;
        }
        if(selfState2 == H ) {
            if( fast_tick && dir2 && center2<630) center2++;
            if (fast_tick && !dir2 && center2>10) center2--;
            color2 = EFFECT1;
            if(gun1 && fast_tick) wound2+=12;
            if (slow_tick ) wound2 += Wound[currentState1];
        }
        //===================================================
                //---------gun effect or dissappear-----
        if( gun1&&(gunX1 >= 630 || gunX1 <= 10|| selfState2 == H) ) gun1 = 0;
        if( gun2&&(gunX2 >= 630 || gunX2 <= 10|| selfState1 == H) ) gun2 = 0;

        //-------------x position----------------------------------    
        if(center1>=10 && (selfState1 == LW)&&fast_tick) center1 -= SPEED;
        else if (center1 <=630 && (selfState1 == RW)&&fast_tick) center1 += SPEED;
        if(center2>=10 && (selfState2 == LW)&&fast_tick) center2 -= SPEED;
        else if (center2 <=630 &&(selfState2 == RW)&&fast_tick) center2 += SPEED; 
        //--------------x jump position--------------------------------   
        if(center1>=10 && (selfState1 == LJ)&&fast_tick) center1 -= JSPEED;
        else if (center1 <=630 && (selfState1 == RJ)&&fast_tick) center1 += JSPEED;
        if(center2>=10 && (selfState2 == LJ)&&fast_tick) center2 -= JSPEED;
        else if (center2 <=630 &&(selfState2 == RJ)&&fast_tick) center2 += JSPEED;   
        //-------------DASH x position----------------------------------    
        if(center1>=10 && (selfState1 == DASH && dir1)&&fast_tick) center1 -= (JSPEED + SPEED);
        else if (center1 <=630 && (selfState1 == DASH && !dir1)&&fast_tick) center1 += (JSPEED + SPEED);
        if(center2>=10 && (selfState2 == DASH && dir2)&&fast_tick) center2 -= (JSPEED + SPEED);
        else if (center2 <=630 && (selfState2 == DASH && !dir2)&&fast_tick) center2 += (JSPEED + SPEED);    
        //--------------generate next state--------------
        if(currentState1 == selfState1){
        	if(slow_tick) currentMotion1 = nextState(currentMotion1); 
        }
        else if( selfState1 == JK) currentMotion1 = nextJK(currentMotion1); 
        else if( selfState1 == JP) currentMotion1 = nextJP(currentMotion1); 
        else currentMotion1 = startMotion[selfState1];
        
        if(currentState2 == selfState2){
        	if(slow_tick) currentMotion2 = nextState(currentMotion2);
        }
        else if(selfState2 == JK) currentMotion2 = nextJK(currentMotion2);
        else if(selfState2 == JP) currentMotion2 = nextJP(currentMotion2);
        else currentMotion2 = startMotion[selfState2];
        
        if(currentMotion1 > 106) currentMotion1 = S1;
        if(currentMotion2 > 106) currentMotion2 = S1;
        currentState1 = selfState1;
        currentState2 = selfState2;
        //--------------y position----------------------   
        y1 = generateY(currentMotion1);
        y2 = generateY(currentMotion2);

        //---------------update display info-------------
        p1_image[buf_switch] = romImage[currentMotion1];    
        p2_image[buf_switch] = romImage[currentMotion2];   
        p1_flip[buf_switch] = dir1;
        p2_flip[buf_switch] = dir2; 
        p1_x[buf_switch] = center1;
        p2_x[buf_switch] = center2;
        p1_y[buf_switch] = 480 - y1 - imageHeight[currentState1];
        p2_y[buf_switch] = 480 - y2 - imageHeight[currentState2];
        p1_center[buf_switch] = romCenter[currentState1];
        p2_center[buf_switch] = romCenter[currentState2];
        p1_width[buf_switch] = romWidth[currentState1];
        p2_width[buf_switch] = romWidth[currentState2];
        p1_color[buf_switch] = color1;
        p2_color[buf_switch] = color2;
        //----------------------------------------------
        hit1[buf_switch] = (selfState1 == H) && attack_rangeX2_t && !gun1; 
        hit2[buf_switch] = (selfState2 == H) && attack_rangeX1_t && !gun2; 
        hit1_x[buf_switch] = attack_rangeX2; 
        hit1_y[buf_switch] =460 - y2 - attack_rangeY2_t;  
        hit2_x[buf_switch] = attack_rangeX1;  
        hit2_y[buf_switch] =460 - y1 - attack_rangeY1_t; 
        if(time > 0){
            p1_hp_off[buf_switch]= wound1;
            p2_hp_off[buf_switch]= wound2;
        }
          //---------------------------------------------
         gunn1[buf_switch] = gun1;
         gunn2[buf_switch] = gun2;
         gun1_flip[buf_switch] = gun_dir1; 
         gun2_flip[buf_switch] = gun_dir2;
         gun1_x[buf_switch] = gunX1;
         gun2_x[buf_switch] = gunX2;
         gun1_y[buf_switch] = 480 - GUN_Y;
         gun2_y[buf_switch] = 480 - GUN_Y;
        //================================================
        phantom1[buf_switch] = (selfState1 == DASH);
        phantom2[buf_switch] = (selfState2 == DASH);
        //===============================================
        effect1[buf_switch] = hg_fire1;
        effect2[buf_switch] = hg_fire2;
        if(hg_fire1){
            effect1_image[buf_switch] = 64 + fifteen_second%2; 
            effect1_x[buf_switch] = center1 + HG_FIRE_W; 
            effect1_y[buf_switch] = 480 - y1 - 300;
        }
        if(hg_fire2){
            effect2_image[buf_switch] = 64 + fifteen_second%2; 
            effect2_x[buf_switch] = center2 + HG_FIRE_W; 
            effect2_y[buf_switch] = 480 - y2 - 300; 
        }
        //===============================================
        if(wound1 >= FULL_BLOOD || wound2 >= FULL_BLOOD) time = 0;
        if(time == 0) break;
        //================================================
        //if(slow_tick){
            key1 = 0;
            key2 = 0; 
    //}  
    }
    while(1){}
    return 0;   
}



int motionJudge(int key, int* bufferhold )
{
    int MotionState;
 
    if ( bufferhold[5] >0 )   MotionState=LP;                    
    else if ( bufferhold[6] >0 )   {MotionState=2; }                      
    else if ( bufferhold[7] >0 )   MotionState=LK;                      
    else if ( bufferhold[8] >0 )   MotionState=HK;                          
         if ( key == 9  )  { MotionState=GUN;  }                       
    else if ( key == 10 )  MotionState=DASH;                        
    else if ( key == 11 )  MotionState=HG;                          
    else if ( key == 12 )  MotionState=UP;                       
    else if ( key == 13 )  MotionState=LASER;
    else if ( bufferhold[1] >0 )     MotionState=J;       
    else if ( bufferhold[2] >0 )     MotionState=L;         
    else if ( bufferhold[3] >0 )     MotionState=LW;      
    else if ( bufferhold[4] >0 )     MotionState=RW;        
    else if (  bufferhold[1]==0 && bufferhold[2]==0 && 
                bufferhold[3]==0 && bufferhold[4]==0 && 
                bufferhold[5]==0 && bufferhold[6]==0 && 
                bufferhold[7]==0 && bufferhold[8]==0   )    MotionState= S; 
    return MotionState; 
}

int priority(int state, int input, int* bufferhold )
{
    int new_state;
    switch(state){
    case S:
        new_state = input;
        break;
    case LW:
        if(input == J) new_state = LJ;
        else if(bufferhold[3]==0) new_state = S;
        else if (input == LW) new_state = state;
        else new_state = input;
        break;
    case RW:
        if(input == J) new_state = RJ;
        else if(bufferhold[4]==0) new_state = S;
        else if (input == RW) new_state = state;
        else    new_state = input;
        break;
    case L:
         if(bufferhold[2]==0)     new_state=S;
        else if(input == S)     new_state= S;
        else if(input == LP)     new_state= LLP;
        else if(input == HP)     new_state= LHP;
        else if(input == LK)     new_state=LLK;
        else if(input == HK)     new_state= LHK;
        else new_state = state;                                                            
        break;
    case J:
             if(input==LP)      new_state=JP;
                 else if(input==HP)      new_state=JP;
                 else if(input==LK)     new_state=JK;
                 else if(input==HK)     new_state=JK;
                 else new_state = state;
            break;
    case RJ:
             if(input==LP)      new_state=JP;
                else if(input==HP)     new_state=JP;
                else if(input==LK)     new_state=JK;
                else if(input==HK)     new_state=JK;
                else new_state = state;
            break;      
    case LJ:
             if(input==LP)      new_state=JP;
                 else if(input==HP)      new_state=JP;
                 else if(input==LK)     new_state=JK;
                 else if(input==HK)     new_state=JK;
                 else new_state = state;
            break;
   
    default: new_state = state; 
    }
    return new_state;
}
//int attackRange(int state)
//{
//	int range;
//	switch(state){
//		case 
//	}
//}
int nextState(int currentState)
{
    int nextState;
    switch (currentState){
        case W1: nextState = W2;                    break;
        case W2: nextState = W3;                    break;
        case W3: nextState = W4;                    break;
        case W4: nextState = W5;                    break;                    
        case W5: nextState = W6;                    break;
        case W6: nextState = W7;                    break;
        case W7: nextState = W8;                    break;
        case W8: nextState = W9;                    break;                        
        case W9: nextState = W10;                    break;
        case W10: nextState = W1;                    break;   
     //-----------------------------------                    
        case HP1: nextState = HP2;                    break;
        case HP2: nextState = HP3;                    break;
        case HP3: nextState = HP4;                    break;
        case HP4: nextState = S1;                     break;   
    //-------------------------------------                 
        case HK1: nextState = HK2;                    break;
        case HK2: nextState = HK3;                    break;
        case HK3: nextState = S1;                     break; 
    //-------------------------------------    
        case LP1: nextState = LP2;                    break;
        case LP2: nextState = S1;                     break;              
    //-------------------------------------    
        case LK1: nextState = LK2;                    break;
        case LK2: nextState = S1;                     break;                     
    //-------------------------------------    
        case L1: nextState = L1;                      break;                    
    //-----------------------------------                    
        case LHP1: nextState = LHP2;                    break;
        case LHP2: nextState = LHP3;                    break;
        case LHP3: nextState = LHP4;                    break;
        case LHP4: nextState = S1;                      break;                    
     //-------------------------------------    
        case LLP1: nextState = LLP2;                    break;
        case LLP2: nextState = S1;                      break;    
     //-------------------------------------                 
        case LHK1: nextState = LHK2;                    break;
        case LHK2: nextState = LHK3;                    break;
        case LHK3: nextState = S1;                      break;                                       
    //-------------------------------------    
        case LLK1: nextState = LLK2;                    break;
        case LLK2: nextState = S1;                      break;   
    //-------------------------------------
        case J1: nextState = J2;                    break;
        case J2: nextState = J3;                    break;
        case J3: nextState = J4;                    break;
        case J4: nextState = J5;                    break;                    
        case J5: nextState = J6;                    break;
        case J6: nextState = S1;                    break;                    
    //-------------------------------------
        case JK1: nextState = JK2;                    break;
        case JK2: nextState = JK3;                    break;
        case JK3: nextState = JK4;                    break;
        case JK4: nextState = JK5;                    break;                    
        case JK5: nextState = JK6;                    break;
        case JK6: nextState = S1;                     break;                       
    //-------------------------------------
        case JP1: nextState = JP2;                    break;
        case JP2: nextState = JP3;                    break;
        case JP3: nextState = JP4;                    break;
        case JP4: nextState = JP5;                    break;                    
        case JP5: nextState = JP6;                    break;
        case JP6: nextState = S1;                     break;                       
    //-------------------------------------
        case GUN1: nextState = GUN2;                    break;
        case GUN2: nextState = GUN3;                    break;
        case GUN3: nextState = GUN4;                    break;
        case GUN4: nextState = GUN5;                    break;                    
        case GUN5: nextState = S1;                      break;                    
    //-------------------------------------
        case DASH1: nextState = DASH2;                    break;
        case DASH2: nextState = DASH3;                    break;
        case DASH3: nextState = DASH4;                    break;
        case DASH4: nextState = DASH5;                    break;                    
        case DASH5: nextState = DASH6;                    break;
        case DASH6: nextState = S1;                       break;                     
    //-------------------------------------
        case LASER1: nextState = LASER2;                    break;
        case LASER2: nextState = LASER3;                    break;
        case LASER3: nextState = LASER4;                    break;
        case LASER4: nextState = LASER5;                    break;                    
        case LASER5: nextState = LASER6;                    break;
        case LASER6: nextState = S1;                        break; 
    //-------------------------------------
        case UP1: nextState = UP2;                    break;
        case UP2: nextState = UP3;                    break;
        case UP3: nextState = UP4;                    break;
        case UP4: nextState = UP5;                    break;                    
        case UP5: nextState = S1;                     break;     
   //--------------------------------------                  
        case HG1: nextState = HG2;                    break;
        case HG2: nextState = HG3;                    break;
        case HG3: nextState = HG4;                    break;
        case HG4: nextState = HG5;                    break;    
        case HG5: nextState = HG6;                    break;
        case HG6: nextState = HG7;                    break;
        case HG7: nextState = HG8;                    break;
        case HG8: nextState = HG9;                     break;
        case HG9: nextState = HG10;                    break;
        case HG10: nextState = HG11;                    break;
        case HG11: nextState = HG12;                    break;
        case HG12: nextState = HG13;                    break;    
        case HG13: nextState = HG14;                    break;
        case HG14: nextState = HG15;                    break;
        case HG15: nextState = HG16;                    break;
        case HG16: nextState = S1;                     break;                  
   //--------------------------------------                  
        case H1: nextState = H2;                     break;
        case H2: nextState = H3;                     break;
        case H3: nextState = S1;                     break;                                            
   //--------------------------------------                  
        case D1: nextState = D2;                     break; 
        case D2: nextState = D3;                     break;                     
        case D3: nextState = D4;                     break; 
        case D4: nextState = S1;                     break;                                                      
   //--------------------------------------                  
        case LD1: nextState = LD2;                    break; 
        case LD2: nextState = LD3;                    break;                     
        case LD3: nextState = LD4;                    break; 
        case LD4: nextState = S1;                     break;                          
   //--------------------------------------                  
        case S1: nextState = S1;                      break;    
   //--------------------------------------                  
        case WIN1: nextState = WIN1;                  break;    
   //--------------------------------------                  
        case LOSE1: nextState = LOSE1;                break; 
   //--------------------------------------                  
        case KD1: nextState = KD2;                    break; 
        case KD2: nextState = KD3;                    break;                     
        case KD3: nextState = KD4;                    break; 
        case KD4: nextState = KD4;                    break;          
        default:  nextState = S1;                               
    }
    return nextState;
}

int nextJK(int currentState)
{
	int nextState;
	switch (currentState){
	case J1: nextState = JK2;		break;
	case J2: nextState = JK3;		break;
	case J3: nextState = JK4;		break;
	case J4: nextState = JK5;		break;
	case J5: nextState = JK6;		break;
	case J6: nextState = S1;		break;
	default: nextState = S1;
	}
	return nextState;
}

int nextJP(int currentState)
{
	int nextState;
	switch (currentState){
	case J1: nextState = JP2;		break;
	case J2: nextState = JP3;		break;
	case J3: nextState = JP4;		break;
	case J4: nextState = JP5;		break;
	case J5: nextState = JP6;		break;
	case J6: nextState = S1;		break;
	default: nextState = S1;
	}
	return nextState;
}

int generateY(int currentMotion)
{
    int y,y0,y1,y2,y3;
    y0 = 50;
    y1 = 120;
    y2 = 180;
    y3 = 210;
    switch (currentMotion){
        case J1: y = y1;            break;
        case J2: y = y2;            break;            
        case J3: y = y3;            break;            
        case J4: y = y2;            break;            
        case J5: y = y1;            break;
        case J6: y = y0;            break;   
        case JK1: y = y1;            break;
        case JK2: y = y2;            break;            
        case JK3: y = y3;            break;            
        case JK4: y = y2;            break;            
        case JK5: y = y1;            break;
        case JK6: y = y0;            break; 
        case JP1: y = y1;            break;
        case JP2: y = y2;            break;            
        case JP3: y = y3;            break;            
        case JP4: y = y2;            break;            
        case JP5: y = y1;            break;
        case JP6: y = y0;            break;                      
     default : y = y0;                                                  
    }
    return y;
}

void reset_buffer9( int *buffer )
  {
   int i; 
   for (i=0; i<=8 ;i++)
    {  buffer[i]=0;  }
  }  

static void timer_irqhandler (void * context, alt_u32 id)
{
    IOWR_16DIRECT(IRTIMER_INST_BASE, 0, 0); // reset request
    time_count += 1;

}

//void printbuf(int *buf, int length){
//    int i;
//    for(i=0;i<length;i++)
//        printf("%d ",buf[i]);
//}
static void key_irqhandler (void * context, alt_u32 id)
{

    read_make_code (&decode_mode, &key);
    
      //printf( "key is%d\n",key1);
        if(decode_mode==P1_PRESS_CODE){ 
            currentT=time_count;
    
            keyBuf1[buf1_e]=key;
            timeBuf1[buf1_e]=currentT;
            buf1_e++; 
        }
                
        else if(decode_mode==P2_PRESS_CODE){ 
            currentT=time_count;  
            keyBuf2[buf2_e]=key;
            timeBuf2[buf2_e]=currentT;
            buf2_e++; 
        }
      
//    printf("\nkeyBuf2 is :");
//            printbuf(keyBuf2,10);
//            printf("\ntimeBuf2 is :");
//            printbuf(timeBuf2,10);   
//
}













