library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity line_buf is
	port (
		clk : in std_logic;
		we : in std_logic;
		a : in unsigned(7 downto 0);
		di : in unsigned(6 downto 0);
		do : out unsigned(6 downto 0)
	);
end line_buf;
architecture rtl of line_buf is
	type ram_type is array (0 to 255) of unsigned(6 downto 0);
	signal RAM : ram_type;
	signal read_a : unsigned(7 downto 0);
begin
	process (clk)
	begin
		if rising_edge(clk) then
			if we = '1' then
				RAM(to_integer(a)) <= di;
			end if;
			read_a <= a;
		end if;
	end process;
	do <= RAM(to_integer(read_a));
end rtl;

