library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity buf_bypass is
	port (
		clk : in std_logic;
		flip : in std_logic;
		buf_select : in std_logic;
		color_table : in unsigned(2 downto 0);
		write_addr : in unsigned(9 downto 0);
		read_addr : in unsigned(9 downto 0);
		di : in unsigned(15 downto 0);
		do : out unsigned(6 downto 0)
	);
end buf_bypass;
architecture rtl of buf_bypass is
	signal di_0, di_1, di_2, di_3 : unsigned(3 downto 0);
	signal plus_one_addr : unsigned(7 downto 0);
	signal addr_0_0, addr_0_1, addr_0_2, addr_0_3,
		   addr_1_0, addr_1_1, addr_1_2, addr_1_3 : unsigned(7 downto 0);
	signal do_0_0, do_0_1, do_0_2, do_0_3,
		   do_1_0, do_1_1, do_1_2, do_1_3 : unsigned(6 downto 0);
	signal we0_0, we0_1, we0_2, we0_3,
		   we1_0, we1_1, we1_2, we1_3 : std_logic;
		
	signal dii_0, dii_1, dii_2, dii_3 : unsigned(3 downto 0);
	signal addri_0_0, addri_0_1, addri_0_2, addri_0_3,
		   addri_1_0, addri_1_1, addri_1_2, addri_1_3 : unsigned(7 downto 0);
	signal wei0_0, wei0_1, wei0_2, wei0_3,
		   wei1_0, wei1_1, wei1_2, wei1_3 : std_logic;
	signal color_tablei : unsigned(2 downto 0);
	signal doo_0_0, doo_0_1, doo_0_2, doo_0_3,
		   doo_1_0, doo_1_1, doo_1_2, doo_1_3 : unsigned(6 downto 0);
begin
	plus_one_addr <= write_addr(9 downto 2) + 1;
------------------------------------------------------
	addri_0_0 <= read_addr(9 downto 2) when buf_select = '1' else
				write_addr(9 downto 2) when write_addr(1 downto 0) = "00" else
				plus_one_addr;
	addri_0_1 <= read_addr(9 downto 2) when buf_select = '1' else
				write_addr(9 downto 2) when write_addr(1 downto 0) = "00" or write_addr(1 downto 0) = "01" else
				plus_one_addr;
	addri_0_2 <= read_addr(9 downto 2) when buf_select = '1' else
				plus_one_addr when write_addr(1 downto 0) = "11" else
				write_addr(9 downto 2);
	addri_0_3 <= read_addr(9 downto 2) when buf_select = '1' else
				write_addr(9 downto 2);
------------------------------------------------------
	addri_1_0 <= read_addr(9 downto 2) when buf_select = '0' else
				write_addr(9 downto 2) when write_addr(1 downto 0) = "00" else
				plus_one_addr;
	addri_1_1 <= read_addr(9 downto 2) when buf_select = '0' else
				write_addr(9 downto 2) when write_addr(1 downto 0) = "00" or write_addr(1 downto 0) = "01" else
				plus_one_addr;
	addri_1_2 <= read_addr(9 downto 2) when buf_select = '0' else
				plus_one_addr when write_addr(1 downto 0) = "11" else
				write_addr(9 downto 2);
	addri_1_3 <= read_addr(9 downto 2) when buf_select = '0' else
				write_addr(9 downto 2);
------------------------------------------------------
	we0_0 <= '1' when buf_select = '0'  and di_0 /= "1111" else '0';
	we0_1 <= '1' when buf_select = '0'  and di_1 /= "1111" else '0';
	we0_2 <= '1' when buf_select = '0'  and di_2 /= "1111" else '0';
	we0_3 <= '1' when buf_select = '0'  and di_3 /= "1111" else '0';
	we1_0 <= '1' when buf_select = '1'  and di_0 /= "1111" else '0';
	we1_1 <= '1' when buf_select = '1'  and di_1 /= "1111" else '0';
	we1_2 <= '1' when buf_select = '1'  and di_2 /= "1111" else '0';
	we1_3 <= '1' when buf_select = '1'  and di_3 /= "1111" else '0';
------------------------------------------------------

	do <=  doo_0_0 when buf_select = '1' and read_addr(1 downto 0) = "00" else
		   doo_0_1 when buf_select = '1' and read_addr(1 downto 0) = "01" else
		   doo_0_2 when buf_select = '1' and read_addr(1 downto 0) = "10" else
		   doo_0_3 when buf_select = '1' and read_addr(1 downto 0) = "11" else
		   doo_1_0 when buf_select = '0' and read_addr(1 downto 0) = "00" else
		   doo_1_1 when buf_select = '0' and read_addr(1 downto 0) = "01" else	
		   doo_1_2 when buf_select = '0' and read_addr(1 downto 0) = "10" else
		   doo_1_3;
------------------------------------------------------
	di_0 <= di(15 downto 12) when write_addr(1 downto 0) = "00" and flip = '0' else
			di( 3 downto  0) when write_addr(1 downto 0) = "01" and flip = '0' else
			di( 7 downto  4) when write_addr(1 downto 0) = "10" and flip = '0' else
			di(11 downto  8) when write_addr(1 downto 0) = "11" and flip = '0' else
			di( 3 downto  0) when write_addr(1 downto 0) = "00" and flip = '1' else
			di(15 downto 12) when write_addr(1 downto 0) = "01" and flip = '1' else
			di(11 downto  8) when write_addr(1 downto 0) = "10" and flip = '1' else
			di( 7 downto  4);

	di_1 <= di(11 downto  8) when write_addr(1 downto 0) = "00" and flip = '0' else
			di(15 downto 12) when write_addr(1 downto 0) = "01" and flip = '0' else
			di( 3 downto  0) when write_addr(1 downto 0) = "10" and flip = '0' else
			di( 7 downto  4) when write_addr(1 downto 0) = "11" and flip = '0' else
			di( 7 downto  4) when write_addr(1 downto 0) = "00" and flip = '1' else
			di( 3 downto  0) when write_addr(1 downto 0) = "01" and flip = '1' else
			di(15 downto 12) when write_addr(1 downto 0) = "10" and flip = '1' else
			di(11 downto  8);
			
	di_2 <= di( 7 downto  4) when write_addr(1 downto 0) = "00" and flip = '0' else
			di(11 downto  8) when write_addr(1 downto 0) = "01" and flip = '0' else
			di(15 downto 12) when write_addr(1 downto 0) = "10" and flip = '0' else
			di( 3 downto  0) when write_addr(1 downto 0) = "11" and flip = '0' else
			di(11 downto  8) when write_addr(1 downto 0) = "00" and flip = '1' else
			di( 7 downto  4) when write_addr(1 downto 0) = "01" and flip = '1' else
			di( 3 downto  0) when write_addr(1 downto 0) = "10" and flip = '1' else
			di(15 downto 12);
			
	di_3 <= di( 3 downto  0) when write_addr(1 downto 0) = "00" and flip = '0' else
			di( 7 downto  4) when write_addr(1 downto 0) = "01" and flip = '0' else
			di(11 downto  8) when write_addr(1 downto 0) = "10" and flip = '0' else
			di(15 downto 12) when write_addr(1 downto 0) = "11" and flip = '0' else
			di(15 downto 12) when write_addr(1 downto 0) = "00" and flip = '1' else
			di(11 downto  8) when write_addr(1 downto 0) = "01" and flip = '1' else
			di( 7 downto  4) when write_addr(1 downto 0) = "10" and flip = '1' else
			di( 3 downto  0);
--------------------------------------------------------

process(clk)
begin
	if rising_edge(clk) then
		dii_0 <= di_0;
		dii_1 <= di_1;
		dii_2 <= di_2;
		dii_3 <= di_3;
		color_tablei <= color_table;
		
--		addri_0_0 <= addr_0_0;
--		addri_0_1 <= addr_0_1;
--		addri_0_2 <= addr_0_2;
--		addri_0_3 <= addr_0_3;
--		addri_1_0 <= addr_1_0;
--		addri_1_1 <= addr_1_1;
--		addri_1_2 <= addr_1_2;
--		addri_1_3 <= addr_1_3;
		
		wei0_0 <= we0_0;
		wei0_1 <= we0_1;
		wei0_2 <= we0_2;
		wei0_3 <= we0_3;
		wei1_0 <= we1_0;
		wei1_1 <= we1_1;
		wei1_2 <= we1_2;
		wei1_3 <= we1_3;
		
		doo_0_0 <= do_0_0;
		doo_0_1 <= do_0_1;
		doo_0_2 <= do_0_2;
		doo_0_3 <= do_0_3;
		doo_1_0 <= do_1_0;
		doo_1_1 <= do_1_1;
		doo_1_2 <= do_1_2;
		doo_1_3 <= do_1_3;
	end if;
end process;
--------------------------------------------------------
	LINE_BUF_0_0 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei0_0,		a	=> addri_0_0 ,
		di(3 downto 0)=> dii_0, di(6 downto 4) => color_tablei,
		do	=>	do_0_0 );
	LINE_BUF_0_1 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei0_1,		a	=> addri_0_1,
		di(3 downto 0)=> dii_1, di(6 downto 4) => color_tablei,
		do	=>	do_0_1 );
	LINE_BUF_0_2 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei0_2,		a	=> addri_0_2,
		di(3 downto 0)=> dii_2, di(6 downto 4) => color_tablei,
		do	=>	do_0_2 );
	LINE_BUF_0_3 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei0_3,		a	=> addri_0_3,
		di(3 downto 0)=> dii_3, di(6 downto 4) => color_tablei,
		do	=>	do_0_3 );	
--------------------------------------------------------
	LINE_BUF_1_0 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei1_0,		a	=> addri_1_0,
		di(3 downto 0)=> dii_0, di(6 downto 4) => color_tablei,
		do	=>	do_1_0 );
	LINE_BUF_1_1 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei1_1,		a	=> addri_1_1,
		di(3 downto 0)=> dii_1, di(6 downto 4) => color_tablei,
		do	=>	do_1_1);
	LINE_BUF_1_2 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei1_2,		a	=> addri_1_2,
		di(3 downto 0)=> dii_2, di(6 downto 4) => color_tablei,
		do	=>	do_1_2);
	LINE_BUF_1_3 : entity work.line_buf port map(
		clk	=> clk ,	we	=> wei1_3,		a	=> addri_1_3,
		di(3 downto 0)=> dii_3, di(6 downto 4) => color_tablei,
		do	=>	do_1_3 );	
end rtl;

