library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity buf is
port(
	-- interface with CPU
	address   : in std_logic_vector(15 downto 0);-- higher 4 bit is sprite index, lower 6 bit is ROM number
	writedata : in unsigned(31 downto 0);-- higher 10 bit is y value, lower 10 bit is x value
	write     : in std_logic;
	reset     : in std_logic;
	clk_50    : in std_logic;
	irq_out   : out std_logic;
	
	-- interface with sprite controller
	address_out   : out std_logic_vector(15 downto 0);-- higher 4 bit is sprite index, lower 6 bit is ROM number
	writedata_out : out unsigned(31 downto 0);-- higher 10 bit is y value, lower 10 bit is x value
	write_out     : out std_logic;
	reset_out     : out std_logic;
	clk_50_out    : out std_logic;
	irq           : in std_logic
	);
end buf;

architecture bypass of buf is
begin
	address_out <= address;
	writedata_out <= writedata;
	write_out <= write;
	reset_out <= reset;
	clk_50_out <= clk_50;
	irq_out <= irq;
end bypass;
