library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity lab3 is
  
  port (
    signal CLOCK_50 : in std_logic;                -- 50 MHz clock
    signal LEDR : out std_logic_vector(17 downto 0); -- Red LEDs

    -- PS/2 port
    PS2_DAT,                    -- Data
    PS2_CLK : in std_logic;     -- Clock

    --  Ethernet Interface    
    ENET_DATA : inout std_logic_vector(15 downto 0);    -- DATA bus 16Bits
    ENET_CMD,           -- Command/Data Select, 0 = Command, 1 = Data
    ENET_CS_N,                                          -- Chip Select
    ENET_WR_N,                                          -- Write
    ENET_RD_N,                                          -- Read
    ENET_RST_N,                                         -- Reset
    ENET_CLK : out std_logic;                           -- Clock 25 MHz
    ENET_INT : in std_logic;                            -- Interrupt

    -- Audio CODEC
    
    AUD_ADCLRCK : inout std_logic;                      -- ADC LR Clock
    AUD_ADCDAT : in std_logic;                          -- ADC Data
    AUD_DACLRCK : inout std_logic;                      -- DAC LR Clock
    AUD_DACDAT : out std_logic;                         -- DAC Data
    AUD_BCLK : inout std_logic;                         -- Bit-Stream Clock
    AUD_XCK : out std_logic;                            -- Chip Clock


    SRAM_DQ : inout std_logic_vector(15 downto 0); -- Data bus 16 Bits
    SRAM_ADDR : out std_logic_vector(17 downto 0); -- Address bus 18 Bits
    SRAM_UB_N,                                     -- High-byte Data Mask
    SRAM_LB_N,                                     -- Low-byte Data Mask
    SRAM_WE_N,                                     -- Write Enable
    SRAM_CE_N,                                     -- Chip Enable
    SRAM_OE_N : out std_logic                      -- Output Enable
    );
  
end lab3;

architecture rtl of lab3 is
  
  signal clk25 : std_logic := '0';
  signal counter : unsigned(15 downto 0);
  signal reset_n : std_logic;
  --signal keyHandlerIrq: std_logic;
  signal audio_request : std_logic;
  
begin

  LEDR(17) <= '1';
  LEDR(16) <= '1';

  process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
      clk25 <= not clk25;
    end if;
  end process;

  ENET_CLK <= clk25;
  AUD_XCK <= clk25; 

  process (CLOCK_50)
  begin
    if rising_edge(CLOCK_50) then
      if counter = x"ffff" then
        reset_n <= '1';
      else
        reset_n <= '0';
        counter <= counter + 1;
      end if;
    end if;
  end process;

  nios : entity work.nios_system port map (

    -- the_de2_ps2_inst
    PS2_Clk_to_the_de2_ps2_inst  => PS2_CLK,
    PS2_Data_to_the_de2_ps2_inst => PS2_DAT,

    ENET_CMD_from_the_DM9000A => ENET_CMD,
    ENET_CS_N_from_the_DM9000A => ENET_CS_N,
    ENET_DATA_to_and_from_the_DM9000A => ENET_DATA,
    ENET_INT_to_the_DM9000A => ENET_INT,
    ENET_RD_N_from_the_DM9000A => ENET_RD_N,
    ENET_RST_N_from_the_DM9000A => ENET_RST_N,
    ENET_WR_N_from_the_DM9000A => ENET_WR_N,

    AUD_ADCDAT_to_the_audio_inst => AUD_ADCDAT,
    AUD_ADCLRCK_from_the_audio_inst=> AUD_ADCLRCK,
    AUD_BCLK_to_and_from_the_audio_inst=> AUD_BCLK,
    AUD_DACDAT_from_the_audio_inst =>AUD_DACDAT,
    AUD_DACLRCK_from_the_audio_inst =>AUD_DACLRCK,

    audio_request_from_the_audio_inst => audio_request,

    clk_to_the_audio_inst => clk25,
    data_to_the_audio_inst => "0000000000000000",
    reset_n_to_the_audio_inst => '1',
    test_mode_to_the_audio_inst => '0',



    clk                          => CLOCK_50,
    reset_n                      => reset_n,
    --leds_from_the_leds           => LEDR(15 downto 0),
    SRAM_ADDR_from_the_sram      => SRAM_ADDR,
    SRAM_CE_N_from_the_sram      => SRAM_CE_N,
    SRAM_DQ_to_and_from_the_sram => SRAM_DQ,
    SRAM_LB_N_from_the_sram      => SRAM_LB_N,
    SRAM_OE_N_from_the_sram      => SRAM_OE_N,
    SRAM_UB_N_from_the_sram      => SRAM_UB_N,
    SRAM_WE_N_from_the_sram      => SRAM_WE_N
    );

end rtl;
