-- Shangru Li
-- 
-- This component is basically a 26-bit counter
--
-- When the counter is 1, irq will be '1'
-- The irq is reset to '0' by the cpu, when the cpu wants to write to this
-- component, the irq will become '0'
--
-- The address, readdata, and writedata are effectively ignored

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity irTimer is port (
  clk, reset_n, chipselect, read, write, address : in std_logic;
  readdata  : out std_logic_vector(15 downto 0);
  writedata : in  std_logic_vector(15 downto 0);
  irq       : out std_logic);
end irTimer;

architecture rtl of irTimer is 
  signal data    : std_logic_vector(15 downto 0);
  signal counter : unsigned(21 downto 0);
begin
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        data <= (others => '0');
      else
        if chipselect = '1' then
          if address = '1' then
            if write = '1' then
              data <= writedata;
            elsif read = '1' then
              readdata <= data;
            end if;
          end if;
        end if;
      end if;
    end if;
  end process;
  
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        counter <= (others => '0');
      else
        counter <= counter +1 ;
      end if;
    end if;
  end process;
    
  process (clk)
  begin
    if rising_edge(clk) then
      if reset_n = '0' then
        irq <= '0';
      else
        if counter = 1 then
          irq <= '1';
        elsif write = '1' and chipselect = '1' then
          irq <= '0';  -- important to reset the irq
        end if;
      end if;
    end if;
  end process;
  
end rtl;


