library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_sram_controller is
  
  port (
	clk	:	in std_logic;

    signal chipselect : in std_logic;
    signal write, read : in std_logic;
    signal address  :  in std_logic_vector(17 downto 0);
    signal readdata : out std_logic_vector(15 downto 0);
    signal writedata : in std_logic_vector(15 downto 0);
    signal byteenable : in std_logic_vector(1 downto 0);

	signal user_addr_in : in std_logic_vector(18 downto 0);
	signal user_data_out : out std_logic_vector(7 downto 0);

    signal SRAM_DQ   : inout std_logic_vector(15 downto 0);
    signal SRAM_ADDR : out std_logic_vector(17 downto 0);
    signal SRAM_UB_N, SRAM_LB_N : out std_logic;
    signal SRAM_WE_N, SRAM_CE_N : out std_logic;
    signal SRAM_OE_N            : out std_logic
    );
  
end de2_sram_controller;

architecture dp of de2_sram_controller is
begin

  process(chipselect)
  begin
	if chipselect = '1' then
		if write = '1' then
			SRAM_DQ <= writedata;
		else
			SRAM_DQ <= (others => 'Z');
		end if;
		readdata <= SRAM_DQ;
		SRAM_ADDR <= address;
		SRAM_UB_N <= not byteenable(1);
		SRAM_LB_N <= not byteenable(0);
		SRAM_WE_N <= not write;
		SRAM_CE_N <= not chipselect;
		SRAM_OE_N <= not read;
	else
		SRAM_DQ <= (others => 'Z');
		if user_addr_in(0) = '1' then
			user_data_out <= SRAM_DQ(15 downto 8);
		else
			user_data_out <= SRAM_DQ(7 downto 0);
		end if;
		SRAM_ADDR <= user_addr_in(18 downto 1);
		SRAM_UB_N <= '0';
		SRAM_LB_N <= '0';
		SRAM_WE_N <= '1';
		SRAM_CE_N <= '0';
		SRAM_OE_N <= '0';
	end if;
  end process;

end dp;
