#ifndef VGA_IF_H
#define VGA_IF_H

#include <system.h>
#include "sprite16_data.h"
#include "sprite32_data.h"

#define WRITE_RAM(offset, data) \
    IOWR_16DIRECT(VGA_BASE, offset << 1, data)
#define READ_RAM(offset) \
    IORD_16DIRECT(VGA_BASE, offset << 1 )

struct sprite_data
{
    unsigned short data     : 7;
    unsigned short set_rt   : 1;
    unsigned short set_fl   : 1;
    unsigned short set_hl   : 1;
    unsigned short pd       : 6;
};

int load_sprites_32();
int load_sprites_16();
unsigned short changeTile32(int y, int x, int spriteno, int rot, int flip, int inv);
unsigned short changeTile16(int y, int x, int spriteno, int rot, int flip, int inv);
unsigned short read_sprite_32(int x, int y);
unsigned short read_sprite_16(int x, int y);
void invert32(int x, int y);
void invert16(int x, int y);


#endif
