#include "basic_io.h"
#include "DM9000A.h"
#include "ethernet.h"

#include <stdio.h>
#include <system.h>
#include <io.h>
#include <string.h>
//#include "sprite16_data.h"
//#include "sprite32_data.h"
#include "vga_if.h"
#include "ethernet.h"
#include "DM9000A.h"
//unsigned char mac_address[6] = { 0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F  };
//unsigned int interrupt_number;
//extern void ethernet_interrupt_handler();
//extern unsigned short transmit_checksum;

unsigned char code;
unsigned char keyflag = 0;
int display32[15][12][4];
int display16[30][16][4];

int playerScore = 0;
int opponentScore = 0 ;
int turn = 0;
int cursorX = 0;
int cursorY = 0;
int displaySetting = 0; //0 = player ships big, opponent ships small;  1 = opponent ships big, player ships small
int exitGame = 0;  //0 = keep going, 1 = exit game
int exitPlayer = 1; //0 = Keep same player, 1 = New player
int exitRound = 0;  //0 = keep going, 1 = exit round
char* playerName = "Your Name  ";
char* opponentName = "Their Name ";
int patrolboatleft = 2;
int submarineleft = 3;
int destroyerleft = 3;
int battleshipleft = 4;
int carrierleft = 5;

int receivedMessageFlag = 0;

#define MAX_MSG_LENGTH 128
#define IP_LENGTH_OFFSET 16
#define UDP_PACKET_PAYLOAD_OFFSET 42
#define UDP_PACKET_LENGTH_OFFSET 38
#define UDP_PACKET_PAYLOAD (transmit_buffer + UDP_PACKET_PAYLOAD_OFFSET)
#define IP_HEADER_CHECKSUM_OFFSET 24
#define IP_PACKET_ID_OFFSET 18
#define IP_DESTINATION_ADDRESS_OFFSET 30
int jjj = 1;

// Ethernet MAC address.  Choose the last three bytes yourself
unsigned char mac_address[6] = { 0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F  };
unsigned int interrupt_number;
// MOVED TO MAIN()

unsigned char ip_address[4] = { 0xc0, 0xa8, 0x01, 0x02 };

unsigned int receive_buffer_length = 0;
unsigned char receive_buffer[1600];
char receivedMessage[1600];
unsigned short transmit_checksum;
unsigned short receive_checksum;

char* pointer_to_transmit_buffer;
char* pointer_to_receive_buffer;

unsigned short packet_id = 0x0000;

// CHECKSUM FUNCTION -----------------------------------------
static unsigned short udp_everyPacket_computeChecksum(char* buffer){
    int access;
    unsigned int checksum = 0x00000000;
    
    for (access = 14; access < 34; access++) { // ip header from byte 14 to 33 inclusive
        if(access != IP_HEADER_CHECKSUM_OFFSET) {
            checksum = checksum + ((((int)buffer[access]) << 8) & 0x0000ff00); //msb
           // printf("\n+%x", ((((int)buffer[access]) << 8) & 0x0000ff00));
            access++;
            checksum = checksum + (((int)buffer[access]) & 0x000000ff); //lsb
            //printf("\n+%x", (((int)buffer[access]) & 0x000000ff));
            /* this adds to check sum the following:
            assume buffer[22] = 0x80 and buffer[23] = 0x11
            then (buffer[22] << 8) = 0x8000 */
        } else{
            access++; // since checksum is 2 bytes long, this skips checksum_offset + 1 also :)
        }
        // ignore the check sum fields (24-25) :)
    }
    
    //printf("\nCheck: %x", checksum);                            
    checksum = (checksum & 0x0FFFF) + ((checksum & 0xF0000) >> 16); // 2's complement
    //printf("\n2comp: %x", checksum);
    checksum = ~checksum; // 1's complement
   // printf("\n1comp: %x", checksum);
    //printf("\nshort: %x", (short)checksum);

    return (short)checksum;
}

// TRANSMIT BUFFER ----------------------------------------- // from Lab 2
unsigned char arp_buffer[] = {
  // Ethernet MAC header
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Destination MAC address (must be upadated)
  0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F, // Source MAC address 
  
  0x08, 0x06, // ARP packet type
  
  0x00, 0x01, // Hardware Type = ethernet 0x0001
  0x08, 0x00, // Protocol Type = IP (0x0800)
  0x06, 0x04, // 6 bytes for MAC address, 4 bytes for IP address
  0x00, 0x02, // 0x0002 indicates an ARP reply
  0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F, // my MAC (again!)
  0xc0,0xa8,0x01,0x01, // our IP
  0xC8, 0x2A, 0x14, 0x37, 0xCA, 0x8A, // destination, must be updated too
  0xc0,0xa8,0x01,0x02 // STATIC
};

unsigned char transmit_buffer[] = {
  // Ethernet MAC header
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // Destination MAC address
  0x01, 0x60, 0x6E, 0x11, 0x02, 0x0F, // Source MAC address ----------------------
  // MUST WRITE FUCN TO ALLOW USER TO MANUALLY INPUT MAC/IP ADDRESSES ------------
  // -----------------------------------------------------------------------------
  // -----------------------------------------------------------------------------
  0x08, 0x00,                         // Packet Type: 0x800 = IP
                          
  // IP Header
  0x45,                // version (IPv4), header length = 20 bytes
  0x00,                // differentiated services field
  0x00,0x9C,           // total length: 20 bytes for IP header +
                       // 8 bytes for UDP header + bytes of payload
  0x00, 0x00,          // packet ID
  0x00,                // flags
  0x00,                // fragment offset
  0x80,                // time-to-live
  0x11,                // protocol: 11 = UDP
  0x00,0x00,           // header checksum // initially 0x0000
  0xc0,0xa8,0x01,0x01, // source IP address
  0xc0,0xa8,0x01,0x02, // destination IP address
                          
  // UDP Header
  0x13,0x8D, // source port port (5005)
  0x13,0x8D, // destination port (5005)
  0x00,0x88, // length (136: 8 for UDP header + data)
  0x00,0x00, // checksum: 0 = none
                          
  // UDP payload
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67,
  0x74, 0x65, 0x73, 0x74, 0x20, 0x6d, 0x73, 0x67
}; 

// SETTING PKT LENGTH -----------------------------------------
void udp_everyPacket_setPacketLength(unsigned int packet_length){
  // sets the length field of Ethernet appropriately
  transmit_buffer[IP_LENGTH_OFFSET] = (20 + 8 + packet_length) >> 8;
  transmit_buffer[IP_LENGTH_OFFSET + 1] = (20 + 8 + packet_length) & 0xff;
  
  // sets the length field of UDP appropriately
  transmit_buffer[UDP_PACKET_LENGTH_OFFSET] = (8 + packet_length) >> 8;
  transmit_buffer[UDP_PACKET_LENGTH_OFFSET + 1] = (8 + packet_length) & 0xff;
  return;
}

// SETTING PACKET ID -----------------------------------------
void udp_everyPacket_setPacketID(){
   // include packet id
   packet_id = (packet_id + 1) & 0xffff; // maintian it 2 bytes long
   transmit_buffer[IP_PACKET_ID_OFFSET] = packet_id >> 8;
   transmit_buffer[IP_PACKET_ID_OFFSET + 1] = packet_id & 0x00ff;
   return;
}

void udp_everyPacket_setChecksum(char* buffer, unsigned int checksum){
    // include checksum
    buffer[IP_HEADER_CHECKSUM_OFFSET] = (checksum & 0x0000ffff) >> 8; // msb
    buffer[IP_HEADER_CHECKSUM_OFFSET + 1] = checksum & 0x000000ff; // lsb
    return;
}

// FROMING ATTACK LAUNCH PKT -----------------------------------------
/*unsigned int udp_formPacket_myAttack_coordinates(unsigned short X, unsigned short Y){
  // UDP_PACKET_PAYLOAD[0] indicates purpose of packet
  
  transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 0] = 'A'; // A stands for send my attaaaack!!!
  
  transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 1] = 'X';
  if(X == 0) { // int 0 terminates UDP packet!
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 2] = 'Z'; // Z for Zero, or Zoro! :)
  } else {
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 2] = 'e';
  }
  transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 3] = 'Y';
  if(Y == 0) {
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 4] = 'Z';
  } else {
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 4] = 'f';
  }
  transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + 5] = 0; // termination character
  
  unsigned short packet_length;
  packet_length = 6;

 return packet_length;
}*/

//////////////////////
//////char* receivePacket(){ ////// NAME IS ALREADY USED CHAAAANGEEEE!!!!
//////    //while (receive_buffer_length == 0){
//////        //Wait for a packet
//////    //}
//////    //receive_buffer_length = 0;
//////    return receive_buffer;
//////}

// RECEIVING ETHERNET UDP MSGS -----------------------------------------
//static void ethernet_interrupt_handler() {
static void ethernet_interrupt_handler() {
  unsigned int receive_status;

//if(jjj == 1){
//    TransmitPacket(arp_buffer, 42); /////////////// remove later
//    jjj = 0;
//}

//while(1){
  receive_status = ReceivePacket(receive_buffer, &receive_buffer_length);
// TransmitPacket(arp_buffer, 42);
  if (receive_status == DMFE_SUCCESS) {
    //printf("receive_buffer_length : %x\n", receive_buffer_length);
    
    if (receive_buffer_length >= 14) {
      //  A real Ethernet packet
      if ((receive_buffer[12] == 8 && receive_buffer[13] == 0 &&
      receive_buffer_length >= 34)) {
    // An IP packet
    if ((receive_buffer[23] == 0x11)){
      // A UDP packet
      if (receive_buffer_length >= UDP_PACKET_PAYLOAD_OFFSET) {
        receivedMessageFlag = 1;
        int i; //printf("\n\nReceived:\n");
        for(i = 0; i < receive_buffer_length; i++){
            //printf("%x\t", receive_buffer[i]);
            if ((i+1) % 8 == 0){
             //printf("\n");
            } 
        }
        printf("\n\nMessage Received: ");
        //char* message_received = "";

        char* message_received = receive_buffer + UDP_PACKET_PAYLOAD_OFFSET;
        
        //sprintf(message_received, "%s", packet_message);
        //printf("%x\n", message_received[0]);
        printf("%s", message_received); printf("\n");
        
        //printf("\nReceived: %x\n",
         //  receive_buffer + UDP_PACKET_PAYLOAD_OFFSET);
         // get checksum for ip header
          pointer_to_receive_buffer = &receive_buffer[0];
          receive_checksum = udp_everyPacket_computeChecksum(pointer_to_receive_buffer);
           // verify checksum to determine weather to print to screen or discard
          if( ((receive_checksum >> 8) == (receive_buffer[IP_HEADER_CHECKSUM_OFFSET]))
            && ((receive_checksum & 0x00ff) == (receive_buffer[IP_HEADER_CHECKSUM_OFFSET+1])) )
            {
                //printf("\nChecksum OK");
            }
            else {
                //printf("\nChecksum test failed. Message ignored.\n");
            }
        
      }
    } else {
      //printf("\nReceived non-UDP packet\n");
    }
      } else {
    //printf("\nReceived non-IP packet\n");
        TransmitPacket(arp_buffer, 42);
        printf("\nARP reply sent.\n");
      }
    } else {
      //printf("Malformed Ethernet packet\n");
    }

  } else {
    //printf("Error receiving packet\n");
   // break;
  }
//}

  /* Clear the DM9000A ISR: PRS, PTS, ROS, ROOS 4 bits, by RW/C1 */
  dm9000a_iow(ISR, 0x3F);
              
  /* Re-enable DM9000A interrupts */
  dm9000a_iow(IMR, INTR_set);
}


char* receivePacket(){
    int i;
    while(receivedMessageFlag == 0){
           
    }
    for(i = UDP_PACKET_PAYLOAD_OFFSET; i < receive_buffer_length; i++)
        receivedMessage[i - UDP_PACKET_PAYLOAD_OFFSET] = receive_buffer[i];
    printf("receivePacket function returns: %s\n", receivedMessage);
    receivedMessageFlag = 0;
    return receivedMessage;
}

void sendPacket(char* message){
//This sends a UDP packet with the string message as the payload to the recipient at IPADDRESS 

  unsigned int message_length = 0;
  unsigned int packet_checksum;
    
   transmit_buffer[IP_DESTINATION_ADDRESS_OFFSET + 0] = ip_address[0];
   transmit_buffer[IP_DESTINATION_ADDRESS_OFFSET + 1] = ip_address[1];
   transmit_buffer[IP_DESTINATION_ADDRESS_OFFSET + 2] = ip_address[2];
   transmit_buffer[IP_DESTINATION_ADDRESS_OFFSET + 3] = ip_address[3];

   while(message[message_length] != '\0'){
    transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + message_length] = message[message_length];
    message_length++;
   }
   transmit_buffer[UDP_PACKET_PAYLOAD_OFFSET + message_length] = '\0';
   message_length++;
   
       // Set Packet ID
    udp_everyPacket_setPacketID();

    // Set Packet Length
    udp_everyPacket_setPacketLength(message_length);

    // get checksum for ip header
    pointer_to_transmit_buffer = &transmit_buffer[0];
    packet_checksum = udp_everyPacket_computeChecksum(pointer_to_transmit_buffer);
    udp_everyPacket_setChecksum(pointer_to_transmit_buffer, packet_checksum);
    /////////////////////////
     int j; printf("\n"); for (j = 0; j < 14 + 20 + 8 + message_length; j++){ // 14 ethernet, 20 ip, 8 udp headers
     //printf("%x\t",transmit_buffer[j]);  
     if ((j+1) % 6 == 0){
     //printf("\n");
     } 
    } //////////////////////////
    
    if (TransmitPacket(transmit_buffer, message_length + 14 + 20 + 8)==DMFE_SUCCESS) { 
        printf("\nMessage sent successfully");
    } else {
        printf("\nMessage sending failed\n"); 
    }
}

char* getInput()
{
    //printf("Getting Keystroke");
    int valid = 0;
    char* input_string;
    while (valid == 0){
        while(!IORD_8DIRECT(PS2_BASE, 0));
            //printf("polled status is %x \n" , IORD_8DIRECT(PS2_BASE, 0));
        //printf("Got Keystroke!");
        code = IORD_8DIRECT(PS2_BASE,4);
        //printf("scan code is %x\n", code);  
        
        
       //if (is_my_turn == 1)  {
        switch(code)
        {
            case 0x1C: // A
              if (keyflag == 0){
                valid = 1;
                input_string ="A"; 
              }
              keyflag = 0;
              break;
            case 0x32: // B
              if (keyflag == 0){
                valid = 1;
                input_string ="B"; 
              }
              keyflag = 0;
              break;
            case 0x21: // C
              if (keyflag == 0){
                valid = 1;
                input_string ="C"; 
              }
              keyflag = 0;
              break;
            case 0x23: // D
              if (keyflag == 0){
                valid = 1;
                input_string ="D"; 
              }
              keyflag = 0;
              break;
            case 0x24: // E
              if (keyflag == 0){
                valid = 1;
                input_string ="E"; 
              }
              keyflag = 0;
              break;
            case 0x2B: // F
              if (keyflag == 0){
                valid = 1;
                input_string ="F"; 
              }
              keyflag = 0;
              break;
            case 0x34: // G
              if (keyflag == 0){
                valid = 1;
                input_string ="G"; 
              }
              keyflag = 0;
              break;
            case 0x33: // H
              if (keyflag == 0){
                valid = 1;
                input_string ="H"; 
              keyflag = 0;
              }
              break;
            case 0x43: // I
              if (keyflag == 0){
                valid = 1;
                input_string ="I"; 
              }
              keyflag = 0;
              break;
            case 0x3B: // J
              if (keyflag == 0){
                valid = 1;
                input_string ="J"; 
              }
              keyflag = 0;
              break;
            case 0x42: // K
              if (keyflag == 0){
                valid = 1;
                input_string ="K"; 
              }
              keyflag = 0;
              break;
            case 0x4B: // L
              if (keyflag == 0){
                valid = 1;
                input_string ="L"; 
              }
              keyflag = 0;
              break;
            case 0x3A: // M
              if (keyflag == 0){
                valid = 1;
                input_string ="M"; 
              }
              keyflag = 0;
              break;
             case 0x31: // N
              if (keyflag == 0){
                valid = 1;
                input_string ="N"; 
              }
              keyflag = 0;
              break;
             case 0x44: // O
              if (keyflag == 0){
                valid = 1;
                input_string ="O"; 
              }
              keyflag = 0;
              break;
             case 0x4D: // P
              if (keyflag == 0){
                valid = 1;
                input_string ="P"; 
              }
              keyflag = 0;
              break;
              case 0x15: // Q
              if (keyflag == 0){
                valid = 1;
                input_string ="Q"; 
              }
              keyflag = 0;
              break;
             case 0x2D: // R
              if (keyflag == 0){
                valid = 1;
                input_string ="R"; 
              }
              keyflag = 0;
              break;
              case 0x1B: // S
              if (keyflag == 0){
                valid = 1;
                input_string ="S"; 
              }
              keyflag = 0;
              break;
              case 0x2C: // T
              if (keyflag == 0){
                valid = 1;
                input_string ="T"; 
              }
              keyflag = 0;
              break;
              case 0x3C: // U
              if (keyflag == 0){
                valid = 1;
                input_string ="U"; 
              }
              keyflag = 0;
              break;
             case 0x2A: // V
              if (keyflag == 0){
                valid = 1;
                input_string ="V"; 
              }
              keyflag = 0;
              break;
             case 0x1D: // W
              if (keyflag == 0){
                valid = 1;
                input_string ="W"; 
              }
              keyflag = 0;
              break;
             case 0x22: // X
              if (keyflag == 0){
                valid = 1;
                input_string ="X"; 
              }
              keyflag = 0;
              break;    
              case 0x35: // Y
              if (keyflag == 0){
                valid = 1;
                input_string ="Y"; 
              }
              keyflag = 0;
              break;
              case 0x1A: // Z
              if (keyflag == 0){
                valid = 1;
                input_string ="Z"; 
              }
              keyflag = 0;
              break;
          
            case 0x45: // 0
              if (keyflag == 0){
                valid = 1;
                input_string ="0"; 
              }
              keyflag = 0;
              break;
            case 0x16: // 1
              if (keyflag == 0){
                valid = 1;
                input_string ="1"; 
              }
              keyflag = 0;
              break;
            case 0x1E: // 2
              if (keyflag == 0){
                valid = 1;
                input_string ="2"; 
              }
              keyflag = 0;
              break;
            case 0x26: // 3
              if (keyflag == 0){
                valid = 1;
                input_string ="3"; 
              }
              keyflag = 0;
              break;
            case 0x25: // 4
              if (keyflag == 0){
                valid = 1;
                input_string ="4"; 
              }
              keyflag = 0;
              break;
            case 0x2E: // 5
              if (keyflag == 0){
                valid = 1;
                input_string ="5";
              } 
              keyflag = 0;
              break;
            case 0x36: // 6
              if (keyflag == 0){
                valid = 1;
                input_string ="6"; 
              }
              keyflag = 0;
              break;
            case 0x3D: // 7
              if (keyflag == 0){
                valid = 1;
                input_string ="7"; 
              }
              keyflag = 0;
              break;
            case 0x3E: // 8
              if (keyflag == 0){
                valid = 1;
                input_string ="8"; 
              }
              keyflag = 0;
              break;
            case 0x46: // 9
              if (keyflag == 0){
                valid = 1;
                input_string ="9"; 
              }
              keyflag = 0;
              break;
              case 0x29: // Space
              if (keyflag == 0){
                valid = 1;
                input_string =" "; 
              }
              keyflag = 0;
              break;
               case 0x66: // Back Space
              if (keyflag == 0){
                valid = 1;
                input_string ="BackSpace"; 
              }
              keyflag = 0;
              break;
            case 0x6B: // LEFT Key
            if (keyflag == 1){
                valid = 1;
                input_string ="Left"; 
              } // ELSE DO NOTHING
             keyflag = 0;
              break;
            case 0x74: // RIGHT Key
            if (keyflag == 1){
                valid = 1;
                input_string ="Right"; 
              } // ELSE DO NOTHING
              
            keyflag = 0;
              break;
            case 0x75: // UP Key
            if (keyflag == 1){
                valid = 1;
                input_string ="Up";    
            }
            keyflag = 0;
              break;
            case 0x72: //DOWN
            if (keyflag == 1){
                valid = 1;
                input_string ="Down";   
            }
            keyflag = 0;
              break;
            case 0x5A:
            if (keyflag == 0)
            {
                valid = 1;
                input_string ="Return"; 
    
            }
            keyflag = 0;
            break;
            case 0x76: //escape
                if (keyflag == 0){
                    valid = 1;
                    input_string ="Escape";
                }
                keyflag = 0;
            break;
            
            case 0xE0 :
              keyflag = 1;
              input_string = "";
            break;
            case 0xF0 :
              keyflag = 2;
              input_string = "";
            break;
           default:
                keyflag = 0;
              // ILLEGAL GAME KEY
              // DO NOT CHANGE TARGET
              break;
        }
    }
   //}
    return input_string;
}


struct sprite_addr_type
{
    unsigned short data     : 7;
    unsigned short set_rt   : 1;
    unsigned short set_fl   : 1;
    unsigned short set_hl   : 1;
    unsigned short pd       : 6;
};

#define sprite_addr \
    struct sprite_addr_type;
/*
#define WRITE_RAM(offset, data) \
    IOWR_16DIRECT(VGA_BASE, offset << 1, data)
#define READ_RAM(offset) \
    IORD_16DIRECT(VGA_BASE, offset << 1 )
*/



int load_sprites_32()
{
    int i;
    for(i = 0; i < SPRITE_32_LEN; i++)
    {
        IOWR_8DIRECT(SRAM_BASE, i, sprite_32_data[i]);
    }
    return 0;
}

int load_sprites_16()
{
    int i;
    for(i = 0; i < SPRITE_16_LEN; i++)
    {
        IOWR_8DIRECT(SRAM_BASE, i + 0x20000, sprite_16_data[i]);
    }
    return 0;
}

unsigned short changeTile32(int y, int x, int spriteno, int rot, int flip, int inv)
{
    display32[y][x][0] = spriteno;
    display32[y][x][1] = rot;
    display32[y][x][2] = flip;
    display32[y][x][3] = inv;
    struct sprite_data data;
    unsigned short wdata;
    unsigned int addr;

    addr = ((y % 15) * 12) + (x % 12);
    data.data = spriteno;
    data.set_rt = rot & 1;
    data.set_fl = flip & 1;
    data.set_hl = inv & 1;
    data.pd = 0;
    
    wdata = *((unsigned short *)(&data));
    WRITE_RAM(addr, wdata);
    return wdata;
}

unsigned short changeTile16(int y, int x, int spriteno, int rot, int flip, int inv)
{
    display16[y][x][0] = spriteno;
    display16[y][x][1] = rot;
    display16[y][x][2] = flip;
    display16[y][x][3] = inv;
    struct sprite_data data;
    unsigned short wdata;
    unsigned int addr;

    addr = ((y % 30) * 16) + (x % 16) + 180;
    data.data = spriteno;
    data.set_rt = rot & 1;
    data.set_fl = flip & 1;
    data.set_hl = inv & 1;
    data.pd = 0;
    
    wdata = *((unsigned short *)(&data));
    WRITE_RAM(addr, wdata);
    return wdata;
}

unsigned short read_sprite_32(int x, int y)
{
    unsigned int addr = ((y % 15) * 12) + (x % 12);
    return READ_RAM(addr);
}

unsigned short read_sprite_16(int x, int y)
{
    unsigned int addr = ((y % 30) * 16) + (x % 16) + 180;
    return READ_RAM(addr);
}

/*unsigned short invert32(int x, int y)
{
    struct sprite_data data;
    int hl_bit;
    unsigned short wdata;
    unsigned int addr = ((y % 15) * 12) + (x % 12);
    wdata = READ_RAM(addr);
    data = *((struct sprite_data *) &wdata);
    hl_bit = data.set_hl ^ 1;
    data.set_hl = hl_bit & 1;
    
    wdata = *((unsigned short *)(&data));
    WRITE_RAM(addr, wdata);
    return wdata;
}

unsigned short invert16(int x, int y)
{
    struct sprite_data data;
    int hl_bit;
    unsigned short wdata;
    unsigned int addr = ((y % 30) * 16) + (x % 16) + 180;
    wdata = READ_RAM(addr);
    data = *((struct sprite_data *) &wdata);
    hl_bit = data.set_hl ^ 1;
    data.set_hl = hl_bit & 1;
    
    wdata = *((unsigned short *)(&data));
    WRITE_RAM(addr, wdata);
    return wdata;
}
*/

int write_sprite_data_to_memory()
{
    printf("Running write_sprite_data_to_memory()\n");
    int i;
    for(i = 0; i < SPRITE_32_LEN; i++)
    {
        IOWR_8DIRECT(SRAM_BASE, i, sprite_32_data[i]);
    }
    for(i = 0; i < SPRITE_16_LEN; i++)
    {
        IOWR_8DIRECT(SRAM_BASE, i + 0x20000, sprite_16_data[i]);
    }
    return 0;
}

int run_sprites()
{
    printf("Running run_sprites()\n");
    unsigned int addr, data, rt, fl, hl;
    unsigned int x, y;
    struct sprite_addr_type in_data;
    unsigned short wdata;
 
    for(;;)
    {
     printf("Waiting for input:");
     
      
     scanf("%d %d %d %d %d %d", &x, &y, &data, &fl, &rt, &hl);
     if(x >= 100)
        addr = y * 16 + (x % 100) + 180;
     else
        addr = y * 12 + x;
     printf("Caught: (%02d, %02d)(0x%08x)=%d\n",x, y, addr, data);
     in_data.pd = 0;
     in_data.set_hl = hl & 1;
     in_data.set_fl = fl & 1;
     in_data.set_rt = rt & 1;
     in_data.data = data & 0x1FF;
     printf("%x %d %d %d\n", in_data.data, in_data.set_rt, in_data.set_fl, in_data.set_hl);
     
     wdata = *((unsigned short *)(&in_data));
     printf("Writing %x to addr %x\n", wdata, addr);
     WRITE_RAM(addr, wdata);
     printf("You wrote %x to addr %x\n", READ_RAM(addr), addr);
    }
    return 0;
}

int run_sprites_2()
{
    printf("Running run_sprites_2()\n");
    unsigned int data, rt, fl, hl;
    unsigned int x, y, tmpx;
    unsigned short wdata;
 
    for(;;)
    {
     printf("Waiting for input:");
     
     scanf("%d %d %d %d %d %d", &x, &y, &data, &fl, &rt, &hl);
     if(x >= 100)
     {
        tmpx = x % 100;
        changeTile16(tmpx, y, data, rt, fl, hl);
        wdata = read_sprite_32(tmpx, y);
        printf("You wrote %x to 32(%d, %d)\n", wdata, tmpx, y);
     }
     else
     {
        changeTile32(x, y, data, rt, fl, hl);
        wdata = read_sprite_32(x, y);
        printf("You wrote %x to 32(%d, %d)\n", wdata, x, y);
     }

     
    }
    return 0;
}

int run_sram()
{
    printf("Running run_sram()\n");
    unsigned int wr;
    unsigned int addr = 0;
    unsigned int data = 0;
    unsigned int temp = 18;
    printf("addr = %d, data = %d\n", addr, data);
    for(;;)
    {
     printf("ENTER COMMAND: \n");
     scanf("%d %d %d", &wr, &addr, &data);
     if(wr == 0)
     {
        printf("READING FROM %d...\n", addr);
        data = IORD_8DIRECT(SRAM_BASE, addr);
        printf("READ %d FROM ADDRESS %d\n", data, addr);
     }
     else if (wr == 1)
     {
        printf("WRITING %d TO %d...\n", data, addr);
        IOWR_8DIRECT(SRAM_BASE, addr, data);
        temp = IORD_8DIRECT(SRAM_BASE, addr);
        printf("WROTE %d TO ADDRESS %d\n", temp, addr);
     }
     else
     {
       printf("NOT A VALID COMMAND\n");
     }
     
    }
    return 0;
}

int run_keys()
{
    printf("Running run_keys()\n");
    int x = 0;
    int y = 0;
    int addr = 0;
    char * input;
    struct sprite_addr_type black_data, white_data;
    black_data.data = 0;
    black_data.set_rt = 0;
    black_data.set_fl = 0;
    black_data.set_hl = 0;
    white_data.data = 4;
    white_data.set_rt = 0;
    white_data.set_fl = 0;
    white_data.set_hl = 0;
    for(;;)
    {
        WRITE_RAM(addr, *((unsigned short *)(&white_data)));
        input = getInput();
        WRITE_RAM(addr, *((unsigned short *)(&black_data)));
        if(strcmp(input, "UP") == 0)
        {
           if (y == 0)
              y = 14;
           else
              y = y - 1;
        }
        else if (strcmp(input, "DOWN") == 0)
        {
            if (y == 14)
              y = 0;
           else
              y = y + 1;
        }
        else if (strcmp(input, "LEFT") == 0)
        {
            if (x == 0)
              x = 11;
           else
              x = x - 1;
        }
        else if (strcmp(input, "RIGHT") == 0)
        {
            if (x == 11)
              x = 0;
           else
              x = x + 1;
        }
        input = "";
        addr = y * 12 + x; 
    }
    
    return 0;
}


//Invert a square on the 32 side
void invert32(int row, int col){
    if (display32[row][col][3] == 0)
        display32[row][col][3] = 1;
    else if (display32[row][col][3] == 1)
        display32[row][col][3] = 0;
    changeTile32(row, col, display32[row][col][0], display32[row][col][1], display32[row][col][2], display32[row][col][3]);
    return;
}   
    
//Invert a square on the 16 side
void invert16(int row, int col){
    if (display16[row][col][3] == 0)
        display16[row][col][3] = 1;
    else if (display16[row][col][3] == 1)
        display16[row][col][3] = 0;
    changeTile16(row, col, display16[row][col][0], display16[row][col][1], display16[row][col][2], display16[row][col][3]);
    return;
}

//Display a character at a coordinate on the 32 side    
char * displayChar32(char p_char, int row, int col){
    char * czChar = "\0\0";
    if (p_char == 'A'){
        czChar[0] = p_char;
        changeTile32(row, col, 12, 0, 0, 0);
    }
    else if (p_char == 'B'){
        czChar[0] = p_char;
        changeTile32(row, col, 13, 0, 0, 0);
    }
    else if (p_char == 'C'){
        czChar[0] = p_char;
        changeTile32(row, col, 14, 0, 0, 0);
    }
    else if (p_char == 'D'){
        czChar[0] = p_char;
        changeTile32(row, col, 15, 0, 0, 0);
    }
    else if (p_char == 'E'){
        czChar[0] = p_char;
        changeTile32(row, col, 16, 0, 0, 0);
    }
    else if (p_char == 'F'){
        czChar[0] = p_char;
        changeTile32(row, col, 17, 0, 0, 0);
    }
    else if (p_char == 'G'){
        czChar[0] = p_char;
        changeTile32(row, col, 18, 0, 0, 0);
    }
    else if (p_char == 'H'){
        czChar[0] = p_char;
        changeTile32(row, col, 19, 0, 0, 0);
    }   
    else if (p_char == 'I'){
        czChar[0] = p_char;
        changeTile32(row, col, 20, 0, 0, 0);
    }
    else if (p_char == 'J'){
        czChar[0] = p_char;
        changeTile32(row, col, 21, 0, 0, 0);
    }
    else if (p_char == 'K'){
        czChar[0] = p_char;
        changeTile32(row, col, 22, 0, 0, 0);
    }
    else if (p_char == 'L'){
        czChar[0] = p_char;
        changeTile32(row, col, 23, 0, 0, 0);
    }
    else if (p_char == 'M'){
        czChar[0] = p_char;
        changeTile32(row, col, 24, 0, 0, 0);
    }
    else if (p_char == 'N'){
        czChar[0] = p_char;
        changeTile32(row, col, 25, 0, 0, 0);
    }
    else if (p_char == 'O'){
        czChar[0] = p_char;
        changeTile32(row, col, 26, 0, 0, 0);
    }
    else if (p_char == 'P'){
        czChar[0] = p_char;
        changeTile32(row, col, 27, 0, 0, 0);
    }   
    else if (p_char == 'Q'){
        czChar[0] = p_char;
        changeTile32(row, col, 28, 0, 0, 0);
    }
    else if (p_char == 'R'){
        czChar[0] = p_char;
        changeTile32(row, col, 29, 0, 0, 0);
    }
    else if (p_char == 'S'){
        czChar[0] = p_char;
        changeTile32(row, col, 30, 0, 0, 0);
    }
    else if (p_char == 'T'){
        czChar[0] = p_char;
        changeTile32(row, col, 31, 0, 0, 0);
    }
    else if (p_char == 'U'){
        czChar[0] = p_char;
        changeTile32(row, col, 32, 0, 0, 0);
    }
    else if (p_char == 'V'){
        czChar[0] = p_char;
        changeTile32(row, col, 33, 0, 0, 0);
    }
    else if (p_char == 'W'){
        czChar[0] = p_char;
        changeTile32(row, col, 34, 0, 0, 0);
    }
    else if (p_char == 'X'){
        czChar[0] = p_char;
        changeTile32(row, col, 35, 0, 0, 0);
    }   
    else if (p_char == 'Y'){
        czChar[0] = p_char;
        changeTile32(row, col, 36, 0, 0, 0);
    }
    else if (p_char == 'Z'){
        czChar[0] = p_char;
        changeTile32(row, col, 37, 0, 0, 0);
    }
    else if (p_char == 'a'){
        czChar[0] = p_char;
        changeTile32(row, col, 38, 0, 0, 0);
    }
    else if (p_char == 'b'){
        czChar[0] = p_char;
        changeTile32(row, col, 39, 0, 0, 0);
    }
    else if (p_char == 'c'){
        czChar[0] = p_char;
        changeTile32(row, col, 40, 0, 0, 0);
    }
    else if (p_char == 'd'){
        czChar[0] = p_char;
        changeTile32(row, col, 41, 0, 0, 0);
    }
    else if (p_char == 'e'){
        czChar[0] = p_char;
        changeTile32(row, col, 42, 0, 0, 0);
    }
    else if (p_char == 'f'){
        czChar[0] = p_char;
        changeTile32(row, col, 43, 0, 0, 0);
    }       
    else if (p_char == 'g'){
        czChar[0] = p_char;
        changeTile32(row, col, 44, 0, 0, 0);
    }
    else if (p_char == 'h'){
        czChar[0] = p_char;
        changeTile32(row, col, 45, 0, 0, 0);
    }
    else if (p_char == 'i'){
        czChar[0] = p_char;
        changeTile32(row, col, 46, 0, 0, 0);
    }
    else if (p_char == 'j'){
        czChar[0] = p_char;
        changeTile32(row, col, 47, 0, 0, 0);
    }
    else if (p_char == 'k'){
        czChar[0] = p_char;
        changeTile32(row, col, 48, 0, 0, 0);
    }
    else if (p_char == 'l'){
        czChar[0] = p_char;
        changeTile32(row, col, 49, 0, 0, 0);
    }
    else if (p_char == 'm'){
        czChar[0] = p_char;
        changeTile32(row, col, 50, 0, 0, 0);
    }
    else if (p_char == 'n'){
        czChar[0] = p_char;
        changeTile32(row, col, 51, 0, 0, 0);
    }   
    else if (p_char == 'o'){
        czChar[0] = p_char;
        changeTile32(row, col, 52, 0, 0, 0);
    }
    else if (p_char == 'p'){
        czChar[0] = p_char;
        changeTile32(row, col, 53, 0, 0, 0);
    }
    else if (p_char == 'q'){
        czChar[0] = p_char;
        changeTile32(row, col, 54, 0, 0, 0);
    }
    else if (p_char == 'r'){
        czChar[0] = p_char;
        changeTile32(row, col, 55, 0, 0, 0);
    }
    else if (p_char == 's'){
        czChar[0] = p_char;
        changeTile32(row, col, 56, 0, 0, 0);
    }
    else if (p_char == 't'){
        czChar[0] = p_char;
        changeTile32(row, col, 57, 0, 0, 0);
    }
    else if (p_char == 'u'){
        czChar[0] = p_char;
        changeTile32(row, col, 58, 0, 0, 0);
    }
    else if (p_char == 'v'){
        czChar[0] = p_char;
        changeTile32(row, col, 59, 0, 0, 0);
    }
    else if (p_char == 'w'){
        czChar[0] = p_char;
        changeTile32(row, col, 60, 0, 0, 0);
    }
    else if (p_char == 'x'){
        czChar[0] = p_char;
        changeTile32(row, col, 61, 0, 0, 0);
    }       
    else if (p_char == 'y'){
        czChar[0] = p_char;
        changeTile32(row, col, 62, 0, 0, 0);
    }
    else if (p_char == 'z'){
        czChar[0] = p_char;
        changeTile32(row, col, 63, 0, 0, 0);
    }
    else if (p_char == '0'){
        czChar[0] = p_char;
        changeTile32(row, col, 64, 0, 0, 0);
    }
    else if (p_char == '1'){
        czChar[0] = p_char;
        changeTile32(row, col, 65, 0, 0, 0);
    }
    else if (p_char == '2'){
        czChar[0] = p_char;
        changeTile32(row, col, 66, 0, 0, 0);
    }
    else if (p_char == '3'){
        czChar[0] = p_char;
        changeTile32(row, col, 67, 0, 0, 0);
    }
    else if (p_char == '4'){
        czChar[0] = p_char;
        changeTile32(row, col, 68, 0, 0, 0);
    }
    else if (p_char == '5'){
        czChar[0] = p_char;
        changeTile32(row, col, 69, 0, 0, 0);
    }   
    else if (p_char == '6'){
        czChar[0] = p_char;
        changeTile32(row, col, 70, 0, 0, 0);
    }
    else if (p_char == '7'){
        czChar[0] = p_char;
        changeTile32(row, col, 71, 0, 0, 0);
    }
    else if (p_char == '8'){
        czChar[0] = p_char;
        changeTile32(row, col, 72, 0, 0, 0);
    }
    else if (p_char == '9'){
        czChar[0] = p_char;
        changeTile32(row, col, 73, 0, 0, 0);
    }
    else if (p_char == ':'){
        czChar[0] = p_char;
        changeTile32(row, col, 116, 0, 0, 0);
    }
    else if (p_char == '?'){
        czChar[0] = p_char;
        changeTile32(row, col, 117, 0, 0, 0);
    }
    else if (p_char == ' '){
        czChar[0] = p_char;
        changeTile32(row, col, 11, 0, 0, 0);
    }
    else{
        changeTile32(row, col, 11, 0, 0, 0);
    }
    return czChar;
}


//Display a character at a coordinate on the 16 side    
char * displayChar16(char p_char, int row, int col){
    char * czChar = "\0\0";
    if (p_char == 'A'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+12, 0, 0, 0);
    }
    else if (p_char == 'B'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+13, 0, 0, 0);
    }
    else if (p_char == 'C'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+14, 0, 0, 0);
    }
    else if (p_char == 'D'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+15, 0, 0, 0);
    }
    else if (p_char == 'E'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+16, 0, 0, 0);
    }
    else if (p_char == 'F'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+17, 0, 0, 0);
    }
    else if (p_char == 'G'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+18, 0, 0, 0);
    }
    else if (p_char == 'H'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+19, 0, 0, 0);
    }   
    else if (p_char == 'I'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+20, 0, 0, 0);
    }
    else if (p_char == 'J'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+21, 0, 0, 0);
    }
    else if (p_char == 'K'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+22, 0, 0, 0);
    }
    else if (p_char == 'L'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+23, 0, 0, 0);
    }
    else if (p_char == 'M'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+24, 0, 0, 0);
    }
    else if (p_char == 'N'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+25, 0, 0, 0);
    }
    else if (p_char == 'O'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+26, 0, 0, 0);
    }
    else if (p_char == 'P'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+27, 0, 0, 0);
    }   
    else if (p_char == 'Q'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+28, 0, 0, 0);
    }
    else if (p_char == 'R'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+29, 0, 0, 0);
    }
    else if (p_char == 'S'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+30, 0, 0, 0);
    }
    else if (p_char == 'T'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+31, 0, 0, 0);
    }
    else if (p_char == 'U'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+32, 0, 0, 0);
    }
    else if (p_char == 'V'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+33, 0, 0, 0);
    }
    else if (p_char == 'W'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+34, 0, 0, 0);
    }
    else if (p_char == 'X'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+35, 0, 0, 0);
    }   
    else if (p_char == 'Y'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+36, 0, 0, 0);
    }
    else if (p_char == 'Z'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+37, 0, 0, 0);
    }
    else if (p_char == 'a'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+38, 0, 0, 0);
    }
    else if (p_char == 'b'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+39, 0, 0, 0);
    }
    else if (p_char == 'c'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+40, 0, 0, 0);
    }
    else if (p_char == 'd'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+41, 0, 0, 0);
    }
    else if (p_char == 'e'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+42, 0, 0, 0);
    }
    else if (p_char == 'f'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+43, 0, 0, 0);
    }       
    else if (p_char == 'g'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+44, 0, 0, 0);
    }
    else if (p_char == 'h'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+45, 0, 0, 0);
    }
    else if (p_char == 'i'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+46, 0, 0, 0);
    }
    else if (p_char == 'j'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+47, 0, 0, 0);
    }
    else if (p_char == 'k'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+48, 0, 0, 0);
    }
    else if (p_char == 'l'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+49, 0, 0, 0);
    }
    else if (p_char == 'm'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+50, 0, 0, 0);
    }
    else if (p_char == 'n'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+51, 0, 0, 0);
    }   
    else if (p_char == 'o'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+52, 0, 0, 0);
    }
    else if (p_char == 'p'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+53, 0, 0, 0);
    }
    else if (p_char == 'q'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+54, 0, 0, 0);
    }
    else if (p_char == 'r'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+55, 0, 0, 0);
    }
    else if (p_char == 's'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+56, 0, 0, 0);
    }
    else if (p_char == 't'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+57, 0, 0, 0);
    }
    else if (p_char == 'u'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+58, 0, 0, 0);
    }
    else if (p_char == 'v'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+59, 0, 0, 0);
    }
    else if (p_char == 'w'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+60, 0, 0, 0);
    }
    else if (p_char == 'x'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+61, 0, 0, 0);
    }       
    else if (p_char == 'y'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+62, 0, 0, 0);
    }
    else if (p_char == 'z'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+63, 0, 0, 0);
    }
    else if (p_char == '0'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+64, 0, 0, 0);
    }
    else if (p_char == '1'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+65, 0, 0, 0);
    }
    else if (p_char == '2'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+66, 0, 0, 0);
    }
    else if (p_char == '3'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+67, 0, 0, 0);
    }
    else if (p_char == '4'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+68, 0, 0, 0);
    }
    else if (p_char == '5'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+69, 0, 0, 0);
    }   
    else if (p_char == '6'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+70, 0, 0, 0);
    }
    else if (p_char == '7'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+71, 0, 0, 0);
    }
    else if (p_char == '8'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+72, 0, 0, 0);
    }
    else if (p_char == '9'){
        czChar[0] = p_char;
        changeTile16(row, col, 3+73, 0, 0, 0);
    }
    else if (p_char == ':'){
        czChar[0] = p_char;
        changeTile16(row, col, 124, 0, 0, 0);
    }
    else if (p_char == '?'){
        czChar[0] = p_char;
        changeTile16(row, col, 125, 0, 0, 0);
    }
    else if (p_char == ' '){
        czChar[0] = p_char;
        changeTile16(row, col, 14, 0, 0, 0);
    }
    else{
        changeTile16(row, col, 14, 0, 0, 0);
    }
    return czChar;
}

//Display a string on the 32 side
void displayString32(char* inputstring, int row, int col){
    int l, i;
    char* output;
    l = strlen(inputstring);
    for (i=0;i<l;i++)
        output = displayChar32(inputstring[i], row, col + i);
    return;
}
//Display a string on the 16 side
void displayString16(char* inputstring, int row, int col){
    int l, i; 
    char* output;
    l = strlen(inputstring);
    for (i=0; i < l; i++)
        output = displayChar16(inputstring[i], row, col + i);
    return;
}


//Set up the basic screen display, with a blank ocean and player name for both screens.
void initializeDisplay(){
    //Display the 32 side
    //Display border on the 32 side
    int c, r, i;
    for (c=0;c<5;c++)
        changeTile32(0,c,8,0,0,0);
    for (r=0;r<15;r++)
        changeTile32(r,0,8,0,0,0);
    for (c=0;c<12;c++)
        changeTile32(14,c,8,0,0,0); 
    //Display the Battleship Title on the 32 side
    for (i=0;i<7;i++)
        changeTile32(0,5+i,109+i,0,0,0);
    
    //Display the battleship title on the 16 side
    for (c=0;c<3;c++){
        changeTile16(0,0 + (2*c),112 + (4*c),0,0,0);
        changeTile16(1,0 + (2*c),114 + (4*c),0,0,0);
        changeTile16(0,1 + (2*c),113 + (4*c),0,0,0);
        changeTile16(1,1 + (2*c),115 + (4*c),0,0,0);
    }   
    for (c=3;c<8;c++){
        changeTile16(0,0 + (2*c),8,0,0,0);
        changeTile16(1,0 + (2*c),10,0,0,0);
        changeTile16(0,1 + (2*c),9,0,0,0);
        changeTile16(1,1 + (2*c),11,0,0,0);
    }   
    //Display the blank text squares on the 32 side
    for(r=1;r<3;r++)
        for(c=1;c<12;c++)
            changeTile32(r,c,11,0,0,0);
    changeTile32(3,1,11,0,0,0);
    
    //Display the numbers along the top of the battle screen on the 32 side
    for (c=0;c<10;c++)
        changeTile32(3,2+c,65+c,0,0,0);
        
    //Display the letters along the side of the battle screen on the 32 side
    for (r=0;r<10;r++)
        changeTile32(4+r,1,12+r,0,0,0);
        
    //Display the ocean on the 32 side
    for (r=0;r<10;r++)
        for (c=0;c<10;c++)
            changeTile32(r+4,c+2,5,0,0,0);
    
    //Display the 16 side
    //Display the border on the 16 side.  Fill the entire side with border.  This will be overwritten as necessary.
    for (r=1;r<15;r++){
        for (c=0;c<8;c++){
            changeTile16(r*2+0,0 + (2*c),8,0,0,0);
            changeTile16(r*2+1,0 + (2*c),10,0,0,0);
            changeTile16(r*2+0,1 + (2*c),9,0,0,0);
            changeTile16(r*2+1,1 + (2*c),11,0,0,0);
        }
    }
    //Display the blank text squares on the 16 side
    for (r=0;r<2;r++){
        for (c=0;c<11;c++){
            changeTile16(r+3, c+2,14,0,0,0);
            changeTile16(r+19, c+2,14,0,0,0);
            changeTile16(r+22, c+2,14,0,0,0);
            changeTile16(r+25, c+2,14,0,0,0);
        }
    }
    changeTile16(6,2,14,0,0,0);
    
    //Display the numbers along the top of the battle screen on the 16 side
    for (c=0;c<10;c++)
        changeTile16(6,3+c,68+c,0,0,0);
        
    //Display the letters along the side of the battle screen on the 16 side
    for (r=0;r<10;r++)
        changeTile16(7+r,2,15+r,0,0,0);
        
    //Display the ocean on the 16 side
    for (r=0;r<10;r++)
        for (c=0;c<10;c++)
            changeTile16(r+7,c+3,5,0,0,0);
    return;
}

//Get the players name and display it
char* getPlayerName(){
    //Set the cursor to the beginning of the ENTERNAME box
    cursorX = 1;
    cursorY = 2;
    invert32(cursorY, cursorX);
    char* name = "";
    displayString32("Enter Name:", 1, 1);
    char* input = "";
    char* buffer;
    input = "";
    input = getInput();
    printf("I have received input: %s\n", input);
    while (strcmp(input, "Return") != 0){
        printf("I am trying to receive another input because I have not yet detected Return\n");
        if (strcmp(input, "BackSpace") == 0 && cursorX > 1){
            if (cursorX < 12)
                invert32(cursorY, cursorX);
            cursorX = cursorX - 1;
            changeTile32(cursorY, cursorX, 11, 0, 0, 0);
            invert32(cursorY, cursorX);
            strncpy(name, name, cursorX - 1);
        }
        else if (cursorX <= 11 && strcmp(input, "BackSpace") && strcmp(input, "Left") && strcmp(input, "Right") && strcmp(input, "Up") && strcmp(input, "Down") && strcmp(input, "Escape")){
            if (strlen(input) == 1){
                buffer = displayChar32(input[0], cursorY, cursorX);
                name = strcat(name, buffer);
                cursorX = cursorX + 1;
                if (cursorX < 12)
                    invert32(cursorY, cursorX);
            }
        }
        input = "";
        input = getInput();
    }
    printf("Name: %s\n", name);
    printf("I have received input: %s\n", input);
    return name;
}

void checkPlayAgain(){
    char * input;
    displayString32("Play Again?", 1, 1);
    displayString32("    Y N    ", 2, 1);
    cursorX = 5;
    cursorY = 2;
    invert32(cursorY, cursorX);
    exitPlayer = -1;
    while  (exitPlayer == -1){
        input = getInput(); 
        if (strcmp(input, "Left") == 0 && cursorX == 7){
            invert32(cursorY, cursorX);
            cursorX = 5;
            invert32(cursorY, cursorX);
        }
        else if (strcmp(input, "Right") == 0 && cursorX == 5){
            invert32(cursorY, cursorX);
            cursorX = 7;
            invert32(cursorY, cursorX);
        }
        else if (strcmp(input, "Return") == 0){
            invert32(cursorY, cursorX);
            if (cursorX == 5){
                exitPlayer = 0;
            }
            else{
                exitPlayer = 1;
            }
        }
    }
    return;
}

void placeCarrier(int  x,int  y,char* direction){
    if ( strcmp(direction , "Left") == 0 ){
        changeTile32(y, x, 75, 1, 1, 0);
        changeTile32(y, x-1, 76, 1, 1, 0);
        changeTile32(y, x-2, 77, 1, 1, 0);
        changeTile32(y, x-3, 78, 1, 1, 0);
        changeTile32(y, x-4, 79, 1, 1, 0);
        }
                
    else if (strcmp(direction , "Right") == 0){
        changeTile32(y, x, 75, 1, 0, 0);
        changeTile32(y, x+1, 76, 1, 0, 0);
        changeTile32(y, x+2, 77, 1, 0, 0);
        changeTile32(y, x+3, 78, 1, 0, 0);
        changeTile32(y, x+4, 79, 1, 0, 0);
        }
    
    else if (strcmp(direction , "Up") == 0){
        changeTile32(y, x, 75, 0, 1, 0);
        changeTile32(y-1, x, 76, 0, 1, 0);
        changeTile32(y-2, x, 77, 0, 1, 0);
        changeTile32(y-3, x, 78, 0, 1, 0);
        changeTile32(y-4, x, 79, 0, 1, 0);
        }
                
    else if (strcmp(direction , "Down") == 0){
        changeTile32(y, x, 75, 0, 0, 0);
        changeTile32(y+1, x, 76, 0, 0, 0);
        changeTile32(y+2, x, 77, 0, 0, 0);
        changeTile32(y+3, x, 78, 0, 0, 0);
        changeTile32(y+4, x, 79, 0, 0, 0);
        }
    return;
}

void placeBattleship(int x,int  y,char*  direction){
    if (strcmp(direction , "Left") == 0){
        changeTile32(y, x, 80, 1, 1, 0);
        changeTile32(y, x-1, 81, 1, 1, 0);
        changeTile32(y, x-2, 82, 1, 1, 0);
        changeTile32(y, x-3, 83, 1, 1, 0);
        }

    else if  (strcmp(direction , "Right") == 0) {
        changeTile32(y, x, 80, 1, 0, 0);
        changeTile32(y, x+1, 81, 1, 0, 0);
        changeTile32(y, x+2, 82, 1, 0, 0);
        changeTile32(y, x+3, 83, 1, 0, 0);
        }

    else if (strcmp(direction , "Up") == 0){
        changeTile32(y, x, 80, 0, 1, 0);
        changeTile32(y-1, x, 81, 0, 1, 0);
        changeTile32(y-2, x, 82, 0, 1, 0);
        changeTile32(y-3, x, 83, 0, 1, 0);
        }

    else if (strcmp(direction , "Down") == 0){
        changeTile32(y, x, 80, 0, 0, 0);
        changeTile32(y+1, x, 81, 0, 0, 0);
        changeTile32(y+2, x, 82, 0, 0, 0);
        changeTile32(y+3, x, 83, 0, 0, 0);
        }
    return;
}

    
void placeDestroyer(int x,int  y,char* direction){
    if (strcmp(direction , "Left") == 0){
        changeTile32(y, x, 84, 1, 1, 0);
        changeTile32(y, x-1, 85, 1, 1, 0);
        changeTile32(y, x-2, 86, 1, 1, 0);
        }

    else if (strcmp(direction , "Right") == 0){
        changeTile32(y, x, 84, 1, 0, 0);
        changeTile32(y, x+1, 85, 1, 0, 0);
        changeTile32(y, x+2, 86, 1, 0, 0);
        }

    else if (strcmp(direction , "Up") == 0){
        changeTile32(y, x, 84, 0, 1, 0);
        changeTile32(y-1, x, 85, 0, 1, 0);
        changeTile32(y-2, x, 86, 0, 1, 0);
        }

    else if (strcmp(direction , "Down") == 0){
        changeTile32(y, x, 84, 0, 0, 0);
        changeTile32(y+1, x, 85, 0, 0, 0);
        changeTile32(y+2, x, 86, 0, 0, 0);
        }
    return;
}

void placeSubmarine(int x,int  y,char*  direction){
    if (strcmp(direction , "Left") == 0){
        changeTile32(y, x, 87, 1, 1, 0);
        changeTile32(y, x-1, 88, 1, 1, 0);
        changeTile32(y, x-2, 89, 1, 1, 0);
        }

    else if (strcmp(direction , "Right") == 0){
        changeTile32(y, x, 87, 1, 0, 0);
        changeTile32(y, x+1, 88, 1, 0, 0);
        changeTile32(y, x+2, 89, 1, 0, 0);
        }

    else if (strcmp(direction , "Up") == 0){
        changeTile32(y, x, 87, 0, 1, 0);
        changeTile32(y-1, x, 88, 0, 1, 0);
        changeTile32(y-2, x, 89, 0, 1, 0);
        }

    else if (strcmp(direction , "Down") == 0){
        changeTile32(y, x, 87, 0, 0, 0);
        changeTile32(y+1, x, 88, 0, 0, 0);
        changeTile32(y+2, x, 89, 0, 0, 0);
        }
    return;
}

void placePatrolBoat(int x,int y,char* direction){
    if (strcmp(direction , "Left") == 0){
        changeTile32(y, x, 90, 1, 1, 0);
        changeTile32(y, x-1, 91, 1, 1, 0);
        }

    else if (strcmp(direction , "Right") == 0){
        changeTile32(y, x, 90, 1, 0, 0);
        changeTile32(y, x+1, 91, 1, 0, 0);
        }

    else if (strcmp(direction , "Up") == 0){
        changeTile32(y, x, 90, 0, 1, 0);
        changeTile32(y-1, x, 91, 0, 1, 0);
        }

    else if (strcmp(direction , "Down") == 0){
        changeTile32(y, x, 90, 0, 0, 0);
        changeTile32(y+1, x, 91, 0, 0, 0);
        }
    return;
}


void getLocation32(){
    char* input = "";
    //global cursorY, cursorX
    invert32(cursorY, cursorX);
    while ( strcmp(input , "Return") != 0 ){
        if ( (cursorX > 11) || (cursorX < 2) || (cursorY < 4) || (cursorY > 13) ){
            printf( "Invalid cursor position:  %d,%d", cursorX, cursorY);
            printf( "Resetting cursor");
            cursorX = 2;
            cursorY = 4;
            }
        if ( ( strcmp(input , "Left" ) == 0) && (cursorX > 2) ){
            invert32(cursorY, cursorX);
            cursorX = cursorX - 1;
            invert32(cursorY, cursorX);
            }
        else if ( ( strcmp(input , "Right" ) == 0) && (cursorX < 11) ) {
            invert32(cursorY, cursorX);
            cursorX = cursorX + 1;
            invert32(cursorY, cursorX);
            }
        else if ( ( strcmp(input , "Up" ) == 0) &&  (cursorY > 4) ){
            invert32(cursorY, cursorX);
            cursorY = cursorY - 1;
            invert32(cursorY, cursorX);
            }       
        else if ( ( strcmp(input , "Down" ) == 0) &&  (cursorY < 13) ){
            invert32(cursorY, cursorX);
            cursorY = cursorY + 1;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "A") == 0) || ( strcmp(input , "a") == 0) ) {
            invert32(cursorY, cursorX);
            cursorY = 4;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "1") == 0 ) {
            invert32(cursorY, cursorX);
            cursorX = 2;
            invert32(cursorY, cursorX);
            }

        else if ( (strcmp(input , "B") == 0) || ( strcmp(input , "b") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 5;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "2") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 3;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "C") == 0) || ( strcmp(input , "c") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 6;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "3") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 4;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "D") == 0) || ( strcmp(input , "d") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 7;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "4") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 5;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "E") == 0) || ( strcmp(input , "e") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 8;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "5") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 6;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "F") == 0) || ( strcmp(input , "f") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 9;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "6") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 7;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "G") == 0) || ( strcmp(input , "g") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 10;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "7") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 8;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "H") == 0) || ( strcmp(input , "h") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 11;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "8") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 9;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "I") == 0) || ( strcmp(input , "i") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 12;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "9") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 10;
            invert32(cursorY, cursorX);
            }
            
        else if ( (strcmp(input , "J") == 0) || ( strcmp(input , "j") == 0) ){
            invert32(cursorY, cursorX);
            cursorY = 13;
            invert32(cursorY, cursorX);
            }
        else if ( strcmp(input , "0") == 0 ){
            invert32(cursorY, cursorX);
            cursorX = 11;
            invert32(cursorY, cursorX);
            }

        input = getInput();
    }   
    return;
}
    
void getLocation16(){
    char* input = "";
    //global cursorY, cursorX
    invert16(cursorY, cursorX);
    while  ( strcmp(input , "Return") != 0 ){
        if ( (cursorX > 12) || (cursorX < 3) || (cursorY < 7) || (cursorY > 16) ){
            printf( "Invalid cursor position:  %d,%d", cursorX, cursorY);
            printf( "Resetting cursor");
            cursorX = 2;
            cursorY = 4;
            }
        if (  (strcmp(input , "Left") == 0) && (cursorX > 3)  ){
            invert16(cursorY, cursorX);
            cursorX = cursorX - 1;
            invert16(cursorY, cursorX);
            }
        else if (  (strcmp(input , "Right") == 0) && (cursorX < 12)  ){
            invert16(cursorY, cursorX);
            cursorX = cursorX + 1;
            invert16(cursorY, cursorX);
            }
        else if ( (strcmp(input , "Up") == 0) && (cursorY > 7)  ){
            invert16(cursorY, cursorX);
            cursorY = cursorY - 1;
            invert16(cursorY, cursorX);
            }       
        else if (  (strcmp(input , "Down") == 0) && (cursorY < 16)  ){
            invert16(cursorY, cursorX);
            cursorY = cursorY + 1;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "A") == 0) || ( strcmp(input , "a") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 7;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "1") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 3;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "B") == 0) || ( strcmp(input , "b") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 8;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "2") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 4;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "C") == 0) || ( strcmp(input , "c") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 9;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "3") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 5;
            invert16(cursorY, cursorX);
            }
        else if ( (strcmp(input , "D") == 0) || ( strcmp(input , "d") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 10;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "4") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 6;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "E") == 0) || ( strcmp(input , "e") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 11;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "5") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 7;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "F") == 0) || ( strcmp(input , "f") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 12;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "6") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 8;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "G") == 0) || ( strcmp(input , "g") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 13;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "7") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 9;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "H") == 0) || ( strcmp(input , "h") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 14;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "8") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 10;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "I") == 0) || ( strcmp(input , "i") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 15;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "9") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 11;
            invert16(cursorY, cursorX);
            }

        else if ( (strcmp(input , "J") == 0) || ( strcmp(input , "j") == 0) ) {
            invert16(cursorY, cursorX);
            cursorY = 16;
            invert16(cursorY, cursorX);
            }
        else if ( strcmp(input , "0") == 0 ) {
            invert16(cursorY, cursorX);
            cursorX = 12;
            invert16(cursorY, cursorX);
            }

        input = getInput();
        }
    return;
}

//Conduct the players turn
void playerTurn(){
    //global cursorX, cursorY, playerScore
    int fired = 0;
    char* message, response;
    cursorX = 3;
    cursorY = 7;
    displayString16("Select shot", 3, 2);
    displayString16("location:  ", 4, 2);
    while (fired == 0){
        getLocation16();
        if (display16[cursorY][cursorX][0] == 5)
            fired = 1;
    }
    int x = cursorX - 2;
    if (x == 10)
        x = 0;
    int y = cursorY - 6;
    if (y == 10)
        y = 0;  
    printf("Shot: %d %d", x, y);
    sprintf(message, "Shot: %d %d", x, y);
    int kkk;
    for(kkk = 0; kkk < 5; kkk++){
        sendPacket(message);
    }
    response = 0;
    while (response == 0){
        message = receivePacket();
        if (strlen(message) >= 3 && strncmp(message, "Hit", 3)==0){
            playerScore = playerScore + 1;
            displayString16("Hit        ", 3, 2);
            changeTile16(cursorY, cursorX, 6, 0, 0, 0);
            response = 1;
        }
        else if (strlen(message) >= 4 && strncmp(message, "Miss", 4)==0){
            displayString16("Miss       ", 3, 2);
            changeTile16(cursorY, cursorX, 7, 0, 0, 0);
            response = 1;
        }
        else if (strlen(message) >= 4 && strncmp(message, "Sunk", 4)==0){
            char ship = message[6];
            changeTile16(cursorY, cursorX, 6, 0, 0, 0);
            playerScore = playerScore + 1;
            displayString16("Sunk       ", 3, 2);
            if (ship == 'B')
                displayString16("Battleship ", 4, 2);
            
            else if (ship == 'A')
                displayString16("Carrier    ", 4, 2);
        
            else if (ship == 'D')
                displayString16("Destroyer  ", 4, 2);
                
            else if (ship == 'S')
                displayString16("Submarine  ", 4, 2);
                
            else if (ship == 'P')
                displayString16("Patrol Boat", 4, 2);
        }
    }
    printf("I have sent a shot and received a response!\n");
    return; 
}

//Conduct the opponents turn
void opponentTurn(){
    //global opponentScore, carrierleft, battleshipleft, destroyerleft, submarineleft, patrolboatleft
    int receivedShot, x, y;
    char* message;
    receivedShot = 0;
    x = -1;
    y = -1;
    while (receivedShot == 0){
        message = receivePacket();
        printf("XXX\n");
        if (strlen(message) >= 9 && strncmp(message,"Shot", 4)==0){
            receivedShot = 1; printf("AAA\n");
            x = message[6] - '0';
            y = message[8] - '0';
            if (x == 0)
                x = 10;
            if (y == 0)
                y = 10;
        } printf("BBB\n");
    }           
    printf("I have received a shot\n");
    
    if (display32[y + 3][x + 1][0] == 5){
        sendPacket("Miss");
        changeTile32(y + 3, x + 1, 7, 0, 0, 0); //Display Miss
    }
    else if (display32[y + 3][x + 1][0] >= 75 && display32[y + 3][x + 1][0] <= 91){  //If this is an unexploded ship
        opponentScore = opponentScore + 1;
        if (display32[y + 3][x + 1][0] >= 75 && display32[y + 3][x + 1][0] <= 79){ //Carrier
            carrierleft = carrierleft - 1;
            if (carrierleft == 0){
                sendPacket("Sunk A");
                printf("Carrier sunk!\n");
            }
            else
                sendPacket("Hit");
        }
        else if (display32[y + 3][x + 1][0] >= 80 && display32[y + 3][x + 1][0] <= 83){ //Battleship
            battleshipleft = battleshipleft - 1;
            if (battleshipleft == 0){
                sendPacket("Sunk B");
                printf("Battleship sunk!\n");
            }
            else
                sendPacket("Hit");
        }
        else if (display32[y + 3][x + 1][0] >= 84 && display32[y + 3][x + 1][0] <= 86){ //Destroyer
            destroyerleft = destroyerleft - 1;
            if (destroyerleft == 0){
                sendPacket("Sunk D");
                printf("Destroyer sunk!\n");
            }
            else
                sendPacket("Hit");
        }
        else if (display32[y + 3][x + 1][0] >= 87 && display32[y + 3][x + 1][0] <= 89){ //Submarine
            submarineleft = submarineleft - 1;
            if (submarineleft == 0){
                sendPacket("Sunk S");
                printf("Submarine sunk!\n");
            }
            else
                sendPacket("Hit");
        }
        else if (display32[y + 3][x + 1][0] >= 90 && display32[y + 3][x + 1][0] <= 91){ //Patrol Boat
            patrolboatleft = patrolboatleft - 1;
            if (patrolboatleft == 0){
                sendPacket("Sunk P");
                printf("Patrol Boat sunk!\n");
            }
            else
                sendPacket("Hit");
        
        sendPacket("Hit");
        changeTile32(y + 3, x + 1, display32[y+3][x+1][0] + 17, 0, 0, 0); //Display exploded ship part
        }
    }
    else{
        printf("Invalid shot attempted\n");
            sendPacket("Invalid shot");
    }
    return;
}

//If the player wins
void playerVictory(){
    displayString16("Victory    ", 25, 2);
    return;
}

//If the opponent wins
void opponentVictory(){
    displayString32("Defeat     ", 25, 2);
    return;
}

int checkValidShip(int x, int y, int length, char* direction){
    printf("I am testing the validity of %d, %d for a ship of length %d heading %s\n", x, y, length, direction);
    int i;
    int valid = 1;
    if (strcmp(direction, "Left")==0){
        if (x-length >= 1){
            for (i=x-length;i<x;i++)
                if (display32[y][i+1][0] != 5)
                    valid = 0;
        }
        else
            valid = 0;
    }
                
    else if (strcmp(direction, "Right")==0){
        if (x+length <= 12){
            for (i=x;i<x+length;i++)
                if (display32[y][i][0] != 5)
                    valid = 0;
        }
        else
            valid = 0;
    }
    
    else if (strcmp(direction, "Up")==0){
        if (y - length >= 3){
            for (i=y-length;i<y;i++)
                if (display32[i+1][x][0] != 5)
                    valid = 0;
        }
        else
            valid = 0;
    }
                
    else if (strcmp(direction, "Down")==0){
        if (y + length <= 14){
            for (i=y;i<y+length;i++)
                if (display32[i][x][0] != 5)
                    valid = 0;
        }
        else
            valid = 0;
    }
    if (valid == 0)
        printf("I have found this configuration to be invalid\n");
    else
        printf("I have found this configuration to be valid\n");
    return valid;
}

void initializeRound(){
    //global playerName, cursorX, cursorY, patrolboatleft, submarineleft, destroyerleft, battleshipleft, carrierleft, playerScore, opponentScore
    
    //Initialize score and ship health
    
    patrolboatleft = 2;
    submarineleft = 3;
    destroyerleft = 3;
    battleshipleft = 4;
    carrierleft = 5;
    playerScore = 0;
    opponentScore = 0;
    char* input;

    //Place the Carrier
    displayString32("Place 5 sq ", 1, 1);
    displayString32("Carrier    ", 2, 1);
    cursorY = 4;
    cursorX = 2;
    int carrier = 0;
    printf("I am now going to try to get a location for the carrier\n");
    while (carrier == 0)
    {
        getLocation32();
        printf("I got a location: %d %d\n", cursorX, cursorY);
        if (checkValidShip(cursorX, cursorY, 5, "Left") || checkValidShip(cursorX, cursorY, 5, "Right") || checkValidShip(cursorX, cursorY, 5, "Up") || checkValidShip(cursorX, cursorY, 5, "Down")){
            carrier = 1;
        }
        else{
            printf("Invalid placement for carrier\n");
            invert32(cursorY, cursorX);
        }
    }       
    printf("Valid location for carrier\n");
    carrier = 0;
    displayString32("Direction? ", 1, 1);
    displayString32("Length: 5  ", 2, 1);
    while (carrier == 0)
    {
        input = getInput();
        if (strcmp(input, "Left") == 0 && checkValidShip(cursorX, cursorY, 5, "Left")){
            placeCarrier(cursorX, cursorY, "Left");
            carrier = 1;
        }
        if (strcmp(input, "Right") == 0 && checkValidShip(cursorX, cursorY, 5, "Right")){
            placeCarrier(cursorX, cursorY, "Right");
            carrier = 1;
        }
        if (strcmp(input, "Up") == 0 && checkValidShip(cursorX, cursorY, 5, "Up")){
            placeCarrier(cursorX, cursorY, "Up");
            carrier = 1;
        }       
        if (strcmp(input, "Down") == 0 && checkValidShip(cursorX, cursorY, 5, "Down")){
            placeCarrier(cursorX, cursorY, "Down");
            carrier = 1;
        }
    }
    printf("You placed a carrier!\n");
    
    //Place the Battleship
    displayString32("Place 4 sq ", 1, 1);
    displayString32("Battleship ", 2, 1);
    cursorY = 4;
    cursorX = 2;
    int battleship = 0;
    printf("I am now going to try to get a location for the battleship\n");
    while (battleship == 0)
    {
        getLocation32();
        printf("I got a location: %d, %d\n", cursorX, cursorY);
        if (checkValidShip(cursorX, cursorY, 4, "Left") || checkValidShip(cursorX, cursorY, 4, "Right") || checkValidShip(cursorX, cursorY, 4, "Up") || checkValidShip(cursorX, cursorY, 4, "Down")){
            battleship = 1;
        }
        else{
            printf("Invalid placement for battleship\n");
            invert32(cursorY, cursorX);
        }
    }        
    printf("Valid location for battleship\n");
    battleship = 0;
    displayString32("Direction? ", 1, 1);
    displayString32("Length: 4  ", 2, 1);
    while (battleship == 0){
        input = getInput();
        if (strcmp(input, "Left") == 0 && checkValidShip(cursorX, cursorY, 4, "Left")){
            placeBattleship(cursorX, cursorY, "Left");
            battleship = 1;
        }
        if (strcmp(input, "Right") == 0 && checkValidShip(cursorX, cursorY, 4, "Right")){
            placeBattleship(cursorX, cursorY, "Right");
            battleship = 1;
        }
        if (strcmp(input, "Up") == 0 && checkValidShip(cursorX, cursorY, 4, "Up")){
            placeBattleship(cursorX, cursorY, "Up");
            battleship = 1;
        }       
        if (strcmp(input, "Down") == 0 && checkValidShip(cursorX, cursorY, 4, "Down")){
            placeBattleship(cursorX, cursorY, "Down");
            battleship = 1;
        }
    }
    printf("You placed a battleship!\n");
    
    //Place the Destroyer
    displayString32("Place 3 sq ", 1, 1);
    displayString32("Destroyer  ", 2, 1);
    cursorY = 4;
    cursorX = 2;
    int destroyer = 0;
    printf("I am now going to try to get a location for the destroyer\n");
    while (destroyer == 0)
    {
        getLocation32();
        printf("I got a location: %d, %d\n", cursorX, cursorY);
        if (checkValidShip(cursorX, cursorY, 3, "Left") || checkValidShip(cursorX, cursorY, 3, "Right") || checkValidShip(cursorX, cursorY, 3, "Up") || checkValidShip(cursorX, cursorY, 3, "Down")){
            destroyer = 1;
        }
        else{
            printf("Invalid placement for destroyer\n");
            invert32(cursorY, cursorX);
        }
    }
            
    printf("Valid location for destroyer\n");
    destroyer = 0;
    displayString32("Direction? ", 1, 1);
    displayString32("Length: 3  ", 2, 1);
    while (destroyer == 0)
    {
        input = getInput();
        if (strcmp(input, "Left") == 0 && checkValidShip(cursorX, cursorY, 3, "Left")){
            placeDestroyer(cursorX, cursorY, "Left");
            destroyer = 1;
        }
        if (strcmp(input, "Right") == 0 && checkValidShip(cursorX, cursorY, 3, "Right")){
            placeDestroyer(cursorX, cursorY, "Right");
            destroyer = 1;
        }
        if (strcmp(input, "Up") == 0 && checkValidShip(cursorX, cursorY, 3, "Up")){
            placeDestroyer(cursorX, cursorY, "Up");
            destroyer = 1;
        }       
        if (strcmp(input, "Down") == 0 && checkValidShip(cursorX, cursorY, 3, "Down")){
            placeDestroyer(cursorX, cursorY, "Down");
            destroyer = 1;
        }
    }
    printf("You placed a destroyer!\n");
    
    //Place the Submarine
    displayString32("Place 3 sq ", 1, 1);
    displayString32("Submarine  ", 2, 1);
    cursorY = 4;
    cursorX = 2;
    int submarine = 0;
    printf("I am now going to try to get a location for the submarine\n");
    while (submarine == 0)
    {
        getLocation32();
        printf("I got a location: %d, %d\n", cursorX, cursorY);
        if (checkValidShip(cursorX, cursorY, 3, "Left") || checkValidShip(cursorX, cursorY, 3, "Right") || checkValidShip(cursorX, cursorY, 3, "Up") || checkValidShip(cursorX, cursorY, 3, "Down")){
            submarine = 1;
        }
        else{
            printf("Invalid placement for submarine");
            invert32(cursorY, cursorX);
        }
    }       
    printf("Valid location for submarine\n");
    submarine = 0;
    displayString32("Direction? ", 1, 1);
    displayString32("Length: 3  ", 2, 1);
    while (submarine == 0)
    {
        input = getInput();
        if (strcmp(input, "Left") == 0 && checkValidShip(cursorX, cursorY, 3, "Left")){
            placeSubmarine(cursorX, cursorY, "Left");
            submarine = 1;
        }
        if (strcmp(input, "Right") == 0 && checkValidShip(cursorX, cursorY, 3, "Right")){
            placeSubmarine(cursorX, cursorY, "Right");
            submarine = 1;
        }
        if (strcmp(input, "Up") == 0 && checkValidShip(cursorX, cursorY, 3, "Up")){
            placeSubmarine(cursorX, cursorY, "Up");
            submarine = 1;
        }       
        if (strcmp(input, "Down") == 0 && checkValidShip(cursorX, cursorY, 3, "Down")){
            placeSubmarine(cursorX, cursorY, "Down");
            submarine = 1;
        }
    }
    printf("You placed a submarine!\n");
    
    //Place the Patrol Boat
    displayString32("Place 2 sq ", 1, 1);
    displayString32("Patrol Boat", 2, 1);
    cursorY = 4;
    cursorX = 2;
    int patrolboat = 0;
    printf("I am now going to try to get a location for the patrol boat\n");
    while (patrolboat == 0)
    {
        getLocation32();
        printf("I got a location: %d, %d", cursorX, cursorY);
        if(checkValidShip(cursorX, cursorY, 2, "Left") || checkValidShip(cursorX, cursorY, 2, "Right") || checkValidShip(cursorX, cursorY, 2, "Up") || checkValidShip(cursorX, cursorY, 2, "Down")){
            patrolboat = 1;
        }
        else{
            printf("Invalid placement for patrol boat\n");
            invert32(cursorY, cursorX);
        }
    }       
    printf("Valid location for patrol boat\n");
    patrolboat = 0;
    displayString32("Direction? ", 1, 1);
    displayString32("Length: 2  ", 2, 1);
    while(patrolboat == 0)
    {
        input = getInput();
        if (strcmp(input, "Left") == 0 && checkValidShip(cursorX, cursorY, 2, "Left")){
            placePatrolBoat(cursorX, cursorY, "Left");
            patrolboat = 1;
        }
        if (strcmp(input, "Right") == 0 && checkValidShip(cursorX, cursorY, 2, "Right")){
            placePatrolBoat(cursorX, cursorY, "Right");
            patrolboat = 1;
        }
        if (strcmp(input, "Up") == 0 && checkValidShip(cursorX, cursorY, 2, "Up")){
            placePatrolBoat(cursorX, cursorY, "Up");
            patrolboat = 1;
        }       
        if (strcmp(input, "Down") == 0 && checkValidShip(cursorX, cursorY, 2, "Down")){
            placePatrolBoat(cursorX, cursorY, "Down");
            patrolboat = 1;
        }
    }
    printf("You placed a patrol boat!\n");
    
    displayString16(playerName, 19, 2);
    displayString16(opponentName, 22, 2);
    displayString16("00 Hits", 20, 4);
    displayString16("00 Hits", 23, 4);
    
    //Exchange Ethernet Handshake with other computer.  Send playerName and ready signal, and wait for both to come back.
    //Skipping handshake to show 16 bit cursor
    /*sendPacket(strcat("Player Name ", playerName));
    sendPacket("Ready");
    char* message1 = receivePacket();
    int receivedName = 0;
    while (receivedName == 0){
        if (strlen(message1) >= 12 && strcmp(message1, "Player Name") == 0){
            strcpy(opponentName, message1+12);
            receivedName = 1;
        }
        else
            message1 = receivePacket();
    }
    char* message2 = receivePacket();
    int receivedReady = 0;
    while (receivedReady == 0){
        if (strcmp(message1, "Ready") == 0)
            receivedReady = 1;
        else
            message2 = receivePacket();
    }
    displayString16(playerName, 19, 2);
    displayString16(opponentName, 22, 2);
    return;*/
}


//Setup a game
void setupGame(){
    printf("I am initializing the display now\n");
    initializeDisplay();
    exitGame = 0;
    exitRound = 0;
    playerName = getPlayerName();
    //return;
}



//Play a game.  Initialize the round, then play a round.
void playGame(){
    
    initializeRound(); //This sets up the ships and waits until both players are ready

    while (exitRound == 0){
        //Play the game.  exitRound should be set to 1 if a player wins, 2 if a player quits the game using the quit condition (implement), 3 if the game goes out of sync. or 4 if another error occurs
        if (turn == 0){ //If players turn, enact that.
            playerTurn();
            turn = 1; //Set turn to opponent.
            } 
        else if (turn == 1){ //If opponent turn, enact that.
            opponentTurn();
            turn = 0; //Set turn to player.
            }
        else{ //Error condition.  Should never occur.
            exitRound = 4;
        }
        if (playerScore >= 17 || opponentScore >= 17)
            exitRound = 1;
        }
    //End of game loop
            
    //If game ended in victory
    if (exitRound == 1){
        if (playerScore == 17) //Player win condition.  Enact player victory.
            playerVictory();
        else if (opponentScore == 17) //Opponent win condition.  Enact opponent victory.
            opponentVictory();
    }
    //If player chose to exit game.
    else if (exitRound == 2){
        printf("Player quit game.  Goodbye!\n");
        sendPacket("Player Quit");
    }
        
    //If game falls out of sync.
    else if (exitRound == 3){
        printf("Game out of sync.  Game ending.  Sorry!\n");
        sendPacket("Out of Sync Quit");
    }
    //If other error condition occurs
    else{
        printf("Game error.  Game ending.  Sorry!\n") ;
        sendPacket("Game Error Quit");
    }
    return;
}

int main()
{
    
  // initialize ethernet
  DM9000_init(mac_address);
  interrupt_number = 0;
  alt_irq_register(DM9000A_IRQ, NULL, (void*)ethernet_interrupt_handler);  // listen to port
  printf("\nEthernet Initialized\n");
    
  // sprite and vga initialization
  write_sprite_data_to_memory();

  initializeDisplay();
  printf("\nDisplay Initialized\n");
  exitPlayer = 1;
  while (exitGame == 0){
        printf("I have determined that the game is not over\n");
        if (exitPlayer == 1){
            printf("I am setting up a game for new players\n");
            setupGame();
        }
        printf("I am going to play a new round now\n");
        playGame();
        printf("I am going to check if the player wants to play again\n");
        checkPlayAgain();
    }
    printf("I am going to quit the game now\n");
    return 0;

  return 0;
}
