library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity info_controller is
  port(
clk   : in std_logic;    
address: integer;
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector(4 downto 0);
pixel_G: out std_logic_vector(4 downto 0);
pixel_B: out std_logic_vector(4 downto 0)
  );

end info_controller;

architecture rtl of info_controller is 
----------------------------------COMPONENTS--------------------------------------------
component num0
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num1
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num2
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num3
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num4
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num5
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num6
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num7
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num8
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component num9
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component numl
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component numv
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;
component numx
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic
  );
end component;

-----------------------------------SIGNALS--------------------------------------------------------
signal ver : integer;
signal hor : integer;
signal sum : integer;
signal out0: std_logic;
signal out1: std_logic;
signal out2: std_logic;
signal out3: std_logic;
signal out4: std_logic;
signal out5: std_logic;
signal out6: std_logic;
signal out7: std_logic;
signal out8: std_logic;
signal out9: std_logic;
signal outl: std_logic;
signal outv: std_logic;
signal outx: std_logic;


begin
pout0: num0 port map(clk,ver*32+hor,out0);
pout1: num1 port map(clk,ver*32+hor,out1);
pout2: num2 port map(clk,ver*32+hor,out2);
pout3: num3 port map(clk,ver*32+hor,out3);
pout4: num4 port map(clk,ver*32+hor,out4);
pout5: num5 port map(clk,ver*32+hor,out5);
pout6: num6 port map(clk,ver*32+hor,out6);
pout7: num7 port map(clk,ver*32+hor,out7);
pout8: num8 port map(clk,ver*32+hor,out8);
pout9: num9 port map(clk,ver*32+hor,out9);
poutl: numl port map(clk,ver*32+hor,outl);
poutv: numv port map(clk,ver*32+hor,outv);
poutx: numx port map(clk,ver*32+hor,outx);
process(clk)
begin
if rising_edge(clk) then 
   hor <= horizontal;
   ver <= vertical;
end if;
end process;

process(clk)
begin
 if rising_edge(clk) then 
 case address is
 when 0 => if out0 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 1 => if out1 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 2 => if out2 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 3 => if out3 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 4 => if out4 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 5 => if out5 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 6 => if out6 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 7 => if out7 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 8 => if out8 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 9 => if out9 ='1' then 
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 10 => if outx ='1' then      ------XXXXX
              pixel_R <= "00000";
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 11 => if outl ='1' then 
              pixel_R <= "00000";   -- LLL
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
 when 12 => if outv ='1' then 
              pixel_R <= "00000";     --------- VVVVV
              pixel_G <= "00000";
              pixel_B <= "00000";
           else
              pixel_R <= "11111";
              pixel_G <= "11111";
              pixel_B <= "11111";
           end if;
when others =>   pixel_R <= "11111";
                 pixel_G <= "11111";
                 pixel_B <= "11111";
 
 end case;
  
 end if;

end process;



end rtl;
