library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity ice_cream_controller is
  port(
clk   : in std_logic;    
address: in unsigned (4 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector (4 downto 0);
pixel_G: out std_logic_vector (4 downto 0);
pixel_B: out std_logic_vector (4 downto 0)
  );

end ice_cream_controller;

architecture rtl of ice_cream_controller is
-------------------------------------------------------------sprite_down-----------------------------
component ice_cream_red_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_dlf--------------------------------
component ice_cream_red_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_drf-------------------------
component ice_cream_red_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_up-----------------------------
component ice_cream_red_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_ulf--------------------------------
component ice_cream_red_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_urf-------------------------
component ice_cream_red_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_left-----------------------------
component ice_cream_red_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_llf--------------------------------
component ice_cream_red_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_lrf-------------------------
component ice_cream_red_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_right-----------------------------
component ice_cream_red_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_rlf--------------------------------
component ice_cream_red_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_rrf-------------------------
component ice_cream_red_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_blue_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------dead----------------------------
component ice_cream_red_dead
 port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component ice_cream_green_dead
 port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;


component ice_cream_blue_dead
 port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

signal ver : integer;
signal hor : integer;
signal sprite_R_down,sprite_G_down,sprite_B_down : std_logic_vector(4 downto 0); 
signal sprite_R_dlf,sprite_G_dlf,sprite_B_dlf : std_logic_vector(4 downto 0); 
signal sprite_R_drf,sprite_G_drf,sprite_B_drf : std_logic_vector(4 downto 0);

signal sprite_R_up,sprite_G_up,sprite_B_up : std_logic_vector(4 downto 0); 
signal sprite_R_ulf,sprite_G_ulf,sprite_B_ulf : std_logic_vector(4 downto 0); 
signal sprite_R_urf,sprite_G_urf,sprite_B_urf : std_logic_vector(4 downto 0);


signal sprite_R_left,sprite_G_left,sprite_B_left : std_logic_vector(4 downto 0); 
signal sprite_R_llf,sprite_G_llf,sprite_B_llf : std_logic_vector(4 downto 0); 
signal sprite_R_lrf,sprite_G_lrf,sprite_B_lrf : std_logic_vector(4 downto 0);

signal sprite_R_right,sprite_G_right,sprite_B_right : std_logic_vector(4 downto 0); 
signal sprite_R_rlf,sprite_G_rlf,sprite_B_rlf : std_logic_vector(4 downto 0); 
signal sprite_R_rrf,sprite_G_rrf,sprite_B_rrf : std_logic_vector(4 downto 0);


signal sprite_R_dead, sprite_G_dead, sprite_B_dead : std_logic_vector(4 downto 0);

begin
----------------------------------------down -----------------------------------
ice_cream_R_down: ice_cream_red_down port map (clk,ver*32+hor,sprite_R_down);
ice_cream_G_down: ice_cream_green_down port map (clk,ver*32+hor,sprite_G_down);
ice_cream_B_down: ice_cream_blue_down port map (clk,ver*32+hor,sprite_B_down);

ice_cream_R_dlf: ice_cream_red_dlf port map (clk,ver*32+hor,sprite_R_dlf);
ice_cream_G_dlf: ice_cream_green_dlf port map (clk,ver*32+hor,sprite_G_dlf);
ice_cream_B_dlf: ice_cream_blue_dlf port map (clk,ver*32+hor,sprite_B_dlf);

ice_cream_R_drf: ice_cream_red_drf port map (clk,ver*32+hor,sprite_R_drf);
ice_cream_G_drf: ice_cream_green_drf port map (clk,ver*32+hor,sprite_G_drf);
ice_cream_B_drf: ice_cream_blue_drf port map (clk,ver*32+hor,sprite_B_drf);

----------------------------------------------up---------------------------------
ice_cream_R_up: ice_cream_red_up port map (clk,ver*32+hor,sprite_R_up);
ice_cream_G_up: ice_cream_green_up port map (clk,ver*32+hor,sprite_G_up);
ice_cream_B_up: ice_cream_blue_up port map (clk,ver*32+hor,sprite_B_up);

ice_cream_R_ulf: ice_cream_red_ulf port map (clk,ver*32+hor,sprite_R_ulf);
ice_cream_G_ulf: ice_cream_green_ulf port map (clk,ver*32+hor,sprite_G_ulf);
ice_cream_B_ulf: ice_cream_blue_ulf port map (clk,ver*32+hor,sprite_B_ulf);

ice_cream_R_urf: ice_cream_red_urf port map (clk,ver*32+hor,sprite_R_urf);
ice_cream_G_urf: ice_cream_green_urf port map (clk,ver*32+hor,sprite_G_urf);
ice_cream_B_urf: ice_cream_blue_urf port map (clk,ver*32+hor,sprite_B_urf);

----------------------------------------------left--------------------------------
ice_cream_R_left: ice_cream_red_left port map (clk,ver*32+hor,sprite_R_left);
ice_cream_G_left: ice_cream_green_left port map (clk,ver*32+hor,sprite_G_left);
ice_cream_B_left: ice_cream_blue_left port map (clk,ver*32+hor,sprite_B_left);

ice_cream_R_llf: ice_cream_red_llf port map (clk,ver*32+hor,sprite_R_llf);
ice_cream_G_llf: ice_cream_green_llf port map (clk,ver*32+hor,sprite_G_llf);
ice_cream_B_llf: ice_cream_blue_llf port map (clk,ver*32+hor,sprite_B_llf);

ice_cream_R_lrf: ice_cream_red_lrf port map (clk,ver*32+hor,sprite_R_lrf);
ice_cream_G_lrf: ice_cream_green_lrf port map (clk,ver*32+hor,sprite_G_lrf);
ice_cream_B_lrf: ice_cream_blue_lrf port map (clk,ver*32+hor,sprite_B_lrf);

-----------------------------------------------right----------------------------
ice_cream_R_right: ice_cream_red_right port map (clk,ver*32+hor,sprite_R_right);
ice_cream_G_right: ice_cream_green_right port map (clk,ver*32+hor,sprite_G_right);
ice_cream_B_right: ice_cream_blue_right port map (clk,ver*32+hor,sprite_B_right);

ice_cream_R_rlf: ice_cream_red_rlf port map (clk,ver*32+hor,sprite_R_rlf);
ice_cream_G_rlf: ice_cream_green_rlf port map (clk,ver*32+hor,sprite_G_rlf);
ice_cream_B_rlf: ice_cream_blue_rlf port map (clk,ver*32+hor,sprite_B_rlf);

ice_cream_R_rrf: ice_cream_red_rrf port map (clk,ver*32+hor,sprite_R_rrf);
ice_cream_G_rrf: ice_cream_green_rrf port map (clk,ver*32+hor,sprite_G_rrf);
ice_cream_B_rrf: ice_cream_blue_rrf port map (clk,ver*32+hor,sprite_B_rrf);


-----------------------------------------------dead-----------------------------

ice_cream_R_dead: ice_cream_red_dead port map (clk,ver*32+hor,sprite_R_dead);
ice_cream_G_dead: ice_cream_green_dead port map (clk,ver*32+hor,sprite_G_dead);
ice_cream_B_dead: ice_cream_blue_dead port map (clk,ver*32+hor,sprite_B_dead);




process(clk)
begin
if rising_edge(clk) then 
   hor <= horizontal;
   ver <= vertical;
end if;
end process;

process(clk)
begin
if rising_edge(clk) then 
case address is 
	----------------------------------------down---------------------------------------
  when "00000" =>								-- down
 --   if sprite_R_down /= "00000" then
    pixel_R <= sprite_R_down;
 --   else
 --   pixel_R <= "11111";
 --   end if;

 --   if sprite_G_down /= "00000" then     
    pixel_G <= sprite_G_down;
 --   else
 --   pixel_G <= "11111";
 --   end if;

 --   if sprite_B_down /= "00000" then
    pixel_B <= sprite_B_down;
 --   else
 --   pixel_B <= "11111";
 --   end if;

  when "00001" =>   						    -- dlf
 --   if sprite_R_dlf /= "00000" then
    pixel_R <= sprite_R_dlf;
 --   else
 --   pixel_R <= "11111";
 --   end if;

--    if sprite_G_dlf /= "00000" then
    pixel_G <= sprite_G_dlf;
--    else
--    pixel_G <= "11111";
--    end if;

--    if sprite_B_dlf /= "00000" then
    pixel_B <= sprite_B_dlf;
--    else
--    pixel_B <= "11111";
 --   end if;
 
 when "00010" =>                               -- drf
--     if sprite_R_drf /= "00000" then
    pixel_R <= sprite_R_drf;
 --   else
 --   pixel_R <= "11111";
 --   end if;

 --   if sprite_G_drf /= "00000" then
    pixel_G <= sprite_G_drf;
--    else
--    pixel_G <= "11111";
 --   end if;

 --   if sprite_B_drf /= "00000" then
    pixel_B <= sprite_B_drf;
 --   else
 --   pixel_B <= "11111";
 --   end if;  

---------------------------------------------------------------up----------------------------
 when "00011" =>								
--    if sprite_R_up /= "00000" then
    pixel_R <= sprite_R_up;
--    else
--    pixel_R <= "11111";
 --   end if;

--    if sprite_G_up /= "00000" then     
    pixel_G <= sprite_G_up;
 --   else
 --   pixel_G <= "11111";
 --   end if;

 --   if sprite_B_up /= "00000" then
    pixel_B <= sprite_B_up;
 --   else
 --   pixel_B <= "11111";
 --   end if;

  when "00100" =>   						    
 --   if sprite_R_ulf /= "00000" then
    pixel_R <= sprite_R_ulf;
 --   else
 --   pixel_R <= "11111";
 --   end if;

 --   if sprite_G_ulf /= "00000" then
    pixel_G <= sprite_G_ulf;
 --   else
 --   pixel_G <= "11111";
 --   end if;

 --   if sprite_B_ulf /= "00000" then
    pixel_B <= sprite_B_ulf;
 --   else
 --   pixel_B <= "11111";
 --   end if;
 
 when "00101" =>                               -- urf
--     if sprite_R_urf /= "00000" then
    pixel_R <= sprite_R_urf;
 --   else
 --   pixel_R <= "11111";
--    end if;

 --   if sprite_G_urf /= "00000" then
    pixel_G <= sprite_G_urf;
--    else
--    pixel_G <= "11111";
 --   end if;

  --  if sprite_B_urf /= "00000" then
    pixel_B <= sprite_B_urf;
--    else
--    pixel_B <= "11111";
 --   end if;  

---------------------------------------------------------------left----------------------------
 when "00110" =>								
 --   if sprite_R_left /= "00000" then
    pixel_R <= sprite_R_left;
 --   else
 --   pixel_R <= "11111";
--    end if;

 --   if sprite_G_left /= "00000" then     
    pixel_G <= sprite_G_left;
  --  else
  --  pixel_G <= "11111";
  --  end if;

  --  if sprite_B_left /= "00000" then
    pixel_B <= sprite_B_left;
 --   else
 --   pixel_B <= "11111";
 --   end if;

  when "00111" =>   						    
  --  if sprite_R_llf /= "00000" then
    pixel_R <= sprite_R_llf;
 --   else
 --   pixel_R <= "11111";
 --   end if;

 --   if sprite_G_llf /= "00000" then
    pixel_G <= sprite_G_llf;
 --   else
 --   pixel_G <= "11111";
 --   end if;

  --  if sprite_B_llf /= "00000" then
    pixel_B <= sprite_B_llf;
 --   else
 --   pixel_B <= "11111";
  --  end if;
 
 when "01000" =>                               -- lrf
 --    if sprite_R_lrf /= "00000" then
    pixel_R <= sprite_R_lrf;
 --   else
 --   pixel_R <= "11111";
 --   end if;

 --   if sprite_G_lrf /= "00000" then
    pixel_G <= sprite_G_lrf;
 --   else
 --   pixel_G <= "11111";
 --   end if;

  --  if sprite_B_lrf /= "00000" then
    pixel_B <= sprite_B_lrf;
 --   else
 --  pixel_B <= "11111";
 --   end if;  

---------------------------------------------------------------right----------------------------
 when "01001" =>								
 --   if sprite_R_right /= "00000" then
    pixel_R <= sprite_R_right;
 --   else
 --   pixel_R <= "11111";
 --   end if;

  --  if sprite_G_right /= "00000" then     
    pixel_G <= sprite_G_right;
 --   else
 --   pixel_G <= "11111";
  --  end if;

  --  if sprite_B_right /= "00000" then
    pixel_B <= sprite_B_right;
 --   else
 --   pixel_B <= "11111";
  --  end if;

  when "01010" =>   						    
 --   if sprite_R_rlf /= "00000" then
    pixel_R <= sprite_R_rlf;
 --   else
 --   pixel_R <= "11111";
  --  end if;

 --   if sprite_G_rlf /= "00000" then
    pixel_G <= sprite_G_rlf;
 --   else
 --  pixel_G <= "11111";
  --  end if;

  --  if sprite_B_rlf /= "00000" then
    pixel_B <= sprite_B_rlf;
 --   else
 --   pixel_B <= "11111";
 --   end if;
 
 when "01011" =>                               -- rrf
   --  if sprite_R_rrf /= "00000" then
    pixel_R <= sprite_R_rrf;
 --   else
 --   pixel_R <= "11111";
  --  end if;

  --  if sprite_G_rrf /= "00000" then
    pixel_G <= sprite_G_rrf;
 --   else
 --   pixel_G <= "11111";
  --  end if;

  --  if sprite_B_rrf /= "00000" then
    pixel_B <= sprite_B_rrf;
 --   else
 --   pixel_B <= "11111";
 --   end if;  

  when "01100" => 								--dead
  pixel_R <= sprite_R_dead;
  pixel_G <= sprite_G_dead;
  pixel_B <= sprite_B_dead;


  when others =>
  pixel_R <= "11111";
  pixel_G <= "11111";
  pixel_B <= "11111";
	end case;
  

    

end if;
end process;

end rtl;
