library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_red_lrf is
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end guard_red_lrf;

architecture rtl of guard_red_lrf is

type rom_type is array (0 to 1023) of std_logic_vector(4 downto 0);   -- denote tile content

constant ROM :rom_type :=  (
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","10110","10001","10011","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","10100","11000","10110","01110","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11011","10110","10111","10110","10111","11000","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","10111","01111","11111","10010","10010","11111","11111","11000","10010","10011","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11011","10111","10011","11000","10011","10010","10111","10111","01111","01000","01001","10100","10110","11000","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","01111","10001","10111","01001","10101","10100","00100","00100","10000","11010","11001","01010","00110","01001","11001","11110","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","01111","01010","01010","01010","01100","01110","10001","10001","10001","10010","10010","10111","11001","10110","00101","10101","11110","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","01001","01110","11011","01011","01010","01011","01110","10001","10001","10001","10001","10010","10010","10011","11001","01001","01101","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11011","00111","01110","01101","01100","11001","01111","01001","01011","01101","10000","10010","10001","10001","10001","10010","11010","01000","01100","11111","01111","11000","11111",
"11111","11111","11111","11111","11111","11111","11111","11101","11101","11001","01101","01011","01000","01001","11110","11011","10010","00111","01010","01011","01101","10001","10001","10001","10010","10100","00111","00110","10010","11001","10101","10101",
"11111","11111","11111","11111","11111","11111","11101","11101","11101","11100","11000","01001","01011","10101","11110","11111","11011","10100","01001","01000","01100","10010","10010","10010","10000","00111","10010","10010","01011","11110","10100","10001",
"11111","11111","11111","11111","11110","11101","11101","11110","11110","11110","11101","10100","10101","11100","11111","11110","11001","10010","10100","01101","01001","01101","10001","10010","10000","00110","10001","10101","10101","11110","10101","10010",
"11111","11111","11111","11111","11100","11100","11111","11111","11110","11110","11111","11110","11100","11011","11101","11101","10101","00111","11101","10100","01011","01100","01111","01111","01110","10010","10010","10110","11110","11110","10011","10001",
"11111","11111","11111","11000","10111","11001","11110","11110","11101","11101","11110","11110","11101","11100","11011","11000","10010","01010","11001","10110","10001","10010","01111","01010","01010","11100","11111","11111","11110","11101","10010","01111",
"11111","11111","11101","00011","01001","10001","11001","11000","11100","11110","11100","11100","11101","11110","11100","01111","01100","10010","10001","10001","10001","10001","01110","01010","01010","11100","11110","11110","11101","11001","10010","10011",
"11111","11111","11100","00100","01100","10001","01110","01110","10100","11011","11110","11111","11101","11100","11110","11101","11000","10010","10010","10001","10001","10001","01111","01010","01001","11010","11011","11010","11001","01010","10110","11111",
"11111","11011","10001","00011","01100","10010","10001","10001","01111","10001","11011","11110","11111","11110","11110","11110","11101","11010","10010","10001","10001","10001","10011","01100","00100","01001","01001","01001","01011","11011","11111","11111",
"11111","11010","10000","00011","01000","01101","10010","10001","10001","10000","01111","11001","11101","11110","11101","11101","11101","11011","10011","10001","10001","10001","10010","10001","01110","00111","10110","11100","11011","11111","11111","11111",
"11000","10100","10000","00011","00111","01101","10010","10010","10010","10001","10000","10000","10111","11111","11100","11101","11101","11011","10011","10001","10001","10001","10001","10010","10000","00100","10000","11010","11111","11111","11111","11111",
"10101","10001","10000","00011","00111","01100","01111","10000","10001","10010","10010","01101","10100","11110","11110","11111","11110","11100","10011","10001","10001","10001","10001","10010","01111","00011","01100","10111","11111","11111","11111","11111",
"10101","10010","10000","00010","00111","01011","01100","01110","01111","10000","10010","10000","10001","10101","11101","11110","11011","10110","10010","10001","10001","10001","10001","10010","10000","00010","01101","10111","11111","11111","11111","11111",
"10101","10001","10001","01000","00111","01000","01010","01100","01100","01101","10000","10010","10000","01111","10111","10110","10100","10001","10001","10001","10001","10010","10010","01111","01011","01000","01110","10111","11111","11111","11111","11111",
"10101","10001","10010","10011","01010","00110","01000","01010","01010","01011","01111","10000","10001","10001","10001","01111","01111","10010","10010","10010","10001","10001","10001","01001","00011","10010","10001","10110","11111","11111","11111","11111",
"10101","10001","10010","10010","10010","01110","00100","01000","01010","01011","01110","01110","01101","01110","10001","10001","10001","10001","10001","10001","10000","01101","01010","00111","00110","10001","10001","10110","11111","11111","11111","11111",
"10110","10010","10010","10010","10010","10010","10001","00101","00111","01010","01010","01010","01010","01010","01101","01101","01101","01101","01101","01101","01101","01010","00011","01001","10010","10010","10010","10111","11111","11111","11111","11111",
"11111","11001","10001","10010","10010","10010","10010","10001","01001","00011","00011","00011","00011","00011","00011","00101","00111","00110","00011","00111","01001","00011","00010","01001","10010","10001","11010","11111","11111","11111","11111","11111",
"11111","11010","10001","10010","10010","10010","10010","10010","10000","01100","00010","01100","01111","01111","01110","01111","01111","01111","01100","00111","00011","00010","01100","10000","10010","10001","11011","11111","11111","11111","11111","11111",
"11111","11110","11010","10010","10001","10010","10010","10010","10010","01111","00010","01100","10000","10000","10000","01111","01111","01111","01111","00111","00011","01101","10001","10010","10010","11011","11110","11111","11111","11111","11111","11111",
"11111","11111","11111","11010","10100","10001","10001","10010","10010","10000","01011","00111","00110","00110","00110","00110","00110","00110","00110","01001","01101","10010","10001","10101","11011","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11010","11000","11000","10010","10001","10001","10010","01011","01000","01001","01001","01001","01001","01001","01000","01110","10100","11000","11000","11011","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","10111","10110","10101","10001","10010","10010","10010","10010","10010","10010","10010","10110","10110","11000","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","10101","10101","10101","10101","10101","10101","10100","10101","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"
); 

begin

  process(clk)
begin
  if rising_edge(clk) then
  data <= ROM(addr);
  end if;
  end process;

end rtl;