library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_red_dlf is
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end guard_red_dlf;

architecture rtl of guard_red_dlf is

type rom_type is array (0 to 1023) of std_logic_vector(4 downto 0);   -- denote tile content

constant ROM :rom_type :=  (
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11010","10001","10001","11100","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11001","01110","11000","10101","11001","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11100","10110","11000","10110","10110","11000","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","10110","10111","10111","10111","10111","10111","11101","11111","11101","01101","11011","11010","10011","11001","11110","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","10101","00101","00100","00011","00011","00011","00010","10011","11110","11101","01100","11001","11111","11011","01011","11011","11111","11111","11111","11111","11111","11111",
"11111","11111","11110","11111","11111","11111","11111","11111","11111","01111","01001","11000","01110","01011","01010","01010","01010","00100","01110","11101","01100","11000","11110","11100","01101","11010","11111","11111","11111","11111","11111","11111",
"11111","11000","01111","10000","11101","11111","11111","11111","01001","10000","10110","01110","01011","01010","01010","01010","01000","00111","01000","01010","01011","11000","11110","11110","11011","01101","10100","11111","11111","11111","11111","11111",
"10101","10110","11000","01110","11100","11111","11100","01111","01011","01100","01101","01010","00111","00111","00111","01000","01000","01101","01010","00101","11001","11100","11110","11110","11101","01010","10010","11111","11111","11111","11111","11111",
"10001","10110","11100","01110","11101","11001","10000","01001","01011","01010","01001","01001","10010","10100","10000","01000","10110","11010","10101","01011","01101","11001","11110","11011","10000","10100","11011","11111","11111","11111","11111","11111",
"10010","10101","11101","10110","11000","10000","00111","01001","01000","01000","01011","10100","11101","11110","10101","00111","11000","11010","10111","10000","00010","10110","11111","11001","00110","11010","11111","11111","11111","11111","11111","11111",
"10001","10101","11110","11111","01111","01010","01000","00111","01101","01101","10010","11111","11111","11110","10111","01101","01110","10000","10001","10000","00111","10001","10101","10100","01111","11100","11111","11111","11111","11111","11111","11111",
"10100","10101","11100","11110","01110","01101","01111","01011","11001","11100","11101","11110","11111","11111","11110","11010","01011","10000","10011","10011","10011","01000","00011","01000","11011","11111","11111","11111","11111","11111","11111","11111",
"11111","10110","01110","11101","11110","11101","11101","11101","01010","10010","11100","11100","11111","11111","11110","11011","11011","11011","11011","11011","11100","10101","10010","01111","00100","11000","11111","11111","11111","11111","11111","11111",
"11111","10110","01110","11100","11101","11110","11111","11110","00111","00110","01110","11100","11111","11101","11011","11011","11011","11101","11110","11110","11110","11100","11011","11001","10000","00111","01100","10110","11111","11111","11111","11111",
"11111","11101","10111","01100","11010","11110","11110","11101","00110","01001","01110","01100","11010","11100","11100","11110","11110","11110","11110","11101","11101","11110","11110","11110","11001","10000","01001","01000","10101","11110","11111","11111",
"11111","11111","11110","10101","10000","01111","01110","01101","01011","10010","10110","10011","11100","11101","11101","11101","11101","11101","11101","11101","11101","11110","11111","11111","11011","10101","01010","00100","10001","10110","11100","11111",
"11111","11111","11111","11111","10011","10001","01110","00010","10011","11010","11101","11101","11101","11101","11101","11101","11101","11101","11110","11111","11111","11111","11111","11111","11011","10100","01001","00100","10010","10001","11001","11111",
"11111","11111","11111","11111","11111","11101","10101","00111","11000","11110","11110","11110","11101","11100","11101","11111","11111","11111","11111","11110","11110","11110","11110","11101","11000","10011","01100","00111","01110","10001","10111","11101",
"11111","11111","11111","11111","11111","10000","00101","10011","11010","11101","11101","11101","11110","11111","11111","11110","11110","11110","11100","11001","11001","11001","11001","10111","01111","10001","10010","01110","00010","01111","10010","10101",
"11111","11111","11111","11111","11111","10000","00111","11100","11111","11101","11101","11110","11111","11111","11101","11010","11010","11011","10110","01111","01111","01111","01111","10000","10001","10010","01110","01001","00010","01111","10010","10101",
"11111","11111","11111","11111","11111","10000","00111","11100","11111","11111","11111","11111","11111","11101","11000","10000","10000","10000","10001","10001","10001","10001","10001","10001","10010","01111","01100","01000","00010","01111","10010","10101",
"11111","11111","11111","11111","11111","10000","00101","10101","11011","11100","11100","11100","11101","10110","10001","10000","10000","10000","10001","10001","10001","10010","10000","01111","01111","01100","01000","00110","01110","10001","10001","10101",
"11111","11111","11111","11111","11111","10000","00011","01110","10100","10101","10100","10100","10100","10001","10000","10010","10010","10010","10010","10010","10010","10000","01110","01011","01100","01011","00110","00011","01001","10001","10010","10101",
"11111","11111","11111","11111","11111","10011","00111","00111","01110","01111","01110","01110","01111","10001","10010","10010","10010","10001","10000","10000","10000","01101","01011","01010","01010","01011","00110","00011","01000","01011","01110","10101",
"11111","11111","11111","11111","11111","11011","10001","00011","01011","01101","01101","01110","10001","10001","10001","10001","10001","01111","01101","01110","01101","01011","01010","01010","01000","01001","00110","00110","10000","00011","01011","11000",
"11111","11111","11111","11111","11111","11111","11001","00011","01000","01010","01010","01010","01110","01110","01110","01110","01110","01011","01010","01010","01010","01010","01010","01000","00100","00101","00111","01001","01001","00100","10011","11111",
"11111","11111","11111","11111","11111","11111","11001","00010","00010","00111","01010","01010","01010","01010","01010","01010","01010","01010","01010","01010","01010","01010","00111","00101","10001","00110","00011","00011","00011","01110","11001","11111",
"11111","11111","11111","11111","11111","11111","11001","00010","01000","01000","00111","01011","01010","01010","01010","01010","01010","01011","01000","00011","00011","00011","01000","10000","10010","10000","01111","01111","01111","11011","11111","11111",
"11111","11111","11111","11111","11111","11111","11110","10110","00110","00010","00010","00100","00100","00100","00100","00100","00100","00100","00111","01101","01101","01101","01111","10010","10010","10001","10001","10011","11100","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","10100","10001","10010","10001","01011","01010","01010","01010","01010","01010","01101","10010","10010","10010","10010","10001","10001","10111","11001","11010","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11000","11000","10110","10010","10010","10010","10010","10001","10001","10001","10100","10111","10111","11101","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11100","10100","10101","10101","10101","10101","10101","10100","11001","11111","11111","11111","11111","11111","11111","11111","11111","11111"
); 

begin

  process(clk)
begin
  if rising_edge(clk) then
  data <= ROM(addr);
  end if;
  end process;

end rtl;