library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_green_down is
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end guard_green_down;

architecture rtl of guard_green_down is

type rom_type is array (0 to 1023) of std_logic_vector(4 downto 0);   -- denote tile content

constant ROM :rom_type :=  (
"11111","11111","11111","11111","11111","11110","01111","01110","01110","10110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","10110","01110","01110","11010","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11101","11000","10001","10000","01010","10011","11111","11111","11011","11000","11000","11000","11000","11000","11010","11111","11111","11111","10011","01010","10000","10110","11011","11111","11111","11111","11111","11111",
"11111","11111","11111","11100","10101","10000","11010","11011","10001","10111","11111","11011","10011","01101","01110","01110","01110","01110","10000","11001","11110","11111","10111","10001","11011","10011","10010","11011","11011","11111","11111","11111",
"11111","11111","11111","01101","10100","11110","01011","01010","11100","11110","11001","01000","10011","11011","11011","11011","11011","11011","10111","01000","10101","11011","11110","11100","01001","11001","11011","01010","01101","11111","11111","11111",
"11111","11110","11011","01110","10101","11110","01011","01010","11001","10011","00111","01000","01001","01010","01001","01001","01001","01001","01001","01000","01000","00111","10011","11001","01010","11001","11011","01100","01111","11011","11110","11111",
"11111","10111","00111","10011","11011","11111","10111","10110","01010","00111","01000","01000","01000","01000","00110","00101","00101","00110","01000","01000","01000","01000","00111","01010","10110","11101","11101","10110","10100","00111","10111","11111",
"11111","10111","00111","10011","11011","11110","01100","01011","00111","00110","00101","00101","00110","00110","00111","01001","01001","00111","00110","00101","00101","00101","00110","00111","01010","11001","11110","10110","10100","00111","10111","11111",
"11111","10111","00110","10011","11001","11100","10100","10011","01000","01101","10101","10101","01110","01001","01110","10110","11000","01111","01011","10101","10100","10100","01101","01000","10011","11010","11011","10110","10100","00110","10111","11111",
"11111","10110","00100","10100","10111","11000","11110","11110","01011","10011","11111","10100","01111","01011","10000","10111","11110","10011","01100","10010","11100","11111","10010","01011","11110","11010","10111","10111","10100","00100","10110","11111",
"11111","11011","10001","01101","10001","10111","11000","11000","01001","10001","11100","00110","01000","01011","01110","10011","10110","10000","01001","00100","10110","11111","10001","01001","11000","10111","10100","01101","01110","10001","11011","11111",
"11111","11111","11111","10011","10000","10000","01111","01111","10000","10110","11010","00111","00111","01001","01100","10001","10000","01100","01000","00101","10101","11101","10110","10000","01111","10000","10000","10000","10011","11111","11111","11111",
"11111","11111","11111","11111","10101","00111","01000","01001","11001","11100","11001","00111","00110","00111","01010","01110","01110","01010","00110","00101","10100","11100","11100","11001","01001","01000","01110","11111","11111","11111","11111","11111",
"11111","11111","11111","01110","10001","11001","11001","11001","01111","01100","01100","01010","01010","01010","01010","01011","01011","01010","01010","01001","01100","01101","01100","01111","11000","11001","10101","01011","01111","11111","11111","11111",
"11111","11111","11111","01010","10001","11100","10001","10000","10110","10111","10111","10111","10111","10111","10111","10111","10111","10111","10111","10111","11010","11011","11011","11001","10000","11001","10111","00101","01010","11111","11111","11111",
"11111","11001","01011","10110","10100","10000","10111","10111","10110","10110","10101","01100","01110","10000","10000","10000","10000","10000","01111","01100","10100","11000","10111","11000","11100","10011","10001","11000","10110","01011","11001","11111",
"11111","10111","00101","11010","10011","01000","10100","10100","01100","01010","01011","10001","10010","10011","10011","10011","10011","10011","10011","10010","01101","01010","01010","01100","10110","01111","10000","11101","11001","00101","10111","11111",
"11111","10111","00110","11001","10010","00111","10000","10001","01010","01001","01010","10011","10010","10001","10001","10001","10001","10001","10010","10100","01100","01001","01001","01010","10001","01100","01111","11100","11001","00110","10111","11111",
"11111","10111","00110","11001","10100","01010","01100","01100","01100","01100","01100","01100","01011","01010","01010","01010","01010","01010","01010","01100","01100","01100","01100","01100","01100","01010","01111","11101","11001","00110","10110","11111",
"11101","10100","00110","10111","11010","10111","01011","01010","01010","01010","01010","01001","10010","11001","11000","11000","11000","11000","10110","01010","01010","01010","01010","01010","01001","10011","11001","11010","10111","00110","10100","11101",
"11101","10100","00110","10001","10111","11011","11000","11000","11000","11000","11000","10111","11010","11100","11100","11100","11100","11100","11011","11000","11000","11000","11000","11000","10111","11010","11001","10011","10001","00110","10100","11101",
"11101","10100","00101","10001","10101","11000","11011","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11001","10110","10100","10001","00101","10100","11101",
"11100","11000","10001","01100","10000","10101","11001","11001","11001","11010","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11100","11010","11001","11001","10110","10010","01100","01101","10001","11000","11100",
"11100","11011","11011","01000","01011","10100","10100","10101","10100","10111","11010","11001","11001","11001","11001","11001","11001","11001","11001","11001","11001","11001","10111","10101","10101","10100","01111","00100","01000","11011","11011","11100",
"11100","11011","11011","10011","01110","01101","10011","10011","10011","10100","10101","10101","10101","10101","10101","10101","10101","10101","10101","10101","10101","10101","10100","10011","10011","01110","01101","10001","10010","11011","11011","11100",
"11101","11100","11100","10011","10001","01111","10000","10000","10001","10010","10011","10011","10011","10011","10011","10011","10011","10011","10011","10011","10011","10011","10010","10001","10000","01111","10000","10010","10011","11100","11101","11110",
"11111","11011","10010","01110","10100","11010","10001","10000","10000","10001","10001","01110","01110","01110","01110","01110","01110","01110","01110","01110","10000","10001","10001","10000","10000","11000","11000","01110","01111","10010","11011","11111",
"11111","10111","00101","11001","11010","10110","10111","10111","10100","10001","01101","00110","00110","00110","00110","00110","00110","00110","00110","00110","01100","01110","10001","10100","10111","10111","11000","11101","11001","00101","10111","11111",
"11111","10111","00110","10011","10100","10100","10100","10011","01010","01000","01001","10110","10111","10111","10111","10111","10111","10111","10111","11000","01100","00111","01000","01010","10011","10100","10100","10101","10010","00110","10111","11111",
"11111","11110","11001","01011","01000","01001","01000","01001","10100","10110","10111","11011","11011","11011","11011","11011","11011","11011","11011","11100","11000","10110","10111","10100","01001","01000","01001","01000","01011","11001","11110","11111",
"11111","11111","11111","11010","11001","11001","11001","11001","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11011","11001","11001","11001","11001","11010","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11110","11011","11011","11011","11011","11011","11011","11011","11011","11011","11101","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11100","11100","11100","11100","11100","11100","11100","11100","11100","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"
); 

begin

  process(clk)
begin
  if rising_edge(clk) then
  data <= ROM(addr);
  end if;
  end process;

end rtl;