library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_controller is
  port(
clk   : in std_logic;    
address: in unsigned (4 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector (4 downto 0);
pixel_G: out std_logic_vector (4 downto 0);
pixel_B: out std_logic_vector (4 downto 0)
  );

end guard_controller;

architecture rtl of guard_controller is
-------------------------------------------------------------sprite_down-----------------------------
component guard_red_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_down
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_dlf--------------------------------
component guard_red_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_dlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_drf-------------------------
component guard_red_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_drf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_up-----------------------------
component guard_red_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_up
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_ulf--------------------------------
component guard_red_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_ulf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_urf-------------------------
component guard_red_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_urf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_left-----------------------------
component guard_red_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_left
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_llf--------------------------------
component guard_red_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_llf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_lrf-------------------------
component guard_red_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_lrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

-------------------------------------------------------------sprite_right-----------------------------
component guard_red_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_right
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-----------------------------------------------------------sprite_rlf--------------------------------
component guard_red_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_rlf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;
-------------------------------------------------------------sprite_rrf-------------------------
component guard_red_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_green_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;

component guard_blue_rrf
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end component;


signal ver : integer;
signal hor : integer;
signal monster_R_down,monster_G_down,monster_B_down : std_logic_vector(4 downto 0); 
signal monster_R_dlf,monster_G_dlf,monster_B_dlf : std_logic_vector(4 downto 0); 
signal monster_R_drf,monster_G_drf,monster_B_drf : std_logic_vector(4 downto 0);

signal monster_R_up,monster_G_up,monster_B_up : std_logic_vector(4 downto 0); 
signal monster_R_ulf,monster_G_ulf,monster_B_ulf : std_logic_vector(4 downto 0); 
signal monster_R_urf,monster_G_urf,monster_B_urf : std_logic_vector(4 downto 0);


signal monster_R_left,monster_G_left,monster_B_left : std_logic_vector(4 downto 0); 
signal monster_R_llf,monster_G_llf,monster_B_llf : std_logic_vector(4 downto 0); 
signal monster_R_lrf,monster_G_lrf,monster_B_lrf : std_logic_vector(4 downto 0);

signal monster_R_right,monster_G_right,monster_B_right : std_logic_vector(4 downto 0); 
signal monster_R_rlf,monster_G_rlf,monster_B_rlf : std_logic_vector(4 downto 0); 
signal monster_R_rrf,monster_G_rrf,monster_B_rrf : std_logic_vector(4 downto 0);

begin
----------------------------------------down -----------------------------------
guard_R_down: guard_red_down port map (clk,ver*32+hor,monster_R_down);
guard_G_down: guard_green_down port map (clk,ver*32+hor,monster_G_down);
guard_B_down: guard_blue_down port map (clk,ver*32+hor,monster_B_down);

guard_R_dlf: guard_red_dlf port map (clk,ver*32+hor,monster_R_dlf);
guard_G_dlf: guard_green_dlf port map (clk,ver*32+hor,monster_G_dlf);
guard_B_dlf: guard_blue_dlf port map (clk,ver*32+hor,monster_B_dlf);

guard_R_drf: guard_red_drf port map (clk,ver*32+hor,monster_R_drf);
guard_G_drf: guard_green_drf port map (clk,ver*32+hor,monster_G_drf);
guard_B_drf: guard_blue_drf port map (clk,ver*32+hor,monster_B_drf);

----------------------------------------------up---------------------------------
guard_R_up: guard_red_up port map (clk,ver*32+hor,monster_R_up);
guard_G_up: guard_green_up port map (clk,ver*32+hor,monster_G_up);
guard_B_up: guard_blue_up port map (clk,ver*32+hor,monster_B_up);

guard_R_ulf: guard_red_ulf port map (clk,ver*32+hor,monster_R_ulf);
guard_G_ulf: guard_green_ulf port map (clk,ver*32+hor,monster_G_ulf);
guard_B_ulf: guard_blue_ulf port map (clk,ver*32+hor,monster_B_ulf);

guard_R_urf: guard_red_urf port map (clk,ver*32+hor,monster_R_urf);
guard_G_urf: guard_green_urf port map (clk,ver*32+hor,monster_G_urf);
guard_B_urf: guard_blue_urf port map (clk,ver*32+hor,monster_B_urf);

----------------------------------------------left--------------------------------
guard_R_left: guard_red_left port map (clk,ver*32+hor,monster_R_left);
guard_G_left: guard_green_left port map (clk,ver*32+hor,monster_G_left);
guard_B_left: guard_blue_left port map (clk,ver*32+hor,monster_B_left);

guard_R_llf: guard_red_llf port map (clk,ver*32+hor,monster_R_llf);
guard_G_llf: guard_green_llf port map (clk,ver*32+hor,monster_G_llf);
guard_B_llf: guard_blue_llf port map (clk,ver*32+hor,monster_B_llf);

guard_R_lrf: guard_red_lrf port map (clk,ver*32+hor,monster_R_lrf);
guard_G_lrf: guard_green_lrf port map (clk,ver*32+hor,monster_G_lrf);
guard_B_lrf: guard_blue_lrf port map (clk,ver*32+hor,monster_B_lrf);

-----------------------------------------------right----------------------------
guard_R_right: guard_red_right port map (clk,ver*32+hor,monster_R_right);
guard_G_right: guard_green_right port map (clk,ver*32+hor,monster_G_right);
guard_B_right: guard_blue_right port map (clk,ver*32+hor,monster_B_right);

guard_R_rlf: guard_red_rlf port map (clk,ver*32+hor,monster_R_rlf);
guard_G_rlf: guard_green_rlf port map (clk,ver*32+hor,monster_G_rlf);
guard_B_rlf: guard_blue_rlf port map (clk,ver*32+hor,monster_B_rlf);

guard_R_rrf: guard_red_rrf port map (clk,ver*32+hor,monster_R_rrf);
guard_G_rrf: guard_green_rrf port map (clk,ver*32+hor,monster_G_rrf);
guard_B_rrf: guard_blue_rrf port map (clk,ver*32+hor,monster_B_rrf);

process(clk)
begin
if rising_edge(clk) then 
   hor <= horizontal;
   ver <= vertical;
end if;
end process;

process(clk)
begin
if rising_edge(clk) then 
case address is 
----------------------------------------down---------------------------------------
  when "00000" =>								-- down
--    if monster_R_down /= "00000" then
    pixel_R <= monster_R_down;
--    else
--    pixel_R <= "11111";
--    end if;

 --   if monster_G_down /= "00000" then     
    pixel_G <= monster_G_down;
--    else
--    pixel_G <= "11111";
--    end if;

   
    pixel_B <= monster_B_down;
   
  when "00001" =>   						    -- dlf
   
    pixel_R <= monster_R_dlf;
   

   
    pixel_G <= monster_G_dlf;
   

   
    pixel_B <= monster_B_dlf;
   
 when "00010" =>                               -- drf
   
    pixel_R <= monster_R_drf;
   
   
    pixel_G <= monster_G_drf;
   
    pixel_B <= monster_B_drf;
  
---------------------------------------------------------------up----------------------------
 when "00011" =>								
  
    pixel_R <= monster_R_up;
   
    pixel_G <= monster_G_up;
 
    pixel_B <= monster_B_up;
  

  when "00100" =>   						    
  
    pixel_R <= monster_R_ulf;
  

 
    pixel_G <= monster_G_ulf;
  

  
    pixel_B <= monster_B_ulf;
  
 
 when "00101" =>                               -- urf
 
    pixel_R <= monster_R_urf;
  
    pixel_G <= monster_G_urf;
    pixel_B <= monster_B_urf;
  
---------------------------------------------------------------left----------------------------
 when "00110" =>								
   
    pixel_R <= monster_R_left;
  
    pixel_G <= monster_G_left;
   
    pixel_B <= monster_B_left;
   

  when "00111" =>   						    
  
    pixel_R <= monster_R_llf;
  
    pixel_G <= monster_G_llf;
    
    pixel_B <= monster_B_llf;
   
 
 when "01000" =>                               -- lrf
    
    pixel_R <= monster_R_lrf;
   
    pixel_G <= monster_G_lrf;
   
    pixel_B <= monster_B_lrf;
    
---------------------------------------------------------------right----------------------------
 when "01001" =>								
   
    pixel_R <= monster_R_right;
   
    pixel_G <= monster_G_right;
   
    pixel_B <= monster_B_right;
   

  when "01010" =>   						    

    pixel_R <= monster_R_rlf;
  
    pixel_G <= monster_G_rlf;
   
    pixel_B <= monster_B_rlf;
 
 
 when "01011" =>                               -- rrf
   
    pixel_R <= monster_R_rrf;
   
    pixel_G <= monster_G_rrf;
   
    pixel_B <= monster_B_rrf;
   


  when others =>
  pixel_R <= "11111";
  pixel_G <= "11111";
  pixel_B <= "11111";
end case;
  
end if;
end process;

end rtl;
