library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_blue_up is
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end guard_blue_up;

architecture rtl of guard_blue_up is

type rom_type is array (0 to 1023) of std_logic_vector(4 downto 0);   -- denote tile content

constant ROM :rom_type :=  (
"11111","11111","11111","11111","11111","11111","11111","10001","00110","00111","11001","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11001","00111","00110","10001","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11110","01100","10001","10001","00000","10111","11111","11111","10000","01101","01101","01101","01101","10000","11111","11111","10111","00000","10001","10001","01100","11110","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11001","10001","01110","10001","10010","01111","11011","11100","10010","01110","01101","01101","01101","01101","01110","10010","11100","11011","01111","10010","10001","01110","10001","11001","11111","11111","11111","11111",
"11111","11111","11111","11111","10000","00001","11111","01100","00100","11111","11010","10010","00110","10100","10111","10111","10111","10111","10100","00110","10010","11010","11111","00100","01100","11111","00001","10000","11111","11111","11111","11111",
"11111","11111","11111","11100","01111","00100","11111","01101","00101","11100","01011","00111","01111","01110","01110","01110","01110","01110","01110","01111","00111","01011","11100","00101","01101","11111","00100","01111","11100","11111","11111","11111",
"11111","11111","11111","00101","00100","01101","11111","10100","01010","00101","01011","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","00101","01010","10100","11111","01101","00100","00101","11111","11111","11111",
"11111","11111","11111","00100","00100","01101","11110","11111","11000","00100","01011","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","00100","11000","11111","11110","01101","00100","00100","11111","11111","11111",
"11111","11111","11111","00101","00101","01100","10110","11101","11011","00100","01011","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","00100","11011","11101","10110","01100","00101","00101","11111","11111","11111",
"11111","11111","11111","00100","00101","01100","01110","10101","10101","00100","01011","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","00100","10101","10101","01110","01100","00101","00100","11111","11111","11111",
"11111","11111","11111","10001","01010","00110","01010","01110","01110","00100","01011","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","00100","01110","01110","01010","00110","01010","10001","11111","11111","11111",
"11111","11111","11111","11111","10101","01001","01001","01001","01000","00111","01100","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01100","00111","01000","01001","01001","01001","10101","11111","11111","11111","11111",
"11111","11111","11111","11111","11110","11010","00111","00101","00111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","00111","00101","00111","11010","11110","11111","11111","11111","11111",
"11111","11111","11111","11111","10011","00101","01101","01111","01111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01101","00101","10011","11111","11111","11111","11111",
"11111","11111","11111","11111","10011","00100","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01101","00010","10010","11111","11111","11111","11111",
"11111","11111","11111","01101","01010","01100","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01011","01010","01101","11111","11111","11111",
"11111","11111","11110","00101","00111","01111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01111","00111","00101","11110","11111","11111",
"11111","11111","11110","00110","00111","01111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01111","00111","00110","11110","11111","11111",
"11111","11111","11110","00110","00111","01111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01111","00111","00110","11110","11111","11111",
"11111","11111","11110","00110","00111","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","00111","00110","11110","11111","11111",
"11111","11111","11110","00110","00100","01001","01101","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01101","01001","00100","00110","11110","11111","11111",
"11111","11111","11110","00101","00100","01000","01000","01100","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01110","01100","01000","01000","00100","00101","11110","11111","11111",
"11111","11111","11110","11001","01110","00011","00111","01001","01010","01001","01101","01110","01110","01111","01001","00100","01101","01110","01110","01110","01110","01101","01011","01010","01001","00111","00011","01110","11001","11110","11111","11111",
"11111","11111","11111","11111","10001","00000","00111","01000","00111","00111","01010","01011","01011","01011","01000","00101","01011","01100","01100","01100","01011","01010","01000","01000","01000","00111","00000","10001","11111","11111","11111","11111",
"11111","11111","11111","11111","10111","01101","00110","00111","01000","01000","00111","00111","00111","01000","01000","01001","01001","01001","01001","01001","01000","00111","00111","01000","00111","00110","01101","10111","11111","11111","11111","11111",
"11111","11111","11111","11111","11100","10111","00110","00101","00110","00110","00111","01000","01000","00111","00111","00111","00111","00111","00111","00111","00111","00111","00110","00110","00101","00110","10111","11100","11111","11111","11111","11111",
"11111","11111","11110","11101","10000","00011","01101","00110","00001","00100","00110","00111","00111","00111","00111","00111","00111","00111","00111","00111","00111","00110","00100","00001","00110","01101","00011","10000","11101","11110","11111","11111",
"11111","11111","11110","00111","01000","01101","01001","01000","00111","00111","00101","00011","00011","00011","00011","00011","00011","00011","00011","00011","00011","00101","00111","00111","01000","01001","01101","01000","00111","11110","11111","11111",
"11111","11111","11111","00101","00100","01001","01000","01000","00111","00010","00001","01001","11011","11010","11010","11010","11010","11010","11010","11011","01001","00001","00010","00111","01000","01000","01001","00100","00101","11111","11111","11111",
"11111","11111","11111","11001","01101","00001","00011","00010","00110","10110","10110","11001","11111","11111","11111","11111","11111","11111","11111","11111","11001","10110","10110","00110","00010","00011","00001","01101","11001","11111","11111","11111",
"11111","11111","11111","11111","11001","10001","10010","10001","10100","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","10100","10001","10010","10001","11001","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"
); 

begin

  process(clk)
begin
  if rising_edge(clk) then
  data <= ROM(addr);
  end if;
  end process;

end rtl;