library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity guard_blue_drf is
  port(
clk   : in std_logic;    
addr  : in integer;
data  : out std_logic_vector (4 downto 0)
  );
end guard_blue_drf;

architecture rtl of guard_blue_drf is

type rom_type is array (0 to 1023) of std_logic_vector(4 downto 0);   -- denote tile content

constant ROM :rom_type :=  (
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11001","00110","00111","10111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","10011","01101","10100","00001","10011","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","10011","01111","01111","10010","01111","11001","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11101","10110","00111","10101","11000","00000","11100","11111","11101","10111","10111","10111","10111","10111","10111","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11000","00000","10010","11100","10110","00001","11100","11110","10011","00010","00011","00011","00011","00100","00110","10101","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","10111","00001","11011","11010","01110","00001","11011","01111","00011","00010","00010","00010","00010","00101","10111","01010","10000","11111","11111","11111","11111","11111","11110","11110","11111","11111",
"11111","11111","11111","11111","11111","10001","00101","01010","11101","11010","01110","00000","00100","00011","00001","00001","00010","00010","00010","00011","00101","10011","10000","01010","11111","11111","11111","11010","00101","00011","10011","11111",
"11111","11111","11111","11111","11111","01111","00001","01100","11101","11001","10010","01111","00100","01000","01000","00001","00010","00001","00001","00001","00010","00110","00110","00011","01001","11010","11111","11010","00001","10100","01111","01101",
"11111","11111","11111","11111","11111","11010","10000","00101","10001","11001","11000","01011","01010","10100","11001","10011","00011","00101","00110","00101","00001","00001","00010","00010","00001","01010","10111","11010","00000","11011","01111","00110",
"11111","11111","11111","11111","11111","11111","11000","00000","01000","10010","10010","00100","01101","10101","11001","10111","00011","00110","01100","10001","01111","00101","00001","00001","00010","00000","01001","10010","01111","11001","01100","00111",
"11111","11111","11111","11111","11111","11111","11011","01010","01001","01000","01000","00111","01101","01110","01100","01001","00011","00111","10000","11010","11111","01011","00110","01001","00001","00001","00000","00110","11111","10111","01000","00111",
"11111","11111","11111","11111","11111","11111","11111","11100","01001","00101","01000","01110","01101","01101","01001","00010","00101","01111","10011","10011","10111","01100","10001","11001","00110","00100","00100","01010","11110","10100","01010","01011",
"11111","11111","11111","11111","11111","11111","11001","00110","01100","01111","01110","01010","01000","00111","00111","00110","00000","01010","10001","10001","01000","00111","00101","00111","11110","10110","11001","11101","10100","00011","10000","11111",
"11111","11111","11111","11111","11111","10011","01000","01101","01010","01010","01110","11000","10111","11000","10010","00101","00101","00110","01011","01110","00001","00001","00010","01000","11111","11111","11010","10100","01100","00000","10000","11111",
"11111","11111","11111","11111","01101","01010","01001","00100","01110","10100","10010","01001","01000","10100","11001","10101","10110","01010","00110","00111","00001","01001","01000","00101","10000","10001","01111","01011","00011","10011","11100","11111",
"11111","11111","11111","11110","00110","01000","01011","00000","10000","10110","10101","01101","01101","01111","10000","10000","10000","10001","10010","10000","00100","00111","01010","01010","00111","00100","00011","00111","10011","11101","11111","11111",
"11111","11111","11111","11111","00111","01000","01011","00000","01111","10010","10011","10011","10100","10000","01101","01101","01101","10001","10011","10011","01111","10000","01111","01010","00100","01100","01110","10001","11111","11111","11111","11111",
"11111","11111","11101","10111","01000","01010","01100","00010","01010","01011","01011","01011","01011","10001","10101","10101","10101","01111","01011","01101","10100","11100","10100","00101","00111","10101","11101","11111","11111","11111","11111","11111",
"11111","11111","11001","00010","01011","01110","01101","01010","00010","00000","00001","00001","00000","01011","10010","10010","10010","10100","10101","10011","00110","01110","01101","01000","01110","00101","10001","11111","11111","11111","11111","11111",
"11111","11111","11001","00010","00110","01011","01110","01110","01010","01001","01001","01001","01010","00100","00001","00001","00000","01110","10101","10100","10100","01000","01010","10001","01010","00100","10001","11111","11111","11111","11111","11111",
"11111","11111","11001","00010","00110","01000","01010","01110","01110","01110","01110","01110","01110","01010","01000","01000","01000","00100","00111","10001","10000","01110","01111","01111","01010","00011","10000","11111","11111","11111","11111","11111",
"11111","11111","11101","11000","00111","00101","01000","01010","01001","01100","01111","01110","01110","01101","01101","01101","01101","01001","00101","00011","00100","00100","00011","00101","01101","00011","10000","11111","11111","11111","11111","11111",
"11111","11111","11101","01111","00100","00101","01000","00111","00111","01001","01100","01110","01110","01110","01110","01110","01110","01101","01010","00100","00101","00101","00110","01000","01011","00010","01111","11111","11111","11111","11111","11111",
"11111","11010","10001","00110","00010","00100","01000","01000","00111","00111","01001","01100","01100","01100","01101","01110","01110","01110","01101","01100","01010","01001","01011","01011","00110","01011","10110","11111","11111","11111","11111","11111",
"11111","10000","00010","01101","00100","00100","00111","00110","00111","01000","01000","01000","01001","01001","01010","01101","01101","01101","01101","01101","01001","01000","01000","00111","00100","11001","11111","11111","11111","11111","11111","11111",
"11111","10011","00100","00111","00111","00101","00011","00101","00110","00111","00111","00111","00111","00111","01000","01010","01001","01001","01001","01001","01000","00111","00111","00110","00100","11001","11111","11111","11111","11111","11111","11111",
"11111","11111","11000","00011","00011","00010","01001","11101","00111","00101","00111","00111","00111","00111","00111","01000","01000","01000","01000","01000","00111","01000","00100","00000","00010","11001","11111","11111","11111","11111","11111","11111",
"11111","11111","11110","11010","11010","11010","11011","11111","11100","01100","00001","00010","00010","00110","01000","01000","01000","01000","01000","01000","01000","00101","00101","00110","00001","11001","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11010","10110","10110","10111","01010","00010","00011","00011","00011","00011","00011","00011","00001","00001","00110","10110","11110","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","10110","10001","10001","10001","10001","10001","10001","10010","10010","10001","10100","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111",
"11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"
); 

begin

  process(clk)
begin
  if rising_edge(clk) then
  data <= ROM(addr);
  end if;
  end process;

end rtl;