-------------------------------------------------------------------------------
--
-- Simple VGA raster display
--
-- Haodan Huang & Ziheng Zhou
-- sedwards@cs.columbia.edu
--
-------------------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster is
  
  port (
    reset_n : in std_logic;
    clk   : in std_logic;                    -- Should be 25.125 MHz

    VGA_CLK,                         -- Clock
    VGA_HS,                          -- H_SYNC
    VGA_VS,                          -- V_SYNC
    VGA_BLANK,                       -- BLANK
    VGA_SYNC : out std_logic;        -- SYNC
    VGA_R,                           -- Red[9:0]
    VGA_G,                           -- Green[9:0]
    VGA_B : out std_logic_vector(9 downto 0); -- Blue[9:0]

---------------------------------------------------------circle component
    write      : in  std_logic;
	read       : in  std_logic;
    chipselect : in  std_logic;
    address    : in  unsigned(4 downto 0);
    writedata  : in  unsigned(15 downto 0);
    readdata   : out unsigned(15 downto 0)
------------------------------------------------------------
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
component ice_cream_controller
 port(
clk   : in std_logic;    
address: in unsigned (4 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector(4 downto 0);
pixel_G: out std_logic_vector(4 downto 0);
pixel_B: out std_logic_vector(4 downto 0)
  );
end component;

component guard_controller
 port(
clk   : in std_logic;    
address: in unsigned (4 downto 0);
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector(4 downto 0);
pixel_G: out std_logic_vector(4 downto 0);
pixel_B: out std_logic_vector(4 downto 0)
  );
end component;
component info_controller
port(
clk   : in std_logic;    
address: integer;
vertical: in integer;
horizontal: in integer;

pixel_R: out std_logic_vector(4 downto 0);
pixel_G: out std_logic_vector(4 downto 0);
pixel_B: out std_logic_vector(4 downto 0)
);
end component;

  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  
  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;


  type ice_cream_row is array(0 to 31) of std_logic_vector(7 downto 0);   -- denote tile content
  type ice_cream_column is array(0 to 31) of ice_cream_row;
  
  type snow_row is array(0 to 31) of std_logic_vector(4 downto 0);  --denote snow content
  type snow_tile is array(0 to 31) of snow_row;
  
  type map_position1 is array(19 downto 0) of std_logic_vector(2 downto 0);
  type map_position is array(14 downto 0) of map_position1; 
  type map_level is array (2 downto 0) of map_position;

--------------------------------------------------ice-----------------

constant ice_red : ice_cream_column :=  (
("11111101","11110110","11111101","01111000","00110000","00110111","00110111","00110111","00111000","00111000","00111000","00111000","00111000","00111000","00110111","00110111","00110111","00110111","00110111","00110111","00111000","00111000","00111000","00110111","00110111","00111000","00111000","00110111","00110100","11001010","11111101","11111111"),
("11011100","01001100","01000111","10011101","11001011","11000110","11000110","11000110","11000101","11000101","11000101","11000101","11000101","11000101","11000110","11000110","11000110","11000110","11000110","11000110","11000101","11000101","11000101","11000110","11000110","11000101","11000101","11000110","11001000","01100100","01100011","11111001"),
("01101001","10111001","10111000","11010001","11011111","11011110","11011111","11100100","10100011","01111111","10000011","10000011","10000010","10000000","11001011","11100000","11011110","11011111","11100001","11011011","10001100","10000001","01111101","10111101","11011111","10001011","01111100","10101011","11100010","11000100","10101001","01011000"),
("01001110","11011111","11100000","11011100","11011011","11100001","11000010","10000100","01110011","01101000","01100110","01100010","10010000","11000010","11010101","11011100","11100010","10110101","10000011","10000100","01100110","10000001","11000110","10011010","10000100","10111000","10111110","11001011","11011100","11100010","11000100","00110000"),
("01010001","11011011","11011100","11011101","11010111","10010110","10000001","01101000","01101001","01101111","10110010","10111000","11001011","11100000","11011111","11010000","10010001","01111011","01100100","01101100","10110100","10101111","10001100","10100111","10111010","11011010","11011111","11011110","11011101","11011111","11000010","00110101"),
("01010001","11011011","11011100","11010011","11000101","01110000","01101000","01101011","01110100","10000001","11010110","11100001","11011110","11011100","11010010","10111011","01100111","01110000","01111100","10000001","11001010","10110110","01101111","10111000","11100011","11011100","11011101","11010101","11001100","11011011","11000010","00110101"),
("01010001","11011011","11100000","10010100","01101100","01101100","01101111","01110010","10110101","11011011","11011011","11011011","11010111","11010010","10000100","01101110","01110001","10011111","11010011","11001001","01111110","10010100","11011010","11011010","11011011","11010011","11010110","10100101","01101010","11000110","11000101","00110101"),
("01010001","11011011","11100000","10010001","01100111","01100100","10001011","11010110","11011001","11011101","11011111","11100100","10101100","01101111","01100111","01111010","11011010","10101000","01101100","01110111","11001000","11010110","11011100","11011111","11011001","01111111","01110011","01110000","01101001","11000101","11000101","00110101"),
("01010001","11011011","11100000","10001110","01101000","10101110","11000011","11011101","11100000","11011011","10011000","10010010","01111100","01100100","10101001","10110101","10001101","10100000","10110101","10110110","11011000","11011110","11100011","10101111","10001100","01101111","01101010","01101011","01101011","11000101","11000101","00110101"),
("01010001","11011011","11011101","10111100","10101111","11011011","11100000","11100011","10110011","10010100","01101000","01011111","10001001","10110110","10011110","10011011","10100110","11000010","11100001","11011111","11100010","11001011","10011010","01111011","01100110","01101100","01101100","01101100","01101011","11000101","11000101","00110101"),
("01010001","11011011","11011100","11011110","11100000","11011101","11001000","10100010","01111011","01101001","10100000","10100110","10100110","10100111","10100000","10101011","11011111","11011110","11011011","11011000","10101010","10010000","01100101","01101010","01101100","01101100","01101100","01101100","01101011","11000101","11000101","00110101"),
("01010001","11011011","11011100","11011011","11011011","11100011","10111000","01100011","01100110","01110000","11011001","11101011","10100110","01011101","11000110","11100010","11011011","11011101","11100000","11011000","01110010","01100111","01101100","01101100","01101100","01101100","01101100","01101100","01101011","11000101","11000101","00110101"),
("01010001","11011011","11011100","11011111","11011011","10011101","10000101","01100010","10011100","10110111","10010011","10001110","10100000","10110011","11010010","11011101","11100011","10111101","10010010","10010011","01110000","01101011","01101100","01101100","01101100","01101100","01101100","01101001","01100101","11000100","11000101","00110101"),
("01010001","11011011","11011110","10110011","10010111","01100101","01111011","10110001","10100011","10011101","10100100","10100011","11000001","11100001","11100001","11010101","10100000","10000100","01100110","01101000","01101100","01101100","01101100","01101100","01101100","01101000","01100100","10000101","10101100","11010011","11000011","00110101"),
("01010001","11011011","11100000","10001011","01100011","10100001","10100111","10100110","10011111","10100000","11011010","11100001","11100000","11100000","10110100","10011010","01101000","01101001","01101100","01101100","01101100","01101100","01101100","01101000","01101010","10011011","10011111","10111111","11100111","11100001","11000001","00110101"),
("01010001","11011011","11011110","10101111","10011000","10110010","10101001","10010000","11000110","11100011","11011011","11011101","11000110","10101100","01110110","01100110","01101100","01101100","01101100","01101100","01101100","01101100","01101010","10000111","10011111","11011001","11100011","11001001","10101011","11010100","11000011","00110101"),
("01010001","11011011","11011100","11100000","11011000","01101100","10001100","11100100","11011101","11011011","11011100","11100001","10100100","01100010","01101011","01101100","01101100","01101100","01101100","01101100","01101100","01101100","01100110","10110100","11100100","11011100","11100001","10100111","01100000","11000100","11000101","00110101"),
("01010001","11011011","11011111","10100000","10000011","10111100","11001011","11011100","11011110","11011000","10001101","10000101","01111001","01101011","01101100","01101100","01101100","01101100","01101100","01101100","01100110","10000100","11000100","11010100","11011010","10001110","10000101","01111000","01100110","11000100","11000101","00110101"),
("01010010","11011010","11011100","11000011","10111001","11011011","11011111","11100010","10101001","10000111","01101100","01101000","01101010","01101100","01101100","01101100","01101100","01101010","01100111","01101101","10110010","11001000","11100111","10101101","10000111","01101001","01100001","10001100","10111110","11010110","11000010","00110110"),
("01001101","11101110","11110001","11100011","11011100","11011100","11001011","10101110","01111101","01100000","01100111","01100111","01100111","01100111","01100111","01100111","01100101","01111100","10010101","10011000","11011000","11010000","10101110","01111110","01100011","10001111","10010010","10110101","11100000","11101111","11010010","00101011"),
("00110110","11000111","11000110","11011111","11101100","11101110","11010000","10010110","10011100","10011101","10011101","10011101","10011101","10011101","10011101","10011101","10011001","11000100","11110100","11110000","11101110","11010010","10010110","10011011","10100010","11101000","11110001","11101110","11101011","11010011","10101011","00011000"),
("00011011","00110111","00110001","10011110","11011001","11010011","11010100","11010111","11010111","11010111","11010111","11010111","11010111","11010111","11010111","11010111","11010111","11010101","11010011","11010011","11010011","11010100","11010111","11010111","11010111","11010011","11010011","11010011","11010101","01011100","00101101","00010110"),
("00011101","00111101","00111101","00111100","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111011","00111101","00110111","00010110"),
("00011101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111110","00110111","00010110"),
("00011101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111110","00110111","00010110"),
("00011101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111110","00110111","00010110"),
("00011101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111110","00110111","00010110"),
("00011101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111101","00111110","00110111","00010110"),
("00011000","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111110","00111111","00110111","00010000"),
("00111101","00110010","00110010","00110111","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00111001","00110011","00110100","00111111"),
("11010111","00110011","00110010","00100111","00100001","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00100010","00101010","01010001","11111001"),
("11111101","11110110","11111110","01100010","00001101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010101","00010100","00010010","11000010","11111110","11111111")
);


constant ice_green : ice_cream_column :=  (
("11111101","11110110","11111101","01110000","00100011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101011","00101000","11000111","11111101","11111111"),
("11011001","01000001","00111001","10101000","11100100","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11011110","11100000","01100000","01011000","11111001"),
("01100011","11001110","11001101","11101100","11111110","11111100","11111100","11111101","11110011","11101101","11101110","11101110","11101110","11101110","11111001","11111100","11111100","11111100","11111100","11111011","11101111","11101110","11101101","11110111","11111100","11101111","11101101","11110100","11111101","11011011","10111001","01001101"),
("01001000","11111100","11111110","11111010","11111000","11111001","11110100","11101011","11101000","11100111","11100110","11100101","11101101","11110101","11110111","11111000","11111010","11110010","11101010","11101011","11100110","11101010","11110101","11101110","11101011","11110011","11110100","11110110","11111000","11111111","11011100","00100011"),
("01001011","11110111","11111001","11111000","11110111","11101101","11101010","11100111","11100111","11101000","11110010","11110011","11110101","11111000","11111000","11110110","11101100","11101001","11100110","11100111","11110010","11110001","11101100","11110000","11110011","11110111","11111000","11111000","11111000","11111100","11011000","00101000"),
("01001011","11110111","11111001","11110111","11110101","11100111","11100110","11100111","11101000","11101010","11111000","11111001","11111001","11111000","11110111","11110011","11100110","11100111","11101001","11101010","11110101","11110010","11101000","11110011","11111010","11111000","11111000","11110111","11110110","11111100","11011000","00101000"),
("01001011","11110111","11111001","11101101","11100111","11100111","11100111","11100111","11110010","11111000","11111000","11111000","11111000","11110111","11101011","11101000","11100111","11101111","11110111","11110101","11101010","11101101","11110111","11111000","11111000","11110111","11111000","11110000","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111010","11101101","11100110","11100101","11101011","11111000","11111000","11111000","11111001","11111010","11110001","11100111","11100110","11101001","11110111","11110000","11100111","11101001","11110110","11111000","11111000","11111001","11111000","11101010","11101000","11101000","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111010","11101100","11100110","11110001","11110100","11111000","11111001","11111000","11101110","11101101","11101010","11100110","11110000","11110010","11101100","11101111","11110010","11110010","11110111","11111000","11111010","11110010","11101100","11101000","11100111","11100111","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111001","11110011","11110001","11111000","11111001","11111001","11110010","11101101","11100111","11100101","11101100","11110011","11101111","11101110","11110000","11110100","11111001","11111001","11111001","11110110","11101110","11101001","11100110","11100111","11100111","11100111","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111001","11111001","11111001","11111000","11110101","11101111","11101001","11100110","11101111","11110000","11110000","11110000","11101111","11110001","11111001","11111001","11111000","11110111","11110000","11101100","11100110","11100111","11100111","11100111","11100111","11100111","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111001","11111000","11111000","11111010","11110011","11100101","11100110","11100111","11110111","11111010","11110000","11100101","11110101","11111001","11111000","11111000","11111001","11111000","11101000","11100110","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11111001","11011001","00101000"),
("01001011","11110111","11111001","11111001","11111000","11101110","11101011","11100101","11101110","11110010","11101101","11101101","11101111","11110010","11110111","11111000","11111010","11110011","11101101","11101101","11101000","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100110","11111000","11011001","00101000"),
("01001011","11110111","11111001","11110010","11101110","11100110","11101001","11110001","11101111","11101110","11110000","11110000","11110100","11111001","11111001","11110111","11110000","11101011","11100110","11100110","11100111","11100111","11100111","11100111","11100111","11100110","11100110","11101010","11110000","11111011","11011000","00101000"),
("01001011","11110111","11111010","11101100","11100110","11101111","11110000","11110000","11101111","11101111","11111000","11111001","11111001","11111001","11110010","11101110","11100110","11100110","11100111","11100111","11100111","11100111","11100111","11100110","11100110","11101110","11101111","11110100","11111001","11111101","11011000","00101000"),
("01001011","11110111","11111001","11110001","11101110","11110010","11110000","11101100","11110101","11111001","11111000","11111000","11110101","11110001","11101000","11100110","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11101011","11101111","11111000","11111010","11110101","11110001","11111011","11011000","00101000"),
("01001011","11110111","11111001","11111001","11111000","11100111","11101100","11111010","11111000","11111000","11111000","11111001","11101111","11100101","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100110","11110010","11111010","11111000","11111001","11110000","11100101","11111000","11011001","00101000"),
("01001011","11110111","11111001","11101111","11101010","11110011","11110101","11111000","11111000","11110111","11101100","11101011","11101001","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11101011","11110100","11110111","11110111","11101100","11101011","11101001","11100111","11111001","11011001","00101000"),
("01001100","11110111","11111001","11110101","11110011","11111000","11111000","11111010","11110001","11101011","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100111","11100110","11100111","11110010","11110101","11111010","11110001","11101011","11100111","11100101","11101100","11110011","11111011","11011001","00101001"),
("01000110","11111100","11111110","11111010","11111000","11111000","11110110","11110001","11101010","11100110","11100110","11100110","11100110","11100110","11100110","11100110","11100110","11101001","11101101","11101110","11110111","11110110","11110001","11101010","11100110","11101100","11101101","11110010","11111000","11111111","11011100","00100001"),
("00111000","11101001","11101010","11110110","11111101","11111100","11111000","11101111","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11101111","11110110","11111110","11111101","11111101","11111000","11101111","11101111","11110001","11111100","11111101","11111101","11111100","11110011","11001001","00010100"),
("00101111","10110111","10110110","11011100","11110001","11101111","11101111","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11110000","11101111","11101111","11101111","11101111","11110000","11110000","11110000","11101111","11101111","11101111","11110000","11000111","10011100","00010100"),
("00110000","10111001","10111010","10111000","10110111","10110111","10110111","10111000","10110111","10110111","10110111","10110111","10110111","10111000","10111000","10111000","10110111","10110111","10111000","10111000","10111000","10111000","10111000","10110111","10110111","10110111","10110111","10110111","10110111","10111100","10100000","00010100"),
("00110000","10111001","10111001","11000010","11000111","11001000","11000011","10110111","11000001","11000111","11001000","11001001","11000001","10111000","10111000","10111011","11001000","11000001","10111000","10111001","10111001","10111001","10110111","11000001","11000111","11000110","11000110","11000110","11000110","10111111","10011111","00010100"),
("00110000","10111001","10111000","11010101","11100100","11011001","11010001","11000010","11011000","11100011","11011001","11011001","11001001","10110111","11000010","11001001","11011001","11001010","10111000","10111001","10111000","10111100","11000011","11010111","11100011","11100010","11100010","11100011","11100100","11000110","10011111","00010100"),
("00110000","10111001","10111001","11001110","11010111","11000001","11001011","11100101","11011101","11010110","10111010","10110110","10111100","11000010","11010110","11010101","10111000","10111000","10111000","10111001","10111111","11001011","11100011","11100001","11100001","11100010","11100010","11011110","11011001","11000100","10011111","00010100"),
("00110000","10111001","10111010","10111101","11000010","11011110","11100000","11011100","11000101","10111000","10111110","10111110","11001100","11011100","11000000","10111000","10111001","10111100","10111111","11000001","11011110","11100010","11100001","11100001","11100001","11011100","11011100","11001100","10111000","10111101","10100000","00010100"),
("00110000","10111001","10111000","11010011","11100010","11100100","11010110","10111001","10111000","10111010","11011110","11100100","11001111","10111000","10111001","10111001","10110101","11001010","11100010","11100000","11100001","11100001","11100001","11100011","11100001","10111110","10111001","10111010","10111001","10111101","10100000","00010100"),
("00101100","10111101","10111100","11010110","11100010","11001111","11000110","10111000","11000111","11001111","11001110","11001111","11000100","10111000","10111001","10111101","11001101","11010111","11100011","11100010","11100010","11100010","11100011","11010101","11001011","10111011","10111001","10111001","10111001","11000000","10100010","00001110"),
("01001100","10010111","10010101","11000100","11011011","10111100","10111001","10111001","11010001","11011100","10111100","10111000","10111001","10111010","10111001","11000000","11011101","11011100","11011011","11011011","11011011","11011011","11011100","11000110","10111000","10111010","10111010","10111010","10111010","10100001","10001000","00111100"),
("11010110","00110000","00101010","01111000","10100001","10011100","10011100","10011100","10011101","10011101","10011100","10011100","10011100","10011100","10011100","10011100","10011101","10011101","10011101","10011101","10011101","10011101","10011101","10011100","10011100","10011100","10011100","10011100","10011101","01000100","01001011","11111001"),
("11111101","11110101","11111101","01100010","00001110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010110","00010101","00010011","11000001","11111101","11111111")
);


constant ice_blue : ice_cream_column :=  (
("11111110","11111100","11111110","11010110","11000000","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000010","11000001","11101111","11111110","11111111"),
("11110101","11001000","11000110","11100011","11110011","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110001","11110010","11010000","11001111","11111110"),
("11010001","11101101","11101101","11110101","11111001","11111001","11111001","11111001","11110001","11101101","11101101","11101101","11101101","11101101","11110110","11111001","11111001","11111001","11111001","11111000","11101110","11101101","11101101","11110101","11111001","11101110","11101100","11110010","11111010","11110000","11101000","11001100"),
("11001010","11111001","11111001","11111000","11111000","11111000","11110100","11101101","11101011","11101010","11101001","11101001","11101110","11110100","11110111","11111000","11111000","11110011","11101101","11101101","11101001","11101101","11110110","11110000","11101101","11110011","11110100","11110110","11111000","11111010","11110000","11000000"),
("11001011","11111000","11111000","11111000","11110111","11101111","11101101","11101010","11101010","11101011","11110011","11110100","11110110","11111000","11111000","11110110","11101110","11101100","11101001","11101010","11110011","11110010","11101110","11110001","11110011","11110111","11111000","11111000","11111000","11111001","11110000","11000001"),
("11001011","11111000","11111000","11110111","11110101","11101011","11101010","11101010","11101011","11101101","11110111","11111000","11111000","11111000","11110111","11110100","11101001","11101010","11101100","11101101","11110101","11110011","11101010","11110011","11111001","11111000","11111000","11110111","11110110","11111001","11110000","11000001"),
("11001011","11111000","11111001","11101111","11101001","11101010","11101010","11101011","11110011","11111000","11111000","11111000","11111000","11110111","11101101","11101010","11101011","11110000","11110111","11110101","11101101","11101111","11111000","11111000","11111000","11110111","11111000","11110001","11101001","11110110","11110000","11000001"),
("11001011","11111000","11111001","11101111","11101001","11101001","11101110","11110111","11111000","11111000","11111001","11111010","11110010","11101010","11101001","11101011","11110111","11110001","11101010","11101100","11110110","11110111","11111000","11111001","11111000","11101100","11101011","11101011","11101010","11110110","11110000","11000001"),
("11001011","11111000","11111001","11101110","11101001","11110010","11110101","11111000","11111001","11111000","11110000","11101111","11101100","11101001","11110010","11110011","11101110","11110000","11110011","11110011","11110111","11111000","11111001","11110011","11101110","11101011","11101010","11101010","11101010","11110110","11110000","11000001"),
("11001011","11111000","11111000","11110100","11110010","11111000","11111001","11111001","11110011","11101111","11101010","11101000","11101110","11110011","11110001","11110000","11110010","11110101","11111001","11111001","11111001","11110110","11110000","11101100","11101001","11101010","11101010","11101010","11101010","11110110","11110000","11000001"),
("11001011","11111000","11111000","11111001","11111001","11111000","11110110","11110001","11101100","11101001","11110000","11110001","11110001","11110001","11110001","11110010","11111001","11111001","11111000","11111000","11110010","11101111","11101001","11101010","11101010","11101010","11101010","11101010","11101010","11110110","11110000","11000001"),
("11001011","11111000","11111000","11111000","11111000","11111001","11110100","11101000","11101001","11101010","11111000","11111010","11110001","11101000","11110110","11111001","11111000","11111000","11111001","11111000","11101011","11101001","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11110110","11110000","11000001"),
("11001011","11111000","11111000","11111001","11111000","11110000","11101101","11101000","11110000","11110011","11101111","11101111","11110001","11110011","11110111","11111000","11111001","11110100","11101111","11101111","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101001","11110110","11110000","11000001"),
("11001011","11111000","11111001","11110011","11101111","11101001","11101100","11110010","11110001","11110000","11110001","11110001","11110101","11111001","11111001","11110111","11110000","11101101","11101001","11101001","11101010","11101010","11101010","11101010","11101010","11101001","11101001","11101101","11110010","11111000","11110000","11000001"),
("11001011","11111000","11111001","11101110","11101001","11110000","11110001","11110001","11110000","11110001","11111000","11111001","11111001","11111001","11110011","11101111","11101001","11101001","11101010","11101010","11101010","11101010","11101010","11101001","11101001","11110000","11110001","11110101","11111001","11111001","11110000","11000001"),
("11001011","11111000","11111001","11110011","11110000","11110011","11110010","11101110","11110110","11111001","11111000","11111000","11110101","11110010","11101011","11101001","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101110","11110001","11111000","11111001","11110110","11110010","11111000","11110000","11000001"),
("11001011","11111000","11111000","11111001","11111000","11101010","11101110","11111010","11111000","11111000","11111000","11111001","11110001","11101000","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101001","11110011","11111010","11111000","11111001","11110001","11101000","11110110","11110000","11000001"),
("11001011","11111000","11111001","11110001","11101101","11110100","11110110","11111000","11111000","11110111","11101110","11101101","11101100","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101101","11110101","11110111","11111000","11101110","11101101","11101100","11101010","11110110","11110000","11000001"),
("11001110","11111000","11111000","11110101","11110100","11111000","11111000","11111001","11110010","11101101","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101010","11101001","11101010","11110011","11110110","11111010","11110010","11101101","11101010","11101000","11101110","11110100","11111000","11110000","11000101"),
("10101011","11111101","11111110","11111010","11111000","11111000","11110110","11110010","11101100","11101001","11101001","11101001","11101001","11101001","11101001","11101001","11101001","11101100","11101111","11110000","11110111","11110110","11110010","11101100","11101001","11101110","11101111","11110011","11111000","11111110","11101110","10011010"),
("01101101","11101110","11101110","11110111","11111101","11111100","11111000","11110001","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110111","11111100","11111100","11111100","11111001","11110001","11110010","11110011","11111011","11111100","11111100","11111100","11110101","11010110","01010010"),
("01101000","11000100","11000011","11100010","11110100","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110010","11110011","11010001","10110010","01010101"),
("01101001","11000110","11000111","11000101","11000100","11000100","11000100","11000101","11000100","11000100","11000100","11000100","11000100","11000101","11000101","11000101","11000100","11000100","11000101","11000101","11000101","11000101","11000101","11000100","11000100","11000100","11000100","11000100","11000100","11001000","10110101","01010101"),
("01101001","11000110","11000110","11001111","11010100","11010100","11001111","11000100","11001110","11010100","11010100","11010101","11001101","11000101","11000101","11000111","11010100","11001110","11000101","11000110","11000110","11000110","11000100","11001110","11010100","11010011","11010011","11010011","11010011","11001011","10110100","01010101"),
("01101001","11000110","11000101","11100001","11101111","11100100","11011100","11001110","11100100","11101110","11100100","11100100","11010101","11000100","11001110","11010100","11100100","11010101","11000101","11000110","11000101","11001000","11001111","11100010","11101110","11101101","11101101","11101110","11101111","11010010","10110100","01010101"),
("01101001","11000110","11000101","11011001","11100011","11001110","11010111","11110000","11101000","11100010","11000111","11000011","11001001","11001111","11100001","11100000","11000101","11000101","11000101","11000110","11001100","11010111","11101110","11101100","11101100","11101101","11101101","11101001","11100100","11001111","10110100","01010101"),
("01101001","11000110","11000110","11001001","11001110","11101010","11101010","11100111","11010001","11000101","11001011","11001011","11011001","11101000","11001101","11000101","11000110","11001001","11001100","11001110","11101001","11101100","11101100","11101100","11101100","11100111","11100111","11011000","11000101","11001000","10110101","01010101"),
("01101001","11000110","11000101","11011110","11101101","11101111","11100001","11000110","11000101","11000111","11101001","11101111","11011011","11000101","11000110","11000110","11000010","11010110","11101101","11101011","11101100","11101100","11101100","11101110","11101100","11001011","11000110","11000111","11000110","11001000","10110101","01010101"),
("01100110","11001001","11001000","11100001","11101101","11011011","11010011","11000101","11010011","11011011","11011001","11011010","11010000","11000101","11000110","11001001","11011001","11100011","11101110","11101101","11101101","11101101","11101110","11100001","11010111","11001000","11000110","11000110","11000110","11001011","10110111","01010010"),
("01111101","10101111","10101101","11010100","11100111","11001001","11000110","11000111","11011110","11101000","11001001","11000101","11000111","11001000","11000111","11001110","11101001","11101000","11100111","11100111","11100111","11100111","11101000","11010010","11000101","11001000","11001000","11001000","11001000","10110110","10100101","01110011"),
("11100010","01101001","01100110","10011100","10111010","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10110111","10111000","01111000","01111101","11111011"),
("11111110","11111000","11111110","10001110","01010001","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010111","01010101","11010011","11111110","11111111")
);


----------------------------------------------------------------------------------------------banana
constant banana_red : ice_cream_column :=  (
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110111","11110010","11001011","11000110","11000111","11000111","11000111","11001001","11110010","11111000","11110111","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11111000","11101001","01010111","01001000","01001010","01001010","01001000","01010010","11100010","11111001","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110111","11111100","11111100","11111100","11110111","11110110","11110110","11110110","11111000","11101000","01010010","01011011","10010000","10011100","10100110","10100010","01110011","01101011","01100110","10111011","11111111","11111100","11111100","11111001","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11111001","11101001","10110111","10111000","10111000","11101010","11111001","11110111","11110111","11111000","11101110","10010100","10000111","10000000","10011010","10101100","10100111","01111000","01110000","01101110","10011000","10111011","10111001","10110111","11010011","11111001","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11001100","01001011","01001100","01001101","11010000","11110101","11110001","11110001","11110100","11110111","11111111","11000110","01000011","01101111","10001000","10001000","10110100","10111011","11000001","01111110","01000101","01001000","01000001","10010010","11111101","11110110"),
("11110110","11110110","11110110","11110111","11110001","01110101","01111101","11011010","11100001","11101000","01111110","01100001","01100100","01100000","11001001","11111011","11111100","11000010","01000111","01110001","10001011","10000110","01011111","01101000","10010000","10010101","10011001","01011011","01000101","10010101","11111101","11110110"),
("11110110","11110110","11110110","11110111","11110001","01011101","01101110","11110011","11111010","11111111","01101011","01000001","01000110","01000001","11000011","11111111","11111111","11000100","01000010","01101111","10001010","10000100","01010001","01011010","10001001","10011011","10101010","01011110","01000101","10010101","11111101","11110110"),
("11110110","11110110","11110110","11110111","11110001","01011100","01101100","11110011","11110011","11110100","11010110","11001101","11001110","11010001","10010010","01110100","01110100","10010010","11010011","10101011","10010011","10010010","01010110","01010000","01011001","01011110","01100001","01001101","01000001","10010010","11111101","11110110"),
("11110110","11110110","11110110","11110111","11110010","10001100","10001010","10111101","11010110","11101111","11111011","11111111","11111111","11111111","10100011","01110101","01110101","10100011","11111111","11010101","10111000","10110101","01011000","01010111","01111101","01111011","01111010","01111100","01111000","10110000","11111011","11110110"),
("11110110","11110110","11110110","11110110","11110110","11111110","11010010","01000001","10011100","11110001","11101110","11101111","11101111","11101111","11111010","11111111","11111111","11111111","11111111","11111111","11111111","11110111","01011101","01110110","11111101","11111010","11111010","11111010","11111010","11111000","11110110","11110110"),
("11110110","11110110","11110110","11110111","11110010","01111111","10000110","11011100","11101100","11111100","11101101","11101010","11101010","11101010","11110000","11110011","11110011","11110001","11101100","11111000","11111111","11111101","11100010","10111111","01101000","10111011","11111111","11110111","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110111","11111000","11110010","01011100","01110000","11111111","11111111","11111111","11110101","11110010","11110010","11110010","11101111","11101101","11101101","11101110","11110001","11111001","11111111","11111111","11111111","11010001","00111111","10010011","11011000","11110000","11111000","11110111","11110110","11110110"),
("11110110","11110110","11110100","11110100","11101110","01100000","01101110","11101010","11110100","11111111","11111111","11111111","11111111","11111111","11110000","11101001","11101001","11110000","11111111","11111110","11111110","11111110","11111111","11010100","01001101","01110001","10001110","11100000","11110101","11110100","11110110","11110110"),
("11110110","11111010","11000100","10011100","10011100","01011000","01010001","01011101","10101100","11110111","11110001","11110011","11111111","11111111","11111101","11111100","11111100","11111101","11111111","11110001","11100111","11101001","11111101","11111000","11100110","10001101","01000011","10010000","10011101","11000100","11111010","11110110"),
("11110110","11111010","10111100","10001101","10001111","01010100","01001000","01000000","10011110","11110110","11101111","11110001","11111111","11111111","11111111","11111111","11111111","11111111","11111111","11101111","11100011","11100101","11111100","11111110","11111111","10010010","00110101","10000000","10001101","10111011","11111010","11110110"),
("11110111","11111111","10011010","01001101","01011001","10111110","11010000","11001101","11011101","11101100","11101011","11101100","11110100","11110100","11110100","11110011","11101011","11101010","11101001","11110010","11111000","11111000","11111110","11111101","11111111","10010010","00110111","10000010","10001111","10111101","11111101","11110111"),
("11101110","11100000","01111110","00110011","01000001","11100101","11111111","11111111","11110111","11101111","11110000","11110000","11101101","11101101","11101101","11101101","11101010","11101010","11101001","11110111","11111111","11111111","11111101","11111011","11111101","10010001","00110111","10000010","10010000","10110000","11011100","11101110"),
("11011001","10001111","01100000","00111001","01000100","11010111","11110110","11111111","11111111","11111111","11111111","11111100","11101010","11101010","11101010","11101100","11111101","11111111","11111111","11111111","11111111","11111111","11111000","11110101","11110110","10001110","00110111","10000010","10010011","10010000","10001011","11011001"),
("11011010","10001111","10000111","10000000","01111111","01100010","10000010","11110011","11111001","11111111","11111111","11111110","11111011","11111011","11111011","11111011","11111111","11111111","11111111","11111111","11111111","11111110","11110111","11001100","01011101","01110010","10000001","10001110","10010001","10010001","10001110","11011010"),
("11011010","10001110","10010010","10010100","10010000","01000000","01100000","11101101","11110011","11111010","11111011","11111101","11111111","11111111","11111111","11111111","11111111","11111110","11111100","11111010","11111001","11111000","11110100","11000001","00111000","01101101","10010111","10010001","10010001","10010001","10001110","11011010"),
("11011010","10001110","10010001","10010010","10001110","01000010","01100011","11101111","11101110","11101111","11110101","11111000","11111111","11111111","11111111","11111111","11111111","11111101","11110111","11110010","11101111","11101111","11110010","11000101","01000111","01110010","10010100","10010001","10010001","10010001","10001110","11011010"),
("11011010","10001110","10010001","10010001","10001111","01010100","01101010","11001010","11011101","11110000","11110100","11110111","11111100","11111100","11111101","11111101","11111100","11111010","11110110","11110001","11101110","11101100","11001110","10101011","01011000","01111001","10010011","10010001","10010001","10010001","10001110","11011010"),
("11011001","10001011","10010000","10010001","10010001","10010011","10000001","01000100","10011111","11110100","11110010","11110011","11101111","11101111","11110101","11110111","11101111","11110000","11110011","11101111","11101110","11100101","01001110","01001110","10010011","10010001","10010001","10010001","10010001","10010000","10001011","11011001"),
("11101110","11011100","10110000","10001110","10010001","10010010","10001101","01111111","01110100","01101010","01101010","10000001","11101101","11110001","11110101","11110111","11110101","11001000","01101001","01101100","01101011","01101100","01110111","01111111","10010001","10010001","10010001","10010001","10001110","10110000","11011100","11101110"),
("11110111","11111101","10111101","10001101","10010001","10010001","10010001","10010110","01110000","01001101","01001101","01011111","10110111","10111010","10111100","10111101","10111101","10011000","01001100","01010000","01001111","01010011","10001100","10010100","10010001","10010001","10010001","10010001","10001101","10111101","11111101","11110111"),
("11110110","11111010","10111100","10001101","10010001","10010001","10010001","10010001","10010010","10010011","10010101","10000101","00111100","00111001","00111001","00111001","00110111","01010101","10010110","10010011","10010011","10010011","10010001","10010001","10010001","10010001","10010001","10010001","10001101","10111100","11111010","11110110"),
("11110110","11110111","11101010","11100010","11011111","10011000","10001100","10010001","10010001","10010001","10010001","10001110","10000000","10000000","10000000","10000000","01111111","10000101","10010010","10010001","10010001","10010001","10010001","10010001","10010001","10001110","10001110","11010011","11100011","11101010","11110111","11110110"),
("11110110","11110110","11111000","11111010","11110111","11000000","10101100","10010001","10010001","10010001","10010001","10010001","10010011","10010011","10010011","10010011","10010011","10010010","10010001","10010001","10010001","10010001","10010001","10010001","10001111","10100101","10111000","11101101","11111010","11110111","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11111100","11100010","10001101","10001110","10001110","10010000","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10001110","10001110","10001001","11001001","11111110","11111000","11111100","11111100","11111100","11111100"),
("11110110","11110110","11110110","11110110","11110110","11111000","11100100","10100100","10100101","10100101","10010101","10010000","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010001","10010010","10100011","10100101","10100010","11010001","11111001","11110111","11111111","11111111","11111111","11111111"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","10100011","10001011","10001110","10001110","10001110","10001110","10001110","10001110","10001110","10001110","10001101","10010011","11101010","11111000","11110110","11110110","11110110","11110111","11111111","11111111","11111111","11111111"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11100000","11011001","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011011","11110011","11110110","11110110","11110110","11110110","11110111","11111111","11111111","11111111","11111111")
);

constant banana_green : ice_cream_column :=  (
  ("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111010","11001100","11000111","11001000","11000111","11000110","11001010","11111001","11111111","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11101111","01000110","00110100","00110111","00110111","00110101","01000000","11100111","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111110","11111110","11111110","11111110","11111111","11101110","01000010","01000011","01101110","01111001","10000010","01111111","01100100","01011111","01011001","10110111","11111111","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111111","11101111","10110110","10110110","10110110","11110000","11111111","11111111","11111111","11111111","11110100","10001110","01111000","01100001","01110100","10000000","01111101","01011011","01010101","01010010","10001011","10111011","10110111","10110100","11010101","11111111","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11001100","00110101","00110111","00111001","11010001","11111101","11111000","11111000","11111100","11111110","11111111","11000011","00110011","01001100","01011001","01011011","10001010","10010010","10010101","01100000","00110011","00110101","00101101","10001010","11111111","11111110"),
("11111110","11111110","11111110","11111111","11111001","01101100","01011011","01111001","10011011","10111011","01101010","01010011","01010110","01010001","11001010","11111111","11111111","11000010","00110101","01001110","01011011","01011001","01001000","01001101","01100001","01101101","01110111","01000111","00110011","10001110","11111111","11111110"),
("11111110","11111110","11111110","11111111","11111000","01010000","01000110","10000110","10101101","11010010","01010100","00110001","00110101","00101111","11000001","11111111","11111111","11000010","00110001","01001100","01011100","01011001","00111101","01000010","01011001","01110001","10000100","01001001","00110010","10001110","11111111","11111110"),
("11111110","11111110","11111110","11111111","11111000","01010000","00111001","01010001","01111001","10011110","10100011","10100101","10100101","10100111","01111111","01101100","01101100","01111110","10100111","01111100","01100001","01100001","01000000","00111100","00111110","01000100","01001001","00111001","00101101","10001011","11111111","11111110"),
("11111110","11111110","11111110","11111111","11111010","10000111","01100100","00111010","01010110","01110001","10101100","10111110","10111100","10111111","01111011","01011011","01011010","10000001","11010110","10100011","10000100","10000011","01000010","01001000","01110011","01110001","01110000","01110010","01101100","10101101","11111111","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111111","11010011","00111010","00111101","00111111","01110101","10000101","10000011","10000001","10111000","11010010","11001111","11001110","11001011","11001100","11001110","11000110","01000111","01101011","11111111","11111111","11111111","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111111","11111001","01110110","01110010","10110010","10110001","10101111","01011110","01000110","01001001","01000111","01111110","10011001","10011000","10000011","01010010","10011110","11010000","11001010","10110100","10011011","01011011","10111000","11111111","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111111","11111000","01001110","01010000","10110110","11000100","11010000","10000101","01101111","01110001","01110001","01101011","01101001","01101001","01101011","01101101","10101000","11010000","11001100","11010011","10101000","00101011","10011101","11111011","11111100","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111101","11111110","11110111","01010100","01001000","01111110","10100110","11001100","11001101","11001110","11010000","11010100","01101110","00111110","00111110","01101110","11010101","11001011","11001000","11001000","11001111","10101000","00110110","10010000","11011011","11110110","11111110","11111101","11111110","11111110"),
("11111110","11111111","11101101","11100000","11011011","01010010","00111011","01000011","01101011","10010001","10001101","10010111","11001010","11001100","10111111","10111000","10111000","10111111","11001111","10010110","01110000","01111000","11000011","11000000","10011100","01101011","01000101","11000101","11100010","11101101","11111111","11111110"),
("11111110","11111111","11101100","11011111","11011010","01001110","00110101","00110100","01011111","10001000","10000011","10010000","11001100","11001101","11001110","11001111","11010000","11001111","11010010","10001101","01011110","01101000","11000000","11000100","10101111","01100101","00101001","10111011","11011101","11101001","11111111","11111110"),
("11111110","11111111","10100011","01011001","01100010","10011100","10100110","10100111","01111000","01001011","01001101","01011011","10011010","10011011","10011011","10011000","01111011","01111000","01110110","10011001","10110001","10110000","11001010","11000100","10101110","01100110","00101100","10111101","11011110","11101010","11111111","11111110"),
("11111011","11111100","10000000","00100001","00101111","10101000","11000011","11010101","10011001","01100000","01100101","01100111","01101111","01101111","01101111","01110000","01110111","01111000","01110101","10101100","11010010","11001101","11000100","10111000","10100011","01100001","00101100","10111100","11011110","11100110","11110101","11111011"),
("11110100","11100000","01111000","00101000","00110011","01110110","10010101","11001100","11001101","11001110","11010001","10111000","01000010","00111110","00111101","01001010","11000011","11010000","11001110","11001100","11001011","11001001","10101100","10011110","10000111","01010101","00101110","10111101","11011111","11011011","11011001","11110100"),
("11110100","11011100","11000111","10110111","10110100","01001111","01010010","10010010","10110010","11010000","11001110","11001000","10110000","10101111","10101111","10110001","11001001","11001100","11001100","11001101","11001111","11001011","10010111","01111001","00111011","10000010","10111101","11010101","11011100","11011011","11011010","11110100"),
("11110100","11011010","11011101","11100000","11011001","01000100","00111100","01111011","10011000","10110100","10111011","11000001","11001111","11001111","11001111","11001111","11001100","11000111","10111110","10110111","10110010","10110000","10000101","01101001","00101001","10010000","11100110","11011100","11011011","11011011","11011010","11110100"),
("11110100","11011010","11011011","11011100","11010101","01000010","00111001","01110010","01111011","10000100","10100000","10101111","11001100","11001101","11001100","11001100","11001110","11000010","10101000","10010010","10000010","10000010","01110110","01100011","00110000","10010001","11100010","11011011","11011011","11011011","11011010","11110100"),
("11110100","11011010","11011011","11011100","11010111","01100101","01010101","01100101","01110100","10000010","10011010","10100110","10111100","10111101","11000010","11000100","10111111","10110100","10100001","10001110","10000000","10000000","01101000","01100001","01010110","10100001","11100000","11011011","11011011","11011011","11011010","11110100"),
("11110100","11011001","11011011","11011011","11011011","11100000","10110110","00110100","01010110","01110101","10000011","10000111","10000101","10000100","10011110","10100111","10001000","10000101","10001000","01111011","01110011","01110000","00101111","01010111","11011110","11011011","11011011","11011011","11011011","11011011","11011001","11110100"),
("11111011","11110101","11100110","11011010","11011011","11011101","11010010","10110010","01110011","00110111","01000000","01001011","01110111","01111000","10001010","10010000","01111100","01100111","01000001","00111110","00111011","01000001","10011101","10111001","11011101","11011100","11011011","11011011","11011010","11100110","11110101","11111011"),
("11111110","11111111","11101010","11011010","11011011","11011011","11011100","11100110","10011101","01011000","01011101","01011101","01011110","01011110","01100111","01101010","01011111","01011110","01011101","01011110","01011101","01100100","11010010","11100010","11011011","11011011","11011011","11011011","11011010","11101010","11111111","11111110"),
("11111110","11111111","11101010","11011010","11011011","11011011","11011011","11011011","11011101","11011111","11100011","11000011","00110001","00101101","00101110","00101110","00101000","01100100","11100100","11011111","11011111","11011111","11011011","11011011","11011011","11011011","11011011","11011011","11011010","11101010","11111111","11111110"),
("11111110","11111110","11111010","11110111","11110110","11011110","11011010","11011011","11011011","11011011","11011100","11010110","10111001","10111000","10111000","10111000","10110111","11000011","11011100","11011011","11011011","11011011","11011011","11011011","11011011","11011010","11011010","11110010","11110111","11111010","11111110","11111110"),
("11111110","11111110","11111111","11111111","11111110","11101011","11100101","11011011","11011011","11011011","11011011","11011100","11011111","11011111","11011111","11011111","11011111","11011110","11011011","11011011","11011011","11011011","11011011","11011011","11011010","11100010","11101001","11111011","11111111","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111111","11110111","11011010","11011010","11011010","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011010","11011010","11011000","11101110","11111111","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111111","11111000","11100010","11100010","11100010","11011100","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11011011","11100001","11100010","11100001","11110001","11111111","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11100001","11011001","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011010","11011100","11111010","11111111","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11110110","11110100","11110100","11110100","11110100","11110100","11110100","11110100","11110100","11110100","11110100","11110100","11111101","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111") 
);


constant banana_blue : ice_cream_column :=  (
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111001","10111111","10111001","10111010","10111001","10111000","10111100","11110111","11111111","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11101011","00010110","00000000","00000011","00000011","00000001","00001110","11100001","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111110","11111110","11111110","11111110","11111111","11101010","00010011","00000001","00001111","00010101","00011001","00011011","00110110","00111011","00110010","10100110","11111111","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111111","11101011","10100100","10100100","10100100","11101101","11111111","11111111","11111111","11111111","11110010","01110001","01000110","00001011","00010111","00011110","00011100","00001100","00001010","00000011","01011111","10101100","10100101","10100001","11001011","11111111","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","10111110","00000000","00000000","00000001","11000101","11111100","11110110","11110110","11111100","11111110","11111111","10110100","00000001","00010100","00011100","00011011","00011101","00011101","00011111","00001110","00000000","00000000","00000000","01101100","11111111","11111110"),
("11111110","11111110","11111110","11111111","11110111","01000111","00100001","00010100","00100001","00101101","00101010","00101010","00101010","00100100","10111101","11111111","11111111","10110011","00000001","00010100","00011100","00011010","00001101","00010000","00011011","00011001","00010111","00001011","00000000","01110001","11111111","11111110"),
("11111110","11111110","11111110","11111111","11110110","00100101","00000100","00010111","00100110","00110011","00001100","00000010","00000011","00000000","10110010","11111111","11111111","10110011","00000000","00010011","00011100","00011010","00001011","00001101","00011011","00011011","00011010","00001100","00000000","01110001","11111111","11111110"),
("11111110","11111110","11111110","11111111","11110110","00100011","00000000","00000101","00010011","00100000","00100101","00100111","00100111","00100110","01000001","01001101","01001101","01000000","00100101","00011101","00010111","00010110","00001011","00001000","00000110","00000101","00000101","00000010","00000000","01101100","11111111","11111110"),
("11111110","11111110","11111110","11111111","11111000","01101000","00111001","00000001","00001001","00010001","00100110","00101100","00101011","00101100","00010110","00001011","00001011","00011000","00110100","00100110","00011101","00011101","00001001","00011010","01001111","01001110","01001101","01001101","01000110","10011000","11111111","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111111","11000111","00000111","00000100","00000000","00010010","00010111","00010110","00010101","00101001","00110011","00110010","00110010","00110001","00110010","00110010","00110000","00000110","01000110","11111111","11111111","11111111","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111111","11111000","01010110","00110011","00101010","00101001","00100111","00001010","00000010","00000011","00000010","00010101","00011110","00011110","00010111","00000110","00100001","00110011","00110001","00101001","00101101","00110011","10100110","11111111","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111111","11110110","00100100","00000111","00101001","00101110","00110010","00011000","00010000","00010001","00010001","00001111","00001110","00001110","00001111","00010000","00100100","00110010","00110001","00110011","00100110","00000000","10001100","11111111","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111111","11110110","00101010","00000111","00010101","00100011","00110001","00110010","00110010","00110011","00110101","00010000","00000000","00000000","00010000","00110101","00110010","00110001","00110001","00110010","00100111","00000000","10000111","11111010","11111100","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111011","11111011","11110001","00101001","00000101","00001010","00010011","00011100","00011011","00011110","00110001","00110001","00101100","00101010","00101010","00101100","00110001","00110100","00110110","00110110","00110010","00101101","00011111","00100111","00110000","11010101","11111110","11111011","11111110","11111110"),
("11111110","11111110","11111110","11111111","11110110","00101001","00000011","00000111","00010000","00011000","00010110","00011011","00110001","00110010","00110011","00110011","00110010","00110010","00110001","00110101","00110111","00110111","00110010","00101110","00100110","00010110","00001100","11001110","11111101","11111011","11111110","11111110"),
("11111110","11111111","10011010","01001001","01001111","00101101","00100110","00100111","00010101","00000100","00000100","00001001","00011110","00011111","00011111","00100000","00101011","00101100","00101100","00110000","00110011","00110011","00110010","00101110","00100101","00010111","00010000","11001110","11111101","11111011","11111110","11111110"),
("11111101","11111111","01101110","00000000","00000111","00100110","00101101","00110100","00011111","00001011","00001101","00001101","00010000","00010000","00010000","00010010","00101010","00101100","00101100","00101111","00110001","00110001","00101110","00101010","00100001","00010101","00001111","11001110","11111101","11111010","11111100","11111101"),
("11111100","11111111","01110010","00000101","00001111","00010100","00011100","00110001","00110010","00110010","00110011","00101010","00000001","00000000","00000000","00000100","00101101","00110010","00110001","00110001","00110001","00110000","00100110","00100000","00010111","00010001","00010001","11001110","11111101","11111000","11111000","11111100"),
("11111100","11111010","11011101","11001000","11000011","00101001","00010000","00011011","00100111","00110011","00110010","00110000","00100111","00100111","00100111","00101000","00110000","00110001","00110010","00110010","00110010","00110001","00011100","00010111","00001001","01110101","11010001","11110000","11111001","11111000","11111000","11111100"),
("11111100","11111000","11111011","11111111","11110110","00101111","00001101","00011010","00100001","00101001","00101011","00101101","00110010","00110010","00110010","00110010","00110001","00101111","00101100","00101010","00101000","00100111","00011100","00010110","00000010","10010001","11111111","11111001","11111000","11111000","11111000","11111100"),
("11111100","11111000","11111000","11111010","11110000","00101000","00001010","00100011","00011100","00010101","00100001","00100111","00110010","00110010","00110001","00110001","00110010","00101110","00100100","00011100","00010101","00010111","00100010","00011010","00000000","10001001","11111111","11111000","11111000","11111000","11111000","11111100"),
("11111100","11111000","11111000","11111001","11110010","01011000","00110011","00011100","00011010","00011001","00011111","00100011","00101100","00101100","00101101","00101110","00101101","00101001","00100001","00011100","00011001","00011001","00011100","00100100","00110001","10100001","11111111","11111000","11111000","11111000","11111000","11111100"),
("11111100","11111000","11111000","11111000","11111000","11111111","11000000","00000000","00010010","00100010","00011001","00010111","00010111","00010111","00100000","00100011","00011000","00010111","00010111","00011101","00100010","00100000","00000100","01000101","11111100","11111000","11111000","11111000","11111000","11111000","11111000","11111100"),
("11111101","11111100","11111010","11111000","11111000","11111011","11101010","10111100","01011110","00000101","00001010","00001101","00011111","00011111","00011100","00011011","00011111","00011001","00001001","00001011","00001011","00010100","10100001","11001011","11111010","11111001","11111000","11111000","11111000","11111010","11111100","11111101"),
("11111110","11111110","11111011","11111000","11111000","11111000","11111010","11111111","10100100","01000111","01010001","01001000","00011100","00011011","00010101","00010011","00011001","00101011","01010010","01001111","01001101","01010111","11101011","11111111","11111000","11111000","11111000","11111000","11111000","11111011","11111110","11111110"),
("11111110","11111110","11111011","11111000","11111000","11111000","11111000","11111000","11111011","11111110","11111111","11011001","00010011","00001101","00001110","00001110","00000110","01011000","11111111","11111110","11111110","11111110","11111001","11111000","11111000","11111000","11111000","11111000","11111000","11111011","11111110","11111110"),
("11111110","11111110","11111101","11111101","11111101","11111001","11111000","11111000","11111000","11111000","11111001","11110001","11001010","11001001","11001001","11001001","11000111","11010111","11111001","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111100","11111101","11111101","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111011","11111001","11111000","11111000","11111000","11111000","11111001","11111110","11111110","11111110","11111110","11111110","11111100","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111001","11111010","11111101","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111101","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111011","11111110","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111101","11111001","11111001","11111001","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111001","11111001","11111001","11111100","11111110","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111001","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111000","11111101","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111100","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111")
);

------------------------------------------------------grape-------------------------------------------------
constant grape_red :ice_cream_column :=  (
 ("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110111","11110000","10010000","10000010","01111111","01111111","01111111","01111111","01111101","01111110","10000001","10100101","11111001","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11111000","11101010","00110011","00101001","01010111","01010110","01010110","01010110","01100101","01100010","00011101","01011011","11111100","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11111000","11101001","00100110","00111001","11001101","11001100","11001011","11001011","11110111","11101010","00011011","01010010","11111100","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11111000","11101001","00100011","00101110","10101001","10101001","10100111","10100110","11000111","10111011","00010100","01001111","11111100","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110110","11110111","11110111","11110111","11111001","11101100","01001011","01000001","01100110","01100101","01101111","01110111","01101001","01011111","00110110","01101110","11111100","11110111","11110111","11110111","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110101","11110100","11110100","11110100","11110100","11110100","11110111","11000010","00010110","00010011","01001111","01111110","00101010","00101010","11100101","11110100","11110100","11110100","11110100","11110100","11110110","11110110","11110110","11110110","11110110","11110110"),
("11110110","11110110","11111011","11111110","11111110","11111111","11010010","01001111","01010101","01011000","01010111","01011101","10110101","10011000","00010011","00010000","01001101","01111110","00101000","00100010","10110100","10100000","01010101","01011000","01010110","01011001","11100011","11111111","11111110","11111011","11110110","11110110"),
("11110110","11111010","10101110","10000100","10001000","10000111","10001101","10011111","01110110","01001100","01001111","01010000","01100101","01010100","00010101","00010010","01001110","01111110","00101010","00011011","01100001","01100000","01001110","01001110","01100110","01110110","10000101","10001000","10000100","10101110","11111010","11110110"),
("11111000","11111111","01110111","00101000","00101101","00100110","01011111","11111111","10101110","01011110","01100100","01100000","00111001","00101100","00010100","00010000","01001101","01111110","00101001","00010011","00101100","00111110","01100100","01100000","10010001","10101100","01000000","00101001","00100011","01110100","11111111","11111000"),
("11000010","01110011","01100000","01010110","10100010","10110010","10100111","10001110","10100111","11000000","11001001","11000110","01100001","01001110","00111100","00111001","01011111","01111110","01010010","01010010","10101000","10111000","11001101","11001111","10011000","01111001","10101001","10110101","11000000","10100101","01101111","11000010"),
("10100101","00100111","01100101","10000111","11100001","11111000","11001100","01010111","10100101","11110101","11111010","11110110","10001110","01110101","01010001","01010000","01011110","01101001","01111011","10001101","11101010","11110101","11111100","11111111","10011010","01011110","11000010","11011101","11111111","10110110","00100010","10100101"),
("10101000","00101100","10000001","10101101","11010110","11100010","11000010","01101010","10100110","11100011","11011110","11011010","10101111","10010101","01010010","01010011","01010010","01010000","10010100","10110000","11011011","11011110","11011101","11100001","10011000","01101101","10010000","10100011","11100011","10100101","00101010","10101000"),
("10101001","00101111","01111111","10101000","10100101","10100101","10100100","10100011","10100100","10100110","10100110","10100110","10100110","10010110","01100100","01100101","01100101","01100100","10010110","10100110","10100110","10100110","10100110","10100110","10100100","10100010","01101111","01101111","10101000","10000000","00101111","10101001"),
("11101100","11100011","01111101","01000100","01100110","01101100","01101011","01101000","10001000","10101010","10101001","10100110","01110111","01101000","01001101","01001101","01001100","01001100","01101000","01110111","10100101","10101001","10101001","10101011","10000010","01101001","01100010","01011011","01000100","01111101","11100011","11101100"),
("11001010","10001001","01100101","01010001","10100100","10110100","10110101","11000001","10100000","01111110","01101101","01100100","01100011","01110100","10101010","10101001","10110000","10110110","01110110","01100100","01110010","01101110","01100101","01100010","10010110","10110101","10111111","10101111","01010001","01100101","10001001","11001010"),
("10100101","00100111","01010011","01101011","11011010","11110000","11110010","11111111","10110010","01011011","01000001","00110110","01011100","10000011","11110000","11101111","11111000","11111111","10000110","01011101","01001110","01000100","00110000","00101010","10101001","11110110","11111111","11101001","01101011","01010011","00100111","10100101"),
("10101000","00101110","01110010","10010110","11011111","11101110","11101110","11110110","11000011","10001111","01001111","00111001","10000110","10100110","11101101","11101100","11110000","11110011","10100111","10001000","01010000","01011100","10000011","01111110","11000101","11110000","11110011","11100100","10010111","01110010","00101110","10101000"),
("10101000","00101101","10000010","10101110","11001000","11001110","11001101","11001110","10111010","10101000","01100100","01001101","10011101","10110001","11001101","11001101","11001101","11001100","10110000","10011110","01011010","01101110","10101011","10101000","11000000","11001110","11001101","11000111","10101111","10000010","00101101","10101000"),
("10101000","00101101","01111001","10011111","10100010","10100011","10100011","10100011","10100100","10100111","01111000","01101001","10011111","10100101","10100010","10100010","10100010","10100010","10100101","10011111","01101000","01111000","10100111","10100101","10100100","10100011","10100011","10100001","10010111","01110100","00101110","10101000"),
("10101000","00110000","01010110","01101001","10011010","10100100","10100011","10100100","10100100","10100110","01110110","01100110","10011110","10100101","10100101","10100101","10100101","10100101","10100101","10011110","01100110","01110110","10100110","10100100","10100100","10100100","10100101","10010100","00111100","00111001","00110010","10101000"),
("11000111","10000001","01010111","00111101","01001001","01001010","01010101","01110010","01110001","01110001","01001100","01000000","01101001","01111100","10100111","10100110","10100110","10100111","01111100","01101001","00111111","01001100","01110001","01110000","01110001","01110000","01010001","01000111","00110110","01010010","10000001","11000111"),
("11001101","10010010","01011011","00111010","00111001","00110111","01000011","01100100","01100100","01100110","01001011","01000011","01100111","01111001","10100001","10100001","10100001","10100001","01111000","01100111","01000100","01001100","01100110","01100101","01100100","01100010","00111111","00111000","00111011","01011100","10010010","11001101"),
("11001100","10001101","10001100","10000110","01010100","01001010","01001101","01010001","01011011","01100010","10110111","11011100","11101111","11010010","01101001","01101010","01101010","01101001","11000011","11100000","11101110","11000101","01100000","01100101","01011001","01010001","01001011","01010100","10000110","10001100","10001101","11001100"),
("11001011","10001000","10010000","10010010","10000000","01111110","01101101","00111011","01101001","10010101","11010101","11110001","11110110","11011111","10010010","10010011","10010011","10010010","11011010","11110001","11111000","11011010","10010001","10010111","01011110","00111110","01110011","10000001","10010010","10010000","10001000","11001011"),
("11011110","10111010","10100000","10001111","10010011","10010110","01111011","00110000","01100001","10010000","10111101","11010001","11010000","10111111","10001001","10001010","10001001","10001000","11000000","11010001","11010000","10111100","10001100","10010001","01010110","00110100","10000100","10010101","10001111","10100000","10111010","11011110"),
("11111000","11111110","10110110","10001101","10010001","10010011","01111110","01000110","01010010","01011011","10000001","10010001","10010011","10001110","01111010","01111010","01111100","01111110","10001110","10010011","10010001","10000001","01011011","01011101","01001111","01001000","10000101","10010011","10001101","10110110","11111110","11111000"),
("11110110","11111010","10110010","10001010","10010001","10010001","10010001","10010100","01100101","00110011","00111001","00111011","01000111","01101111","11101001","11101000","11110100","11111110","01110011","01000110","00111011","00111001","00110111","00110100","01101111","10010011","10010001","10010001","10001010","10110010","11111010","11110110"),
("11110110","11111001","11000101","10100111","10010100","10001111","10010000","10010100","01110001","01001101","00111110","00111010","01011101","10000011","11101011","11101010","11110011","11111100","10000110","01011101","00111010","00111110","01010000","01001100","01111001","10010100","10010000","10010100","10100111","11000101","11111001","11110110"),
("11110110","11110110","11111000","11110110","10100101","10010101","10010101","10010001","10010010","10010100","01010101","01000001","10010101","10110000","11100110","11100101","11100101","11100110","10110000","10010101","01000001","01010101","10010100","10010010","10010001","10010001","10010100","10100101","11110110","11111000","11110110","11110110"),
("11110110","11110110","11110110","11110110","11101101","11101111","11010100","10001100","10001110","10001110","10001010","10000100","01000101","01011000","10110000","10101111","10101111","10110000","01011000","01000101","10000100","10001010","10001110","10001110","10001101","10001111","11011101","11110000","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11111000","11111001","11110000","11010110","11010111","11011001","10100011","10001010","01110100","01101001","01010010","01010010","01010010","01010010","01101001","01110100","10001010","10100011","11011001","11010111","11010111","11011000","11110011","11111000","11110110","11110110","11110110","11110110"),
("11110110","11110110","11110110","11110110","11110110","11110110","11110111","11111010","11111010","11111100","11001101","10111010","11000000","10110010","10000100","10000101","10000101","10000100","10110010","11000000","10111010","11001101","11111100","11111010","11111010","11111010","11110111","11110110","11110110","11110110","11110110","11110110")
);


constant grape_green :ice_cream_column :=  (
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111010","10111001","10101111","10101011","10101011","10101011","10101011","10101010","10101011","10101110","11000111","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110101","01101010","01100110","10011000","10010111","10010111","10010111","10011010","10010100","01011010","10001001","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110011","01000010","01011100","11111100","11111011","11111010","11111010","11111111","11101011","00111001","01101010","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110011","01000001","01010101","11100011","11100010","11011111","11011110","11101001","11010111","00110101","01101001","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111","11110110","01100101","01100101","10100110","10100100","10110001","10111100","10101011","10011101","01010110","10000101","11111111","11111111","11111111","11111111","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111101","11111100","11111100","11111100","11111100","11111100","11111111","11001111","00110110","00110010","10000011","11000100","01010010","01000111","11101110","11111100","11111100","11111100","11111100","11111100","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111111","11111111","11111111","11111111","11001101","00111001","00111110","00111111","00111110","01000100","10001111","10000001","00110100","00101111","10000010","11000100","01010001","00111011","10010010","01111110","00111101","00111111","00111110","01000010","11100000","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111111","10100111","01110011","01111000","01111001","01101100","01001000","00111011","00101101","00101110","00101111","00111101","00111100","00110110","00110000","10000010","11000100","01010011","00110011","00111110","00111010","00101110","00101110","00110011","00110111","01101101","01111001","01110011","10100111","11111111","11111110"),
("11111110","11111111","01100010","00000101","00001101","00001010","00101000","01111011","01011111","01000100","01000101","01000001","00011000","00011011","00110110","00110000","10000010","11000100","01010011","00101110","00010010","00100000","01000101","01000011","01010000","01010111","00011001","00001011","00000001","01011111","11111111","11111110"),
("10111111","01011111","01000110","00110110","01010001","01010110","01010101","01010011","01011100","01100011","10001101","10010111","01000001","00110100","00110001","00101011","10000011","11001010","01011100","00111110","01010010","01101001","10011101","10011110","01101000","01001000","01010011","01011110","10001100","01111110","01011100","10111111"),
("10011100","00000101","00111000","01010000","01110000","01111000","01101001","01000001","01011011","01110101","10011001","10100011","01010110","01000101","00101110","00101010","01011110","10000111","01010111","01001111","01110010","10000100","10100111","10101010","01101000","01000010","01100010","01110011","10101011","01110011","00000001","10011100"),
("10011111","00001100","01000000","01011000","01101001","01101111","01100100","01000110","01011010","01101111","01101011","01101001","01011000","01001101","00110011","00110011","00110000","00101100","01001100","01011000","01101100","01101100","01101010","01101011","01010100","01000111","01001110","01010100","01101101","01001110","00001011","10011111"),
("10100001","00010000","01000000","01010101","01010100","01010100","01010100","01010100","01010100","01010100","01010100","01010100","01010100","01010001","01000101","01000101","01000101","01000101","01010001","01010100","01010100","01010100","01010100","01010100","01010100","01010100","01001000","01001000","01010110","01000001","00010000","10100001"),
("11110010","11100110","01100011","00011011","01000001","01000111","01000101","01000010","01001011","01010101","01010110","01010101","01001010","01000011","00110000","00110000","00101110","00101101","01000010","01001010","01010100","01010101","01010110","01010111","01001101","01000110","01000011","00111100","00011011","01100011","11100110","11110010"),
("11001000","01111001","01001100","00110000","01011001","01100000","01101100","10010010","01101110","01001010","00111000","00110001","01000100","01001010","01010110","01010100","01110000","10000111","01010100","01000100","00111111","00111010","00110001","00101111","01001111","01100011","10001001","10000010","00110001","01001011","01111001","11001000"),
("10011100","00000100","00110100","01001010","01101101","01110010","10001001","11001110","10001000","01000001","00100011","00011000","01000000","01010001","01110101","01110010","10100100","11001101","01100011","01000000","00101111","00100110","00010100","00010001","01010001","01111001","10111100","10110110","01001100","00110011","00000100","10011100"),
("10100000","00001101","00111101","01010011","01101110","01110011","01111001","10001111","01101111","01001111","00100110","00011000","01001010","01011000","01110011","01110010","10000001","10001110","01011110","01001011","00101111","00110011","01000010","00111111","01100001","01110101","10001001","10000100","01010011","00111100","00001101","10100000"),
("10100000","00001101","01000000","01011000","01100100","01100110","01100101","01100100","01011100","01010100","00110110","00101100","01010000","01011001","01100110","01100110","01100100","01100011","01011000","01010001","00111001","01000000","01010111","01010101","01100000","01100111","01100100","01100001","01011001","01000001","00001101","10100000"),
("10011111","00001100","00111110","01010100","01010011","01010011","01010011","01010011","01010011","01010100","01001011","01001000","01010011","01010100","01010011","01010011","01010011","01010011","01010100","01010011","01000111","01001011","01010100","01010100","01010011","01010011","01010011","01010010","01001100","00111001","00001101","10011111"),
("10100001","00010001","00110111","01000111","01010001","01010011","01010011","01010100","01010100","01010100","01001001","01000101","01010011","01010100","01010100","01010100","01010100","01010100","01010100","01010011","01000101","01001001","01010100","01010100","01010100","01010100","01010100","01001011","00011011","00011010","00010011","10100001"),
("11100010","10111110","01010101","00011000","00100001","00100001","00101100","01001010","01001001","01001001","00101010","00100000","01000011","01001010","01010100","01010100","01010100","01010100","01001011","01000100","00100000","00101010","01001001","01001000","01001001","01001000","00101000","00100000","00010001","01010000","10111110","11100010"),
("11110001","11100101","01100101","00011100","00011010","00010111","00100100","01000101","01000101","01000111","00101000","00011110","01001000","01001111","01010011","01010011","01010011","01010011","01001011","01000100","00100011","00101100","01000111","01000110","01000101","01000011","00100000","00011010","00011101","01100101","11100101","11110001"),
("11110000","11011010","11001111","11000011","00111110","00100011","00101010","00110001","00111100","01000110","01011110","01101110","10110010","10011111","01000110","01000111","01000111","01000111","01100101","01110110","10110001","10010100","01000011","01000111","00111001","00110001","00100101","00111110","11000011","11001111","11011010","11110000"),
("11101111","11011000","11011101","11011101","10101101","10101000","10000011","00011011","00110111","01010001","01101010","01111000","10001101","10000001","01001111","01010000","01010000","01010000","01101100","01111000","10001111","01111101","01001110","01010010","00110001","00100000","10001111","10110000","11011101","11011101","11011000","11101111"),
("11110110","11101010","11100000","11011011","11100000","11100111","10101101","00001101","00110001","01010010","01100001","01101000","01100101","01011111","01001110","01001110","01001101","01001100","01100000","01100111","01100101","01011110","01001111","01010010","00101001","00010101","11000000","11100101","11011011","11100000","11101010","11110110"),
("11111110","11111111","11101000","11011010","11011011","11100000","10110010","00110111","00111100","00111110","01000101","01001001","01001100","01001100","01001101","01001100","01010101","01011100","01001111","01001011","01001001","01000101","00111110","00111110","00111011","00111101","11000001","11011110","11011010","11101000","11111111","11111110"),
("11111110","11111111","11100111","11011001","11011011","11011011","11011010","11100010","01111001","00001011","00011000","00011011","00101010","00111101","01110011","01101111","10011111","11000110","01001110","00101000","00011011","00011000","00010100","00001100","10010001","11100001","11011011","11011011","11011001","11100111","11111111","11111110"),
("11111110","11111111","11101101","11100011","11011100","11011011","11011011","11100010","10010101","01000100","00100101","00010111","00110100","01000110","01110100","01110001","10010100","10110001","01010011","00110011","00010111","00100101","01001010","01000011","10100110","11100010","11011011","11011100","11100011","11101101","11111111","11111110"),
("11111110","11111110","11111111","11111110","11100010","11011100","11011100","11011011","11011101","11100011","01011000","00100001","01001100","01011000","01110000","01110000","01110000","01101111","01011000","01001100","00100001","01011000","11100011","11011110","11011100","11011011","11011100","11100010","11111110","11111111","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111011","11111100","11110011","11011001","11011010","11011010","11001111","10111110","00101000","00100100","01011010","01011001","01011001","01011010","00100100","00101000","10111110","11001111","11011010","11011010","11011010","11011011","11110110","11111100","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111111","11111111","11111100","11110011","11110011","11110100","11100011","11011000","10100111","10000001","00100000","00100001","00100001","00100000","10000001","10100111","11011000","11100011","11110100","11110011","11110011","11110011","11111101","11111111","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11110000","11101010","11110100","11010111","01110111","01111000","01111000","01110111","11010111","11110100","11101010","11110000","11111111","11111111","11111111","11111111","11111110","11111110","11111110","11111110","11111110","11111110")
);


constant grape_blue :ice_cream_column :=  (
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110111","10010010","10000011","10000001","10000001","10000001","10000001","01111111","01111111","10000010","10101000","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110001","00110001","00100100","01001110","01001110","01001110","01001110","01100001","01011111","00011010","01011011","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110001","00100110","00110101","10111110","10111100","10111100","10111011","11110100","11101010","00011001","01010011","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11110001","00100100","00101000","10001111","10001110","10001101","10001101","10110100","10101100","00010010","01010001","11111111","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111111","11111111","11111111","11111111","11110100","01001110","00111010","01000011","01000011","01001001","01001110","01000011","00111111","00110101","01110010","11111111","11111111","11111111","11111111","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111101","11111100","11111100","11111100","11111100","11111100","11111111","11001000","00010100","00010011","00110111","01010100","00011111","00101010","11101100","11111100","11111100","11111100","11111100","11111100","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111111","11111111","11111111","11111111","11010100","01010010","01011000","01011010","01011001","01011111","10101000","10001100","00010100","00010010","00110111","01010100","00100000","00100010","10100110","10010111","01011000","01011010","01011000","01011011","11100100","11111111","11111111","11111111","11111110","11111110"),
("11111110","11111111","10110011","10000111","10001011","10001011","10001000","10000011","01100101","01000110","01001000","01001001","01011101","01001110","00010100","00010010","00110111","01010100","00100001","00011010","01011010","01011000","01000111","01000111","01011000","01100100","10000100","10001100","10000111","10110011","11111111","11111110"),
("11111110","11111111","01111000","00101000","00101101","00101000","01010100","11001110","10010001","01010011","01011000","01010101","00111000","00101100","00010011","00010000","00110110","01010100","00100000","00010100","00101110","00111100","01011000","01010101","01111001","10001101","00111100","00101011","00100011","01110101","11111111","11111110"),
("11000111","01110101","01011100","01001101","10001000","10010100","10001100","01111000","10001011","10011110","10110100","10110110","01011000","01000111","00111000","00110111","01000110","01010010","01000100","01001001","10001100","10011110","10111100","10111110","10000111","01100110","10001101","10011001","10110001","10011101","01110001","11000111"),
("10101010","00100111","01011000","01110001","10110110","11001000","10100111","01001110","10001010","11000110","11010110","11010111","01111001","01100100","01001010","01001010","01001100","01001101","01100110","01111000","10111110","11001011","11011101","11100001","10000111","01010011","10011110","10110110","11100010","10100010","00100011","10101010"),
("10101100","00101101","01101100","10001101","10101110","10110111","10011111","01011101","10001010","10111000","10110011","10110000","10001111","01111011","01001011","01001100","01001100","01001011","01111011","10001111","10110010","10110100","10110010","10110101","01111111","01011111","01111000","10000110","10110110","10001000","00101011","10101100"),
("10101110","00110001","01101100","10001001","10000111","10000111","10000111","10000110","10000111","10001000","10001000","10001000","10000111","01111100","01011010","01011010","01011010","01011010","01111100","10000111","10001000","10001000","10001000","10001000","10000111","10000101","01100001","01100001","10001001","01101101","00110001","10101110"),
("11110100","11101010","01111101","01000000","01011001","01011110","01011101","01011010","01110010","10001011","10001010","10001000","01100111","01011100","01000111","01000111","01000110","01000110","01011011","01100111","10000111","10001010","10001010","10001100","01101110","01011100","01010110","01010010","00111111","01111101","11101010","11110100"),
("11010000","10001100","01100010","01001010","10001000","10010100","10011001","10101111","10001101","01101010","01011110","01011000","01011000","01100100","10001101","10001100","10011011","10101000","01101010","01011000","01100010","01100000","01011001","01010111","01111110","10010110","10101011","10011111","01001011","01100010","10001100","11010000"),
("10101001","00100111","01001011","01011110","10110010","11000010","11001101","11110110","10100101","01010001","00111111","00110111","01010011","01110000","11000011","11000000","11011100","11110010","01111010","01010011","01001000","01000000","00110010","00101101","10001101","11000111","11101010","11011001","01011111","01001011","00100111","10101001"),
("10101101","00101110","01100010","01111101","10110101","11000000","11000011","11010001","10100100","01110111","01001010","00111001","01110001","10001001","11000000","10111111","11000111","11001110","10001100","01110010","01001001","01010010","01101111","01101011","10100001","11000010","11001100","11000001","01111101","01100010","00101110","10101101"),
("10101101","00101110","01101110","10001110","10100011","10101000","10100110","10100110","10010111","10001010","01011001","01001001","10000010","10010000","10100111","10100111","10100110","10100101","10010000","10000011","01010001","01100000","10001100","10001001","10011100","10101000","10100110","10100001","10001110","01101110","00101110","10101101"),
("10101100","00101101","01100111","10000011","10000100","10000101","10000101","10000101","10000110","10001000","01101000","01011101","10000011","10000111","10000101","10000101","10000101","10000101","10000111","10000011","01011100","01100111","10001000","10000111","10000110","10000101","10000101","10000011","01111101","01100011","00101101","10101100"),
("10101110","00110011","01001111","01011100","10000000","10000111","10000110","10000110","10000110","10000111","01100101","01011010","10000010","10000111","10000111","10000111","10000111","10000111","10000111","10000010","01011010","01100101","10000111","10000110","10000110","10000110","10001000","01111011","00111100","00111010","00110100","10101110"),
("11101111","11011101","01110011","00110110","01000101","01000101","01001101","01100011","01100010","01100010","01000111","00111110","01011100","01101001","10000111","10000111","10000111","10000111","01101001","01011100","00111110","01000111","01100010","01100001","01100010","01100010","01001011","01000011","00110001","01101111","11011110","11101111"),
("11111101","11111111","10000100","00111100","00111010","00110111","01000000","01011001","01011001","01011010","01000111","01000001","01011101","01101001","10000100","10000100","10000100","10000100","01100111","01011011","01000011","01001000","01011010","01011001","01011001","01010111","00111101","00111001","00111101","10000100","11111111","11111101"),
("11111100","11111000","11101101","11100001","01011010","00111110","01000100","01001011","01010010","01010111","10010111","10110101","11011001","10111111","01011100","01011101","01011101","01011100","10100000","10111001","11011001","10110100","01010110","01011001","01010000","01001010","01000000","01011010","11100001","11101101","11111000","11111100"),
("11111100","11111000","11111010","11111010","11001001","11000100","10100000","00111001","01011011","01111100","10101101","11000100","11010000","10111101","01111001","01111010","01111010","01111001","10110001","11000100","11010001","10111000","01111001","01111101","01010100","00111110","10101011","11001100","11111010","11111010","11111000","11111100"),
("11111101","11111011","11111001","11111000","11111101","11111111","11001010","00101101","01010100","01111001","10011010","10101001","10101000","10011011","01110100","01110100","01110011","01110010","10011101","10101001","10101001","10011010","01110110","01111010","01001011","00110101","11011110","11111111","11111000","11111001","11111011","11111101"),
("11111110","11111110","11111010","11111000","11111000","11111101","11010000","01010111","01010110","01010001","01101101","01111000","01111010","01110110","01101001","01101001","01101101","01110001","01111000","01111010","01111000","01101101","01010001","01010010","01010110","01011101","11011111","11111011","11111000","11111010","11111110","11111110"),
("11111110","11111110","11111010","11111000","11111000","11111000","11110111","11111110","10011000","00101011","00111000","00111011","01000011","01100001","10111101","10111010","11010101","11101010","01101011","01000010","00111011","00111000","00110100","00101100","10101111","11111110","11111000","11111000","11111000","11111010","11111110","11111110"),
("11111110","11111110","11111011","11111001","11111000","11111000","11111000","11111111","10110011","01100100","01000101","00110111","01010011","01101111","10111111","10111101","11010000","11100001","01110110","01010010","00110111","01000101","01101010","01100011","11000100","11111111","11111000","11111000","11111001","11111011","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111001","11111000","11111000","11111000","11111010","11111111","01110111","01000010","01111011","10010000","10111011","10111010","10111010","10111001","10010000","01111100","01000010","01110111","11111111","11111011","11111001","11111000","11111000","11111001","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111101","11111101","11111100","11111000","11111000","11111001","11101100","11011011","01001001","01001011","10010000","10001111","10001111","10001111","01001011","01001001","11011011","11101100","11111001","11111000","11111000","11111000","11111100","11111101","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111101","11111100","11111100","11111100","11111100","11110111","11000101","10100010","01000111","01001000","01001000","01000111","10100010","11000101","11110111","11111100","11111100","11111100","11111100","11111100","11111110","11111110","11111110","11111110","11111110","11111110"),
("11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111100","11111011","11111111","11100110","10001001","10001010","10001010","10001001","11100110","11111111","11111011","11111100","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110","11111110")
);


constant snow_red :snow_tile :=  (
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11111","10111","10010","10011","10011","10011","10011","10011","10011","10010","10111","11111","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11100","10101","10001","10001","10001","10001","10001","10001","10001","10001","10101","11100","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11111","11011","10000","10100","10110","10101","10101","10101","10101","10101","10101","10110","10011","10000","11100","11111","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11001","10110","10101","10111","11000","11000","11000","11000","11000","11000","11000","11000","10111","10101","10110","11001","11111","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11111","11111","11111","10011","10010","11010","11010","11010","11010","11010","11010","11010","11010","11010","11010","11010","11010","10001","10100","11111","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11101","11101","11101","10011","10010","11001","11001","11001","11001","11010","11010","11010","11010","11010","11010","11010","11010","10010","10100","11101","11101","11101","11110","11110","11110","11110","11110","11110"),
("11110","11110","11111","11111","10011","10001","10001","10001","10001","10001","10100","10110","10111","11010","11101","11110","11110","11011","11010","11010","11010","10010","10000","10001","10101","10110","11001","11111","11111","11111","11110","11110"),
("11110","11101","11001","11001","10100","10010","10011","10011","10011","10011","10011","10011","10110","11010","11101","11110","11111","11000","10110","10111","11000","10100","10011","10011","10101","10101","11000","11101","11011","11100","11110","11110"),
("11111","11011","10000","10000","10101","10110","10110","10110","10110","10110","10010","10000","10100","11010","11101","11110","11111","10100","10000","10010","10110","10110","10110","10110","10110","10101","10111","11001","10110","11000","11111","11110"),
("11001","10111","10111","10111","11000","11000","11000","10110","10101","10101","10101","10100","10111","11110","11110","11110","11111","10111","10100","10101","10110","11000","11001","11000","11000","11000","11001","11001","11001","11001","11011","11101"),
("11000","10111","11011","11011","11010","11010","11010","11000","10111","10111","10110","10110","11001","11110","11110","11110","11111","11001","10110","10110","10110","11010","11010","11010","11010","11010","11010","11010","11010","11010","11010","11101"),
("11010","11010","11110","11110","11110","11110","11110","11110","11110","11110","11011","11001","11000","10101","11101","11111","11110","11011","11001","11001","11001","11101","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11100","11100","11110","11110","11110","11110","11110","11110","11110","11110","11101","11100","11010","10111","11011","11101","11110","11100","11100","11100","11100","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11111","11101","11010","11001","11011","11110","11110","11111","11111","11111","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11101","11010","11010","11011","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111")
);

   constant snow_green : snow_tile := (
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11100","11010","11010","11010","11010","11010","11010","11010","11010","11100","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11011","11010","11010","11010","11010","11010","11010","11010","11010","11100","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11110","11001","11100","11101","11101","11101","11101","11101","11101","11101","11101","11011","11001","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11101","11100","11100","11101","11110","11110","11110","11110","11110","11110","11110","11110","11101","11100","11100","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11011","11010","11111","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11111","11010","11011","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11011","11010","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11010","11011","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11011","11010","11010","11001","11001","11001","11100","11101","11110","11110","11111","11111","11111","11111","11111","11110","11110","11010","11001","11010","11100","11101","11110","11111","11111","11111","11111","11111"),
("11111","11111","11101","11101","11011","11011","11011","11011","11011","11011","11011","11011","11100","11110","11111","11111","11111","11101","11100","11101","11110","11011","11011","11011","11100","11101","11110","11111","11110","11111","11111","11111"),
("11111","11110","11001","11001","11100","11101","11101","11101","11101","11101","11011","11001","11011","11110","11111","11111","11111","11011","11001","11011","11101","11101","11101","11101","11101","11101","11110","11110","11101","11110","11111","11111"),
("11110","11101","11101","11101","11110","11110","11110","11101","11101","11101","11100","11100","11101","11111","11111","11111","11111","11101","11100","11100","11101","11110","11110","11110","11110","11110","11110","11110","11110","11110","11111","11111"),
("11110","11101","11111","11111","11111","11110","11110","11110","11101","11101","11101","11101","11110","11111","11111","11111","11111","11110","11101","11101","11101","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11111"),
("11111","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11101","11111","11111","11111","11111","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111")
); 

   constant snow_blue : snow_tile := (
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11101","11110","11110","11110","11110","11110","11110","11101","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11101","11101","11101","11101","11101","11101","11101","11101","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11101","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11101","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11110","11101","11101","11101","11101","11101","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11101","11101","11110","11110","11111","11111","11111","11111","11111","11111"),
("11111","11111","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11110","11111","11111","11111","11111","11111","11110","11111","11111","11110","11110","11110","11110","11110","11111","11111","11111","11111","11111","11111"),
("11111","11111","11101","11101","11110","11110","11110","11110","11110","11110","11110","11101","11110","11111","11111","11111","11111","11110","11101","11101","11110","11110","11110","11110","11110","11110","11111","11111","11110","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11110","11110","11110","11110","11110","11110","11111","11111","11111","11111","11110","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11110","11110","11110","11110","11111","11111","11111","11111","11111","11111","11110","11110","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11110","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111"),
("11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111","11111")
); 



  -- Signals for the video controller
  signal Hcount : unsigned(9 downto 0);  -- Horizontal position (0-800)
  signal Vcount : unsigned(9 downto 0);  -- Vertical position (0-524)
  signal sprite_height :   unsigned(9 downto 0); -- sprite point
  signal sprite_vertical : unsigned(9 downto 0);-- sprite point
  signal guard_height :   unsigned(9 downto 0); -- guard point
  signal guard_vertical : unsigned(9 downto 0);-- guard point
  signal EndOfLine, EndOfField : std_logic;
  
  signal vga_hblank, vga_hsync,
    vga_vblank, vga_vsync : std_logic;  -- Sync. signals

 signal test1: integer := 0;
 signal test2: integer := 0;
 signal test3: integer := 0;
 signal test4: integer := 0;
 signal test5: integer := 0;
 signal test6: integer := 0;
 signal test7: integer := 0;
 signal test8: integer := 0;  
 
 signal tilecounter: integer := 0;			-- move sprite
 signal tileflag: integer := 0;				-- move sprite
 signal guardcounter: integer := 0;			-- move guard
 signal guardflag: integer := 0;  			-- move guard
 
 signal sprite_mode : integer := 0; 		--sprite direction
 signal guard_mode : integer := 0;          --guard direction

  signal sprite_h_down, sprite_v_down, sprite_down : std_logic;  -- sprite area
  signal sprite_h_up,sprite_v_up, sprite_up : std_logic; 
  signal sprite_h_left,sprite_v_left, sprite_left : std_logic; 
  signal sprite_h_right,sprite_v_right, sprite_right : std_logic; 
  signal sprite_h_dead, sprite_v_dead,sprite_dead :std_logic;
  signal sprite_move_flag: std_logic;

  signal guard_h_down, guard_v_down, guard_down : std_logic;  -- guard area
  signal guard_h_up,guard_v_up, guard_up : std_logic; 
  signal guard_h_left,guard_v_left, guard_left : std_logic; 
  signal guard_h_right,guard_v_right, guard_right : std_logic; 
  signal guard_move_flag: std_logic;
 
  

  
  signal map_h, map_v : std_logic;
  signal map_ice_change_h,map_ice_change_v : integer:=0;--indicate the position of ice that need to change
  signal map_ice_change_flag: std_logic; -- map_ice change flag 
  signal map_h_counter : integer := 0;
  signal map_v_counter : integer := 0; 

  signal map_grape_change_h,map_grape_change_v : integer:=0;--indicate the position of ice that need to change
  signal map_grape_change_flag: std_logic; -- map_ice change flag 


  signal map_banana_change_h,map_banana_change_v : integer:=0;--indicate the position of ice that need to change
  signal map_banana_change_flag: std_logic; -- map_ice change flag 

  signal key_counter : integer := 0;   --  key counter for motion
  signal guard_counter : integer := 0;    -- key counter for guard motion
  signal counter_g : unsigned (21 downto 0):="0000000000000000000000";
  signal counter_s : unsigned (21 downto 0):="0000000000000000000000";
  signal gcounter_max : unsigned (21 downto 0):= "0000000000000000000000";
  signal readx : unsigned (15 downto 0) := "0000000000000000";			--for readdata

  signal clk1: std_logic := '0';		-- clk divide

  signal startflag : unsigned (1 downto 0) := "00";
  
--  signal mapping : map_level:= (
--(("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","001","001","001","001","001","001","001","001","000","000","001","001","001","001","001","001","001","001","001"),
--("001","000","000","011","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","001","000","000","000","001","001","001","001","111","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","111"),
--("000","000","000","000","000","001","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","010","010","000","010","010","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","111","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","111","111","111","111","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","011","011","011","011","000","000","000","001","000","000","000","000"),
--("111","100","100","100","100","111","111","111","010","100","100","100","111","111","111","011","100","100","100","111")),
--
--(("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","001","001","001","001","001","001","001","001","000","000","001","001","001","001","001","001","001","001","001"),
--("001","000","000","000","010","010","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","111","111","111","001","001","000","000","000","000","000","000","000","000","011","011","000","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","011","000","000","000","000","000","000","000","000","000","000","000","000","000","000","011","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","011","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","010","001","001","001","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","010","001","001","001","000","000"),
--("000","000","000","000","010","010","000","000","000","000","000","000","000","000","000","001","001","001","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","001","001","000","000"),
--("111","100","100","100","100","111","111","111","010","100","100","100","111","111","111","011","100","100","100","111")),
--
--(("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","001","001","001","001","001","001","001","001","000","000","001","001","001","001","001","001","001","001","001"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","011","000","000","010","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","010","010","010","010","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","111","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","111","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","111","111","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","011","011","011","011","000","000","000","001","000","000","000","000"),
--("111","100","100","100","100","111","111","111","010","100","100","100","111","111","111","011","100","100","100","111"))
--);--ice=01,banana=10,grape=11
--signal mapping : map_position:=
--(("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","001","001","001","001","001","001","001","001","000","000","001","001","001","001","001","001","001","001","001"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("001","000","000","000","000","000","000","000","000","000","111","000","000","000","111","000","000","000","111","000"),
--("001","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","111","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","010","010","010","010","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","111","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","111","111","111","111","000","000","000","001","000","000","000","000"),
--("000","000","000","000","000","000","000","000","011","011","011","011","000","000","000","001","000","000","000","000"),
--("100","100","100","100","001","010","100","100","100","001","011","100","100","100","000","000","000","000","000","000"));
signal mapping : map_level:= (
(("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","010","000","010","000","010","000","010","001","001","111","111","001","001","001","001","001","001","001","001"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","011","001","001"),
("001","001","001","001","001","011","001","001","001","001","001","001","001","001","001","001","001","000","001","001"),
("001","001","001","001","011","001","001","001","001","001","001","001","001","001","001","001","001","011","001","001"),
("001","001","001","011","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","001","011","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","011","001","001"),
("001","001","001","001","001","010","000","010","000","010","000","010","001","001","000","001","001","000","001","001"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","000","001","001","011","001","001"),
("001","001","111","001","001","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("001","001","001","111","001","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","001","001","111","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","001","001","001","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("111","100","100","100","100","111","111","111","100","100","100","100","111","111","111","100","100","100","100","111")),

(("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","001","111","111","000","000","011","001","011","000","000","011","001","011","000","000","111","111","001","001"),
("001","001","111","000","000","000","000","010","000","000","000","000","010","000","000","000","000","111","001","001"),
("001","001","000","000","000","000","011","001","011","000","000","011","001","011","000","000","000","000","001","001"),
("001","001","000","000","000","000","000","010","000","000","000","000","010","000","000","000","000","000","001","001"),
("001","001","000","000","000","000","011","001","011","000","000","011","001","011","000","000","000","000","001","001"),
("001","001","000","000","000","000","000","010","000","000","000","000","010","000","000","000","000","000","001","001"),
("001","001","000","000","000","000","011","001","011","000","000","011","001","011","000","000","000","000","001","001"),
("001","001","000","000","000","000","000","010","000","000","000","000","010","000","000","000","000","000","001","001"),
("001","001","111","000","000","000","011","001","011","000","000","011","001","011","000","000","000","111","001","001"),
("001","001","111","111","000","000","000","010","000","000","000","000","010","000","000","000","111","111","001","001"),
("000","000","001","001","001","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","001","001","001","001","001","001","001","001","001","001","001","001","000","001","001","001","001","001"),
("111","100","100","100","100","111","111","111","100","100","100","100","111","111","111","100","100","100","100","111")),

(("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("001","001","010","010","010","001","001","001","010","010","010","010","001","001","001","010","010","010","001","001"),
("001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001","001"),
("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
("000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000","000"),
("111","111","111","000","000","000","000","000","000","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","011","011","000","000","000","000","000","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","000","000","000","000","000","000","000","001","001","011","001","001","000","001","001","011","001","001"),
("000","000","000","010","000","111","111","111","111","001","001","011","001","001","000","001","001","011","001","001"),
("000","000","000","010","000","000","111","111","000","001","001","011","001","001","000","001","001","011","001","001"),
("000","000","000","000","000","000","000","000","000","001","001","011","001","001","000","001","001","011","001","001"),
("000","000","000","000","000","000","000","000","000","001","001","001","001","001","000","001","001","001","001","001"),
("000","000","000","000","000","000","000","000","000","001","001","001","001","001","000","001","001","001","001","001"),
("111","100","100","100","100","111","111","111","100","100","100","100","111","111","111","100","100","100","100","111"))

);
signal ice_cream_R : std_logic_vector (4 downto 0);
signal ice_cream_G : std_logic_vector (4 downto 0);
signal ice_cream_B : std_logic_vector (4 downto 0);

signal image_address : unsigned(4 downto 0);

signal guard_R : std_logic_vector (4 downto 0);
signal guard_G : std_logic_vector (4 downto 0);
signal guard_B : std_logic_vector (4 downto 0);
signal guard_image_address : unsigned(4 downto 0);
--------------------signals for game info-------------------------------------------------
signal num_address : integer;
 
signal num_R : std_logic_vector (4 downto 0);
signal num_G : std_logic_vector (4 downto 0);
signal num_B : std_logic_vector (4 downto 0);

signal gamelevel: integer := 0;
signal grape_record : integer := 0;
signal grape_recordten : integer :=0;
signal banana_record : integer := 0;
signal banana_recordten : integer := 0;

-----------reset---------------------------------------------------------------------------
signal  reset : integer :=  0; 
signal  reset_flag : integer := 0;

-------------------------------------------------------------------------------------------

begin

sprite_rgb: ice_cream_controller port map (clk,image_address,test1,test2,ice_cream_R,ice_cream_G,ice_cream_B);
guard_rgb : guard_controller port map (clk,guard_image_address,test3,test4,guard_R,guard_G,guard_B);
info_control: info_controller port map(clk,num_address,test5,test6,num_R,num_G,num_B);


 process (clk)
  begin
    if rising_edge(clk) then
      clk1 <= not clk1;
    end if;
  end process;
--------------------------------------------for read data-----------------------
process (clk)
begin
  if rising_edge(clk) then
     if reset_n = '0' then
       readdata  <= (others => '0'); 
     else
     if chipselect = '1' then
       if address = "00001" then
           if read = '1' then
         readdata <= readx;
       end if;
     end if;
   end if;
end if;
end if;
end process;


-----------------------Ice_cream_direction---------------------------------------
  process (clk)
  begin
    if rising_edge(clk) then

      if banana_record =10 then
              banana_recordten <= banana_recordten + 1;
              banana_record <= 0;
      end if;
           if grape_record =10 then
              grape_recordten <= grape_recordten + 1;
              grape_record <= 0;
           end if;

      if startflag = "00" then
			guardflag <= 0;
		end if;
		
      if reset_n = '0' then
        readx  <= (others => '0'); 
      else
        if tilecounter = 32 then			-- see if tilecounter is 0
           tileflag <= 0;
-------------------------------------------------for sprite to move again----------
           readx <= "0000000000001111";				--15 for stop moving
-----------------------------------------------------------------------------------
         end if;
        if guardcounter = 32 then			-- see if guardcounter is 0
           guardflag <= 0;
         end if;
       
        if chipselect = '1' then
--------------------------------------------reset readdata for sprite-----------------------------------
          if  address= "10010" then						--18
               if write = '1' then
                 readx <= "0000000000000000";
              end if; 
          end if;    
--------------------------------------------for select level------------------------------------
          if  address= "01111" then						--15
              gamelevel <= gamelevel + 1;
              reset <= 1;
              if gamelevel = 3 then
              gamelevel <= 0;
              end if; 
          end if;     
-------------------------------------------for select grape record------------------------------
        if address = "10000" then						--16
           if write = '1' then
           grape_record <= grape_record + 1;
--           if grape_record =10 then
--              grape_recordten <= grape_recordten + 1;
--              grape_record <= 0;
--           end if;
           end if;
        end if;
-------------------------------------------for select banana record-----------------------------
        if address = "10001" then						--17
           if write= '1' then
            banana_record <= banana_record + 1;
--           if banana_record =10 then
--              banana_recordten <= banana_recordten + 1;
--              banana_record <= 0;
--           end if;
           end if;
        end if;
-----------------------------------------------------for select ice cream-----------------------

          if address = "00001"  then		         -- down 1
             if write = '1' then
                  if sprite_mode /= 0 then
                     sprite_mode <= 0;
                 end if;

                  if sprite_vertical /= writedata(9 downto 0)  then
				   tileflag <= 1;  			    --for move sprite in vhdl
				  end if;
              
               end if;
          elsif  address = "00000" then 			-- left 0
                if write = '1' then
				     if sprite_mode /= 2 then
                     sprite_mode <= 2;
                 end if;
				   
                 if sprite_height /= writedata(9 downto 0)  then
				   tileflag <= 1;  			    --for move sprite in vhdl
				  end if;
				end if;
				
	      elsif address = "00011"  then		-- up 3
          if write = '1' then
                     if sprite_mode /= 1 then
                     sprite_mode <= 1;
                      end if;

                 if sprite_vertical /= writedata(9 downto 0)  then
				   tileflag <= 1;  			    --for move sprite in vhdl
				  end if;
                           

               end if;
          elsif address= "00010" then    -- right 2
              if write = '1' then
                    if sprite_mode /= 3 then
                     sprite_mode <= 3;
                   end if;
                if sprite_height /= writedata(9 downto 0) then
				   tileflag <= 1;  			    --for move sprite in vhdl
				  end if;
        
               end if;
             end if;


-----------------------------------for select guard---------------------------------------------

          if address = "01001"  then		         -- down 9
          if write = '1' then

              if guard_vertical = writedata(9 downto 0) then
                   guardflag <= 0;				
                  else
				   guardflag <= 1;  			--for move  in vhdl
				  end if;
                  guard_mode <= 0;
               end if;
          elsif  address = "01000" then -- left 8
                   if write = '1' then
                 if guard_height = writedata(9 downto 0) then
                   guardflag <= 0;				
                  else
				   guardflag <= 1;  			--for move in vhdl
				  end if;
                  guard_mode <= 2;
               end if;
	      elsif address = "01011"  then		-- up 11
          if write = '1' then

				 if guard_vertical = writedata(9 downto 0) then
                   guardflag <= 0;				
                  else
				   guardflag <= 1;  			--for move sprite in vhdl
				  end if;
                  guard_mode <= 1;
               end if;
          elsif address= "01010" then    -- right 10
                if write = '1' then


			 if guard_height = writedata(9 downto 0) then
                   guardflag <= 0;				
                  else
				   guardflag <= 1;  			--for move sprite in vhdl
				  end if;
                  guard_mode <= 3;
               end if;
             end if;
 
       end if;
 
          if address = "01110"  then
             if write = '1' then
                  sprite_mode <= 4;				-- dead 14
               end if;
           end if;

          if address = "11110" then 
			if write = '1' then
                  gcounter_max <= "0000111111111111111111";				-- 30  set speed
               end if;
           end if;
        
         if address = "11111" then 
			if write = '1' then
                  gcounter_max <= "0000011111111111111111";				-- 31
               end if;
           end if;
                
         if address = "11101"  then 									--29  reset
            if write = '1' then
                reset <= 1;      
            end if;
         end if;
   
         if reset_flag = 1 then
             reset <= 0; 
          end if;
  
         end if;
        end if;
      
  end process;
------------------------------------move sprite in vhdl---------------------------------
process(clk1)
begin
   
if rising_edge(clk1) then
   
   if startflag = "00" then					--initialize
   sprite_vertical <= "0000100000";
   sprite_height <= "0000000000";    
   guard_vertical <= "0000100000";
   guard_height <= "0111000000";
   startflag <= "01";
   end if;
   
    if reset = 1 then                     -- need to reset
       startflag <= "00";
       counter_g <= "0000000000000000000000";
       reset_flag <= 1;  
    else
       reset_flag <= 0; 
    end if;

	if counter_s = "0000111111111111111111" then 
     if tileflag = 1 then
       if sprite_mode = 0 then
       sprite_vertical <= sprite_vertical + 1;
       elsif sprite_mode = 1 then
       sprite_vertical <= sprite_vertical - 1 ;
       elsif sprite_mode = 2 then
       sprite_height <= sprite_height - 1;
       elsif sprite_mode = 3 then
       sprite_height <= sprite_height + 1;
       end if;
       tilecounter <= tilecounter + 1;			--every time counter ++ to 32 for one tile
       key_counter <= key_counter + 1;
        if key_counter = 15 then
        key_counter <= 0;
       end if;
      else
      tilecounter <= 0;					--reset tilecounter
     end if;
    counter_s<="0000000000000000000000";
  else counter_s <= counter_s + 1;
   end if;
    if counter_g = gcounter_max then 
     if guardflag = 1 then
       if guard_mode = 0 then
       guard_vertical <= guard_vertical + 1;
       elsif guard_mode = 1 then
       guard_vertical <= guard_vertical - 1 ;
       elsif guard_mode = 2 then
       guard_height <= guard_height - 1;
       elsif guard_mode = 3 then
       guard_height <= guard_height + 1;
       end if;
       guardcounter <= guardcounter + 1;			--every time counter ++ to 32 for one tile
       guard_counter <= guard_counter + 1;
        if guard_counter = 15 then
        guard_counter <= 0;
       end if;
      else
      guardcounter <= 0;					--reset tilecounter
     end if;
    counter_g<="0000000000000000000000";
  else counter_g <= counter_g + 1;
   end if;
end if;

end process;


--------------map_ice_banana_grape_change--------generate or eliminate ice wall--------
process (clk)
begin
if rising_edge(clk) then
      if chipselect = '1' then         
          if address = "00100"  then		         -- vertical 4
             if write = '1' then
               map_ice_change_v <=to_integer(writedata(9 downto 0));
             end if;
          elsif address = "00101" then               -- horizontal 5
             if write='1' then
               map_ice_change_h <=to_integer(writedata(9 downto 0));
               map_ice_change_flag <= '1';
             end if;
          elsif address = "00110"  then		         -- vertical address : 6
             if write = '1' then
               map_grape_change_v <=to_integer(writedata(9 downto 0));
             end if;
          elsif address = "00111" then               -- horizontal address : 7
             if write='1' then
               map_grape_change_h <=to_integer(writedata(9 downto 0));
               map_grape_change_flag <= '1';
             end if;
          elsif address = "01100"  then		         -- vertical address: 12
             if write = '1' then
               map_banana_change_v <=to_integer(writedata(9 downto 0));
             end if;
          elsif address = "01101" then               -- horizontal address : 13
             if write='1' then
               map_banana_change_h <=to_integer(writedata(9 downto 0));
               map_banana_change_flag <= '1';
             end if;
          end if;
      elsif map_ice_change_flag='1' then
         case mapping(gamelevel)(map_ice_change_v)(19-map_ice_change_h) is
          when "001" => mapping(gamelevel)(map_ice_change_v)(19-map_ice_change_h)<="000";
          when "000" => mapping(gamelevel)(map_ice_change_v)(19-map_ice_change_h)<="001";          
          when others=> null; 
         end case;
         map_ice_change_flag <= '0';
      elsif map_grape_change_flag='1' then
         case mapping(gamelevel)(map_grape_change_v)(19-map_grape_change_h) is
          when "011" => mapping(gamelevel)(map_grape_change_v)(19-map_grape_change_h)<="000";
          when "000" => mapping(gamelevel)(map_grape_change_v)(19-map_grape_change_h)<="011";
          when others=>null;
         end case;
         map_grape_change_flag <= '0';  
      elsif map_banana_change_flag='1' then
         case mapping(gamelevel)(map_banana_change_v)(19-map_banana_change_h) is
          when "010" => mapping(gamelevel)(map_banana_change_v)(19-map_banana_change_h)<="000";
          when "000" => mapping(gamelevel)(map_banana_change_v)(19-map_banana_change_h)<="010";
          when others =>null;
         end case;
         map_banana_change_flag <= '0';     
      end if;
end if;
end process;

-----------------------------------------------------------------------------------------------



 HCounter : process (clk1)
  begin
    if rising_edge(clk1) then      
      if reset_n = '0' then
        Hcount <= (others => '0');
      elsif EndOfLine = '1' then
        Hcount <= (others => '0');
      else
        Hcount <= Hcount + 1;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk1)
  begin
    if rising_edge(clk1) then      
      if reset_n = '0' then
        Vcount <= (others => '0');
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount <= (others => '0');
        else
          Vcount <= Vcount + 1;
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK

  HSyncGen : process (clk1)
  begin
    if rising_edge(clk1) then     
      if reset_n = '0' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if reset_n = '0' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH  then
        vga_hblank <= '0';
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE  then
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if reset_n = '0' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk1)
  begin
    if rising_edge(clk1) then    
      if reset_n = '0' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;

  -- map everything 
MapGen : process (clk1)
  begin
    if rising_edge(clk1) then     
      if reset_n = '0' or Hcount = HSYNC + HBACK_PORCH + 32*map_h_counter  then      
    map_h_counter <= map_h_counter + 1;
      if map_h_counter = 20 then  -- map_h_counter= 20
    map_h_counter <= 0;
   end if;
  end if;
   if  reset_n = '0' or Vcount = VSYNC + VBACK_PORCH + 32*map_v_counter  then 	  
            map_v_counter <= map_v_counter + 1;
         if map_v_counter = 15 then  -- 15
            map_v_counter <= 0;
         end if;
      end if;   
    end if;
  end process MapGen;



-- sprite generator

  RectangleHGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if  reset_n = '0' or Hcount = HSYNC + HBACK_PORCH +  sprite_height  then
        if sprite_mode = 0 then
        sprite_h_down <= '1';
        sprite_h_up <= '0';
        sprite_h_left <='0';
        sprite_h_right <='0';
        sprite_h_dead <= '0';
        elsif sprite_mode = 1 then
        sprite_h_up <= '1';
        sprite_h_down <= '0';
        sprite_h_left <='0';
        sprite_h_right <='0';
        sprite_h_dead <= '0';
        elsif sprite_mode = 2 then
        sprite_h_left <= '1';
        sprite_h_up <= '0';
        sprite_h_down <='0';
        sprite_h_right <='0';
        sprite_h_dead <= '0';
        elsif sprite_mode = 3 then
        sprite_h_right <= '1';
        sprite_h_up <= '0';
        sprite_h_left <='0';
        sprite_h_down <='0';
        sprite_h_dead <= '0';
        elsif sprite_mode = 4 then
        sprite_h_dead <= '1';
        sprite_h_down <= '0';
        sprite_h_up <= '0';
        sprite_h_left <= '0';
        sprite_h_right <= '0';
       end if;
      end if;			
      if reset_n = '0' or Hcount = HSYNC + HBACK_PORCH + sprite_height+32 then
        sprite_h_down <= '0';
        sprite_h_up <= '0';
        sprite_h_left <= '0';
        sprite_h_right <= '0';
        sprite_h_dead <= '0';
      end if;   
    
       
    end if;
  end process RectangleHGen;

  RectangleVGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if reset_n = '0' then       
        sprite_v_up <= '0';
        sprite_v_down <= '0';
        sprite_v_left <= '0';
        sprite_v_right <= '0';
        sprite_v_dead <= '0';
      elsif EndOfLine = '1' then
         
        if Vcount >= VSYNC + VBACK_PORCH + sprite_vertical -1  then
        if sprite_mode = 0 then
        sprite_v_down <= '1';
        sprite_v_up <= '0';
        sprite_v_left <='0';
        sprite_v_right <='0';
        sprite_v_dead <= '0';
        elsif sprite_mode = 1 then
        sprite_v_up <= '1';
        sprite_v_down <= '0';
        sprite_v_left <='0';
        sprite_v_right <='0';
        sprite_v_dead <= '0';
        elsif sprite_mode = 2 then
        sprite_v_left <= '1';
        sprite_v_up <= '0';
        sprite_v_down <='0';
        sprite_v_right <='0';
        sprite_v_dead <= '0';
        elsif sprite_mode = 3 then
        sprite_v_right <= '1';
        sprite_v_up <= '0';
        sprite_v_left <='0';
        sprite_v_down <='0';
        sprite_v_dead <= '0';
        elsif sprite_mode = 4 then
          sprite_v_dead <= '1';
          sprite_v_down <= '0';
          sprite_v_up <= '0';
          sprite_v_left <= '0';
          sprite_v_right <= '0';
       end if;
       end if;
     if Vcount >= VSYNC + VBACK_PORCH  + sprite_vertical + 31 then
          sprite_v_down <= '0';
          sprite_v_up <= '0';
          sprite_v_left <= '0';
          sprite_v_right <= '0';
          sprite_v_dead <= '0';
		end if; 
      end if;      
   end if;
  end process RectangleVGen;

  sprite_up <= sprite_h_up and sprite_v_up;
  sprite_down <= sprite_h_down and sprite_v_down;
  sprite_left <= sprite_h_left and sprite_v_left;
  sprite_right <= sprite_h_right and sprite_v_right;
  sprite_dead <= sprite_h_dead and sprite_v_dead;
  sprite_move_flag<= sprite_up or sprite_down or sprite_left or sprite_right or sprite_dead;
-- guard generator

  GuardHGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if  reset_n = '0' or Hcount = HSYNC + HBACK_PORCH +  guard_height  then
        if guard_mode = 0 then
        guard_h_down <= '1';
        guard_h_up <= '0';
        guard_h_left <='0';
        guard_h_right <='0';
        elsif guard_mode = 1 then
        guard_h_up <= '1';
        guard_h_down <= '0';
        guard_h_left <='0';
        guard_h_right <='0';
        elsif guard_mode = 2 then
        guard_h_left <= '1';
        guard_h_up <= '0';
        guard_h_down <='0';
        guard_h_right <='0';
        elsif guard_mode = 3 then
        guard_h_right <= '1';
        guard_h_up <= '0';
        guard_h_left <='0';
        guard_h_down <='0';
       end if;
      end if;			
      if reset_n = '0' or Hcount = HSYNC + HBACK_PORCH + guard_height+32 then
        guard_h_down <= '0';
        guard_h_up <= '0';
        guard_h_left <= '0';
        guard_h_right <= '0';
      end if;   
    
       
    end if;
  end process GuardHGen;

  GuardVGen : process (clk1)
  begin
    if rising_edge(clk1) then
      if reset_n = '0' then       
        guard_v_up <= '0';
        guard_v_down <= '0';
        guard_v_left <= '0';
        guard_v_right <= '0';
      elsif EndOfLine = '1' then
         
        if Vcount >= VSYNC + VBACK_PORCH + guard_vertical -1  then
        if guard_mode = 0 then
        guard_v_down <= '1';
        guard_v_up <= '0';
        guard_v_left <='0';
        guard_v_right <='0';
        elsif guard_mode = 1 then
        guard_v_up <= '1';
        guard_v_down <= '0';
        guard_v_left <='0';
        guard_v_right <='0';
        elsif guard_mode = 2 then
        guard_v_left <= '1';
        guard_v_up <= '0';
        guard_v_down <='0';
        guard_v_right <='0';
        elsif guard_mode = 3 then
        guard_v_right <= '1';
        guard_v_up <= '0';
        guard_v_left <='0';
        guard_v_down <='0';
       end if;
       end if;
     if Vcount >= VSYNC + VBACK_PORCH  + guard_vertical + 31 then
          guard_v_down <= '0';
          guard_v_up <= '0';
          guard_v_left <= '0';
          guard_v_right <= '0';
       end if; 
      end if;      
   end if;
  end process GuardVGen;

  guard_up <= guard_h_up and guard_v_up;
  guard_down <= guard_h_down and guard_v_down;
  guard_left <= guard_h_left and guard_v_left;
  guard_right <= guard_h_right and guard_v_right;
  guard_move_flag<= guard_up or guard_down or guard_left or guard_right;


-- Registered video signals going to the video DAC

  VideoOut: process (clk1, reset_n)
  begin
    if reset_n = '0' then
      VGA_R <= "0000000000";			--0100000000
      VGA_G <= "0000000000";            --0110000000
      VGA_B <= "0000000000";            --0100000000
    elsif clk1'event and clk1= '1' then
      ----------------------------------------------------------map ice-----------------------------------   
      if map_v_counter /= 0 and map_h_counter /=0 then
        if mapping(gamelevel)(map_v_counter-1)(20 - map_h_counter) /= "000" then
        VGA_R(1 downto 0) <= "11";
        VGA_G(1 downto 0) <= "11";
        VGA_B(1 downto 0) <= "11";
       
          test5 <= to_integer(Vcount - (VSYNC + VBACK_PORCH )-32*(map_v_counter-1));
          test6 <= to_integer(Hcount - (HSYNC + HBACK_PORCH )-32*(map_h_counter-1));
        
       case  mapping(gamelevel)(map_v_counter-1)(20 - map_h_counter) is
         when "001" => VGA_R(9 downto 2) <=ice_red(test5)(test6);
                      VGA_G(9 downto 2) <=ice_green(test5)(test6);
                      VGA_B(9 downto 2) <=ice_blue(test5)(test6);
         when "010" => VGA_R(9 downto 2) <=banana_red(test5)(test6);
                      VGA_G(9 downto 2) <=banana_green(test5)(test6);
                      VGA_B(9 downto 2) <=banana_blue(test5)(test6);
         when "011" => VGA_R(9 downto 2) <=grape_red(test5)(test6);
                      VGA_G(9 downto 2) <=grape_green(test5)(test6);
                      VGA_B(9 downto 2) <=grape_blue(test5)(test6);
         when "111" => VGA_R(9 downto 5) <= snow_red(test5)(test6);
                       VGA_R(4 downto 0) <= "11111";
                       VGA_G(9 downto 5) <= snow_green(test5)(test6);
                       VGA_G(4 downto 0) <= "11111";
					   VGA_B(9 downto 5) <= snow_blue(test5)(test6);
					   VGA_B(4 downto 0) <= "11111";
         when "100"=> 
                      case map_h_counter is
                      when 2 => num_address <= 11; -- LLL
                      when 3 => num_address <= 12; -- VVV
                      when 4 => num_address <= 10; -- xxx
                      when 5 => num_address <= gamelevel;
                      
                      when 10 => num_address <= 10;
                      when 11 => num_address <= banana_recordten;
                      when 12 => num_address <= banana_record;

                      when 17 => num_address <= 10;
                      when 18 => num_address <=  grape_recordten;
                      when 19 => num_address <= grape_record;

--                      when 18 => num_address <= 10;
--                      when 19 => num_address <= 10; 
                      when others=> null;
                      end case;
                      VGA_R(4 downto 2) <="111";
                      VGA_G(4 downto 2) <="111";
                      VGA_B(4 downto 2) <="111";                      
                      VGA_R(9 downto 5) <=num_R(4 downto 0);
                      VGA_G(9 downto 5) <=num_G(4 downto 0);
                      VGA_B(9 downto 5) <=num_B(4 downto 0);
                     
         when others=>null;
       end case; 
       

     elsif vga_hblank = '0' and vga_vblank ='0' then
        VGA_R <= "1111111111";
        VGA_G <= "1111111111";
        VGA_B <= "1111111111";
     else
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";    
     end if;
    elsif vga_hblank = '0' and vga_vblank ='0' then
        VGA_R <= "1111111111";
        VGA_G <= "1111111111";
        VGA_B <= "1111111111";
     else
        VGA_R <= "0000000000";
        VGA_G <= "0000000000";
        VGA_B <= "0000000000";
     end if;
    ------------------------------------------------------------sprite ------------------------------------
    if sprite_move_flag ='1' then 
        test1 <=  to_integer(Vcount - sprite_vertical) -VSYNC - VBACK_PORCH;
        test2 <=  to_integer(Hcount - sprite_height) -HSYNC - HBACK_PORCH ;
    if sprite_down = '1'  then
       if key_counter <4   then
        image_address <= "00000";
       elsif key_counter > 7 and key_counter < 12   then
        image_address <= "00000";
       elsif key_counter >3 and key_counter < 8 then
        image_address <= "00001";
       elsif key_counter > 11 then
        image_address <= "00010";
      end if;
      elsif sprite_up = '1' then
       if key_counter <4   then
        image_address <= "00011";
       elsif key_counter > 7 and key_counter < 12   then
        image_address <= "00011";
       elsif key_counter >3 and key_counter < 8 then
       image_address <= "00100";
       elsif key_counter > 11 then
        image_address <= "00101";
      end if;
      elsif sprite_left = '1' then
        if key_counter <4   then
        image_address <= "00110";
       elsif key_counter > 7 and key_counter < 12   then
        image_address <= "00110";
       elsif key_counter >3 and key_counter < 8 then
        image_address <= "00111";
       elsif key_counter > 11 then
        image_address <= "01000";
      end if;
      elsif sprite_right = '1' then
       
        if key_counter <4   then
       image_address <= "01001";
       elsif key_counter > 7 and key_counter < 12   then
        image_address <= "01001";
       elsif key_counter >3 and key_counter < 8 then
       image_address <= "01010";
       elsif key_counter > 11 then
       image_address <= "01011";
      end if;

      elsif sprite_dead = '1' then
       image_address <= "01100";
    end if;
     if ice_cream_R /= "00000" then
     VGA_R(9 downto 5) <= ice_cream_R(4 downto 0);
      VGA_R(4 downto 0) <= "11111";
     end if;
      if ice_cream_G /= "00000" then
     VGA_G(9 downto 5) <= ice_cream_G(4 downto 0);
     VGA_G(4 downto 0) <= "11111";
     end if;
       if ice_cream_B /= "00000" then
     VGA_B(9 downto 5) <= ice_cream_B(4 downto 0);
     VGA_B(4 downto 0) <= "11111";
     end if;
    end if;


  ------------------------------------------------------------guard ------------------------------------
    if guard_move_flag ='1' then   
        test3 <=  to_integer(Vcount - guard_vertical) -VSYNC - VBACK_PORCH;
        test4 <=  to_integer(Hcount - guard_height) -HSYNC - HBACK_PORCH;  
    if guard_down = '1'  then
       if guard_counter <4   then
       guard_image_address <= "00000";
       elsif guard_counter > 7 and guard_counter < 12   then
       guard_image_address <= "00000";
       elsif guard_counter >3 and guard_counter < 8 then
        guard_image_address <= "00001";
       elsif guard_counter > 11 then
        guard_image_address <= "00010";
      end if;
      elsif guard_up = '1' then
       if guard_counter <4   then
       guard_image_address <= "00011";
       elsif guard_counter > 7 and guard_counter < 12   then
        guard_image_address <= "00011";
       elsif guard_counter >3 and guard_counter < 8 then
        guard_image_address <= "00100";
       elsif guard_counter > 11 then
        guard_image_address <= "00101";
      end if;
      elsif guard_left = '1' then
        if guard_counter < 4   then
        guard_image_address <= "00110";
       elsif guard_counter > 7 and guard_counter < 12   then
            guard_image_address <= "00110";
       elsif guard_counter >3 and guard_counter < 8 then
               guard_image_address <= "00111";
       elsif guard_counter > 11 then
               guard_image_address <= "01000";
      end if;
      elsif guard_right = '1' then
        if guard_counter <4   then
         guard_image_address <= "01001";
       elsif guard_counter > 7 and guard_counter < 12   then
         guard_image_address <= "01001";
       elsif guard_counter >3 and guard_counter < 8 then
         guard_image_address <= "01010";
       elsif guard_counter > 11 then
        guard_image_address <= "01011";
      end if;
    end if;
       if guard_R /= "11111" then
     VGA_R(9 downto 5) <= guard_R(4 downto 0);
      VGA_R(4 downto 0) <= "11111";
     end if;
      if guard_G /= "11111" then
     VGA_G(9 downto 5) <= guard_G(4 downto 0);
     VGA_G(4 downto 0) <= "11111";
     end if;
       if guard_B /= "11111" then
     VGA_B(9 downto 5) <= guard_B(4 downto 0);
     VGA_B(4 downto 0) <= "11111";
     end if;
   end if;




   end if;
  end process VideoOut;

  VGA_CLK <= clk1;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;
