library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity lines_testbench is
end lines_testbench;

architecture behavioral of lines_testbench is
signal clk : std_logic := '0';
signal start, done : std_logic;
signal x0, y0, x1, y1 : signed(10 downto 0);
signal rstn : std_logic;
begin
  clk <= not clk after 100 ns;

  uut : entity work.lines
     port map (
       clk => clk,
       x0 => x0,
       y0 => y0,
       x1 => x1,
       y1 => y1,
       start => start,
       done => done,
       rst => '0'
     );

  process (clk)
  begin
    if rising_edge(clk) then
      start <= '0';
      if rstn = '0' then
        x0 <= to_signed(0,11);
        y0 <= to_signed(0,11);
        x1 <= to_signed(320,11);
        y1 <= to_signed(200,11);
        start <= '1';
      else
        if done = '1' then
          start <= '1';
          if x1 < to_signed(600,11) then
            x1 <= x1 + 3;
          else
            x1 <= to_signed(40,11);
            if y1 < to_signed(440,11) then
              y1 <= y1 + 3;
            else
              y1 <= to_signed(40, 11);
            end if;
          end if;
        end if;
      end if;
    end if;
  end process;

  process
  begin
    rstn <= '0';
    wait for 1000 ns;
    rstn <= '1';
    wait;
  end process;

--  process
--  begin
--    start <= '0';
--    wait for 200 ns;
--    x0 <= to_signed(0, 11);
--    y0 <= to_signed(0, 11);
----    x1 <= to_signed(639,11);
----    y1 <= to_signed(479,11);
--    x1 <= to_signed(7,11);
--    y1 <= to_signed(4,11);
--    start <= '1';
--    wait for 200 ns;
--    start <= '0';
--    wait until done = '1';
--    wait for 20 ns;
--    x0 <= to_signed(5, 11);
--    y0 <= to_signed(3, 11);
--    x1 <= to_signed(6, 11);
--    y1 <= to_signed(4, 11);
--    start <= '1';
--    wait for 200 ns;
--    start <= '0';
--    wait until done = '1';
--    wait for 20 ns;
--    wait;
--  end process;

end behavioral;
  
