module de0_lines
  (
   ////////////////////	Clock Input	 	////////////////////	 
   CLOCK_50,						//	50 MHz
   CLOCK_50_2,						//	50 MHz
   ////////////////////	Push Button		////////////////////
   BUTTON,							//	Pushbutton[2:0]
   ////////////////////	DPDT Switch		////////////////////
   SW,								//	Toggle Switch[9:0]
   ////////////////////	7-SEG Dispaly	////////////////////
   HEX0_D,							//	Seven Segment Digit 0
   HEX0_DP,						//	Seven Segment Digit DP 0
   HEX1_D,							//	Seven Segment Digit 1
   HEX1_DP,						//	Seven Segment Digit DP 1
   HEX2_D,							//	Seven Segment Digit 2
   HEX2_DP,						//	Seven Segment Digit DP 2
   HEX3_D,							//	Seven Segment Digit 3
   HEX3_DP,						//	Seven Segment Digit DP 3
   ////////////////////////	LED		////////////////////////
   LEDG,							//	LED Green[9:0]
   ////////////////////////	UART	////////////////////////
   UART_TXD,						//	UART Transmitter
   UART_RXD,						//	UART Receiver
   UART_CTS,						//	UART Clear To Send
   UART_RTS,						//	UART Request To Send
   /////////////////////	SDRAM Interface		////////////////
   DRAM_DQ,						//	SDRAM Data bus 16 Bits
   DRAM_ADDR,						//	SDRAM Address bus 13 Bits
   DRAM_LDQM,						//	SDRAM Low-byte Data Mask 
   DRAM_UDQM,						//	SDRAM High-byte Data Mask
   DRAM_WE_N,						//	SDRAM Write Enable
   DRAM_CAS_N,						//	SDRAM Column Address Strobe
   DRAM_RAS_N,						//	SDRAM Row Address Strobe
   DRAM_CS_N,						//	SDRAM Chip Select
   DRAM_BA_0,						//	SDRAM Bank Address 0
   DRAM_BA_1,						//	SDRAM Bank Address 1
   DRAM_CLK,						//	SDRAM Clock
   DRAM_CKE,						//	SDRAM Clock Enable
   ////////////////////	Flash Interface		////////////////
   FL_DQ,							//	FLASH Data bus 15 Bits
   FL_DQ15_AM1,					//	FLASH Data bus Bit 15 or Address A-1
   FL_ADDR,						//	FLASH Address bus 22 Bits
   FL_WE_N,						//	FLASH Write Enable
   FL_RST_N,						//	FLASH Reset
   FL_OE_N,						//	FLASH Output Enable
   FL_CE_N,						//	FLASH Chip Enable
   FL_WP_N,						//	FLASH Hardware Write Protect
   FL_BYTE_N,						//	FLASH Selects 8/16-bit mode
   FL_RY,							//	FLASH Ready/Busy
   ////////////////////	LCD Module 16X2		////////////////
   LCD_BLON,						//	LCD Back Light ON/OFF
   LCD_RW,							//	LCD Read/Write Select, 0 = Write, 1 = Read
   LCD_EN,							//	LCD Enable
   LCD_RS,							//	LCD Command/Data Select, 0 = Command, 1 = Data
   LCD_DATA,						//	LCD Data bus 8 bits
   ////////////////////	SD_Card Interface	////////////////
   SD_DAT0,						//	SD Card Data 0
   SD_DAT3,						//	SD Card Data 3
   SD_CMD,							//	SD Card Command Signal
   SD_CLK,							//	SD Card Clock
   SD_WP_N,						//	SD Card Write Protect
   ////////////////////	PS2		////////////////////////////
   PS2_KBDAT,						//	PS2 Keyboard Data
   PS2_KBCLK,						//	PS2 Keyboard Clock
   PS2_MSDAT,						//	PS2 Mouse Data
   PS2_MSCLK,						//	PS2 Mouse Clock
   ////////////////////	VGA		////////////////////////////
   VGA_HS,							//	VGA H_SYNC
   VGA_VS,							//	VGA V_SYNC
   VGA_R,   						//	VGA Red[3:0]
   VGA_G,	 						//	VGA Green[3:0]
   VGA_B,  						//	VGA Blue[3:0]
   ////////////////////	GPIO	////////////////////////////
   GPIO0_CLKIN,					//	GPIO Connection 0 Clock In Bus
   GPIO0_CLKOUT,					//	GPIO Connection 0 Clock Out Bus
   GPIO0_D,						//	GPIO Connection 0 Data Bus
   GPIO1_CLKIN,					//	GPIO Connection 1 Clock In Bus
   GPIO1_CLKOUT,					//	GPIO Connection 1 Clock Out Bus
   GPIO1_D							//	GPIO Connection 1 Data Bus
   );

   ////////////////////////	Clock Input	 	////////////////////////
  input			CLOCK_50;				//	50 MHz
   input 		CLOCK_50_2;				//	50 MHz
   ////////////////////////	Push Button		////////////////////////
   input [2:0] 		BUTTON;					//	Pushbutton[2:0]
   ////////////////////////	DPDT Switch		////////////////////////
   input [9:0] 		SW;						//	Toggle Switch[9:0]
   ////////////////////////	7-SEG Dispaly	////////////////////////
   output [6:0] 	HEX0_D;					//	Seven Segment Digit 0
   output 		HEX0_DP;				//	Seven Segment Digit DP 0
   output [6:0] 	HEX1_D;					//	Seven Segment Digit 1
   output 		HEX1_DP;				//	Seven Segment Digit DP 1
   output [6:0] 	HEX2_D;					//	Seven Segment Digit 2
   output 		HEX2_DP;				//	Seven Segment Digit DP 2
   output [6:0] 	HEX3_D;					//	Seven Segment Digit 3
   output 		HEX3_DP;				//	Seven Segment Digit DP 3
   ////////////////////////////	LED		////////////////////////////
   output [9:0] 	LEDG;					//	LED Green[9:0]
   ////////////////////////////	UART	////////////////////////////
   output 		UART_TXD;				//	UART Transmitter
   input 		UART_RXD;				//	UART Receiver
   output 		UART_CTS;				//	UART Clear To Send
   input 		UART_RTS;				//	UART Request To Send
   ///////////////////////		SDRAM Interface	////////////////////////
   inout [15:0] 	DRAM_DQ;				//	SDRAM Data bus 16 Bits
   output [12:0] 	DRAM_ADDR;				//	SDRAM Address bus 13 Bits
   output 		DRAM_LDQM;				//	SDRAM Low-byte Data Mask
   output 		DRAM_UDQM;				//	SDRAM High-byte Data Mask
   output 		DRAM_WE_N;				//	SDRAM Write Enable
   output 		DRAM_CAS_N;				//	SDRAM Column Address Strobe
   output 		DRAM_RAS_N;				//	SDRAM Row Address Strobe
   output 		DRAM_CS_N;				//	SDRAM Chip Select
   output 		DRAM_BA_0;				//	SDRAM Bank Address 0
   output 		DRAM_BA_1;				//	SDRAM Bank Address 1
   output 		DRAM_CLK;				//	SDRAM Clock
   output 		DRAM_CKE;				//	SDRAM Clock Enable
   ////////////////////////	Flash Interface	////////////////////////
   inout [14:0] 	FL_DQ;					//	FLASH Data bus 15 Bits
   inout 		FL_DQ15_AM1;			//	FLASH Data bus Bit 15 or Address A-1
   output [21:0] 	FL_ADDR;				//	FLASH Address bus 22 Bits
   output 		FL_WE_N;				//	FLASH Write Enable
   output 		FL_RST_N;				//	FLASH Reset
   output 		FL_OE_N;				//	FLASH Output Enable
   output 		FL_CE_N;				//	FLASH Chip Enable
   output 		FL_WP_N;				//	FLASH Hardware Write Protect
   output 		FL_BYTE_N;				//	FLASH Selects 8/16-bit mode
   input 		FL_RY;					//	FLASH Ready/Busy
   ////////////////////	LCD Module 16X2	////////////////////////////
   inout [7:0] 		LCD_DATA;				//	LCD Data bus 8 bits
   output 		LCD_BLON;				//	LCD Back Light ON/OFF
   output 		LCD_RW;					//	LCD Read/Write Select, 0 = Write, 1 = Read
   output 		LCD_EN;					//	LCD Enable
   output 		LCD_RS;					//	LCD Command/Data Select, 0 = Command, 1 = Data
   ////////////////////	SD Card Interface	////////////////////////
   inout 		SD_DAT0;				//	SD Card Data 0
   inout 		SD_DAT3;				//	SD Card Data 3
   inout 		SD_CMD;					//	SD Card Command Signal
   output 		SD_CLK;					//	SD Card Clock
   input 		SD_WP_N;				//	SD Card Write Protect
   ////////////////////////	PS2		////////////////////////////////
   inout 		PS2_KBDAT;				//	PS2 Keyboard Data
   inout 		PS2_KBCLK;				//	PS2 Keyboard Clock
   inout 		PS2_MSDAT;				//	PS2 Mouse Data
   inout 		PS2_MSCLK;				//	PS2 Mouse Clock
   ////////////////////////	VGA			////////////////////////////
   output 		VGA_HS;					//	VGA H_SYNC
   output 		VGA_VS;					//	VGA V_SYNC
   output [3:0] 	VGA_R;   				//	VGA Red[3:0]
   output [3:0] 	VGA_G;	 				//	VGA Green[3:0]
   output [3:0] 	VGA_B;   				//	VGA Blue[3:0]
   ////////////////////////	GPIO	////////////////////////////////
   input [1:0] 		GPIO0_CLKIN;			//	GPIO Connection 0 Clock In Bus
   output [1:0] 	GPIO0_CLKOUT;			//	GPIO Connection 0 Clock Out Bus
   inout [31:0] 	GPIO0_D;				//	GPIO Connection 0 Data Bus
   input [1:0] 		GPIO1_CLKIN;			//	GPIO Connection 1 Clock In Bus
   output [1:0] 	GPIO1_CLKOUT;			//	GPIO Connection 1 Clock Out Bus
   inout [31:0] 	GPIO1_D;				//	GPIO Connection 1 Data Bus

   //	All inout port turn to tri-state
   assign			DRAM_DQ			=	16'hzzzz;
   assign			FL_DQ			=	16'hzzzz;
   assign			LCD_DATA		=	8'hzz;
   assign			SD_DAT0			=	1'hz;
   assign			SD_DAT3			=	1'hz;
   assign			SD_CMD			=	1'hz;
   assign			PS2_KBDAT		=	1'hz;
   assign			PS2_KBCLK		=	1'hz;
   assign			PS2_MSDAT		=	1'hz;
   assign			PS2_MSCLK		=	1'hz;
   assign			GPIO0_D			=	32'hzzzzzzzz;
   assign			GPIO1_D			=	32'hzzzzzzzz;

   assign			HEX0_D			=	7'h7F;
   assign			HEX0_DP			=	1'h1;
   assign			HEX1_D			=	7'h7F;
   assign			HEX1_DP			=	1'h1;
   assign			HEX2_D			=	7'h7F;
   assign			HEX2_DP			=	1'h1;
   assign			HEX3_D			=	7'h7F;
   assign			HEX3_DP			=	1'h1;

   assign			LEDG			=	10'h000;


   wire			VGA_CTRL_CLK;
   wire [9:0] 		mVGA_X;
   wire [9:0] 		mVGA_Y;
   wire [9:0] 		mVGA_R;
   wire [9:0] 		mVGA_G;
   wire [9:0] 		mVGA_B;
   //wire	[19:0]	mVGA_ADDR;
   wire [9:0] 		sVGA_R;
   wire [9:0] 		sVGA_G;
   wire [9:0] 		sVGA_B;
   assign	VGA_R	=	sVGA_R[3:0];
   assign	VGA_G	=	sVGA_G[3:0];
   assign	VGA_B	=	sVGA_B[3:0];


   VGA_CLK u1
     (.inclk0(CLOCK_50),
      .c0(VGA_CTRL_CLK)
      );

   VGA_Ctrl	u2
     (	//	Host Side
	.oCurrent_X(mVGA_X),
	.oCurrent_Y(mVGA_Y),
	.iRed(mVGA_R),
	.iGreen(mVGA_G),
	.iBlue(mVGA_B),
	//	VGA Side
	.oVGA_R(sVGA_R),
	.oVGA_G(sVGA_G),
	.oVGA_B(sVGA_B),
	.oVGA_HS(VGA_HS),
	.oVGA_VS(VGA_VS),
	.oVGA_SYNC(),
	.oVGA_BLANK(),
	.oVGA_CLOCK(),
	//	Control Signal
	.iCLK(VGA_CTRL_CLK),
	.iRST_N(BUTTON[0])
	);

   VGA_Display u3
     (	//	Read Out Side
	.Red(mVGA_R),
	.Green(mVGA_G),
	.Blue(mVGA_B),
	.VGA_X(mVGA_X),
	.VGA_Y(mVGA_Y),
	.VGA_VS(VGA_VS),
	.VGA_CLK(VGA_CTRL_CLK),
	.rstn(BUTTON[1]),
	.color(BUTTON[2]),
	.clk(CLOCK_50)
	);
     
endmodule
