#ifndef TERRAIN_H_
#define TERRAIN_H_
#define IOWR_VGA_DATA(base,offset,data) IOWR_32DIRECT(base,offset*4,data)
#define START_TERRAIN 200
#define TERRAIN_MIN 10
#define TERRAIN_MAX 300
#define DAMAGE_RADIUS 25
#define BULLSEYE 5
#define GAMEBOARD_LENGTH 1024
#define GAMEBOARD_HEIGHT 1024

// Start and end are used for determining which portion of the gameboard to draw
void drawTerrain(float *terrain, int size, int offset)
{
     unsigned int a = 0; 
     int i;  
      IOWR_VGA_DATA(VGA_BASE,0,a);
    
    for(i=0;i<size;i++)                  
    {                                    
      IOWR_VGA_DATA(VGA_BASE,1,(int)*(terrain+i));          
    }      
}

void genTerrain(float *terrain)
{
float slope = 0;
float curvature = 0;
int i,j,n;

*(terrain + 0) = START_TERRAIN;
n = 1;
    
for(i = 0; i < 16; i++)
{
   curvature = 0.02*(getRandom()-.5);
   for(j = 0; j < 64; j++)
   {
      slope += curvature;
      *(terrain + n) = *(terrain + n -1) + slope; 
      if(*(terrain + n) > TERRAIN_MAX) {slope = -slope;}
      if(*(terrain + n) < TERRAIN_MIN) {slope = -slope;}
      n++;
    }
}    
}

void drawDamage(float *terrain, int damageCenter)
{
int i;
float D = 0;
float R = (float)DAMAGE_RADIUS;
float dy = 0;
for(i = 0; i < GAMEBOARD_LENGTH; i++)
{
   D = (float)(i - damageCenter);
   if(D < 0) {D = -D;}
        
   if(D < R)
   {
    dy = sqrt(pow(R,2) - pow(D,2));
    *(terrain + i) = *(terrain + i) - dy;
   }
        
   if(*(terrain + i) < TERRAIN_MIN) {*(terrain + i) = TERRAIN_MIN;}
}      
}

void smoothTerrain(float *terrain, int n)
{
int i, j;
for(i = 0; i < n; i++)
{
for(j = 1; j < GAMEBOARD_LENGTH-1; j++)
{
   *(terrain + j) = (*(terrain + j - 1) + *(terrain + j) + *(terrain + j + 1)) / 3;
}
} 
}

void centerScreen(int h, int v)
{
 
h = h - 320;
if(h < 0) h = 0;
if(h > 383) h = 383;

//v = GAMEBOARD_HEIGHT - v; 
v = v - 240; 
if(v < 0) v = 0;
if(v > 543) v = 543;
    
unsigned int HVInit; 
   
h <<= 22;
v <<= 12;           
HVInit =  (h|v);
IOWR_VGA_DATA(VGA_BASE,4,HVInit); 
} 

#endif /*TERRAIN_H_*/
